/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.netty.ahessian.rpc.callback;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicLong;
import org.rzo.netty.ahessian.Constants;
import org.rzo.netty.ahessian.rpc.callback.Callback;
import org.rzo.netty.ahessian.rpc.callback.CallbackReplyMessage;
import org.rzo.netty.ahessian.rpc.callback.ServerCallbackProxy;

public class ClientCallback
implements Serializable {
    private transient Callback _callback;
    private Long _id;
    private String _callbackClass;
    private String[] _interfaces;
    private static final AtomicLong _idCounter = new AtomicLong();
    private transient boolean _done = false;

    public ClientCallback() {
    }

    public ClientCallback(Callback callback) {
        this._callback = callback;
        this._id = _idCounter.getAndIncrement();
        this._callbackClass = this._callback.getClass().getName();
        this._interfaces = this.determineInterfaces(this._callback.getClass());
    }

    private String[] determineInterfaces(Class clazz) {
        ArrayList clazzes = new ArrayList();
        while (clazz != null && !clazz.equals(Object.class)) {
            clazzes.addAll(Arrays.asList(clazz.getInterfaces()));
            clazz = clazz.getSuperclass();
        }
        String[] result = new String[clazzes.size()];
        int i = 0;
        for (Class clazz2 : clazzes) {
            result[i] = clazz2.getName();
            ++i;
        }
        return result;
    }

    public Long getId() {
        return this._id;
    }

    public void invoke(CallbackReplyMessage message) {
        try {
            Method[] methods;
            String methodName = message.getMethod();
            Object[] args = message.getArgs();
            if (args == null) {
                args = new Object[]{};
            }
            for (Method method : methods = this._callback.getClass().getMethods()) {
                if (!methodName.equals(method.getName()) || method.getParameterTypes().length != args.length) continue;
                method.invoke((Object)this._callback, args);
                break;
            }
        }
        catch (Exception ex) {
            Constants.ahessianLogger.warn("", (Throwable)ex);
        }
    }

    public String getCallbackClass() {
        return this._callbackClass;
    }

    public String[] getInterfaces() {
        return this._interfaces;
    }

    public static Object clientCallbackArgProxy(ClientCallback cc, ServerCallbackProxy serverCallbackProxy) throws Exception {
        ClassLoader cl = cc.getClass().getClassLoader();
        ArrayList clazzes = new ArrayList();
        for (String clz : cc.getInterfaces()) {
            clazzes.add(cl.loadClass(clz));
        }
        return Proxy.newProxyInstance(cl, clazzes.toArray(new Class[clazzes.size()]), (InvocationHandler)serverCallbackProxy);
    }
}

