/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.netty.ahessian.rpc.callback;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import org.rzo.netty.ahessian.Constants;
import org.rzo.netty.ahessian.rpc.callback.CallbackReplyMessage;
import org.rzo.netty.ahessian.rpc.callback.ClientCallback;
import org.rzo.netty.ahessian.rpc.message.HessianRPCCallMessage;
import org.rzo.netty.ahessian.rpc.server.HessianRPCServiceHandler;

public class ServerCallbackProxy
implements InvocationHandler,
Constants {
    private boolean _done = false;
    private HessianRPCServiceHandler _handler;
    private HessianRPCCallMessage _message;
    private ClientCallback _clientCallback;
    boolean _closed = false;

    public ServerCallbackProxy(HessianRPCServiceHandler handler, HessianRPCCallMessage message, ClientCallback clientCallback) {
        this._message = message;
        this._clientCallback = clientCallback;
        this._handler = handler;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (this._closed) {
            throw new RuntimeException("cannot invoke callback after call to setDone(true)");
        }
        String methodName = method.getName();
        if ("setDone".equals(methodName) && args.length == 1 && args[0] instanceof Boolean) {
            this._done = (Boolean)args[0];
            return null;
        }
        if ("isDone".equals(method.getName()) && (args == null || args.length == 0)) {
            return this._done;
        }
        if ("isValid".equals(method.getName()) && (args == null || args.length == 0)) {
            return this._message.isValid();
        }
        if ("toString".equals(method.getName()) && (args == null || args.length == 0)) {
            return this.toString();
        }
        if ("hashCode".equals(method.getName()) && (args == null || args.length == 0)) {
            return this.hashCode();
        }
        if ("equals".equals(method.getName()) && args.length == 1) {
            return this.equals(args[0]);
        }
        CallbackReplyMessage reply = new CallbackReplyMessage(methodName, args, null, this._message);
        reply.setCallId((Long)this._message.getHeaders().get(CALL_ID_HEADER_KEY));
        reply.setGroup((Integer)this._message.getHeaders().get(GROUP_HEADER_KEY));
        reply.setCallbackId(this._clientCallback.getId());
        reply.setCallbackArgs(args);
        reply.setCallbackMethod(methodName);
        if (this._done) {
            reply.setCallbackDone(true);
        }
        this._handler.writeResult(reply);
        if (this._done) {
            this._closed = true;
        }
        return null;
    }
}

