/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.netty.ahessian.rpc.server;

import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.concurrent.Executor;
import org.rzo.netty.ahessian.Constants;
import org.rzo.netty.ahessian.rpc.callback.ClientCallback;
import org.rzo.netty.ahessian.rpc.callback.ServerCallbackProxy;
import org.rzo.netty.ahessian.rpc.message.HessianRPCCallMessage;
import org.rzo.netty.ahessian.rpc.server.HessianRPCServiceHandler;
import org.rzo.netty.ahessian.rpc.server.HessianSkeleton;
import org.rzo.netty.ahessian.rpc.server.ServiceSessionProvider;

public class ExecutorInvokeService
extends HessianSkeleton
implements Constants {
    Executor _executor;

    public ExecutorInvokeService(Object service, Class apiClass, HessianRPCServiceHandler factory, Executor executor) {
        super(service, apiClass, factory);
        this._executor = executor;
    }

    public void messageReceived(HessianRPCCallMessage message) {
        this.invoke(message);
    }

    void invoke(final HessianRPCCallMessage message) {
        this._executor.execute(new Runnable(){

            public void run() {
                Object result = null;
                Throwable fault = null;
                try {
                    Method method = ExecutorInvokeService.this.getMethod(message);
                    Object[] args = message.getArgs();
                    if (args != null) {
                        for (int i = 0; i < args.length; ++i) {
                            if (!(args[i] instanceof ClientCallback)) continue;
                            ClientCallback cc = (ClientCallback)args[i];
                            args[i] = ClientCallback.clientCallbackArgProxy(cc, new ServerCallbackProxy(ExecutorInvokeService.this._factory, message, cc));
                        }
                    }
                    ServiceSessionProvider.set(message.getSession());
                    ServiceSessionProvider.setHandler(message.getHandler());
                    result = method.invoke(ExecutorInvokeService.this._service, args);
                    ServiceSessionProvider.remove();
                    ServiceSessionProvider.removeHandler();
                }
                catch (Throwable ex) {
                    ServiceSessionProvider.remove();
                    Constants.ahessianLogger.warn("", ex);
                    fault = ex;
                }
                if (fault == null && result instanceof InputStream) {
                    ExecutorInvokeService.this.handleInputStreamResult(fault, result, message);
                } else {
                    ExecutorInvokeService.this.handleDefaultResult(fault, result, message);
                }
            }
        });
    }
}

