/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.netty.ahessian.rpc.stream;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.netty.channel.Channel;
import org.rzo.netty.ahessian.rpc.stream.InputStreamReplyMessage;

public class ServerInputStream {
    static final int BATCH_SIZE = 1000;
    private InputStream _in;
    private Executor _executor;
    private Channel _channel;
    private long _id;
    private static ServerInputStreamBoss _boss = new ServerInputStreamBoss();
    private AtomicBoolean _isDoingStream = new AtomicBoolean(false);

    public ServerInputStream(InputStream in, Executor executor, Channel channel, long id) {
        this._in = in;
        this._executor = executor;
        this._channel = channel;
        this._id = id;
    }

    public void start() {
        _boss.add(this);
    }

    protected void doStream() {
        if (this._isDoingStream.get()) {
            return;
        }
        this._isDoingStream.set(true);
        this._executor.execute(new Runnable(){

            public void run() {
                try {
                    while (ServerInputStream.this._in.available() > 0 && ServerInputStream.this._channel.isWritable()) {
                        byte[] data = new byte[1000];
                        int l = -1;
                        try {
                            ServerInputStream.this._in.read(data);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                        if (l == -1) {
                            ServerInputStream.this.doClose();
                            return;
                        }
                        ServerInputStream.this.doSendData(l, data);
                    }
                }
                catch (Exception ex) {
                    ServerInputStream.this.doClose();
                }
                ServerInputStream.this._isDoingStream.set(false);
            }
        });
    }

    private void doSendData(int length, byte[] data) {
        if (length == 0) {
            return;
        }
        if (length < data.length) {
            byte[] newData = new byte[length];
            System.arraycopy(data, 0, newData, 0, length);
            data = newData;
        }
        InputStreamReplyMessage msg = new InputStreamReplyMessage();
        msg.setId(this._id);
        msg.setData(data);
        this._channel.write((Object)msg);
    }

    private void doClose() {
        try {
            this._in.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        _boss.remove(this);
        InputStreamReplyMessage msg = new InputStreamReplyMessage();
        msg.setId(this._id);
        msg.setClosed(true);
        this._channel.write((Object)msg);
    }

    public long getId() {
        return this._id;
    }

    static {
        _boss.start();
    }

    private static class ServerInputStreamBoss
    extends Thread
    implements Runnable {
        private List<ServerInputStream> _streams = Collections.synchronizedList(new ArrayList());

        private ServerInputStreamBoss() {
        }

        public void add(ServerInputStream stream) {
            this._streams.add(stream);
        }

        public void remove(ServerInputStream stream) {
            this._streams.remove(stream);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                List<ServerInputStream> list = this._streams;
                synchronized (list) {
                    for (ServerInputStream stream : this._streams) {
                        stream.doStream();
                    }
                }
                try {
                    Thread.sleep(500L);
                }
                catch (Exception exception) {
                }
            }
        }
    }
}

