/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.netty.ahessian.session;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.util.Timeout;
import org.jboss.netty.util.Timer;
import org.jboss.netty.util.TimerTask;
import org.rzo.netty.ahessian.Constants;
import org.rzo.netty.ahessian.session.MixinPipeline;
import org.rzo.netty.ahessian.session.Session;
import org.rzo.netty.ahessian.session.SessionFactory;

public class ServerSessionFilter
extends SimpleChannelUpstreamHandler {
    private boolean _hasSession = false;
    private String _sessionId = "";
    private SessionFactory _factory = new SessionFactory();
    private ChannelStateEvent _connectedEvent;
    private ChannelPipelineFactory _mixinFactory;
    private static Map<String, MixinPipeline> _sessionPipelines = Collections.synchronizedMap(new HashMap());
    private long _sessionTimeout = -1L;
    private Timer _timer = null;
    private volatile Channel _channel = null;
    private volatile boolean _valid = true;

    public ServerSessionFilter(ChannelPipelineFactory mixinFactory, Timer timer, long sessionTimeout) {
        this._mixinFactory = mixinFactory;
        this._timer = timer;
        this._sessionTimeout = sessionTimeout;
    }

    public ServerSessionFilter(ChannelPipelineFactory mixinFactory) {
        this(mixinFactory, null, -1L);
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        if (this._hasSession) {
            Session session = (Session)ctx.getAttachment();
            session.onMessage();
            ctx.sendUpstream((ChannelEvent)e);
        } else {
            ChannelBuffer b = (ChannelBuffer)e.getMessage();
            this._sessionId = this._sessionId + b.toString("UTF-8");
            if (this._sessionId.equals("?")) {
                this.newSession(ctx);
            } else {
                this.checkSession(ctx);
            }
        }
    }

    private void checkSession(ChannelHandlerContext ctx) {
        if (this._sessionId.length() == this._factory.getSessionIdLength() * 2) {
            Session session = this._factory.getSession(this._sessionId);
            if (session == null) {
                this.newSession(ctx);
            } else {
                this.confirmSession(ctx);
            }
        }
    }

    private void newSession(ChannelHandlerContext ctx) {
        Session session = this._factory.createSession(null);
        Constants.ahessianLogger.info(ctx.getChannel() + " new session #" + session.getId());
        MixinPipeline pipeline = null;
        try {
            pipeline = (MixinPipeline)this._mixinFactory.getPipeline();
            _sessionPipelines.put(session.getId(), pipeline);
        }
        catch (Exception e) {
            Constants.ahessianLogger.warn("", (Throwable)e);
        }
        this.handleSession(ctx, session, pipeline);
    }

    private void confirmSession(ChannelHandlerContext ctx) {
        Session session = this._factory.getSession(this._sessionId);
        Constants.ahessianLogger.info(ctx.getChannel() + " reuse session #" + session.getId());
        MixinPipeline pipeline = _sessionPipelines.get(this._sessionId);
        this.handleSession(ctx, session, pipeline);
    }

    private void handleSession(ChannelHandlerContext ctx, Session session, MixinPipeline pipeline) {
        Channel c;
        this._hasSession = true;
        session.setClosed(false);
        Timeout timeOut = session.removeTimeout();
        if (timeOut != null) {
            timeOut.cancel();
        }
        if ((c = pipeline.getChannel()) != null && c.isOpen()) {
            Constants.ahessianLogger.warn(ctx.getChannel() + " session already attached -> close connection");
            c.close();
        }
        ChannelPipeline currentPipeline = ctx.getPipeline();
        pipeline.mixin(currentPipeline);
        ctx.setAttachment((Object)session);
        this._channel = ctx.getChannel();
        ChannelFuture future = Channels.future((Channel)ctx.getChannel());
        Channels.write((ChannelHandlerContext)ctx, (ChannelFuture)future, (Object)ChannelBuffers.wrappedBuffer((byte[])session.getId().getBytes()));
        try {
            future.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        ctx.sendUpstream((ChannelEvent)this._connectedEvent);
    }

    public static Session getSession(ChannelHandlerContext ctx) {
        ChannelHandlerContext handler = ctx.getPipeline().getContext(ServerSessionFilter.class);
        if (handler == null) {
            return null;
        }
        return (Session)handler.getAttachment();
    }

    public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        this._connectedEvent = e;
    }

    public void channelDisconnected(final ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        this._hasSession = false;
        ((Session)ctx.getAttachment()).close();
        final String sessionId = ((Session)ctx.getAttachment()).getId();
        Constants.ahessianLogger.info("Session disconnected: " + sessionId);
        this._sessionId = "";
        this._connectedEvent = null;
        this._channel = null;
        if (this._sessionTimeout > 0L) {
            Timeout timeOut = this._timer.newTimeout(new TimerTask(){

                public void run(Timeout arg0) throws Exception {
                    ((Session)ctx.getAttachment()).invalidate();
                    ServerSessionFilter.this._factory.removeSession(sessionId);
                    _sessionPipelines.remove(sessionId);
                    ServerSessionFilter.this._valid = false;
                    Constants.ahessianLogger.warn(ctx.getChannel() + " session timed out: " + sessionId);
                }
            }, this._sessionTimeout, TimeUnit.MILLISECONDS);
            ((Session)ctx.getAttachment()).setTimeOut(timeOut);
        }
        ctx.sendUpstream((ChannelEvent)e);
    }

    public long getSessionTimeout() {
        return this._sessionTimeout;
    }

    public void setSessionTimeout(long sessionTimeout) {
        this._sessionTimeout = sessionTimeout;
    }

    public boolean isValid() {
        return this._valid;
    }

    public Channel getChannel() {
        return this._channel;
    }

    public static ServerSessionFilter getServerSessionFilter(ChannelHandlerContext ctx) {
        return (ServerSessionFilter)ctx.getPipeline().getContext(ServerSessionFilter.class).getHandler();
    }
}

