package org.sackfix.fix50sp2

import org.sackfix.field._
import org.sackfix.common.validated.fields.{SfFixMessageBody, SfFixMessageDecoder, SfFixFieldsToAscii, SfFixRenderable}
import org.sackfix.common.message.SfRepeatingGroupCountException
import scala.annotation.tailrec
import scala.collection.immutable.HashSet
import scala.collection.mutable.ArrayBuffer


/**
  * Generated by SackFix code generator on 20170404
  * Source specification was read from:
  *   /quickfixj1.6.0/FIX50SP2.xml
  */
case class AdjustedPositionReportMessage(posMaintRptIDField:PosMaintRptIDField,
                                         posReqTypeField:Option[PosReqTypeField]=None,
                                         clearingBusinessDateField:ClearingBusinessDateField,
                                         settlSessIDField:Option[SettlSessIDField]=None,
                                         posMaintRptRefIDField:Option[PosMaintRptRefIDField]=None,
                                         partiesComponent:PartiesComponent,
                                         positionQtyComponent:PositionQtyComponent,
                                         instrmtGrpComponent:Option[InstrmtGrpComponent]=None,
                                         settlPriceField:Option[SettlPriceField]=None,
                                         priorSettlPriceField:Option[PriorSettlPriceField]=None) extends SfFixMessageBody("BL")  with SfFixRenderable with SfFixFieldsToAscii {

  override lazy val fixStr : String = appendFixStr().toString
  override def appendFixStr(b:StringBuilder = new StringBuilder): StringBuilder = format(formatForFix, b)

  override def toString():String = appendStringBuilder().toString()
  def appendStringBuilder(b:StringBuilder = new StringBuilder) : StringBuilder = format(formatForToString, b)

  def format( fmt: ((StringBuilder,SfFixRenderable)=>Unit), b:StringBuilder = new StringBuilder()): StringBuilder = {
    fmt(b,posMaintRptIDField)
    posReqTypeField.foreach(fmt(b,_))
    fmt(b,clearingBusinessDateField)
    settlSessIDField.foreach(fmt(b,_))
    posMaintRptRefIDField.foreach(fmt(b,_))
    fmt(b,partiesComponent)
    fmt(b,positionQtyComponent)
    instrmtGrpComponent.foreach(fmt(b,_))
    settlPriceField.foreach(fmt(b,_))
    priorSettlPriceField.foreach(fmt(b,_))
    b
  }

}
     
object AdjustedPositionReportMessage extends SfFixMessageDecoder {
  val MsgType="BL"
  val MsgName="AdjustedPositionReport"
             
  override val MandatoryFields = HashSet[Int](
    PosMaintRptIDField.TagId, ClearingBusinessDateField.TagId)

  override def isMandatoryField(tagId:Int) : Boolean = {
    MandatoryFields.contains(tagId)  || 
    PartiesComponent.isMandatoryField(tagId) || PositionQtyComponent.isMandatoryField(tagId) || InstrmtGrpComponent.isMandatoryField(tagId)
  }

  override val OptionalFields = HashSet[Int](
    PosReqTypeField.TagId, SettlSessIDField.TagId, PosMaintRptRefIDField.TagId, SettlPriceField.TagId, PriorSettlPriceField.TagId)

  override def isOptionalField(tagId:Int) : Boolean = {
    OptionalFields.contains(tagId)  || 
    PartiesComponent.isOptionalField(tagId) || PositionQtyComponent.isOptionalField(tagId) || InstrmtGrpComponent.isOptionalField(tagId)
  }

  override def isFieldOf(tagId:Int) : Boolean = isMandatoryField(tagId) || isOptionalField(tagId)  || 
    PartiesComponent.isFieldOf(tagId) || PositionQtyComponent.isFieldOf(tagId) || InstrmtGrpComponent.isFieldOf(tagId)

   override lazy val RepeatingGroupsTags = HashSet[Int]()
  
      
  override def isFirstField(tagId:Int) : Boolean = tagId==PosMaintRptIDField.TagId 

  override def decode(flds: Seq[Tuple2[Int, Any]], startPos:Int = 0):Option[SfFixMessageBody] = {
    val (pos, myFields, nextTagPosLookup) = extractMyFieldsAndPopulatePositions(false, flds, startPos)
    validateMandatoryFieldsPresent(myFields)

    if (MandatoryFields.isEmpty || myFields.nonEmpty) {
      Some(AdjustedPositionReportMessage(PosMaintRptIDField.decode(myFields.get(PosMaintRptIDField.TagId)).get,
        myFields.get(PosReqTypeField.TagId).flatMap(f=>PosReqTypeField.decode(f)),
        ClearingBusinessDateField.decode(myFields.get(ClearingBusinessDateField.TagId)).get,
        myFields.get(SettlSessIDField.TagId).flatMap(f=>SettlSessIDField.decode(f)),
        myFields.get(PosMaintRptRefIDField.TagId).flatMap(f=>PosMaintRptRefIDField.decode(f)),
        PartiesComponent.decode(flds, startPos).get,
        PositionQtyComponent.decode(flds, startPos).get,
        InstrmtGrpComponent.decode(flds, startPos),
        myFields.get(SettlPriceField.TagId).flatMap(f=>SettlPriceField.decode(f)),
        myFields.get(PriorSettlPriceField.TagId).flatMap(f=>PriorSettlPriceField.decode(f))))
    } else None
  }

    
}
     