package org.sackfix.fix50sp2

import org.sackfix.field._
import org.sackfix.common.validated.fields.{SfFixMessageBody, SfFixMessageDecoder, SfFixFieldsToAscii, SfFixRenderable}
import org.sackfix.common.message.SfRepeatingGroupCountException
import scala.annotation.tailrec
import scala.collection.immutable.HashSet
import scala.collection.mutable.ArrayBuffer


/**
  * Generated by SackFix code generator on 20170404
  * Source specification was read from:
  *   /quickfixj1.6.0/FIX50SP2.xml
  */
case class AdvertisementMessage(advIdField:AdvIdField,
                                advTransTypeField:AdvTransTypeField,
                                advRefIDField:Option[AdvRefIDField]=None,
                                instrumentComponent:InstrumentComponent,
                                instrmtLegGrpComponent:Option[InstrmtLegGrpComponent]=None,
                                undInstrmtGrpComponent:Option[UndInstrmtGrpComponent]=None,
                                advSideField:AdvSideField,
                                quantityField:QuantityField,
                                qtyTypeField:Option[QtyTypeField]=None,
                                priceField:Option[PriceField]=None,
                                currencyField:Option[CurrencyField]=None,
                                tradeDateField:Option[TradeDateField]=None,
                                transactTimeField:Option[TransactTimeField]=None,
                                textField:Option[TextField]=None,
                                encodedTextLenField:Option[EncodedTextLenField]=None,
                                encodedTextField:Option[EncodedTextField]=None,
                                uRLLinkField:Option[URLLinkField]=None,
                                lastMktField:Option[LastMktField]=None,
                                tradingSessionIDField:Option[TradingSessionIDField]=None,
                                tradingSessionSubIDField:Option[TradingSessionSubIDField]=None) extends SfFixMessageBody("7")  with SfFixRenderable with SfFixFieldsToAscii {

  override lazy val fixStr : String = appendFixStr().toString
  override def appendFixStr(b:StringBuilder = new StringBuilder): StringBuilder = format(formatForFix, b)

  override def toString():String = appendStringBuilder().toString()
  def appendStringBuilder(b:StringBuilder = new StringBuilder) : StringBuilder = format(formatForToString, b)

  def format( fmt: ((StringBuilder,SfFixRenderable)=>Unit), b:StringBuilder = new StringBuilder()): StringBuilder = {
    fmt(b,advIdField)
    fmt(b,advTransTypeField)
    advRefIDField.foreach(fmt(b,_))
    fmt(b,instrumentComponent)
    instrmtLegGrpComponent.foreach(fmt(b,_))
    undInstrmtGrpComponent.foreach(fmt(b,_))
    fmt(b,advSideField)
    fmt(b,quantityField)
    qtyTypeField.foreach(fmt(b,_))
    priceField.foreach(fmt(b,_))
    currencyField.foreach(fmt(b,_))
    tradeDateField.foreach(fmt(b,_))
    transactTimeField.foreach(fmt(b,_))
    textField.foreach(fmt(b,_))
    encodedTextLenField.foreach(fmt(b,_))
    encodedTextField.foreach(fmt(b,_))
    uRLLinkField.foreach(fmt(b,_))
    lastMktField.foreach(fmt(b,_))
    tradingSessionIDField.foreach(fmt(b,_))
    tradingSessionSubIDField.foreach(fmt(b,_))
    b
  }

}
     
object AdvertisementMessage extends SfFixMessageDecoder {
  val MsgType="7"
  val MsgName="Advertisement"
             
  override val MandatoryFields = HashSet[Int](
    AdvIdField.TagId, AdvTransTypeField.TagId, AdvSideField.TagId, QuantityField.TagId)

  override def isMandatoryField(tagId:Int) : Boolean = {
    MandatoryFields.contains(tagId)  || 
    InstrumentComponent.isMandatoryField(tagId) || InstrmtLegGrpComponent.isMandatoryField(tagId) || UndInstrmtGrpComponent.isMandatoryField(tagId)
  }

  override val OptionalFields = HashSet[Int](
    AdvRefIDField.TagId, QtyTypeField.TagId, PriceField.TagId, CurrencyField.TagId, TradeDateField.TagId, 
    TransactTimeField.TagId, TextField.TagId, EncodedTextLenField.TagId, EncodedTextField.TagId, URLLinkField.TagId, 
    LastMktField.TagId, TradingSessionIDField.TagId, TradingSessionSubIDField.TagId)

  override def isOptionalField(tagId:Int) : Boolean = {
    OptionalFields.contains(tagId)  || 
    InstrumentComponent.isOptionalField(tagId) || InstrmtLegGrpComponent.isOptionalField(tagId) || UndInstrmtGrpComponent.isOptionalField(tagId)
  }

  override def isFieldOf(tagId:Int) : Boolean = isMandatoryField(tagId) || isOptionalField(tagId)  || 
    InstrumentComponent.isFieldOf(tagId) || InstrmtLegGrpComponent.isFieldOf(tagId) || UndInstrmtGrpComponent.isFieldOf(tagId)

   override lazy val RepeatingGroupsTags = HashSet[Int]()
  
      
  override def isFirstField(tagId:Int) : Boolean = tagId==AdvIdField.TagId 

  override def decode(flds: Seq[Tuple2[Int, Any]], startPos:Int = 0):Option[SfFixMessageBody] = {
    val (pos, myFields, nextTagPosLookup) = extractMyFieldsAndPopulatePositions(false, flds, startPos)
    validateMandatoryFieldsPresent(myFields)

    if (MandatoryFields.isEmpty || myFields.nonEmpty) {
      Some(AdvertisementMessage(AdvIdField.decode(myFields.get(AdvIdField.TagId)).get,
        AdvTransTypeField.decode(myFields.get(AdvTransTypeField.TagId)).get,
        myFields.get(AdvRefIDField.TagId).flatMap(f=>AdvRefIDField.decode(f)),
        InstrumentComponent.decode(flds, startPos).get,
        InstrmtLegGrpComponent.decode(flds, startPos),
        UndInstrmtGrpComponent.decode(flds, startPos),
        AdvSideField.decode(myFields.get(AdvSideField.TagId)).get,
        QuantityField.decode(myFields.get(QuantityField.TagId)).get,
        myFields.get(QtyTypeField.TagId).flatMap(f=>QtyTypeField.decode(f)),
        myFields.get(PriceField.TagId).flatMap(f=>PriceField.decode(f)),
        myFields.get(CurrencyField.TagId).flatMap(f=>CurrencyField.decode(f)),
        myFields.get(TradeDateField.TagId).flatMap(f=>TradeDateField.decode(f)),
        myFields.get(TransactTimeField.TagId).flatMap(f=>TransactTimeField.decode(f)),
        myFields.get(TextField.TagId).flatMap(f=>TextField.decode(f)),
        myFields.get(EncodedTextLenField.TagId).flatMap(f=>EncodedTextLenField.decode(f)),
        myFields.get(EncodedTextField.TagId).flatMap(f=>EncodedTextField.decode(f)),
        myFields.get(URLLinkField.TagId).flatMap(f=>URLLinkField.decode(f)),
        myFields.get(LastMktField.TagId).flatMap(f=>LastMktField.decode(f)),
        myFields.get(TradingSessionIDField.TagId).flatMap(f=>TradingSessionIDField.decode(f)),
        myFields.get(TradingSessionSubIDField.TagId).flatMap(f=>TradingSessionSubIDField.decode(f))))
    } else None
  }

    
}
     