package org.sackfix.fix50sp2

import org.sackfix.field._
import org.sackfix.common.validated.fields.{SfFixMessageBody, SfFixMessageDecoder, SfFixFieldsToAscii, SfFixRenderable}
import org.sackfix.common.message.SfRepeatingGroupCountException
import scala.annotation.tailrec
import scala.collection.immutable.HashSet
import scala.collection.mutable.ArrayBuffer


/**
  * Generated by SackFix code generator on 20170404
  * Source specification was read from:
  *   /quickfixj1.6.0/FIX50SP2.xml
  */
case class ApplicationMessageRequestAckMessage(applResponseIDField:ApplResponseIDField,
                                               applReqIDField:Option[ApplReqIDField]=None,
                                               applReqTypeField:Option[ApplReqTypeField]=None,
                                               applResponseTypeField:Option[ApplResponseTypeField]=None,
                                               applTotalMessageCountField:Option[ApplTotalMessageCountField]=None,
                                               applIDRequestAckGrpComponent:Option[ApplIDRequestAckGrpComponent]=None,
                                               partiesComponent:Option[PartiesComponent]=None,
                                               textField:Option[TextField]=None,
                                               encodedTextLenField:Option[EncodedTextLenField]=None,
                                               encodedTextField:Option[EncodedTextField]=None) extends SfFixMessageBody("BX")  with SfFixRenderable with SfFixFieldsToAscii {

  override lazy val fixStr : String = appendFixStr().toString
  override def appendFixStr(b:StringBuilder = new StringBuilder): StringBuilder = format(formatForFix, b)

  override def toString():String = appendStringBuilder().toString()
  def appendStringBuilder(b:StringBuilder = new StringBuilder) : StringBuilder = format(formatForToString, b)

  def format( fmt: ((StringBuilder,SfFixRenderable)=>Unit), b:StringBuilder = new StringBuilder()): StringBuilder = {
    fmt(b,applResponseIDField)
    applReqIDField.foreach(fmt(b,_))
    applReqTypeField.foreach(fmt(b,_))
    applResponseTypeField.foreach(fmt(b,_))
    applTotalMessageCountField.foreach(fmt(b,_))
    applIDRequestAckGrpComponent.foreach(fmt(b,_))
    partiesComponent.foreach(fmt(b,_))
    textField.foreach(fmt(b,_))
    encodedTextLenField.foreach(fmt(b,_))
    encodedTextField.foreach(fmt(b,_))
    b
  }

}
     
object ApplicationMessageRequestAckMessage extends SfFixMessageDecoder {
  val MsgType="BX"
  val MsgName="ApplicationMessageRequestAck"
             
  override val MandatoryFields = HashSet[Int](
    ApplResponseIDField.TagId)

  override def isMandatoryField(tagId:Int) : Boolean = {
    MandatoryFields.contains(tagId)  || 
    ApplIDRequestAckGrpComponent.isMandatoryField(tagId) || PartiesComponent.isMandatoryField(tagId)
  }

  override val OptionalFields = HashSet[Int](
    ApplReqIDField.TagId, ApplReqTypeField.TagId, ApplResponseTypeField.TagId, ApplTotalMessageCountField.TagId, TextField.TagId, 
    EncodedTextLenField.TagId, EncodedTextField.TagId)

  override def isOptionalField(tagId:Int) : Boolean = {
    OptionalFields.contains(tagId)  || 
    ApplIDRequestAckGrpComponent.isOptionalField(tagId) || PartiesComponent.isOptionalField(tagId)
  }

  override def isFieldOf(tagId:Int) : Boolean = isMandatoryField(tagId) || isOptionalField(tagId)  || 
    ApplIDRequestAckGrpComponent.isFieldOf(tagId) || PartiesComponent.isFieldOf(tagId)

   override lazy val RepeatingGroupsTags = HashSet[Int]()
  
      
  override def isFirstField(tagId:Int) : Boolean = tagId==ApplResponseIDField.TagId 

  override def decode(flds: Seq[Tuple2[Int, Any]], startPos:Int = 0):Option[SfFixMessageBody] = {
    val (pos, myFields, nextTagPosLookup) = extractMyFieldsAndPopulatePositions(false, flds, startPos)
    validateMandatoryFieldsPresent(myFields)

    if (MandatoryFields.isEmpty || myFields.nonEmpty) {
      Some(ApplicationMessageRequestAckMessage(ApplResponseIDField.decode(myFields.get(ApplResponseIDField.TagId)).get,
        myFields.get(ApplReqIDField.TagId).flatMap(f=>ApplReqIDField.decode(f)),
        myFields.get(ApplReqTypeField.TagId).flatMap(f=>ApplReqTypeField.decode(f)),
        myFields.get(ApplResponseTypeField.TagId).flatMap(f=>ApplResponseTypeField.decode(f)),
        myFields.get(ApplTotalMessageCountField.TagId).flatMap(f=>ApplTotalMessageCountField.decode(f)),
        ApplIDRequestAckGrpComponent.decode(flds, startPos),
        PartiesComponent.decode(flds, startPos),
        myFields.get(TextField.TagId).flatMap(f=>TextField.decode(f)),
        myFields.get(EncodedTextLenField.TagId).flatMap(f=>EncodedTextLenField.decode(f)),
        myFields.get(EncodedTextField.TagId).flatMap(f=>EncodedTextField.decode(f))))
    } else None
  }

    
}
     