package org.sackfix.fix50sp2

import org.sackfix.field._
import org.sackfix.common.validated.fields.{SfFixComponent, SfFixDecoder, SfFixFieldsToAscii, SfFixRenderable}
import org.sackfix.common.message.SfRepeatingGroupCountException
import scala.annotation.tailrec
import scala.collection.immutable.HashSet
import scala.collection.mutable.ArrayBuffer


/**
  * Generated by SackFix code generator on 20170404
  * Source specification was read from:
  *   /quickfixj1.6.0/FIX50SP2.xml
  */
case class BaseTradingRulesComponent(tickRulesComponent:Option[TickRulesComponent]=None,
                                     lotTypeRulesComponent:Option[LotTypeRulesComponent]=None,
                                     priceLimitsComponent:Option[PriceLimitsComponent]=None,
                                     expirationCycleField:Option[ExpirationCycleField]=None,
                                     minTradeVolField:Option[MinTradeVolField]=None,
                                     maxTradeVolField:Option[MaxTradeVolField]=None,
                                     maxPriceVariationField:Option[MaxPriceVariationField]=None,
                                     impliedMarketIndicatorField:Option[ImpliedMarketIndicatorField]=None,
                                     tradingCurrencyField:Option[TradingCurrencyField]=None,
                                     roundLotField:Option[RoundLotField]=None,
                                     multilegModelField:Option[MultilegModelField]=None,
                                     multilegPriceMethodField:Option[MultilegPriceMethodField]=None,
                                     priceTypeField:Option[PriceTypeField]=None) extends SfFixComponent  with SfFixRenderable with SfFixFieldsToAscii {

  override lazy val fixStr : String = appendFixStr().toString
  override def appendFixStr(b:StringBuilder = new StringBuilder): StringBuilder = format(formatForFix, b)

  override def toString():String = appendStringBuilder().toString()
  def appendStringBuilder(b:StringBuilder = new StringBuilder) : StringBuilder = format(formatForToString, b)

  def format( fmt: ((StringBuilder,SfFixRenderable)=>Unit), b:StringBuilder = new StringBuilder()): StringBuilder = {
    tickRulesComponent.foreach(fmt(b,_))
    lotTypeRulesComponent.foreach(fmt(b,_))
    priceLimitsComponent.foreach(fmt(b,_))
    expirationCycleField.foreach(fmt(b,_))
    minTradeVolField.foreach(fmt(b,_))
    maxTradeVolField.foreach(fmt(b,_))
    maxPriceVariationField.foreach(fmt(b,_))
    impliedMarketIndicatorField.foreach(fmt(b,_))
    tradingCurrencyField.foreach(fmt(b,_))
    roundLotField.foreach(fmt(b,_))
    multilegModelField.foreach(fmt(b,_))
    multilegPriceMethodField.foreach(fmt(b,_))
    priceTypeField.foreach(fmt(b,_))
    b
  }

}
     
object BaseTradingRulesComponent extends SfFixDecoder {

  override val MandatoryFields = HashSet[Int]()

  override def isMandatoryField(tagId:Int) : Boolean = {
    MandatoryFields.contains(tagId)  || 
    TickRulesComponent.isMandatoryField(tagId) || LotTypeRulesComponent.isMandatoryField(tagId) || PriceLimitsComponent.isMandatoryField(tagId)
  }

  override val OptionalFields = HashSet[Int](
    ExpirationCycleField.TagId, MinTradeVolField.TagId, MaxTradeVolField.TagId, MaxPriceVariationField.TagId, ImpliedMarketIndicatorField.TagId, 
    TradingCurrencyField.TagId, RoundLotField.TagId, MultilegModelField.TagId, MultilegPriceMethodField.TagId, PriceTypeField.TagId)

  override def isOptionalField(tagId:Int) : Boolean = {
    OptionalFields.contains(tagId)  || 
    TickRulesComponent.isOptionalField(tagId) || LotTypeRulesComponent.isOptionalField(tagId) || PriceLimitsComponent.isOptionalField(tagId)
  }

  override def isFieldOf(tagId:Int) : Boolean = isMandatoryField(tagId) || isOptionalField(tagId)  || 
    TickRulesComponent.isFieldOf(tagId) || LotTypeRulesComponent.isFieldOf(tagId) || PriceLimitsComponent.isFieldOf(tagId)

   override lazy val RepeatingGroupsTags = HashSet[Int]()
  
      
  override def isFirstField(tagId:Int) : Boolean = TickRulesComponent.isFirstField(tagId) 

  def decode(flds: Seq[Tuple2[Int, Any]], startPos:Int = 0):Option[BaseTradingRulesComponent] = {
    val (pos, myFields, nextTagPosLookup) = extractMyFieldsAndPopulatePositions(false, flds, startPos)
    validateMandatoryFieldsPresent(myFields)

    if (myFields.nonEmpty) {
      Some(BaseTradingRulesComponent(TickRulesComponent.decode(flds, startPos),
        LotTypeRulesComponent.decode(flds, startPos),
        PriceLimitsComponent.decode(flds, startPos),
        myFields.get(ExpirationCycleField.TagId).flatMap(f=>ExpirationCycleField.decode(f)),
        myFields.get(MinTradeVolField.TagId).flatMap(f=>MinTradeVolField.decode(f)),
        myFields.get(MaxTradeVolField.TagId).flatMap(f=>MaxTradeVolField.decode(f)),
        myFields.get(MaxPriceVariationField.TagId).flatMap(f=>MaxPriceVariationField.decode(f)),
        myFields.get(ImpliedMarketIndicatorField.TagId).flatMap(f=>ImpliedMarketIndicatorField.decode(f)),
        myFields.get(TradingCurrencyField.TagId).flatMap(f=>TradingCurrencyField.decode(f)),
        myFields.get(RoundLotField.TagId).flatMap(f=>RoundLotField.decode(f)),
        myFields.get(MultilegModelField.TagId).flatMap(f=>MultilegModelField.decode(f)),
        myFields.get(MultilegPriceMethodField.TagId).flatMap(f=>MultilegPriceMethodField.decode(f)),
        myFields.get(PriceTypeField.TagId).flatMap(f=>PriceTypeField.decode(f))))
    } else None
  }

    
}
     