package org.sackfix.fix50sp2

import org.sackfix.field._
import org.sackfix.common.validated.fields.{SfFixComponent, SfFixDecoder, SfFixFieldsToAscii, SfFixRenderable}
import org.sackfix.common.message.SfRepeatingGroupCountException
import scala.annotation.tailrec
import scala.collection.immutable.HashSet
import scala.collection.mutable.ArrayBuffer


/**
  * Generated by SackFix code generator on 20170404
  * Source specification was read from:
  *   /quickfixj1.6.0/FIX50SP2.xml
  */
case class ComplexEventsComponent(noComplexEventsField:Option[NoComplexEventsField]=None,
                                  complexEventsGroups: Option[List[ComplexEventsGroup]]=None) extends SfFixComponent  with SfFixRenderable with SfFixFieldsToAscii {
  if (noComplexEventsField.map(_.value).getOrElse(0) != complexEventsGroups.map(_.size).getOrElse(0))
    throw SfRepeatingGroupCountException(NoComplexEventsField.TagId,noComplexEventsField.map(_.value).getOrElse(0), complexEventsGroups.map(_.size).getOrElse(0))

  override lazy val fixStr : String = appendFixStr().toString
  override def appendFixStr(b:StringBuilder = new StringBuilder): StringBuilder = format(formatForFix, b)

  override def toString():String = appendStringBuilder().toString()
  def appendStringBuilder(b:StringBuilder = new StringBuilder) : StringBuilder = format(formatForToString, b)

  def format( fmt: ((StringBuilder,SfFixRenderable)=>Unit), b:StringBuilder = new StringBuilder()): StringBuilder = {
    noComplexEventsField.foreach(fmt(b,_))
    complexEventsGroups.getOrElse(List.empty).foreach(fmt(b,_))
    b
  }

}
     
object ComplexEventsComponent extends SfFixDecoder {

  override val MandatoryFields = HashSet[Int]()

  override def isMandatoryField(tagId:Int) : Boolean = {
    MandatoryFields.contains(tagId)  || 
    ComplexEventsGroup.isMandatoryField(tagId)
  }

  override val OptionalFields = HashSet[Int](
    NoComplexEventsField.TagId)

  override def isOptionalField(tagId:Int) : Boolean = {
    OptionalFields.contains(tagId)  || 
    ComplexEventsGroup.isOptionalField(tagId)
  }

  override def isFieldOf(tagId:Int) : Boolean = isMandatoryField(tagId) || isOptionalField(tagId)  || 
    ComplexEventsGroup.isFieldOf(tagId)

   override lazy val RepeatingGroupsTags = HashSet[Int](
    NoComplexEventsField.TagId)
  
      
  override def isFirstField(tagId:Int) : Boolean = ComplexEventsGroup.isFirstField(tagId) 

  def decode(flds: Seq[Tuple2[Int, Any]], startPos:Int = 0):Option[ComplexEventsComponent] = {
    val (pos, myFields, nextTagPosLookup) = extractMyFieldsAndPopulatePositions(false, flds, startPos)
    validateMandatoryFieldsPresent(myFields)

    if (myFields.nonEmpty) {
      Some(ComplexEventsComponent(myFields.get(NoComplexEventsField.TagId).flatMap(f=>NoComplexEventsField.decode(f)),
        if (nextTagPosLookup.contains(NoComplexEventsField.TagId)) ComplexEventsGroup.decode(flds, nextTagPosLookup(NoComplexEventsField.TagId)) else None))
    } else None
  }

    
}
     