package org.sackfix.fix50sp2

import org.sackfix.field._
import org.sackfix.common.validated.fields.{SfFixMessageBody, SfFixMessageDecoder, SfFixFieldsToAscii, SfFixRenderable}
import org.sackfix.common.message.SfRepeatingGroupCountException
import scala.annotation.tailrec
import scala.collection.immutable.HashSet
import scala.collection.mutable.ArrayBuffer


/**
  * Generated by SackFix code generator on 20170404
  * Source specification was read from:
  *   /quickfixj1.6.0/FIX50SP2.xml
  */
case class ExecutionReportMessage(applicationSequenceControlComponent:Option[ApplicationSequenceControlComponent]=None,
                                  orderIDField:OrderIDField,
                                  secondaryOrderIDField:Option[SecondaryOrderIDField]=None,
                                  secondaryClOrdIDField:Option[SecondaryClOrdIDField]=None,
                                  secondaryExecIDField:Option[SecondaryExecIDField]=None,
                                  clOrdIDField:Option[ClOrdIDField]=None,
                                  origClOrdIDField:Option[OrigClOrdIDField]=None,
                                  clOrdLinkIDField:Option[ClOrdLinkIDField]=None,
                                  quoteRespIDField:Option[QuoteRespIDField]=None,
                                  ordStatusReqIDField:Option[OrdStatusReqIDField]=None,
                                  massStatusReqIDField:Option[MassStatusReqIDField]=None,
                                  hostCrossIDField:Option[HostCrossIDField]=None,
                                  totNumReportsField:Option[TotNumReportsField]=None,
                                  lastRptRequestedField:Option[LastRptRequestedField]=None,
                                  partiesComponent:Option[PartiesComponent]=None,
                                  tradeOriginationDateField:Option[TradeOriginationDateField]=None,
                                  contraGrpComponent:Option[ContraGrpComponent]=None,
                                  listIDField:Option[ListIDField]=None,
                                  crossIDField:Option[CrossIDField]=None,
                                  origCrossIDField:Option[OrigCrossIDField]=None,
                                  crossTypeField:Option[CrossTypeField]=None,
                                  trdMatchIDField:Option[TrdMatchIDField]=None,
                                  execIDField:ExecIDField,
                                  execRefIDField:Option[ExecRefIDField]=None,
                                  execTypeField:ExecTypeField,
                                  ordStatusField:OrdStatusField,
                                  workingIndicatorField:Option[WorkingIndicatorField]=None,
                                  ordRejReasonField:Option[OrdRejReasonField]=None,
                                  execRestatementReasonField:Option[ExecRestatementReasonField]=None,
                                  accountField:Option[AccountField]=None,
                                  acctIDSourceField:Option[AcctIDSourceField]=None,
                                  accountTypeField:Option[AccountTypeField]=None,
                                  dayBookingInstField:Option[DayBookingInstField]=None,
                                  bookingUnitField:Option[BookingUnitField]=None,
                                  preallocMethodField:Option[PreallocMethodField]=None,
                                  allocIDField:Option[AllocIDField]=None,
                                  preAllocGrpComponent:Option[PreAllocGrpComponent]=None,
                                  settlTypeField:Option[SettlTypeField]=None,
                                  settlDateField:Option[SettlDateField]=None,
                                  matchTypeField:Option[MatchTypeField]=None,
                                  orderCategoryField:Option[OrderCategoryField]=None,
                                  cashMarginField:Option[CashMarginField]=None,
                                  clearingFeeIndicatorField:Option[ClearingFeeIndicatorField]=None,
                                  instrumentComponent:InstrumentComponent,
                                  financingDetailsComponent:Option[FinancingDetailsComponent]=None,
                                  undInstrmtGrpComponent:Option[UndInstrmtGrpComponent]=None,
                                  sideField:SideField,
                                  stipulationsComponent:Option[StipulationsComponent]=None,
                                  qtyTypeField:Option[QtyTypeField]=None,
                                  orderQtyDataComponent:Option[OrderQtyDataComponent]=None,
                                  lotTypeField:Option[LotTypeField]=None,
                                  ordTypeField:Option[OrdTypeField]=None,
                                  priceTypeField:Option[PriceTypeField]=None,
                                  priceField:Option[PriceField]=None,
                                  priceProtectionScopeField:Option[PriceProtectionScopeField]=None,
                                  stopPxField:Option[StopPxField]=None,
                                  triggeringInstructionComponent:Option[TriggeringInstructionComponent]=None,
                                  pegInstructionsComponent:Option[PegInstructionsComponent]=None,
                                  discretionInstructionsComponent:Option[DiscretionInstructionsComponent]=None,
                                  peggedPriceField:Option[PeggedPriceField]=None,
                                  peggedRefPriceField:Option[PeggedRefPriceField]=None,
                                  discretionPriceField:Option[DiscretionPriceField]=None,
                                  targetStrategyField:Option[TargetStrategyField]=None,
                                  strategyParametersGrpComponent:Option[StrategyParametersGrpComponent]=None,
                                  targetStrategyParametersField:Option[TargetStrategyParametersField]=None,
                                  participationRateField:Option[ParticipationRateField]=None,
                                  targetStrategyPerformanceField:Option[TargetStrategyPerformanceField]=None,
                                  currencyField:Option[CurrencyField]=None,
                                  complianceIDField:Option[ComplianceIDField]=None,
                                  solicitedFlagField:Option[SolicitedFlagField]=None,
                                  timeInForceField:Option[TimeInForceField]=None,
                                  effectiveTimeField:Option[EffectiveTimeField]=None,
                                  expireDateField:Option[ExpireDateField]=None,
                                  expireTimeField:Option[ExpireTimeField]=None,
                                  execInstField:Option[ExecInstField]=None,
                                  aggressorIndicatorField:Option[AggressorIndicatorField]=None,
                                  orderCapacityField:Option[OrderCapacityField]=None,
                                  orderRestrictionsField:Option[OrderRestrictionsField]=None,
                                  preTradeAnonymityField:Option[PreTradeAnonymityField]=None,
                                  custOrderCapacityField:Option[CustOrderCapacityField]=None,
                                  lastQtyField:Option[LastQtyField]=None,
                                  calculatedCcyLastQtyField:Option[CalculatedCcyLastQtyField]=None,
                                  lastSwapPointsField:Option[LastSwapPointsField]=None,
                                  underlyingLastQtyField:Option[UnderlyingLastQtyField]=None,
                                  lastPxField:Option[LastPxField]=None,
                                  underlyingLastPxField:Option[UnderlyingLastPxField]=None,
                                  lastParPxField:Option[LastParPxField]=None,
                                  lastSpotRateField:Option[LastSpotRateField]=None,
                                  lastForwardPointsField:Option[LastForwardPointsField]=None,
                                  lastMktField:Option[LastMktField]=None,
                                  tradingSessionIDField:Option[TradingSessionIDField]=None,
                                  tradingSessionSubIDField:Option[TradingSessionSubIDField]=None,
                                  timeBracketField:Option[TimeBracketField]=None,
                                  lastCapacityField:Option[LastCapacityField]=None,
                                  leavesQtyField:LeavesQtyField,
                                  cumQtyField:CumQtyField,
                                  avgPxField:Option[AvgPxField]=None,
                                  dayOrderQtyField:Option[DayOrderQtyField]=None,
                                  dayCumQtyField:Option[DayCumQtyField]=None,
                                  dayAvgPxField:Option[DayAvgPxField]=None,
                                  totNoFillsField:Option[TotNoFillsField]=None,
                                  lastFragmentField:Option[LastFragmentField]=None,
                                  fillsGrpComponent:Option[FillsGrpComponent]=None,
                                  gTBookingInstField:Option[GTBookingInstField]=None,
                                  tradeDateField:Option[TradeDateField]=None,
                                  transactTimeField:Option[TransactTimeField]=None,
                                  reportToExchField:Option[ReportToExchField]=None,
                                  commissionDataComponent:Option[CommissionDataComponent]=None,
                                  spreadOrBenchmarkCurveDataComponent:Option[SpreadOrBenchmarkCurveDataComponent]=None,
                                  yieldDataComponent:Option[YieldDataComponent]=None,
                                  grossTradeAmtField:Option[GrossTradeAmtField]=None,
                                  numDaysInterestField:Option[NumDaysInterestField]=None,
                                  exDateField:Option[ExDateField]=None,
                                  accruedInterestRateField:Option[AccruedInterestRateField]=None,
                                  accruedInterestAmtField:Option[AccruedInterestAmtField]=None,
                                  interestAtMaturityField:Option[InterestAtMaturityField]=None,
                                  endAccruedInterestAmtField:Option[EndAccruedInterestAmtField]=None,
                                  startCashField:Option[StartCashField]=None,
                                  endCashField:Option[EndCashField]=None,
                                  tradedFlatSwitchField:Option[TradedFlatSwitchField]=None,
                                  basisFeatureDateField:Option[BasisFeatureDateField]=None,
                                  basisFeaturePriceField:Option[BasisFeaturePriceField]=None,
                                  concessionField:Option[ConcessionField]=None,
                                  totalTakedownField:Option[TotalTakedownField]=None,
                                  netMoneyField:Option[NetMoneyField]=None,
                                  settlCurrAmtField:Option[SettlCurrAmtField]=None,
                                  settlCurrencyField:Option[SettlCurrencyField]=None,
                                  rateSourceComponent:Option[RateSourceComponent]=None,
                                  settlCurrFxRateField:Option[SettlCurrFxRateField]=None,
                                  settlCurrFxRateCalcField:Option[SettlCurrFxRateCalcField]=None,
                                  handlInstField:Option[HandlInstField]=None,
                                  minQtyField:Option[MinQtyField]=None,
                                  matchIncrementField:Option[MatchIncrementField]=None,
                                  maxPriceLevelsField:Option[MaxPriceLevelsField]=None,
                                  displayInstructionComponent:Option[DisplayInstructionComponent]=None,
                                  maxFloorField:Option[MaxFloorField]=None,
                                  positionEffectField:Option[PositionEffectField]=None,
                                  maxShowField:Option[MaxShowField]=None,
                                  bookingTypeField:Option[BookingTypeField]=None,
                                  textField:Option[TextField]=None,
                                  encodedTextLenField:Option[EncodedTextLenField]=None,
                                  encodedTextField:Option[EncodedTextField]=None,
                                  settlDate2Field:Option[SettlDate2Field]=None,
                                  orderQty2Field:Option[OrderQty2Field]=None,
                                  lastForwardPoints2Field:Option[LastForwardPoints2Field]=None,
                                  multiLegReportingTypeField:Option[MultiLegReportingTypeField]=None,
                                  cancellationRightsField:Option[CancellationRightsField]=None,
                                  moneyLaunderingStatusField:Option[MoneyLaunderingStatusField]=None,
                                  registIDField:Option[RegistIDField]=None,
                                  designationField:Option[DesignationField]=None,
                                  transBkdTimeField:Option[TransBkdTimeField]=None,
                                  execValuationPointField:Option[ExecValuationPointField]=None,
                                  execPriceTypeField:Option[ExecPriceTypeField]=None,
                                  execPriceAdjustmentField:Option[ExecPriceAdjustmentField]=None,
                                  priorityIndicatorField:Option[PriorityIndicatorField]=None,
                                  priceImprovementField:Option[PriceImprovementField]=None,
                                  lastLiquidityIndField:Option[LastLiquidityIndField]=None,
                                  contAmtGrpComponent:Option[ContAmtGrpComponent]=None,
                                  instrmtLegExecGrpComponent:Option[InstrmtLegExecGrpComponent]=None,
                                  copyMsgIndicatorField:Option[CopyMsgIndicatorField]=None,
                                  miscFeesGrpComponent:Option[MiscFeesGrpComponent]=None,
                                  dividendYieldField:Option[DividendYieldField]=None,
                                  manualOrderIndicatorField:Option[ManualOrderIndicatorField]=None,
                                  custDirectedOrderField:Option[CustDirectedOrderField]=None,
                                  receivedDeptIDField:Option[ReceivedDeptIDField]=None,
                                  custOrderHandlingInstField:Option[CustOrderHandlingInstField]=None,
                                  orderHandlingInstSourceField:Option[OrderHandlingInstSourceField]=None,
                                  trdRegTimestampsComponent:Option[TrdRegTimestampsComponent]=None,
                                  volatilityField:Option[VolatilityField]=None,
                                  timeToExpirationField:Option[TimeToExpirationField]=None,
                                  riskFreeRateField:Option[RiskFreeRateField]=None,
                                  priceDeltaField:Option[PriceDeltaField]=None) extends SfFixMessageBody("8")  with SfFixRenderable with SfFixFieldsToAscii {

  override lazy val fixStr : String = appendFixStr().toString
  override def appendFixStr(b:StringBuilder = new StringBuilder): StringBuilder = format(formatForFix, b)

  override def toString():String = appendStringBuilder().toString()
  def appendStringBuilder(b:StringBuilder = new StringBuilder) : StringBuilder = format(formatForToString, b)

  def format( fmt: ((StringBuilder,SfFixRenderable)=>Unit), b:StringBuilder = new StringBuilder()): StringBuilder = {
    applicationSequenceControlComponent.foreach(fmt(b,_))
    fmt(b,orderIDField)
    secondaryOrderIDField.foreach(fmt(b,_))
    secondaryClOrdIDField.foreach(fmt(b,_))
    secondaryExecIDField.foreach(fmt(b,_))
    clOrdIDField.foreach(fmt(b,_))
    origClOrdIDField.foreach(fmt(b,_))
    clOrdLinkIDField.foreach(fmt(b,_))
    quoteRespIDField.foreach(fmt(b,_))
    ordStatusReqIDField.foreach(fmt(b,_))
    massStatusReqIDField.foreach(fmt(b,_))
    hostCrossIDField.foreach(fmt(b,_))
    totNumReportsField.foreach(fmt(b,_))
    lastRptRequestedField.foreach(fmt(b,_))
    partiesComponent.foreach(fmt(b,_))
    tradeOriginationDateField.foreach(fmt(b,_))
    contraGrpComponent.foreach(fmt(b,_))
    listIDField.foreach(fmt(b,_))
    crossIDField.foreach(fmt(b,_))
    origCrossIDField.foreach(fmt(b,_))
    crossTypeField.foreach(fmt(b,_))
    trdMatchIDField.foreach(fmt(b,_))
    fmt(b,execIDField)
    execRefIDField.foreach(fmt(b,_))
    fmt(b,execTypeField)
    fmt(b,ordStatusField)
    workingIndicatorField.foreach(fmt(b,_))
    ordRejReasonField.foreach(fmt(b,_))
    execRestatementReasonField.foreach(fmt(b,_))
    accountField.foreach(fmt(b,_))
    acctIDSourceField.foreach(fmt(b,_))
    accountTypeField.foreach(fmt(b,_))
    dayBookingInstField.foreach(fmt(b,_))
    bookingUnitField.foreach(fmt(b,_))
    preallocMethodField.foreach(fmt(b,_))
    allocIDField.foreach(fmt(b,_))
    preAllocGrpComponent.foreach(fmt(b,_))
    settlTypeField.foreach(fmt(b,_))
    settlDateField.foreach(fmt(b,_))
    matchTypeField.foreach(fmt(b,_))
    orderCategoryField.foreach(fmt(b,_))
    cashMarginField.foreach(fmt(b,_))
    clearingFeeIndicatorField.foreach(fmt(b,_))
    fmt(b,instrumentComponent)
    financingDetailsComponent.foreach(fmt(b,_))
    undInstrmtGrpComponent.foreach(fmt(b,_))
    fmt(b,sideField)
    stipulationsComponent.foreach(fmt(b,_))
    qtyTypeField.foreach(fmt(b,_))
    orderQtyDataComponent.foreach(fmt(b,_))
    lotTypeField.foreach(fmt(b,_))
    ordTypeField.foreach(fmt(b,_))
    priceTypeField.foreach(fmt(b,_))
    priceField.foreach(fmt(b,_))
    priceProtectionScopeField.foreach(fmt(b,_))
    stopPxField.foreach(fmt(b,_))
    triggeringInstructionComponent.foreach(fmt(b,_))
    pegInstructionsComponent.foreach(fmt(b,_))
    discretionInstructionsComponent.foreach(fmt(b,_))
    peggedPriceField.foreach(fmt(b,_))
    peggedRefPriceField.foreach(fmt(b,_))
    discretionPriceField.foreach(fmt(b,_))
    targetStrategyField.foreach(fmt(b,_))
    strategyParametersGrpComponent.foreach(fmt(b,_))
    targetStrategyParametersField.foreach(fmt(b,_))
    participationRateField.foreach(fmt(b,_))
    targetStrategyPerformanceField.foreach(fmt(b,_))
    currencyField.foreach(fmt(b,_))
    complianceIDField.foreach(fmt(b,_))
    solicitedFlagField.foreach(fmt(b,_))
    timeInForceField.foreach(fmt(b,_))
    effectiveTimeField.foreach(fmt(b,_))
    expireDateField.foreach(fmt(b,_))
    expireTimeField.foreach(fmt(b,_))
    execInstField.foreach(fmt(b,_))
    aggressorIndicatorField.foreach(fmt(b,_))
    orderCapacityField.foreach(fmt(b,_))
    orderRestrictionsField.foreach(fmt(b,_))
    preTradeAnonymityField.foreach(fmt(b,_))
    custOrderCapacityField.foreach(fmt(b,_))
    lastQtyField.foreach(fmt(b,_))
    calculatedCcyLastQtyField.foreach(fmt(b,_))
    lastSwapPointsField.foreach(fmt(b,_))
    underlyingLastQtyField.foreach(fmt(b,_))
    lastPxField.foreach(fmt(b,_))
    underlyingLastPxField.foreach(fmt(b,_))
    lastParPxField.foreach(fmt(b,_))
    lastSpotRateField.foreach(fmt(b,_))
    lastForwardPointsField.foreach(fmt(b,_))
    lastMktField.foreach(fmt(b,_))
    tradingSessionIDField.foreach(fmt(b,_))
    tradingSessionSubIDField.foreach(fmt(b,_))
    timeBracketField.foreach(fmt(b,_))
    lastCapacityField.foreach(fmt(b,_))
    fmt(b,leavesQtyField)
    fmt(b,cumQtyField)
    avgPxField.foreach(fmt(b,_))
    dayOrderQtyField.foreach(fmt(b,_))
    dayCumQtyField.foreach(fmt(b,_))
    dayAvgPxField.foreach(fmt(b,_))
    totNoFillsField.foreach(fmt(b,_))
    lastFragmentField.foreach(fmt(b,_))
    fillsGrpComponent.foreach(fmt(b,_))
    gTBookingInstField.foreach(fmt(b,_))
    tradeDateField.foreach(fmt(b,_))
    transactTimeField.foreach(fmt(b,_))
    reportToExchField.foreach(fmt(b,_))
    commissionDataComponent.foreach(fmt(b,_))
    spreadOrBenchmarkCurveDataComponent.foreach(fmt(b,_))
    yieldDataComponent.foreach(fmt(b,_))
    grossTradeAmtField.foreach(fmt(b,_))
    numDaysInterestField.foreach(fmt(b,_))
    exDateField.foreach(fmt(b,_))
    accruedInterestRateField.foreach(fmt(b,_))
    accruedInterestAmtField.foreach(fmt(b,_))
    interestAtMaturityField.foreach(fmt(b,_))
    endAccruedInterestAmtField.foreach(fmt(b,_))
    startCashField.foreach(fmt(b,_))
    endCashField.foreach(fmt(b,_))
    tradedFlatSwitchField.foreach(fmt(b,_))
    basisFeatureDateField.foreach(fmt(b,_))
    basisFeaturePriceField.foreach(fmt(b,_))
    concessionField.foreach(fmt(b,_))
    totalTakedownField.foreach(fmt(b,_))
    netMoneyField.foreach(fmt(b,_))
    settlCurrAmtField.foreach(fmt(b,_))
    settlCurrencyField.foreach(fmt(b,_))
    rateSourceComponent.foreach(fmt(b,_))
    settlCurrFxRateField.foreach(fmt(b,_))
    settlCurrFxRateCalcField.foreach(fmt(b,_))
    handlInstField.foreach(fmt(b,_))
    minQtyField.foreach(fmt(b,_))
    matchIncrementField.foreach(fmt(b,_))
    maxPriceLevelsField.foreach(fmt(b,_))
    displayInstructionComponent.foreach(fmt(b,_))
    maxFloorField.foreach(fmt(b,_))
    positionEffectField.foreach(fmt(b,_))
    maxShowField.foreach(fmt(b,_))
    bookingTypeField.foreach(fmt(b,_))
    textField.foreach(fmt(b,_))
    encodedTextLenField.foreach(fmt(b,_))
    encodedTextField.foreach(fmt(b,_))
    settlDate2Field.foreach(fmt(b,_))
    orderQty2Field.foreach(fmt(b,_))
    lastForwardPoints2Field.foreach(fmt(b,_))
    multiLegReportingTypeField.foreach(fmt(b,_))
    cancellationRightsField.foreach(fmt(b,_))
    moneyLaunderingStatusField.foreach(fmt(b,_))
    registIDField.foreach(fmt(b,_))
    designationField.foreach(fmt(b,_))
    transBkdTimeField.foreach(fmt(b,_))
    execValuationPointField.foreach(fmt(b,_))
    execPriceTypeField.foreach(fmt(b,_))
    execPriceAdjustmentField.foreach(fmt(b,_))
    priorityIndicatorField.foreach(fmt(b,_))
    priceImprovementField.foreach(fmt(b,_))
    lastLiquidityIndField.foreach(fmt(b,_))
    contAmtGrpComponent.foreach(fmt(b,_))
    instrmtLegExecGrpComponent.foreach(fmt(b,_))
    copyMsgIndicatorField.foreach(fmt(b,_))
    miscFeesGrpComponent.foreach(fmt(b,_))
    dividendYieldField.foreach(fmt(b,_))
    manualOrderIndicatorField.foreach(fmt(b,_))
    custDirectedOrderField.foreach(fmt(b,_))
    receivedDeptIDField.foreach(fmt(b,_))
    custOrderHandlingInstField.foreach(fmt(b,_))
    orderHandlingInstSourceField.foreach(fmt(b,_))
    trdRegTimestampsComponent.foreach(fmt(b,_))
    volatilityField.foreach(fmt(b,_))
    timeToExpirationField.foreach(fmt(b,_))
    riskFreeRateField.foreach(fmt(b,_))
    priceDeltaField.foreach(fmt(b,_))
    b
  }

}
     
object ExecutionReportMessage extends SfFixMessageDecoder {
  val MsgType="8"
  val MsgName="ExecutionReport"
             
  override val MandatoryFields = HashSet[Int](
    OrderIDField.TagId, ExecIDField.TagId, ExecTypeField.TagId, OrdStatusField.TagId, SideField.TagId, 
    LeavesQtyField.TagId, CumQtyField.TagId)

  override def isMandatoryField(tagId:Int) : Boolean = {
    MandatoryFields.contains(tagId)  || 
    ApplicationSequenceControlComponent.isMandatoryField(tagId) || PartiesComponent.isMandatoryField(tagId) || ContraGrpComponent.isMandatoryField(tagId) || PreAllocGrpComponent.isMandatoryField(tagId) || 
    InstrumentComponent.isMandatoryField(tagId) || FinancingDetailsComponent.isMandatoryField(tagId) || UndInstrmtGrpComponent.isMandatoryField(tagId) || StipulationsComponent.isMandatoryField(tagId) || 
    OrderQtyDataComponent.isMandatoryField(tagId) || TriggeringInstructionComponent.isMandatoryField(tagId) || PegInstructionsComponent.isMandatoryField(tagId) || DiscretionInstructionsComponent.isMandatoryField(tagId) || 
    StrategyParametersGrpComponent.isMandatoryField(tagId) || FillsGrpComponent.isMandatoryField(tagId) || CommissionDataComponent.isMandatoryField(tagId) || SpreadOrBenchmarkCurveDataComponent.isMandatoryField(tagId) || 
    YieldDataComponent.isMandatoryField(tagId) || RateSourceComponent.isMandatoryField(tagId) || DisplayInstructionComponent.isMandatoryField(tagId) || ContAmtGrpComponent.isMandatoryField(tagId) || 
    InstrmtLegExecGrpComponent.isMandatoryField(tagId) || MiscFeesGrpComponent.isMandatoryField(tagId) || TrdRegTimestampsComponent.isMandatoryField(tagId)
  }

  override val OptionalFields = HashSet[Int](
    SecondaryOrderIDField.TagId, SecondaryClOrdIDField.TagId, SecondaryExecIDField.TagId, ClOrdIDField.TagId, OrigClOrdIDField.TagId, 
    ClOrdLinkIDField.TagId, QuoteRespIDField.TagId, OrdStatusReqIDField.TagId, MassStatusReqIDField.TagId, HostCrossIDField.TagId, 
    TotNumReportsField.TagId, LastRptRequestedField.TagId, TradeOriginationDateField.TagId, ListIDField.TagId, CrossIDField.TagId, 
    OrigCrossIDField.TagId, CrossTypeField.TagId, TrdMatchIDField.TagId, ExecRefIDField.TagId, WorkingIndicatorField.TagId, 
    OrdRejReasonField.TagId, ExecRestatementReasonField.TagId, AccountField.TagId, AcctIDSourceField.TagId, AccountTypeField.TagId, 
    DayBookingInstField.TagId, BookingUnitField.TagId, PreallocMethodField.TagId, AllocIDField.TagId, SettlTypeField.TagId, 
    SettlDateField.TagId, MatchTypeField.TagId, OrderCategoryField.TagId, CashMarginField.TagId, ClearingFeeIndicatorField.TagId, 
    QtyTypeField.TagId, LotTypeField.TagId, OrdTypeField.TagId, PriceTypeField.TagId, PriceField.TagId, 
    PriceProtectionScopeField.TagId, StopPxField.TagId, PeggedPriceField.TagId, PeggedRefPriceField.TagId, DiscretionPriceField.TagId, 
    TargetStrategyField.TagId, TargetStrategyParametersField.TagId, ParticipationRateField.TagId, TargetStrategyPerformanceField.TagId, CurrencyField.TagId, 
    ComplianceIDField.TagId, SolicitedFlagField.TagId, TimeInForceField.TagId, EffectiveTimeField.TagId, ExpireDateField.TagId, 
    ExpireTimeField.TagId, ExecInstField.TagId, AggressorIndicatorField.TagId, OrderCapacityField.TagId, OrderRestrictionsField.TagId, 
    PreTradeAnonymityField.TagId, CustOrderCapacityField.TagId, LastQtyField.TagId, CalculatedCcyLastQtyField.TagId, LastSwapPointsField.TagId, 
    UnderlyingLastQtyField.TagId, LastPxField.TagId, UnderlyingLastPxField.TagId, LastParPxField.TagId, LastSpotRateField.TagId, 
    LastForwardPointsField.TagId, LastMktField.TagId, TradingSessionIDField.TagId, TradingSessionSubIDField.TagId, TimeBracketField.TagId, 
    LastCapacityField.TagId, AvgPxField.TagId, DayOrderQtyField.TagId, DayCumQtyField.TagId, DayAvgPxField.TagId, 
    TotNoFillsField.TagId, LastFragmentField.TagId, GTBookingInstField.TagId, TradeDateField.TagId, TransactTimeField.TagId, 
    ReportToExchField.TagId, GrossTradeAmtField.TagId, NumDaysInterestField.TagId, ExDateField.TagId, AccruedInterestRateField.TagId, 
    AccruedInterestAmtField.TagId, InterestAtMaturityField.TagId, EndAccruedInterestAmtField.TagId, StartCashField.TagId, EndCashField.TagId, 
    TradedFlatSwitchField.TagId, BasisFeatureDateField.TagId, BasisFeaturePriceField.TagId, ConcessionField.TagId, TotalTakedownField.TagId, 
    NetMoneyField.TagId, SettlCurrAmtField.TagId, SettlCurrencyField.TagId, SettlCurrFxRateField.TagId, SettlCurrFxRateCalcField.TagId, 
    HandlInstField.TagId, MinQtyField.TagId, MatchIncrementField.TagId, MaxPriceLevelsField.TagId, MaxFloorField.TagId, 
    PositionEffectField.TagId, MaxShowField.TagId, BookingTypeField.TagId, TextField.TagId, EncodedTextLenField.TagId, 
    EncodedTextField.TagId, SettlDate2Field.TagId, OrderQty2Field.TagId, LastForwardPoints2Field.TagId, MultiLegReportingTypeField.TagId, 
    CancellationRightsField.TagId, MoneyLaunderingStatusField.TagId, RegistIDField.TagId, DesignationField.TagId, TransBkdTimeField.TagId, 
    ExecValuationPointField.TagId, ExecPriceTypeField.TagId, ExecPriceAdjustmentField.TagId, PriorityIndicatorField.TagId, PriceImprovementField.TagId, 
    LastLiquidityIndField.TagId, CopyMsgIndicatorField.TagId, DividendYieldField.TagId, ManualOrderIndicatorField.TagId, CustDirectedOrderField.TagId, 
    ReceivedDeptIDField.TagId, CustOrderHandlingInstField.TagId, OrderHandlingInstSourceField.TagId, VolatilityField.TagId, TimeToExpirationField.TagId, 
    RiskFreeRateField.TagId, PriceDeltaField.TagId)

  override def isOptionalField(tagId:Int) : Boolean = {
    OptionalFields.contains(tagId)  || 
    ApplicationSequenceControlComponent.isOptionalField(tagId) || PartiesComponent.isOptionalField(tagId) || ContraGrpComponent.isOptionalField(tagId) || PreAllocGrpComponent.isOptionalField(tagId) || 
    InstrumentComponent.isOptionalField(tagId) || FinancingDetailsComponent.isOptionalField(tagId) || UndInstrmtGrpComponent.isOptionalField(tagId) || StipulationsComponent.isOptionalField(tagId) || 
    OrderQtyDataComponent.isOptionalField(tagId) || TriggeringInstructionComponent.isOptionalField(tagId) || PegInstructionsComponent.isOptionalField(tagId) || DiscretionInstructionsComponent.isOptionalField(tagId) || 
    StrategyParametersGrpComponent.isOptionalField(tagId) || FillsGrpComponent.isOptionalField(tagId) || CommissionDataComponent.isOptionalField(tagId) || SpreadOrBenchmarkCurveDataComponent.isOptionalField(tagId) || 
    YieldDataComponent.isOptionalField(tagId) || RateSourceComponent.isOptionalField(tagId) || DisplayInstructionComponent.isOptionalField(tagId) || ContAmtGrpComponent.isOptionalField(tagId) || 
    InstrmtLegExecGrpComponent.isOptionalField(tagId) || MiscFeesGrpComponent.isOptionalField(tagId) || TrdRegTimestampsComponent.isOptionalField(tagId)
  }

  override def isFieldOf(tagId:Int) : Boolean = isMandatoryField(tagId) || isOptionalField(tagId)  || 
    ApplicationSequenceControlComponent.isFieldOf(tagId) || PartiesComponent.isFieldOf(tagId) || ContraGrpComponent.isFieldOf(tagId) || 
    PreAllocGrpComponent.isFieldOf(tagId) || InstrumentComponent.isFieldOf(tagId) || FinancingDetailsComponent.isFieldOf(tagId) || 
    UndInstrmtGrpComponent.isFieldOf(tagId) || StipulationsComponent.isFieldOf(tagId) || OrderQtyDataComponent.isFieldOf(tagId) || 
    TriggeringInstructionComponent.isFieldOf(tagId) || PegInstructionsComponent.isFieldOf(tagId) || DiscretionInstructionsComponent.isFieldOf(tagId) || 
    StrategyParametersGrpComponent.isFieldOf(tagId) || FillsGrpComponent.isFieldOf(tagId) || CommissionDataComponent.isFieldOf(tagId) || 
    SpreadOrBenchmarkCurveDataComponent.isFieldOf(tagId) || YieldDataComponent.isFieldOf(tagId) || RateSourceComponent.isFieldOf(tagId) || 
    DisplayInstructionComponent.isFieldOf(tagId) || ContAmtGrpComponent.isFieldOf(tagId) || InstrmtLegExecGrpComponent.isFieldOf(tagId) || 
    MiscFeesGrpComponent.isFieldOf(tagId) || TrdRegTimestampsComponent.isFieldOf(tagId)

   override lazy val RepeatingGroupsTags = HashSet[Int]()
  
      
  override def isFirstField(tagId:Int) : Boolean = ApplicationSequenceControlComponent.isFirstField(tagId) 

  override def decode(flds: Seq[Tuple2[Int, Any]], startPos:Int = 0):Option[SfFixMessageBody] = {
    val (pos, myFields, nextTagPosLookup) = extractMyFieldsAndPopulatePositions(false, flds, startPos)
    validateMandatoryFieldsPresent(myFields)

    if (MandatoryFields.isEmpty || myFields.nonEmpty) {
      Some(ExecutionReportMessage(ApplicationSequenceControlComponent.decode(flds, startPos),
        OrderIDField.decode(myFields.get(OrderIDField.TagId)).get,
        myFields.get(SecondaryOrderIDField.TagId).flatMap(f=>SecondaryOrderIDField.decode(f)),
        myFields.get(SecondaryClOrdIDField.TagId).flatMap(f=>SecondaryClOrdIDField.decode(f)),
        myFields.get(SecondaryExecIDField.TagId).flatMap(f=>SecondaryExecIDField.decode(f)),
        myFields.get(ClOrdIDField.TagId).flatMap(f=>ClOrdIDField.decode(f)),
        myFields.get(OrigClOrdIDField.TagId).flatMap(f=>OrigClOrdIDField.decode(f)),
        myFields.get(ClOrdLinkIDField.TagId).flatMap(f=>ClOrdLinkIDField.decode(f)),
        myFields.get(QuoteRespIDField.TagId).flatMap(f=>QuoteRespIDField.decode(f)),
        myFields.get(OrdStatusReqIDField.TagId).flatMap(f=>OrdStatusReqIDField.decode(f)),
        myFields.get(MassStatusReqIDField.TagId).flatMap(f=>MassStatusReqIDField.decode(f)),
        myFields.get(HostCrossIDField.TagId).flatMap(f=>HostCrossIDField.decode(f)),
        myFields.get(TotNumReportsField.TagId).flatMap(f=>TotNumReportsField.decode(f)),
        myFields.get(LastRptRequestedField.TagId).flatMap(f=>LastRptRequestedField.decode(f)),
        PartiesComponent.decode(flds, startPos),
        myFields.get(TradeOriginationDateField.TagId).flatMap(f=>TradeOriginationDateField.decode(f)),
        ContraGrpComponent.decode(flds, startPos),
        myFields.get(ListIDField.TagId).flatMap(f=>ListIDField.decode(f)),
        myFields.get(CrossIDField.TagId).flatMap(f=>CrossIDField.decode(f)),
        myFields.get(OrigCrossIDField.TagId).flatMap(f=>OrigCrossIDField.decode(f)),
        myFields.get(CrossTypeField.TagId).flatMap(f=>CrossTypeField.decode(f)),
        myFields.get(TrdMatchIDField.TagId).flatMap(f=>TrdMatchIDField.decode(f)),
        ExecIDField.decode(myFields.get(ExecIDField.TagId)).get,
        myFields.get(ExecRefIDField.TagId).flatMap(f=>ExecRefIDField.decode(f)),
        ExecTypeField.decode(myFields.get(ExecTypeField.TagId)).get,
        OrdStatusField.decode(myFields.get(OrdStatusField.TagId)).get,
        myFields.get(WorkingIndicatorField.TagId).flatMap(f=>WorkingIndicatorField.decode(f)),
        myFields.get(OrdRejReasonField.TagId).flatMap(f=>OrdRejReasonField.decode(f)),
        myFields.get(ExecRestatementReasonField.TagId).flatMap(f=>ExecRestatementReasonField.decode(f)),
        myFields.get(AccountField.TagId).flatMap(f=>AccountField.decode(f)),
        myFields.get(AcctIDSourceField.TagId).flatMap(f=>AcctIDSourceField.decode(f)),
        myFields.get(AccountTypeField.TagId).flatMap(f=>AccountTypeField.decode(f)),
        myFields.get(DayBookingInstField.TagId).flatMap(f=>DayBookingInstField.decode(f)),
        myFields.get(BookingUnitField.TagId).flatMap(f=>BookingUnitField.decode(f)),
        myFields.get(PreallocMethodField.TagId).flatMap(f=>PreallocMethodField.decode(f)),
        myFields.get(AllocIDField.TagId).flatMap(f=>AllocIDField.decode(f)),
        PreAllocGrpComponent.decode(flds, startPos),
        myFields.get(SettlTypeField.TagId).flatMap(f=>SettlTypeField.decode(f)),
        myFields.get(SettlDateField.TagId).flatMap(f=>SettlDateField.decode(f)),
        myFields.get(MatchTypeField.TagId).flatMap(f=>MatchTypeField.decode(f)),
        myFields.get(OrderCategoryField.TagId).flatMap(f=>OrderCategoryField.decode(f)),
        myFields.get(CashMarginField.TagId).flatMap(f=>CashMarginField.decode(f)),
        myFields.get(ClearingFeeIndicatorField.TagId).flatMap(f=>ClearingFeeIndicatorField.decode(f)),
        InstrumentComponent.decode(flds, startPos).get,
        FinancingDetailsComponent.decode(flds, startPos),
        UndInstrmtGrpComponent.decode(flds, startPos),
        SideField.decode(myFields.get(SideField.TagId)).get,
        StipulationsComponent.decode(flds, startPos),
        myFields.get(QtyTypeField.TagId).flatMap(f=>QtyTypeField.decode(f)),
        OrderQtyDataComponent.decode(flds, startPos),
        myFields.get(LotTypeField.TagId).flatMap(f=>LotTypeField.decode(f)),
        myFields.get(OrdTypeField.TagId).flatMap(f=>OrdTypeField.decode(f)),
        myFields.get(PriceTypeField.TagId).flatMap(f=>PriceTypeField.decode(f)),
        myFields.get(PriceField.TagId).flatMap(f=>PriceField.decode(f)),
        myFields.get(PriceProtectionScopeField.TagId).flatMap(f=>PriceProtectionScopeField.decode(f)),
        myFields.get(StopPxField.TagId).flatMap(f=>StopPxField.decode(f)),
        TriggeringInstructionComponent.decode(flds, startPos),
        PegInstructionsComponent.decode(flds, startPos),
        DiscretionInstructionsComponent.decode(flds, startPos),
        myFields.get(PeggedPriceField.TagId).flatMap(f=>PeggedPriceField.decode(f)),
        myFields.get(PeggedRefPriceField.TagId).flatMap(f=>PeggedRefPriceField.decode(f)),
        myFields.get(DiscretionPriceField.TagId).flatMap(f=>DiscretionPriceField.decode(f)),
        myFields.get(TargetStrategyField.TagId).flatMap(f=>TargetStrategyField.decode(f)),
        StrategyParametersGrpComponent.decode(flds, startPos),
        myFields.get(TargetStrategyParametersField.TagId).flatMap(f=>TargetStrategyParametersField.decode(f)),
        myFields.get(ParticipationRateField.TagId).flatMap(f=>ParticipationRateField.decode(f)),
        myFields.get(TargetStrategyPerformanceField.TagId).flatMap(f=>TargetStrategyPerformanceField.decode(f)),
        myFields.get(CurrencyField.TagId).flatMap(f=>CurrencyField.decode(f)),
        myFields.get(ComplianceIDField.TagId).flatMap(f=>ComplianceIDField.decode(f)),
        myFields.get(SolicitedFlagField.TagId).flatMap(f=>SolicitedFlagField.decode(f)),
        myFields.get(TimeInForceField.TagId).flatMap(f=>TimeInForceField.decode(f)),
        myFields.get(EffectiveTimeField.TagId).flatMap(f=>EffectiveTimeField.decode(f)),
        myFields.get(ExpireDateField.TagId).flatMap(f=>ExpireDateField.decode(f)),
        myFields.get(ExpireTimeField.TagId).flatMap(f=>ExpireTimeField.decode(f)),
        myFields.get(ExecInstField.TagId).flatMap(f=>ExecInstField.decode(f)),
        myFields.get(AggressorIndicatorField.TagId).flatMap(f=>AggressorIndicatorField.decode(f)),
        myFields.get(OrderCapacityField.TagId).flatMap(f=>OrderCapacityField.decode(f)),
        myFields.get(OrderRestrictionsField.TagId).flatMap(f=>OrderRestrictionsField.decode(f)),
        myFields.get(PreTradeAnonymityField.TagId).flatMap(f=>PreTradeAnonymityField.decode(f)),
        myFields.get(CustOrderCapacityField.TagId).flatMap(f=>CustOrderCapacityField.decode(f)),
        myFields.get(LastQtyField.TagId).flatMap(f=>LastQtyField.decode(f)),
        myFields.get(CalculatedCcyLastQtyField.TagId).flatMap(f=>CalculatedCcyLastQtyField.decode(f)),
        myFields.get(LastSwapPointsField.TagId).flatMap(f=>LastSwapPointsField.decode(f)),
        myFields.get(UnderlyingLastQtyField.TagId).flatMap(f=>UnderlyingLastQtyField.decode(f)),
        myFields.get(LastPxField.TagId).flatMap(f=>LastPxField.decode(f)),
        myFields.get(UnderlyingLastPxField.TagId).flatMap(f=>UnderlyingLastPxField.decode(f)),
        myFields.get(LastParPxField.TagId).flatMap(f=>LastParPxField.decode(f)),
        myFields.get(LastSpotRateField.TagId).flatMap(f=>LastSpotRateField.decode(f)),
        myFields.get(LastForwardPointsField.TagId).flatMap(f=>LastForwardPointsField.decode(f)),
        myFields.get(LastMktField.TagId).flatMap(f=>LastMktField.decode(f)),
        myFields.get(TradingSessionIDField.TagId).flatMap(f=>TradingSessionIDField.decode(f)),
        myFields.get(TradingSessionSubIDField.TagId).flatMap(f=>TradingSessionSubIDField.decode(f)),
        myFields.get(TimeBracketField.TagId).flatMap(f=>TimeBracketField.decode(f)),
        myFields.get(LastCapacityField.TagId).flatMap(f=>LastCapacityField.decode(f)),
        LeavesQtyField.decode(myFields.get(LeavesQtyField.TagId)).get,
        CumQtyField.decode(myFields.get(CumQtyField.TagId)).get,
        myFields.get(AvgPxField.TagId).flatMap(f=>AvgPxField.decode(f)),
        myFields.get(DayOrderQtyField.TagId).flatMap(f=>DayOrderQtyField.decode(f)),
        myFields.get(DayCumQtyField.TagId).flatMap(f=>DayCumQtyField.decode(f)),
        myFields.get(DayAvgPxField.TagId).flatMap(f=>DayAvgPxField.decode(f)),
        myFields.get(TotNoFillsField.TagId).flatMap(f=>TotNoFillsField.decode(f)),
        myFields.get(LastFragmentField.TagId).flatMap(f=>LastFragmentField.decode(f)),
        FillsGrpComponent.decode(flds, startPos),
        myFields.get(GTBookingInstField.TagId).flatMap(f=>GTBookingInstField.decode(f)),
        myFields.get(TradeDateField.TagId).flatMap(f=>TradeDateField.decode(f)),
        myFields.get(TransactTimeField.TagId).flatMap(f=>TransactTimeField.decode(f)),
        myFields.get(ReportToExchField.TagId).flatMap(f=>ReportToExchField.decode(f)),
        CommissionDataComponent.decode(flds, startPos),
        SpreadOrBenchmarkCurveDataComponent.decode(flds, startPos),
        YieldDataComponent.decode(flds, startPos),
        myFields.get(GrossTradeAmtField.TagId).flatMap(f=>GrossTradeAmtField.decode(f)),
        myFields.get(NumDaysInterestField.TagId).flatMap(f=>NumDaysInterestField.decode(f)),
        myFields.get(ExDateField.TagId).flatMap(f=>ExDateField.decode(f)),
        myFields.get(AccruedInterestRateField.TagId).flatMap(f=>AccruedInterestRateField.decode(f)),
        myFields.get(AccruedInterestAmtField.TagId).flatMap(f=>AccruedInterestAmtField.decode(f)),
        myFields.get(InterestAtMaturityField.TagId).flatMap(f=>InterestAtMaturityField.decode(f)),
        myFields.get(EndAccruedInterestAmtField.TagId).flatMap(f=>EndAccruedInterestAmtField.decode(f)),
        myFields.get(StartCashField.TagId).flatMap(f=>StartCashField.decode(f)),
        myFields.get(EndCashField.TagId).flatMap(f=>EndCashField.decode(f)),
        myFields.get(TradedFlatSwitchField.TagId).flatMap(f=>TradedFlatSwitchField.decode(f)),
        myFields.get(BasisFeatureDateField.TagId).flatMap(f=>BasisFeatureDateField.decode(f)),
        myFields.get(BasisFeaturePriceField.TagId).flatMap(f=>BasisFeaturePriceField.decode(f)),
        myFields.get(ConcessionField.TagId).flatMap(f=>ConcessionField.decode(f)),
        myFields.get(TotalTakedownField.TagId).flatMap(f=>TotalTakedownField.decode(f)),
        myFields.get(NetMoneyField.TagId).flatMap(f=>NetMoneyField.decode(f)),
        myFields.get(SettlCurrAmtField.TagId).flatMap(f=>SettlCurrAmtField.decode(f)),
        myFields.get(SettlCurrencyField.TagId).flatMap(f=>SettlCurrencyField.decode(f)),
        RateSourceComponent.decode(flds, startPos),
        myFields.get(SettlCurrFxRateField.TagId).flatMap(f=>SettlCurrFxRateField.decode(f)),
        myFields.get(SettlCurrFxRateCalcField.TagId).flatMap(f=>SettlCurrFxRateCalcField.decode(f)),
        myFields.get(HandlInstField.TagId).flatMap(f=>HandlInstField.decode(f)),
        myFields.get(MinQtyField.TagId).flatMap(f=>MinQtyField.decode(f)),
        myFields.get(MatchIncrementField.TagId).flatMap(f=>MatchIncrementField.decode(f)),
        myFields.get(MaxPriceLevelsField.TagId).flatMap(f=>MaxPriceLevelsField.decode(f)),
        DisplayInstructionComponent.decode(flds, startPos),
        myFields.get(MaxFloorField.TagId).flatMap(f=>MaxFloorField.decode(f)),
        myFields.get(PositionEffectField.TagId).flatMap(f=>PositionEffectField.decode(f)),
        myFields.get(MaxShowField.TagId).flatMap(f=>MaxShowField.decode(f)),
        myFields.get(BookingTypeField.TagId).flatMap(f=>BookingTypeField.decode(f)),
        myFields.get(TextField.TagId).flatMap(f=>TextField.decode(f)),
        myFields.get(EncodedTextLenField.TagId).flatMap(f=>EncodedTextLenField.decode(f)),
        myFields.get(EncodedTextField.TagId).flatMap(f=>EncodedTextField.decode(f)),
        myFields.get(SettlDate2Field.TagId).flatMap(f=>SettlDate2Field.decode(f)),
        myFields.get(OrderQty2Field.TagId).flatMap(f=>OrderQty2Field.decode(f)),
        myFields.get(LastForwardPoints2Field.TagId).flatMap(f=>LastForwardPoints2Field.decode(f)),
        myFields.get(MultiLegReportingTypeField.TagId).flatMap(f=>MultiLegReportingTypeField.decode(f)),
        myFields.get(CancellationRightsField.TagId).flatMap(f=>CancellationRightsField.decode(f)),
        myFields.get(MoneyLaunderingStatusField.TagId).flatMap(f=>MoneyLaunderingStatusField.decode(f)),
        myFields.get(RegistIDField.TagId).flatMap(f=>RegistIDField.decode(f)),
        myFields.get(DesignationField.TagId).flatMap(f=>DesignationField.decode(f)),
        myFields.get(TransBkdTimeField.TagId).flatMap(f=>TransBkdTimeField.decode(f)),
        myFields.get(ExecValuationPointField.TagId).flatMap(f=>ExecValuationPointField.decode(f)),
        myFields.get(ExecPriceTypeField.TagId).flatMap(f=>ExecPriceTypeField.decode(f)),
        myFields.get(ExecPriceAdjustmentField.TagId).flatMap(f=>ExecPriceAdjustmentField.decode(f)),
        myFields.get(PriorityIndicatorField.TagId).flatMap(f=>PriorityIndicatorField.decode(f)),
        myFields.get(PriceImprovementField.TagId).flatMap(f=>PriceImprovementField.decode(f)),
        myFields.get(LastLiquidityIndField.TagId).flatMap(f=>LastLiquidityIndField.decode(f)),
        ContAmtGrpComponent.decode(flds, startPos),
        InstrmtLegExecGrpComponent.decode(flds, startPos),
        myFields.get(CopyMsgIndicatorField.TagId).flatMap(f=>CopyMsgIndicatorField.decode(f)),
        MiscFeesGrpComponent.decode(flds, startPos),
        myFields.get(DividendYieldField.TagId).flatMap(f=>DividendYieldField.decode(f)),
        myFields.get(ManualOrderIndicatorField.TagId).flatMap(f=>ManualOrderIndicatorField.decode(f)),
        myFields.get(CustDirectedOrderField.TagId).flatMap(f=>CustDirectedOrderField.decode(f)),
        myFields.get(ReceivedDeptIDField.TagId).flatMap(f=>ReceivedDeptIDField.decode(f)),
        myFields.get(CustOrderHandlingInstField.TagId).flatMap(f=>CustOrderHandlingInstField.decode(f)),
        myFields.get(OrderHandlingInstSourceField.TagId).flatMap(f=>OrderHandlingInstSourceField.decode(f)),
        TrdRegTimestampsComponent.decode(flds, startPos),
        myFields.get(VolatilityField.TagId).flatMap(f=>VolatilityField.decode(f)),
        myFields.get(TimeToExpirationField.TagId).flatMap(f=>TimeToExpirationField.decode(f)),
        myFields.get(RiskFreeRateField.TagId).flatMap(f=>RiskFreeRateField.decode(f)),
        myFields.get(PriceDeltaField.TagId).flatMap(f=>PriceDeltaField.decode(f))))
    } else None
  }

    
}
     