package org.sackfix.fix50sp2

import org.sackfix.field._
import org.sackfix.common.validated.fields.{SfFixComponent, SfFixDecoder, SfFixFieldsToAscii, SfFixRenderable}
import org.sackfix.common.message.SfRepeatingGroupCountException
import scala.annotation.tailrec
import scala.collection.immutable.HashSet
import scala.collection.mutable.ArrayBuffer


/**
  * Generated by SackFix code generator on 20170404
  * Source specification was read from:
  *   /quickfixj1.6.0/FIX50SP2.xml
  */
case class PositionAmountDataComponent(noPosAmtField:Option[NoPosAmtField]=None,
                                       posAmtGroups: Option[List[PosAmtGroup]]=None) extends SfFixComponent  with SfFixRenderable with SfFixFieldsToAscii {
  if (noPosAmtField.map(_.value).getOrElse(0) != posAmtGroups.map(_.size).getOrElse(0))
    throw SfRepeatingGroupCountException(NoPosAmtField.TagId,noPosAmtField.map(_.value).getOrElse(0), posAmtGroups.map(_.size).getOrElse(0))

  override lazy val fixStr : String = appendFixStr().toString
  override def appendFixStr(b:StringBuilder = new StringBuilder): StringBuilder = format(formatForFix, b)

  override def toString():String = appendStringBuilder().toString()
  def appendStringBuilder(b:StringBuilder = new StringBuilder) : StringBuilder = format(formatForToString, b)

  def format( fmt: ((StringBuilder,SfFixRenderable)=>Unit), b:StringBuilder = new StringBuilder()): StringBuilder = {
    noPosAmtField.foreach(fmt(b,_))
    posAmtGroups.getOrElse(List.empty).foreach(fmt(b,_))
    b
  }

}
     
object PositionAmountDataComponent extends SfFixDecoder {

  override val MandatoryFields = HashSet[Int]()

  override def isMandatoryField(tagId:Int) : Boolean = {
    MandatoryFields.contains(tagId)  || 
    PosAmtGroup.isMandatoryField(tagId)
  }

  override val OptionalFields = HashSet[Int](
    NoPosAmtField.TagId)

  override def isOptionalField(tagId:Int) : Boolean = {
    OptionalFields.contains(tagId)  || 
    PosAmtGroup.isOptionalField(tagId)
  }

  override def isFieldOf(tagId:Int) : Boolean = isMandatoryField(tagId) || isOptionalField(tagId)  || 
    PosAmtGroup.isFieldOf(tagId)

   override lazy val RepeatingGroupsTags = HashSet[Int](
    NoPosAmtField.TagId)
  
      
  override def isFirstField(tagId:Int) : Boolean = PosAmtGroup.isFirstField(tagId) 

  def decode(flds: Seq[Tuple2[Int, Any]], startPos:Int = 0):Option[PositionAmountDataComponent] = {
    val (pos, myFields, nextTagPosLookup) = extractMyFieldsAndPopulatePositions(false, flds, startPos)
    validateMandatoryFieldsPresent(myFields)

    if (myFields.nonEmpty) {
      Some(PositionAmountDataComponent(myFields.get(NoPosAmtField.TagId).flatMap(f=>NoPosAmtField.decode(f)),
        if (nextTagPosLookup.contains(NoPosAmtField.TagId)) PosAmtGroup.decode(flds, nextTagPosLookup(NoPosAmtField.TagId)) else None))
    } else None
  }

    
}
     