package org.sackfix.fix50sp2

import org.sackfix.field._
import org.sackfix.common.validated.fields.{SfFixGroup, SfGroupDecoder, SfFixFieldsToAscii, SfFixRenderable}
import org.sackfix.common.message.SfRepeatingGroupCountException
import scala.annotation.tailrec
import scala.collection.immutable.HashSet
import scala.collection.mutable.ArrayBuffer


/**
  * Generated by SackFix code generator on 20170404
  * Source specification was read from:
  *   /quickfixj1.6.0/FIX50SP2.xml
  */
case class SettlObligGroup(netGrossIndField:Option[NetGrossIndField]=None,
                           settlObligIDField:Option[SettlObligIDField]=None,
                           settlObligTransTypeField:Option[SettlObligTransTypeField]=None,
                           settlObligRefIDField:Option[SettlObligRefIDField]=None,
                           ccyAmtField:Option[CcyAmtField]=None,
                           settlCurrAmtField:Option[SettlCurrAmtField]=None,
                           currencyField:Option[CurrencyField]=None,
                           settlCurrencyField:Option[SettlCurrencyField]=None,
                           settlCurrFxRateField:Option[SettlCurrFxRateField]=None,
                           settlDateField:Option[SettlDateField]=None,
                           instrumentComponent:Option[InstrumentComponent]=None,
                           partiesComponent:Option[PartiesComponent]=None,
                           effectiveTimeField:Option[EffectiveTimeField]=None,
                           expireTimeField:Option[ExpireTimeField]=None,
                           lastUpdateTimeField:Option[LastUpdateTimeField]=None,
                           settlDetailsComponent:Option[SettlDetailsComponent]=None) extends SfFixGroup  with SfFixRenderable with SfFixFieldsToAscii {

  override lazy val fixStr : String = appendFixStr().toString
  override def appendFixStr(b:StringBuilder = new StringBuilder): StringBuilder = format(formatForFix, b)

  override def toString():String = appendStringBuilder().toString()
  def appendStringBuilder(b:StringBuilder = new StringBuilder) : StringBuilder = format(formatForToString, b)

  def format( fmt: ((StringBuilder,SfFixRenderable)=>Unit), b:StringBuilder = new StringBuilder()): StringBuilder = {
    netGrossIndField.foreach(fmt(b,_))
    settlObligIDField.foreach(fmt(b,_))
    settlObligTransTypeField.foreach(fmt(b,_))
    settlObligRefIDField.foreach(fmt(b,_))
    ccyAmtField.foreach(fmt(b,_))
    settlCurrAmtField.foreach(fmt(b,_))
    currencyField.foreach(fmt(b,_))
    settlCurrencyField.foreach(fmt(b,_))
    settlCurrFxRateField.foreach(fmt(b,_))
    settlDateField.foreach(fmt(b,_))
    instrumentComponent.foreach(fmt(b,_))
    partiesComponent.foreach(fmt(b,_))
    effectiveTimeField.foreach(fmt(b,_))
    expireTimeField.foreach(fmt(b,_))
    lastUpdateTimeField.foreach(fmt(b,_))
    settlDetailsComponent.foreach(fmt(b,_))
    b
  }

}
     
object SettlObligGroup extends SfGroupDecoder {

  override val MandatoryFields = HashSet[Int]()

  override def isMandatoryField(tagId:Int) : Boolean = {
    MandatoryFields.contains(tagId)  || 
    InstrumentComponent.isMandatoryField(tagId) || PartiesComponent.isMandatoryField(tagId) || SettlDetailsComponent.isMandatoryField(tagId)
  }

  override val OptionalFields = HashSet[Int](
    NetGrossIndField.TagId, SettlObligIDField.TagId, SettlObligTransTypeField.TagId, SettlObligRefIDField.TagId, CcyAmtField.TagId, 
    SettlCurrAmtField.TagId, CurrencyField.TagId, SettlCurrencyField.TagId, SettlCurrFxRateField.TagId, SettlDateField.TagId, 
    EffectiveTimeField.TagId, ExpireTimeField.TagId, LastUpdateTimeField.TagId)

  override def isOptionalField(tagId:Int) : Boolean = {
    OptionalFields.contains(tagId)  || 
    InstrumentComponent.isOptionalField(tagId) || PartiesComponent.isOptionalField(tagId) || SettlDetailsComponent.isOptionalField(tagId)
  }

  override def isFieldOf(tagId:Int) : Boolean = isMandatoryField(tagId) || isOptionalField(tagId)  || 
    InstrumentComponent.isFieldOf(tagId) || PartiesComponent.isFieldOf(tagId) || SettlDetailsComponent.isFieldOf(tagId)

   override lazy val RepeatingGroupsTags = HashSet[Int]()
  
      
  override def isFirstField(tagId:Int) : Boolean = tagId==NetGrossIndField.TagId 

  // Group version, startPos is the index to the first element of the first repeating group
  @tailrec
  def decode(flds: Seq[Tuple2[Int, Any]], startPos:Int = 0, groups:ArrayBuffer[SettlObligGroup]=ArrayBuffer.empty[SettlObligGroup]):Option[List[SettlObligGroup]] = {
    decodeSingle(flds, startPos) match {
      case (pos: Int, None) => if (groups.nonEmpty) Some(groups.toList) else None
      case (pos: Int, grp: Some[SettlObligGroup]) => decode(flds, pos, groups += grp.get)
    }
  }

  /**
    * @param flds For groups in Fix ordering is VITAL.
    * @param startPos This index into the ordered fields. It HAS to contain the first field of the group
    * @return A Tuple2 holding the next position to read from the fields, and the newly created group
    */
  def decodeSingle(flds: Seq[Tuple2[Int, Any]], startPos:Int):Tuple2[Int,Option[SettlObligGroup]] = {
    if (!isFirstField(flds(startPos)._1)) (startPos, None)
    else {
      val (pos, myFields, nextTagPosLookup) = extractMyFieldsAndPopulatePositions(true, flds, startPos)
      validateMandatoryFieldsPresent(myFields)

      if (myFields.nonEmpty) {
        (pos,Some(SettlObligGroup(myFields.get(NetGrossIndField.TagId).flatMap(f=>NetGrossIndField.decode(f)),
          myFields.get(SettlObligIDField.TagId).flatMap(f=>SettlObligIDField.decode(f)),
          myFields.get(SettlObligTransTypeField.TagId).flatMap(f=>SettlObligTransTypeField.decode(f)),
          myFields.get(SettlObligRefIDField.TagId).flatMap(f=>SettlObligRefIDField.decode(f)),
          myFields.get(CcyAmtField.TagId).flatMap(f=>CcyAmtField.decode(f)),
          myFields.get(SettlCurrAmtField.TagId).flatMap(f=>SettlCurrAmtField.decode(f)),
          myFields.get(CurrencyField.TagId).flatMap(f=>CurrencyField.decode(f)),
          myFields.get(SettlCurrencyField.TagId).flatMap(f=>SettlCurrencyField.decode(f)),
          myFields.get(SettlCurrFxRateField.TagId).flatMap(f=>SettlCurrFxRateField.decode(f)),
          myFields.get(SettlDateField.TagId).flatMap(f=>SettlDateField.decode(f)),
          InstrumentComponent.decode(flds, startPos),
          PartiesComponent.decode(flds, startPos),
          myFields.get(EffectiveTimeField.TagId).flatMap(f=>EffectiveTimeField.decode(f)),
          myFields.get(ExpireTimeField.TagId).flatMap(f=>ExpireTimeField.decode(f)),
          myFields.get(LastUpdateTimeField.TagId).flatMap(f=>LastUpdateTimeField.decode(f)),
          SettlDetailsComponent.decode(flds, startPos))))
      } else (startPos, None)
    }
  }
    
}
     