package org.sackfix.fix50sp2

import org.sackfix.field._
import org.sackfix.common.validated.fields.{SfFixComponent, SfFixDecoder, SfFixFieldsToAscii, SfFixRenderable}
import org.sackfix.common.message.SfRepeatingGroupCountException
import scala.annotation.tailrec
import scala.collection.immutable.HashSet
import scala.collection.mutable.ArrayBuffer


/**
  * Generated by SackFix code generator on 20170404
  * Source specification was read from:
  *   /quickfixj1.6.0/FIX50SP2.xml
  */
case class TradeReportOrderDetailComponent(orderIDField:Option[OrderIDField]=None,
                                           secondaryOrderIDField:Option[SecondaryOrderIDField]=None,
                                           clOrdIDField:Option[ClOrdIDField]=None,
                                           secondaryClOrdIDField:Option[SecondaryClOrdIDField]=None,
                                           listIDField:Option[ListIDField]=None,
                                           refOrderIDField:Option[RefOrderIDField]=None,
                                           refOrderIDSourceField:Option[RefOrderIDSourceField]=None,
                                           refOrdIDReasonField:Option[RefOrdIDReasonField]=None,
                                           ordTypeField:Option[OrdTypeField]=None,
                                           priceField:Option[PriceField]=None,
                                           stopPxField:Option[StopPxField]=None,
                                           execInstField:Option[ExecInstField]=None,
                                           ordStatusField:Option[OrdStatusField]=None,
                                           orderQtyDataComponent:Option[OrderQtyDataComponent]=None,
                                           leavesQtyField:Option[LeavesQtyField]=None,
                                           cumQtyField:Option[CumQtyField]=None,
                                           timeInForceField:Option[TimeInForceField]=None,
                                           expireTimeField:Option[ExpireTimeField]=None,
                                           displayInstructionComponent:Option[DisplayInstructionComponent]=None,
                                           orderCapacityField:Option[OrderCapacityField]=None,
                                           orderRestrictionsField:Option[OrderRestrictionsField]=None,
                                           bookingTypeField:Option[BookingTypeField]=None,
                                           origCustOrderCapacityField:Option[OrigCustOrderCapacityField]=None,
                                           orderInputDeviceField:Option[OrderInputDeviceField]=None,
                                           lotTypeField:Option[LotTypeField]=None,
                                           transBkdTimeField:Option[TransBkdTimeField]=None,
                                           origOrdModTimeField:Option[OrigOrdModTimeField]=None) extends SfFixComponent  with SfFixRenderable with SfFixFieldsToAscii {

  override lazy val fixStr : String = appendFixStr().toString
  override def appendFixStr(b:StringBuilder = new StringBuilder): StringBuilder = format(formatForFix, b)

  override def toString():String = appendStringBuilder().toString()
  def appendStringBuilder(b:StringBuilder = new StringBuilder) : StringBuilder = format(formatForToString, b)

  def format( fmt: ((StringBuilder,SfFixRenderable)=>Unit), b:StringBuilder = new StringBuilder()): StringBuilder = {
    orderIDField.foreach(fmt(b,_))
    secondaryOrderIDField.foreach(fmt(b,_))
    clOrdIDField.foreach(fmt(b,_))
    secondaryClOrdIDField.foreach(fmt(b,_))
    listIDField.foreach(fmt(b,_))
    refOrderIDField.foreach(fmt(b,_))
    refOrderIDSourceField.foreach(fmt(b,_))
    refOrdIDReasonField.foreach(fmt(b,_))
    ordTypeField.foreach(fmt(b,_))
    priceField.foreach(fmt(b,_))
    stopPxField.foreach(fmt(b,_))
    execInstField.foreach(fmt(b,_))
    ordStatusField.foreach(fmt(b,_))
    orderQtyDataComponent.foreach(fmt(b,_))
    leavesQtyField.foreach(fmt(b,_))
    cumQtyField.foreach(fmt(b,_))
    timeInForceField.foreach(fmt(b,_))
    expireTimeField.foreach(fmt(b,_))
    displayInstructionComponent.foreach(fmt(b,_))
    orderCapacityField.foreach(fmt(b,_))
    orderRestrictionsField.foreach(fmt(b,_))
    bookingTypeField.foreach(fmt(b,_))
    origCustOrderCapacityField.foreach(fmt(b,_))
    orderInputDeviceField.foreach(fmt(b,_))
    lotTypeField.foreach(fmt(b,_))
    transBkdTimeField.foreach(fmt(b,_))
    origOrdModTimeField.foreach(fmt(b,_))
    b
  }

}
     
object TradeReportOrderDetailComponent extends SfFixDecoder {

  override val MandatoryFields = HashSet[Int]()

  override def isMandatoryField(tagId:Int) : Boolean = {
    MandatoryFields.contains(tagId)  || 
    OrderQtyDataComponent.isMandatoryField(tagId) || DisplayInstructionComponent.isMandatoryField(tagId)
  }

  override val OptionalFields = HashSet[Int](
    OrderIDField.TagId, SecondaryOrderIDField.TagId, ClOrdIDField.TagId, SecondaryClOrdIDField.TagId, ListIDField.TagId, 
    RefOrderIDField.TagId, RefOrderIDSourceField.TagId, RefOrdIDReasonField.TagId, OrdTypeField.TagId, PriceField.TagId, 
    StopPxField.TagId, ExecInstField.TagId, OrdStatusField.TagId, LeavesQtyField.TagId, CumQtyField.TagId, 
    TimeInForceField.TagId, ExpireTimeField.TagId, OrderCapacityField.TagId, OrderRestrictionsField.TagId, BookingTypeField.TagId, 
    OrigCustOrderCapacityField.TagId, OrderInputDeviceField.TagId, LotTypeField.TagId, TransBkdTimeField.TagId, OrigOrdModTimeField.TagId)

  override def isOptionalField(tagId:Int) : Boolean = {
    OptionalFields.contains(tagId)  || 
    OrderQtyDataComponent.isOptionalField(tagId) || DisplayInstructionComponent.isOptionalField(tagId)
  }

  override def isFieldOf(tagId:Int) : Boolean = isMandatoryField(tagId) || isOptionalField(tagId)  || 
    OrderQtyDataComponent.isFieldOf(tagId) || DisplayInstructionComponent.isFieldOf(tagId)

   override lazy val RepeatingGroupsTags = HashSet[Int]()
  
      
  override def isFirstField(tagId:Int) : Boolean = tagId==OrderIDField.TagId 

  def decode(flds: Seq[Tuple2[Int, Any]], startPos:Int = 0):Option[TradeReportOrderDetailComponent] = {
    val (pos, myFields, nextTagPosLookup) = extractMyFieldsAndPopulatePositions(false, flds, startPos)
    validateMandatoryFieldsPresent(myFields)

    if (myFields.nonEmpty) {
      Some(TradeReportOrderDetailComponent(myFields.get(OrderIDField.TagId).flatMap(f=>OrderIDField.decode(f)),
        myFields.get(SecondaryOrderIDField.TagId).flatMap(f=>SecondaryOrderIDField.decode(f)),
        myFields.get(ClOrdIDField.TagId).flatMap(f=>ClOrdIDField.decode(f)),
        myFields.get(SecondaryClOrdIDField.TagId).flatMap(f=>SecondaryClOrdIDField.decode(f)),
        myFields.get(ListIDField.TagId).flatMap(f=>ListIDField.decode(f)),
        myFields.get(RefOrderIDField.TagId).flatMap(f=>RefOrderIDField.decode(f)),
        myFields.get(RefOrderIDSourceField.TagId).flatMap(f=>RefOrderIDSourceField.decode(f)),
        myFields.get(RefOrdIDReasonField.TagId).flatMap(f=>RefOrdIDReasonField.decode(f)),
        myFields.get(OrdTypeField.TagId).flatMap(f=>OrdTypeField.decode(f)),
        myFields.get(PriceField.TagId).flatMap(f=>PriceField.decode(f)),
        myFields.get(StopPxField.TagId).flatMap(f=>StopPxField.decode(f)),
        myFields.get(ExecInstField.TagId).flatMap(f=>ExecInstField.decode(f)),
        myFields.get(OrdStatusField.TagId).flatMap(f=>OrdStatusField.decode(f)),
        OrderQtyDataComponent.decode(flds, startPos),
        myFields.get(LeavesQtyField.TagId).flatMap(f=>LeavesQtyField.decode(f)),
        myFields.get(CumQtyField.TagId).flatMap(f=>CumQtyField.decode(f)),
        myFields.get(TimeInForceField.TagId).flatMap(f=>TimeInForceField.decode(f)),
        myFields.get(ExpireTimeField.TagId).flatMap(f=>ExpireTimeField.decode(f)),
        DisplayInstructionComponent.decode(flds, startPos),
        myFields.get(OrderCapacityField.TagId).flatMap(f=>OrderCapacityField.decode(f)),
        myFields.get(OrderRestrictionsField.TagId).flatMap(f=>OrderRestrictionsField.decode(f)),
        myFields.get(BookingTypeField.TagId).flatMap(f=>BookingTypeField.decode(f)),
        myFields.get(OrigCustOrderCapacityField.TagId).flatMap(f=>OrigCustOrderCapacityField.decode(f)),
        myFields.get(OrderInputDeviceField.TagId).flatMap(f=>OrderInputDeviceField.decode(f)),
        myFields.get(LotTypeField.TagId).flatMap(f=>LotTypeField.decode(f)),
        myFields.get(TransBkdTimeField.TagId).flatMap(f=>TransBkdTimeField.decode(f)),
        myFields.get(OrigOrdModTimeField.TagId).flatMap(f=>OrigOrdModTimeField.decode(f))))
    } else None
  }

    
}
     