/*
 * Decompiled with CFR 0.152.
 */
package org.sahli.asciidoc.confluence.publisher.client.http;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.sahli.asciidoc.confluence.publisher.client.utils.InputStreamUtils;

public class RequestFailedException
extends RuntimeException {
    RequestFailedException(HttpRequest request, HttpResponse response, Exception reason) {
        super(RequestFailedException.buildMessage(request, response, reason), reason);
    }

    private static String buildMessage(HttpRequest request, HttpResponse response, Exception reason) {
        String requestBody = RequestFailedException.requestBody(request);
        String responseBody = response != null ? RequestFailedException.responseBody(response) : "<none>";
        String requestLog = RequestFailedException.statusLine(request) + " " + requestBody;
        String responseLog = response != null ? RequestFailedException.statusLine(response) + " " + responseBody : responseBody;
        String reasonLog = reason != null ? reason.getMessage() : "<none>";
        return RequestFailedException.reasonFromResponseOrDefault(responseBody, "request failed") + " (request: " + requestLog + ", response: " + responseLog + ", reason: " + reasonLog + ")";
    }

    private static String reasonFromResponseOrDefault(String responseBody, String defaultReason) {
        try {
            JsonNode responseNode = new ObjectMapper().readTree(responseBody);
            JsonNode messageNode = responseNode.get("message");
            if (messageNode != null && messageNode.asText() != null) {
                return messageNode.asText();
            }
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
        return defaultReason;
    }

    private static String statusLine(HttpRequest request) {
        return request.getRequestLine().getMethod() + " " + request.getRequestLine().getUri();
    }

    private static String statusLine(HttpResponse response) {
        return response.getStatusLine().getStatusCode() + " " + response.getStatusLine().getReasonPhrase();
    }

    private static String requestBody(HttpRequest request) {
        return request instanceof HttpEntityEnclosingRequest ? RequestFailedException.entityAsString(((HttpEntityEnclosingRequest)request).getEntity()) : "<empty body>";
    }

    private static String responseBody(HttpResponse response) {
        return RequestFailedException.entityAsString(response.getEntity());
    }

    private static String entityAsString(HttpEntity entity) {
        try {
            InputStream content = entity.getContent();
            Charset encoding = entity.getContentEncoding() == null ? Charset.defaultCharset() : Charset.forName(entity.getContentEncoding().getValue());
            String contentString = InputStreamUtils.inputStreamAsString(content, encoding);
            return contentString;
        }
        catch (Exception ignored) {
            return "<empty body>";
        }
    }
}

