/*
 * Decompiled with CFR 0.152.
 */
package org.sahli.asciidoc.confluence.publisher.client.http;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.util.concurrent.RateLimiter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicHeader;
import org.apache.http.ssl.SSLContextBuilder;
import org.sahli.asciidoc.confluence.publisher.client.http.ConfluenceAttachment;
import org.sahli.asciidoc.confluence.publisher.client.http.ConfluenceClient;
import org.sahli.asciidoc.confluence.publisher.client.http.ConfluencePage;
import org.sahli.asciidoc.confluence.publisher.client.http.HttpRequestV2Factory;
import org.sahli.asciidoc.confluence.publisher.client.http.MultipleResultsException;
import org.sahli.asciidoc.confluence.publisher.client.http.NotFoundException;
import org.sahli.asciidoc.confluence.publisher.client.http.ProxyConfiguration;
import org.sahli.asciidoc.confluence.publisher.client.http.RequestFailedException;
import org.sahli.asciidoc.confluence.publisher.client.utils.AssertUtils;

public class ConfluenceRestV2Client
implements ConfluenceClient {
    private final CloseableHttpClient httpClient;
    private final String username;
    private final String passwordOrPersonalAccessToken;
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final HttpRequestV2Factory httpRequestV2Factory;
    private final RateLimiter rateLimiter;

    public ConfluenceRestV2Client(String rootConfluenceUrl, boolean disableSslVerification, boolean enableHttpClientSystemProperties, Double maxRequestsPerSecond, Integer connectionTTL, String username, String passwordOrPersonalAccessToken) {
        this(rootConfluenceUrl, null, disableSslVerification, enableHttpClientSystemProperties, maxRequestsPerSecond, connectionTTL, username, passwordOrPersonalAccessToken);
    }

    public ConfluenceRestV2Client(String rootConfluenceUrl, ProxyConfiguration proxyConfiguration, boolean disableSslVerification, boolean enableHttpClientSystemProperties, Double maxRequestsPerSecond, Integer connectionTTL, String username, String passwordOrPersonalAccessToken) {
        this(rootConfluenceUrl, ConfluenceRestV2Client.defaultHttpClient(proxyConfiguration, disableSslVerification, enableHttpClientSystemProperties, connectionTTL), maxRequestsPerSecond, username, passwordOrPersonalAccessToken);
    }

    public ConfluenceRestV2Client(String rootConfluenceUrl, CloseableHttpClient httpClient, Double maxRequestsPerSecond, String username, String passwordOrPersonalAccessToken) {
        AssertUtils.assertMandatoryParameter(httpClient != null, "httpClient");
        this.httpClient = httpClient;
        this.rateLimiter = maxRequestsPerSecond != null ? RateLimiter.create((double)maxRequestsPerSecond) : null;
        this.username = username;
        this.passwordOrPersonalAccessToken = passwordOrPersonalAccessToken;
        this.httpRequestV2Factory = new HttpRequestV2Factory(rootConfluenceUrl);
        this.configureObjectMapper();
    }

    private void configureObjectMapper() {
        this.objectMapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
    }

    @Override
    public String addPageUnderAncestor(String spaceKey, String ancestorId, String title, String content, String versionMessage) {
        HttpGet lookupSpaceIdRequest = this.httpRequestV2Factory.lookupSpaceIdRequest(spaceKey);
        String spaceId = this.sendRequestAndFailIfNot20x((HttpRequestBase)lookupSpaceIdRequest, response -> {
            JsonNode jsonNode = this.parseJsonResponse((HttpResponse)response);
            return ConfluenceRestV2Client.extractMandatorySingleArrayElement(jsonNode, "results").get("id").asText();
        });
        HttpPost addPageUnderSpaceRequest = this.httpRequestV2Factory.addPageUnderAncestorRequest(spaceId, ancestorId, title, content, versionMessage);
        return this.sendRequestAndFailIfNot20x((HttpRequestBase)addPageUnderSpaceRequest, response -> {
            String contentId = ConfluenceRestV2Client.extractIdFromJsonNode(this.parseJsonResponse((HttpResponse)response));
            return contentId;
        });
    }

    @Override
    public void updatePage(String contentId, String ancestorId, String title, String content, int newVersion, String versionMessage, boolean notifyWatchers) {
        HttpPut updatePageRequest = this.httpRequestV2Factory.updatePageRequest(contentId, ancestorId, title, content, newVersion, versionMessage, notifyWatchers);
        this.sendRequestAndFailIfNot20x((HttpRequestBase)updatePageRequest);
    }

    @Override
    public void deletePage(String contentId) {
        HttpDelete deletePageRequest = this.httpRequestV2Factory.deletePageRequest(contentId);
        this.sendRequestAndFailIfNot20x((HttpRequestBase)deletePageRequest);
    }

    @Override
    public String getPageByTitle(String spaceKey, String ancestorId, String title) throws NotFoundException, MultipleResultsException {
        HttpGet lookupSpaceIdRequest = this.httpRequestV2Factory.lookupSpaceIdRequest(spaceKey);
        String spaceId = this.sendRequestAndFailIfNot20x((HttpRequestBase)lookupSpaceIdRequest, response -> {
            JsonNode jsonNode = this.parseJsonResponse((HttpResponse)response);
            return ConfluenceRestV2Client.extractMandatorySingleArrayElement(jsonNode, "results").get("id").asText();
        });
        HttpGet pageByTitleRequest = this.httpRequestV2Factory.getPageByTitleRequest(spaceId, title);
        return this.sendRequestAndFailIfNot20x((HttpRequestBase)pageByTitleRequest, response -> {
            JsonNode responseNode = this.parseJsonResponse((HttpResponse)response);
            JsonNode pageNode = ConfluenceRestV2Client.extractMandatorySingleArrayElement(responseNode, "results");
            String contentId = ConfluenceRestV2Client.extractIdFromJsonNode(pageNode);
            return contentId;
        });
    }

    @Override
    public void addAttachment(String contentId, String attachmentFileName, InputStream attachmentContent) {
        HttpPost addAttachmentRequest = this.httpRequestV2Factory.addAttachmentRequest(contentId, attachmentFileName, attachmentContent);
        this.sendRequestAndFailIfNot20x((HttpRequestBase)addAttachmentRequest, response -> {
            ConfluenceRestV2Client.closeInputStream(attachmentContent);
            return null;
        });
    }

    @Override
    public void updateAttachmentContent(String contentId, String attachmentId, InputStream attachmentContent, boolean notifyWatchers) {
        HttpPost updateAttachmentContentRequest = this.httpRequestV2Factory.updateAttachmentContentRequest(contentId, attachmentId, attachmentContent, notifyWatchers);
        this.sendRequestAndFailIfNot20x((HttpRequestBase)updateAttachmentContentRequest, response -> {
            ConfluenceRestV2Client.closeInputStream(attachmentContent);
            return null;
        });
    }

    @Override
    public void deleteAttachment(String attachmentId) {
        HttpDelete deleteAttachmentRequest = this.httpRequestV2Factory.deleteAttachmentRequest(attachmentId);
        this.sendRequestAndFailIfNot20x((HttpRequestBase)deleteAttachmentRequest);
    }

    @Override
    public ConfluenceAttachment getAttachmentByFileName(String contentId, String attachmentFileName) throws NotFoundException, MultipleResultsException {
        HttpGet attachmentByFileNameRequest = this.httpRequestV2Factory.getAttachmentByFileNameRequest(contentId, attachmentFileName, null);
        return this.sendRequestAndFailIfNot20x((HttpRequestBase)attachmentByFileNameRequest, response -> {
            JsonNode jsonNode = this.parseJsonResponse((HttpResponse)response);
            JsonNode resultsNode = ConfluenceRestV2Client.extractMandatorySingleArrayElement(jsonNode, "results");
            ConfluenceAttachment attachment = ConfluenceRestV2Client.extractConfluenceAttachment(resultsNode);
            return attachment;
        });
    }

    @Override
    public ConfluencePage getPageWithContentAndVersionById(String contentId) {
        HttpGet pageByIdRequest = this.httpRequestV2Factory.getPageByIdRequest(contentId, null);
        return this.sendRequestAndFailIfNot20x((HttpRequestBase)pageByIdRequest, response -> {
            ConfluencePage confluencePage = ConfluenceRestV2Client.extractConfluencePageWithContent(this.parseJsonResponse((HttpResponse)response));
            return confluencePage;
        });
    }

    private JsonNode parseJsonResponse(HttpResponse response) {
        try {
            return this.objectMapper.readTree(response.getEntity().getContent());
        }
        catch (IOException e) {
            throw new RuntimeException("Could not read JSON response", e);
        }
    }

    private void sendRequestAndFailIfNot20x(HttpRequestBase httpRequest) {
        this.sendRequestAndFailIfNot20x(httpRequest, response -> null);
    }

    private <T> T sendRequestAndFailIfNot20x(HttpRequestBase request, Function<HttpResponse, T> responseHandler) {
        return (T)this.sendRequest(request, response -> {
            StatusLine statusLine = response.getStatusLine();
            if (statusLine.getStatusCode() < 200 || statusLine.getStatusCode() > 206) {
                throw new RequestFailedException((HttpRequest)request, (HttpResponse)response, null);
            }
            return responseHandler.apply((HttpResponse)response);
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    <T> T sendRequest(HttpRequestBase httpRequest, Function<HttpResponse, T> responseHandler) {
        httpRequest.addHeader("Authorization", ConfluenceRestV2Client.authorizationHeaderValue(this.username, this.passwordOrPersonalAccessToken));
        if (this.rateLimiter != null) {
            this.rateLimiter.acquire(1);
        }
        try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpRequest);){
            HttpResponse t = responseHandler.apply((HttpResponse)response);
            return (T)t;
        }
        catch (IOException e) {
            throw new RequestFailedException((HttpRequest)httpRequest, null, e);
        }
    }

    @Override
    public List<ConfluencePage> getChildPages(String contentId) {
        int limit = 25;
        ArrayList<ConfluencePage> childPages = new ArrayList<ConfluencePage>();
        HttpGet getChildPagesByIdRequest = this.httpRequestV2Factory.getChildPagesByIdRequest(contentId, limit, -1, null);
        String nextLink = this.sendRequestAndFailIfNot20x((HttpRequestBase)getChildPagesByIdRequest, response -> this.extractChildPagesAndNextLink((HttpResponse)response, (List<ConfluencePage>)childPages));
        while (nextLink != null) {
            HttpGet getNextChildPagesByIdRequest = this.httpRequestV2Factory.getNextChildPagesByIdRequest(nextLink);
            nextLink = this.sendRequestAndFailIfNot20x((HttpRequestBase)getNextChildPagesByIdRequest, response -> this.extractChildPagesAndNextLink((HttpResponse)response, (List<ConfluencePage>)childPages));
        }
        return childPages;
    }

    @Override
    public List<ConfluenceAttachment> getAttachments(String contentId) {
        int limit = 2;
        ArrayList<ConfluenceAttachment> attachments = new ArrayList<ConfluenceAttachment>();
        HttpGet getAttachmentsRequest = this.httpRequestV2Factory.getAttachmentsRequest(contentId, limit, -1, null);
        String nextLink = this.sendRequestAndFailIfNot20x((HttpRequestBase)getAttachmentsRequest, response -> this.extractAttachmentsAndNextLink((HttpResponse)response, (List<ConfluenceAttachment>)attachments));
        while (nextLink != null) {
            HttpGet getNextAttachmentsRequest = this.httpRequestV2Factory.getNextAttachmentsRequest(nextLink);
            nextLink = this.sendRequestAndFailIfNot20x((HttpRequestBase)getNextAttachmentsRequest, response -> this.extractAttachmentsAndNextLink((HttpResponse)response, (List<ConfluenceAttachment>)attachments));
        }
        return attachments;
    }

    @Override
    public void setPropertyByKey(String contentId, String key, String value) {
        HttpGet lookupPropertyIdByKeyRequest = this.httpRequestV2Factory.lookupPropertyIdByKey(contentId, key);
        this.sendRequestAndFailIfNot20x((HttpRequestBase)lookupPropertyIdByKeyRequest, response -> {
            JsonNode jsonNode = this.parseJsonResponse((HttpResponse)response);
            ConfluenceRestV2Client.extractOptionalSingleArrayElement(jsonNode, "results").ifPresent(resultNode -> {
                String propertyId = resultNode.get("id").asText();
                HttpDelete deletePropertyByKeyRequest = this.httpRequestV2Factory.deletePropertyByKeyRequest(contentId, propertyId);
                this.sendRequestAndFailIfNot20x((HttpRequestBase)deletePropertyByKeyRequest);
            });
            return null;
        });
        HttpPost setPropertyByKeyRequest = this.httpRequestV2Factory.setPropertyByKeyRequest(contentId, key, value);
        this.sendRequestAndFailIfNot20x((HttpRequestBase)setPropertyByKeyRequest);
    }

    @Override
    public String getPropertyByKey(String contentId, String key) {
        HttpGet propertyByKeyRequest = this.httpRequestV2Factory.getPropertyByKeyRequest(contentId, key);
        return this.sendRequest((HttpRequestBase)propertyByKeyRequest, response -> {
            if (response.getStatusLine().getStatusCode() == 200) {
                return ConfluenceRestV2Client.extractOptionalSingleArrayElement(this.parseJsonResponse((HttpResponse)response), "results").map(ConfluenceRestV2Client::extractPropertyValueFromJsonNode).orElse(null);
            }
            return null;
        });
    }

    @Override
    public void deletePropertyByKey(String contentId, String key) {
        HttpDelete deletePropertyByKeyRequest = this.httpRequestV2Factory.deletePropertyByKeyRequest(contentId, key);
        this.sendRequest((HttpRequestBase)deletePropertyByKeyRequest, ignored -> null);
    }

    @Override
    public List<String> getLabels(String contentId) {
        HttpGet getLabelsRequest = this.httpRequestV2Factory.getLabelsRequest(contentId);
        return this.sendRequest((HttpRequestBase)getLabelsRequest, response -> {
            ArrayList labels = new ArrayList();
            JsonNode jsonNode = this.parseJsonResponse((HttpResponse)response);
            jsonNode.withArray("results").elements().forEachRemaining(n -> labels.add(n.get("name").asText()));
            return labels;
        });
    }

    @Override
    public void addLabels(String contentId, List<String> labels) {
        HttpPost addLabelRequest = this.httpRequestV2Factory.addLabelsRequest(contentId, labels);
        this.sendRequestAndFailIfNot20x((HttpRequestBase)addLabelRequest);
    }

    @Override
    public void deleteLabel(String contentId, String label) {
        HttpDelete deleteLabelRequest = this.httpRequestV2Factory.deleteLabelRequest(contentId, label);
        this.sendRequestAndFailIfNot20x((HttpRequestBase)deleteLabelRequest);
    }

    private String extractChildPagesAndNextLink(HttpResponse response, List<ConfluencePage> childPages) {
        JsonNode jsonNode = this.parseJsonResponse(response);
        if (jsonNode.has("results")) {
            jsonNode.withArray("results").forEach(pageNode -> childPages.add(ConfluenceRestV2Client.extractConfluencePageWithoutContent(pageNode)));
        }
        return jsonNode.get("_links").has("next") ? jsonNode.get("_links").get("next").asText() : null;
    }

    private String extractAttachmentsAndNextLink(HttpResponse response, List<ConfluenceAttachment> attachments) {
        JsonNode jsonNode = this.parseJsonResponse(response);
        if (jsonNode.has("results")) {
            jsonNode.withArray("results").forEach(attachmentNode -> attachments.add(ConfluenceRestV2Client.extractConfluenceAttachment(attachmentNode)));
        }
        return jsonNode.get("_links").has("next") ? jsonNode.get("_links").get("next").asText() : null;
    }

    private static ConfluencePage extractConfluencePageWithContent(JsonNode jsonNode) {
        String id = ConfluenceRestV2Client.extractIdFromJsonNode(jsonNode);
        String title = ConfluenceRestV2Client.extractTitleFromJsonNode(jsonNode);
        String content = ConfluenceRestV2Client.extractContentFromJsonNode(jsonNode);
        int version = ConfluenceRestV2Client.extractVersionFromJsonNode(jsonNode);
        return new ConfluencePage(id, title, content, version);
    }

    private static String extractContentFromJsonNode(JsonNode jsonNode) {
        if (jsonNode.has("body") && jsonNode.path("body").has("storage")) {
            return jsonNode.path("body").path("storage").get("value").asText();
        }
        if (jsonNode.has("body") && jsonNode.path("body").has("representation") && jsonNode.path("body").has("value")) {
            return jsonNode.path("body").get("value").asText();
        }
        return "";
    }

    private static ConfluencePage extractConfluencePageWithoutContent(JsonNode jsonNode) {
        String id = ConfluenceRestV2Client.extractIdFromJsonNode(jsonNode);
        String title = ConfluenceRestV2Client.extractTitleFromJsonNode(jsonNode);
        int version = ConfluenceRestV2Client.extractVersionFromJsonNode(jsonNode);
        return new ConfluencePage(id, title, version);
    }

    private static ConfluenceAttachment extractConfluenceAttachment(JsonNode jsonNode) {
        String id = ConfluenceRestV2Client.extractIdFromJsonNode(jsonNode);
        String title = ConfluenceRestV2Client.extractTitleFromJsonNode(jsonNode);
        int version = ConfluenceRestV2Client.extractVersionFromJsonNode(jsonNode);
        String relativeDownloadLink = ConfluenceRestV2Client.extractDownloadLinkFromJsonNode(jsonNode);
        return new ConfluenceAttachment(id, title, relativeDownloadLink, version);
    }

    private static String extractDownloadLinkFromJsonNode(JsonNode jsonNode) {
        if (jsonNode.path("_links").has("download")) {
            return jsonNode.path("_links").get("download").asText();
        }
        if (jsonNode.has("downloadLink")) {
            return jsonNode.get("downloadLink").asText();
        }
        return "";
    }

    private static String extractIdFromJsonNode(JsonNode jsonNode) {
        return jsonNode.get("id").asText();
    }

    private static String extractTitleFromJsonNode(JsonNode jsonNode) {
        return jsonNode.get("title").asText();
    }

    private static int extractVersionFromJsonNode(JsonNode jsonNode) {
        if (jsonNode.has("version") && jsonNode.path("version").has("number")) {
            return jsonNode.path("version").get("number").asInt();
        }
        if (jsonNode.has("version")) {
            return jsonNode.get("version").asInt();
        }
        return 1;
    }

    private static String extractPropertyValueFromJsonNode(JsonNode propertyNode) {
        return propertyNode.path("value").asText();
    }

    private static JsonNode extractMandatorySingleArrayElement(JsonNode jsonNode, String arrayPropertyName) {
        if (!jsonNode.has(arrayPropertyName) || jsonNode.withArray(arrayPropertyName).size() == 0) {
            throw new NotFoundException();
        }
        if (jsonNode.withArray(arrayPropertyName).size() > 1) {
            throw new MultipleResultsException();
        }
        return (JsonNode)jsonNode.withArray(arrayPropertyName).elements().next();
    }

    private static Optional<JsonNode> extractOptionalSingleArrayElement(JsonNode jsonNode, String arrayPropertyName) {
        if (!jsonNode.has(arrayPropertyName) || jsonNode.withArray(arrayPropertyName).size() == 0) {
            return Optional.empty();
        }
        if (jsonNode.withArray(arrayPropertyName).size() > 1) {
            throw new MultipleResultsException();
        }
        return Optional.of((JsonNode)jsonNode.withArray(arrayPropertyName).elements().next());
    }

    private static void closeInputStream(InputStream inputStream) {
        try {
            inputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static CloseableHttpClient defaultHttpClient(ProxyConfiguration proxyConfiguration, boolean disableSslVerification, boolean enableHttpClientSystemProperties, Integer connectionTTL) {
        RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(20000).setConnectTimeout(20000).setCookieSpec("standard").build();
        HttpClientBuilder builder = HttpClients.custom().setDefaultRequestConfig(requestConfig);
        if (enableHttpClientSystemProperties) {
            builder.useSystemProperties();
        }
        if (proxyConfiguration != null && proxyConfiguration.proxyHost() != null) {
            String proxyScheme = proxyConfiguration.proxyScheme() != null ? proxyConfiguration.proxyScheme() : "http";
            String proxyHost = proxyConfiguration.proxyHost();
            int proxyPort = proxyConfiguration.proxyPort() != null ? proxyConfiguration.proxyPort() : 80;
            builder.setProxy(new HttpHost(proxyHost, proxyPort, proxyScheme));
            if (proxyConfiguration.proxyUsername() != null) {
                String proxyUsername = proxyConfiguration.proxyUsername();
                String proxyPassword = proxyConfiguration.proxyPassword();
                builder.setDefaultHeaders(Collections.singletonList(new BasicHeader("Proxy-Authorization", ConfluenceRestV2Client.authorizationHeaderValue(proxyUsername, proxyPassword))));
                BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                credentialsProvider.setCredentials(new AuthScope(proxyHost, proxyPort), (Credentials)new UsernamePasswordCredentials(proxyUsername, proxyPassword));
                builder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
            }
        }
        if (connectionTTL != null) {
            builder.setConnectionTimeToLive((long)connectionTTL.intValue(), TimeUnit.MILLISECONDS);
        }
        if (disableSslVerification) {
            builder.setSSLContext(ConfluenceRestV2Client.trustAllSslContext());
            builder.setSSLHostnameVerifier((HostnameVerifier)new NoopHostnameVerifier());
        }
        return builder.build();
    }

    private static SSLContext trustAllSslContext() {
        try {
            return new SSLContextBuilder().loadTrustMaterial((chain, authType) -> true).build();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create trust-all SSL context", e);
        }
    }

    private static String authorizationHeaderValue(String username, String password) {
        if (username == null || username.isEmpty()) {
            return "Bearer " + password;
        }
        return "Basic " + Base64.getEncoder().encodeToString((username + ":" + password).getBytes(StandardCharsets.UTF_8));
    }
}

