/*
 * Decompiled with CFR 0.152.
 */
package org.sahli.asciidoc.confluence.publisher.client;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.sahli.asciidoc.confluence.publisher.client.ConfluencePublisherListener;
import org.sahli.asciidoc.confluence.publisher.client.PublishingStrategy;
import org.sahli.asciidoc.confluence.publisher.client.http.ConfluenceAttachment;
import org.sahli.asciidoc.confluence.publisher.client.http.ConfluenceClient;
import org.sahli.asciidoc.confluence.publisher.client.http.ConfluencePage;
import org.sahli.asciidoc.confluence.publisher.client.http.NotFoundException;
import org.sahli.asciidoc.confluence.publisher.client.metadata.ConfluencePageMetadata;
import org.sahli.asciidoc.confluence.publisher.client.metadata.ConfluencePublisherMetadata;
import org.sahli.asciidoc.confluence.publisher.client.utils.AssertUtils;
import org.sahli.asciidoc.confluence.publisher.client.utils.InputStreamUtils;

public class ConfluencePublisher {
    static final String CONTENT_HASH_PROPERTY_KEY = "content-hash";
    static final int INITIAL_PAGE_VERSION = 1;
    private final ConfluencePublisherMetadata metadata;
    private final PublishingStrategy publishingStrategy;
    private final ConfluenceClient confluenceClient;
    private final ConfluencePublisherListener confluencePublisherListener;
    private final String versionMessage;

    public ConfluencePublisher(ConfluencePublisherMetadata metadata, PublishingStrategy publishingStrategy, ConfluenceClient confluenceClient) {
        this(metadata, publishingStrategy, confluenceClient, new NoOpConfluencePublisherListener(), null);
    }

    public ConfluencePublisher(ConfluencePublisherMetadata metadata, PublishingStrategy publishingStrategy, ConfluenceClient confluenceClient, ConfluencePublisherListener confluencePublisherListener, String versionMessage) {
        this.metadata = metadata;
        this.publishingStrategy = publishingStrategy;
        this.confluenceClient = confluenceClient;
        this.confluencePublisherListener = confluencePublisherListener;
        this.versionMessage = versionMessage;
    }

    public void publish() {
        AssertUtils.assertMandatoryParameter(StringUtils.isNotBlank((String)this.metadata.getSpaceKey()), "spaceKey");
        AssertUtils.assertMandatoryParameter(StringUtils.isNotBlank((String)this.metadata.getAncestorId()), "ancestorId");
        switch (this.publishingStrategy) {
            case APPEND_TO_ANCESTOR: {
                this.startPublishingUnderAncestorId(this.metadata.getPages(), this.metadata.getSpaceKey(), this.metadata.getAncestorId());
                break;
            }
            case REPLACE_ANCESTOR: {
                this.startPublishingReplacingAncestorId(ConfluencePublisher.singleRootPage(this.metadata), this.metadata.getSpaceKey(), this.metadata.getAncestorId());
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid publishing strategy '" + (Object)((Object)this.publishingStrategy) + "'");
            }
        }
        this.confluencePublisherListener.publishCompleted();
    }

    private static ConfluencePageMetadata singleRootPage(ConfluencePublisherMetadata metadata) {
        List<ConfluencePageMetadata> rootPages = metadata.getPages();
        if (rootPages.size() > 1) {
            String rootPageTitles = rootPages.stream().map(page -> "'" + page.getTitle() + "'").collect(Collectors.joining(", "));
            throw new IllegalArgumentException("Multiple root pages detected: " + rootPageTitles + ", but '" + (Object)((Object)PublishingStrategy.REPLACE_ANCESTOR) + "' publishing strategy only supports one single root page");
        }
        if (rootPages.size() == 1) {
            return rootPages.get(0);
        }
        return null;
    }

    private void startPublishingReplacingAncestorId(ConfluencePageMetadata rootPage, String spaceKey, String ancestorId) {
        if (rootPage != null) {
            this.updatePage(ancestorId, null, rootPage);
            this.deleteConfluenceAttachmentsNotPresentUnderPage(ancestorId, rootPage.getAttachments());
            this.addAttachments(ancestorId, rootPage.getAttachments());
            this.startPublishingUnderAncestorId(rootPage.getChildren(), spaceKey, ancestorId);
        }
    }

    private void startPublishingUnderAncestorId(List<ConfluencePageMetadata> pages, String spaceKey, String ancestorId) {
        this.deleteConfluencePagesNotPresentUnderAncestor(pages, ancestorId);
        pages.forEach(page -> {
            String contentId = this.addOrUpdatePageUnderAncestor(spaceKey, ancestorId, (ConfluencePageMetadata)page);
            this.deleteConfluenceAttachmentsNotPresentUnderPage(contentId, page.getAttachments());
            this.addAttachments(contentId, page.getAttachments());
            this.startPublishingUnderAncestorId(page.getChildren(), spaceKey, contentId);
        });
    }

    private void deleteConfluencePagesNotPresentUnderAncestor(List<ConfluencePageMetadata> pagesToKeep, String ancestorId) {
        List<ConfluencePage> childPagesOnConfluence = this.confluenceClient.getChildPages(ancestorId);
        List<ConfluencePage> childPagesOnConfluenceToDelete = childPagesOnConfluence.stream().filter(childPageOnConfluence -> pagesToKeep.stream().noneMatch(page -> page.getTitle().equals(childPageOnConfluence.getTitle()))).collect(Collectors.toList());
        childPagesOnConfluenceToDelete.forEach(pageToDelete -> {
            List<ConfluencePage> pageScheduledForDeletionChildPagesOnConfluence = this.confluenceClient.getChildPages(pageToDelete.getContentId());
            pageScheduledForDeletionChildPagesOnConfluence.forEach(parentPageToDelete -> this.deleteConfluencePagesNotPresentUnderAncestor(Collections.emptyList(), pageToDelete.getContentId()));
            this.confluenceClient.deletePage(pageToDelete.getContentId());
            this.confluencePublisherListener.pageDeleted((ConfluencePage)pageToDelete);
        });
    }

    private void deleteConfluenceAttachmentsNotPresentUnderPage(String contentId, Map<String, String> attachments) {
        List<ConfluenceAttachment> confluenceAttachments = this.confluenceClient.getAttachments(contentId);
        List<String> confluenceAttachmentsToDelete = confluenceAttachments.stream().filter(confluenceAttachment -> attachments.keySet().stream().noneMatch(attachmentFileName -> attachmentFileName.equals(confluenceAttachment.getTitle()))).map(ConfluenceAttachment::getId).collect(Collectors.toList());
        confluenceAttachmentsToDelete.forEach(this.confluenceClient::deleteAttachment);
    }

    private String addOrUpdatePageUnderAncestor(String spaceKey, String ancestorId, ConfluencePageMetadata page) {
        String contentId;
        try {
            contentId = this.confluenceClient.getPageByTitle(spaceKey, page.getTitle());
            this.updatePage(contentId, ancestorId, page);
        }
        catch (NotFoundException e) {
            String content = InputStreamUtils.fileContent(page.getContentFilePath(), StandardCharsets.UTF_8);
            contentId = this.confluenceClient.addPageUnderAncestor(spaceKey, ancestorId, page.getTitle(), content, this.versionMessage);
            this.confluenceClient.setPropertyByKey(contentId, CONTENT_HASH_PROPERTY_KEY, ConfluencePublisher.contentHash(content));
            this.confluencePublisherListener.pageAdded(new ConfluencePage(contentId, page.getTitle(), content, 1));
        }
        return contentId;
    }

    private void updatePage(String contentId, String ancestorId, ConfluencePageMetadata page) {
        String newContentHash;
        String content = InputStreamUtils.fileContent(page.getContentFilePath(), StandardCharsets.UTF_8);
        ConfluencePage existingPage = this.confluenceClient.getPageWithContentAndVersionById(contentId);
        String existingContentHash = this.confluenceClient.getPropertyByKey(contentId, CONTENT_HASH_PROPERTY_KEY);
        if (ConfluencePublisher.notSameContentHash(existingContentHash, newContentHash = ConfluencePublisher.contentHash(content)) || !existingPage.getTitle().equals(page.getTitle())) {
            this.confluenceClient.deletePropertyByKey(contentId, CONTENT_HASH_PROPERTY_KEY);
            int newPageVersion = existingPage.getVersion() + 1;
            this.confluenceClient.updatePage(contentId, ancestorId, page.getTitle(), content, newPageVersion, this.versionMessage);
            this.confluenceClient.setPropertyByKey(contentId, CONTENT_HASH_PROPERTY_KEY, newContentHash);
            this.confluencePublisherListener.pageUpdated(existingPage, new ConfluencePage(contentId, page.getTitle(), content, newPageVersion));
        }
    }

    private static String contentHash(String content) {
        return DigestUtils.sha256Hex((String)content);
    }

    private void addAttachments(String contentId, Map<String, String> attachments) {
        attachments.forEach((attachmentFileName, attachmentPath) -> this.addOrUpdateAttachment(contentId, (String)attachmentPath, (String)attachmentFileName));
    }

    private void addOrUpdateAttachment(String contentId, String attachmentPath, String attachmentFileName) {
        Path absoluteAttachmentPath = this.absoluteAttachmentPath(attachmentPath);
        try {
            ConfluenceAttachment existingAttachment = this.confluenceClient.getAttachmentByFileName(contentId, attachmentFileName);
            InputStream existingAttachmentContent = this.confluenceClient.getAttachmentContent(existingAttachment.getRelativeDownloadLink());
            if (!ConfluencePublisher.isSameContent(existingAttachmentContent, ConfluencePublisher.fileInputStream(absoluteAttachmentPath))) {
                this.confluenceClient.updateAttachmentContent(contentId, existingAttachment.getId(), ConfluencePublisher.fileInputStream(absoluteAttachmentPath));
            }
        }
        catch (NotFoundException e) {
            this.confluenceClient.addAttachment(contentId, attachmentFileName, ConfluencePublisher.fileInputStream(absoluteAttachmentPath));
        }
    }

    private Path absoluteAttachmentPath(String attachmentPath) {
        return Paths.get(attachmentPath, new String[0]);
    }

    private static boolean notSameContentHash(String actualContentHash, String newContentHash) {
        return actualContentHash == null || !actualContentHash.equals(newContentHash);
    }

    private static boolean isSameContent(InputStream left, InputStream right) {
        String leftHash = ConfluencePublisher.sha256Hash(left);
        String rightHash = ConfluencePublisher.sha256Hash(right);
        return leftHash.equals(rightHash);
    }

    private static String sha256Hash(InputStream content) {
        try {
            String string = DigestUtils.sha256Hex((InputStream)content);
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException("Could not compute hash from input stream", e);
        }
        finally {
            try {
                content.close();
            }
            catch (IOException iOException) {}
        }
    }

    private static FileInputStream fileInputStream(Path filePath) {
        try {
            return new FileInputStream(filePath.toFile());
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("Could not find attachment ", e);
        }
    }

    private static class NoOpConfluencePublisherListener
    implements ConfluencePublisherListener {
        private NoOpConfluencePublisherListener() {
        }

        @Override
        public void pageAdded(ConfluencePage addedPage) {
        }

        @Override
        public void pageUpdated(ConfluencePage existingPage, ConfluencePage updatedPage) {
        }

        @Override
        public void pageDeleted(ConfluencePage deletedPage) {
        }

        @Override
        public void publishCompleted() {
        }
    }
}

