/*
 * Decompiled with CFR 0.152.
 */
package org.sahli.asciidoc.confluence.publisher.converter;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.sahli.asciidoc.confluence.publisher.converter.AsciidocPagesStructureProvider;

public class FolderBasedAsciidocPagesStructureProvider
implements AsciidocPagesStructureProvider {
    private static final String ADOC_FILE_EXTENSION = ".adoc";
    private static final String INCLUDE_FILE_PREFIX = "_";
    private final AsciidocPagesStructureProvider.AsciidocPagesStructure structure;
    private final Charset sourceEncoding;

    public FolderBasedAsciidocPagesStructureProvider(Path documentationRootFolder, Charset sourceEncoding) {
        this.structure = this.buildStructure(documentationRootFolder);
        this.sourceEncoding = sourceEncoding;
    }

    @Override
    public AsciidocPagesStructureProvider.AsciidocPagesStructure structure() {
        return this.structure;
    }

    @Override
    public Charset sourceEncoding() {
        return this.sourceEncoding;
    }

    private AsciidocPagesStructureProvider.AsciidocPagesStructure buildStructure(Path documentationRootFolder) {
        try {
            Map<Path, DefaultAsciidocPage> asciidocPageIndex = FolderBasedAsciidocPagesStructureProvider.indexAsciidocPagesByFolderPath(documentationRootFolder);
            List<DefaultAsciidocPage> allAsciidocPages = this.connectAsciidocPagesToParent(asciidocPageIndex);
            List<AsciidocPagesStructureProvider.AsciidocPage> topLevelAsciiPages = FolderBasedAsciidocPagesStructureProvider.findTopLevelAsciiPages(allAsciidocPages, documentationRootFolder);
            return new DefaultAsciidocPagesStructure(topLevelAsciiPages);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not create asciidoc source structure", e);
        }
    }

    private List<DefaultAsciidocPage> connectAsciidocPagesToParent(Map<Path, DefaultAsciidocPage> asciidocPageIndex) {
        asciidocPageIndex.forEach((asciidocPageFolderPath, asciidocPage) -> asciidocPageIndex.computeIfPresent(asciidocPage.path().getParent(), (ignored, parentAsciidocPage) -> {
            parentAsciidocPage.addChild((AsciidocPagesStructureProvider.AsciidocPage)asciidocPage);
            return parentAsciidocPage;
        }));
        return new ArrayList<DefaultAsciidocPage>(asciidocPageIndex.values());
    }

    private static Map<Path, DefaultAsciidocPage> indexAsciidocPagesByFolderPath(Path documentationRootFolder) throws IOException {
        return Files.walk(documentationRootFolder, new FileVisitOption[0]).filter(path -> FolderBasedAsciidocPagesStructureProvider.isAdocFile(path) && !FolderBasedAsciidocPagesStructureProvider.isIncludeFile(path)).collect(Collectors.toMap(asciidocPagePath -> FolderBasedAsciidocPagesStructureProvider.removeExtension(asciidocPagePath), asciidocPagePath -> new DefaultAsciidocPage((Path)asciidocPagePath)));
    }

    private static List<AsciidocPagesStructureProvider.AsciidocPage> findTopLevelAsciiPages(List<DefaultAsciidocPage> asciiPageByFolderPath, Path documentationRootFolder) {
        return asciiPageByFolderPath.stream().filter(asciidocPage -> asciidocPage.path().equals(documentationRootFolder.resolve(asciidocPage.path().getFileName()))).collect(Collectors.toList());
    }

    private static Path removeExtension(Path path) {
        return Paths.get(path.toString().substring(0, path.toString().lastIndexOf(46)), new String[0]);
    }

    private static boolean isAdocFile(Path file) {
        return file.toString().endsWith(ADOC_FILE_EXTENSION);
    }

    private static boolean isIncludeFile(Path file) {
        return file.getFileName().toString().startsWith(INCLUDE_FILE_PREFIX);
    }

    private static class DefaultAsciidocPagesStructure
    implements AsciidocPagesStructureProvider.AsciidocPagesStructure {
        private final List<AsciidocPagesStructureProvider.AsciidocPage> asciidocPages;

        DefaultAsciidocPagesStructure(List<AsciidocPagesStructureProvider.AsciidocPage> asciidocPages) {
            this.asciidocPages = asciidocPages;
        }

        @Override
        public List<AsciidocPagesStructureProvider.AsciidocPage> pages() {
            return this.asciidocPages;
        }
    }

    private static class DefaultAsciidocPage
    implements AsciidocPagesStructureProvider.AsciidocPage {
        private final Path path;
        private final List<AsciidocPagesStructureProvider.AsciidocPage> children;

        DefaultAsciidocPage(Path path) {
            this.path = path;
            this.children = new ArrayList<AsciidocPagesStructureProvider.AsciidocPage>();
        }

        void addChild(AsciidocPagesStructureProvider.AsciidocPage child) {
            this.children.add(child);
        }

        @Override
        public Path path() {
            return this.path;
        }

        @Override
        public List<AsciidocPagesStructureProvider.AsciidocPage> children() {
            return Collections.unmodifiableList(this.children);
        }
    }
}

