/*
 * Decompiled with CFR 0.152.
 */
package org.sahli.asciidoc.confluence.publisher.converter;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.codec.digest.DigestUtils;
import org.sahli.asciidoc.confluence.publisher.client.metadata.ConfluencePageMetadata;
import org.sahli.asciidoc.confluence.publisher.client.metadata.ConfluencePublisherMetadata;
import org.sahli.asciidoc.confluence.publisher.converter.AsciidocConfluencePage;
import org.sahli.asciidoc.confluence.publisher.converter.AsciidocPagesStructureProvider;
import org.sahli.asciidoc.confluence.publisher.converter.NoOpPageTitlePostProcessor;
import org.sahli.asciidoc.confluence.publisher.converter.PageTitlePostProcessor;

public final class AsciidocConfluenceConverter {
    private static final String TEMPLATE_ROOT_CLASS_PATH_LOCATION = "org/sahli/asciidoc/confluence/publisher/converter/templates";
    private final String spaceKey;
    private final String ancestorId;

    public AsciidocConfluenceConverter(String spaceKey, String ancestorId) {
        this.spaceKey = spaceKey;
        this.ancestorId = ancestorId;
    }

    public ConfluencePublisherMetadata convert(AsciidocPagesStructureProvider asciidocPagesStructureProvider, Path buildFolder, Map<String, Object> userAttributes) {
        return this.convert(asciidocPagesStructureProvider, new NoOpPageTitlePostProcessor(), buildFolder, userAttributes);
    }

    public ConfluencePublisherMetadata convert(AsciidocPagesStructureProvider asciidocPagesStructureProvider, PageTitlePostProcessor pageTitlePostProcessor, Path buildFolder, Map<String, Object> userAttributes) {
        try {
            Path templatesRootFolder = buildFolder.resolve("templates").toAbsolutePath();
            Files.createDirectories(templatesRootFolder, new FileAttribute[0]);
            Path assetsRootFolder = buildFolder.resolve("assets").toAbsolutePath();
            Files.createDirectories(assetsRootFolder, new FileAttribute[0]);
            AsciidocConfluenceConverter.extractTemplatesFromClassPathTo(templatesRootFolder);
            AsciidocPagesStructureProvider.AsciidocPagesStructure structure = asciidocPagesStructureProvider.structure();
            List<AsciidocPagesStructureProvider.AsciidocPage> asciidocPages = structure.pages();
            Charset sourceEncoding = asciidocPagesStructureProvider.sourceEncoding();
            List<ConfluencePageMetadata> confluencePages = AsciidocConfluenceConverter.buildPageTree(templatesRootFolder, assetsRootFolder, asciidocPages, sourceEncoding, pageTitlePostProcessor, userAttributes);
            ConfluencePublisherMetadata confluencePublisherMetadata = new ConfluencePublisherMetadata();
            confluencePublisherMetadata.setSpaceKey(this.spaceKey);
            confluencePublisherMetadata.setAncestorId(this.ancestorId);
            confluencePublisherMetadata.setPages(confluencePages);
            return confluencePublisherMetadata;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not convert asciidoc pages", e);
        }
    }

    private static List<ConfluencePageMetadata> buildPageTree(Path templatesRootFolder, Path assetsRootFolder, List<AsciidocPagesStructureProvider.AsciidocPage> asciidocPages, Charset sourceEncoding, PageTitlePostProcessor pageTitlePostProcessor, Map<String, Object> userAttributes) {
        ArrayList<ConfluencePageMetadata> confluencePages = new ArrayList<ConfluencePageMetadata>();
        asciidocPages.forEach(asciidocPage -> {
            try {
                Path pageAssetsFolder = AsciidocConfluenceConverter.determinePageAssetsFolder(assetsRootFolder, asciidocPage);
                Files.createDirectories(pageAssetsFolder, new FileAttribute[0]);
                AsciidocConfluencePage asciidocConfluencePage = AsciidocConfluencePage.newAsciidocConfluencePage(asciidocPage, sourceEncoding, templatesRootFolder, pageAssetsFolder, pageTitlePostProcessor, userAttributes);
                Path contentFileTargetPath = AsciidocConfluenceConverter.writeToTargetStructure(asciidocPage, pageAssetsFolder, asciidocConfluencePage);
                List<AttachmentMetadata> attachments = AsciidocConfluenceConverter.buildAttachments(asciidocPage, pageAssetsFolder, asciidocConfluencePage.attachments());
                AsciidocConfluenceConverter.copyAttachmentsAvailableInSourceStructureToTargetStructure(attachments);
                List<ConfluencePageMetadata> childConfluencePages = AsciidocConfluenceConverter.buildPageTree(templatesRootFolder, assetsRootFolder, asciidocPage.children(), sourceEncoding, pageTitlePostProcessor, userAttributes);
                ConfluencePageMetadata confluencePageMetadata = AsciidocConfluenceConverter.buildConfluencePageMetadata(asciidocConfluencePage, contentFileTargetPath, childConfluencePages, attachments);
                confluencePages.add(confluencePageMetadata);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not convert and build confluence page", e);
            }
        });
        return confluencePages;
    }

    private static List<AttachmentMetadata> buildAttachments(AsciidocPagesStructureProvider.AsciidocPage asciidocPage, Path pageAssetsFolder, Map<String, String> attachmentsWithRelativePath) {
        return attachmentsWithRelativePath.keySet().stream().map(attachmentWithRelativePath -> {
            Path relativeAttachmentPath = Paths.get(attachmentWithRelativePath, new String[0]);
            Path attachmentSourcePath = asciidocPage.path().getParent().resolve(relativeAttachmentPath);
            Path attachmentTargetPath = pageAssetsFolder.resolve(relativeAttachmentPath.getFileName());
            return new AttachmentMetadata(attachmentSourcePath, attachmentTargetPath);
        }).collect(Collectors.toList());
    }

    private static ConfluencePageMetadata buildConfluencePageMetadata(AsciidocConfluencePage asciidocConfluencePage, Path contentFileTargetPath, List<ConfluencePageMetadata> childConfluencePages, List<AttachmentMetadata> attachments) {
        ConfluencePageMetadata confluencePageMetadata = new ConfluencePageMetadata();
        confluencePageMetadata.setTitle(asciidocConfluencePage.pageTitle());
        confluencePageMetadata.setContentFilePath(contentFileTargetPath.toAbsolutePath().toString());
        confluencePageMetadata.setChildren(childConfluencePages);
        confluencePageMetadata.getAttachments().putAll(AsciidocConfluenceConverter.toTargetAttachmentFileNameAndAttachmentPath(attachments));
        return confluencePageMetadata;
    }

    private static Path writeToTargetStructure(AsciidocPagesStructureProvider.AsciidocPage asciidocPage, Path pageAssetsFolder, AsciidocConfluencePage asciidocConfluencePage) throws IOException {
        Path contentFileTargetPath = AsciidocConfluenceConverter.determineTargetPagePath(asciidocPage, pageAssetsFolder);
        Files.write(contentFileTargetPath, asciidocConfluencePage.content().getBytes("UTF-8"), new OpenOption[0]);
        return contentFileTargetPath;
    }

    private static void copyAttachmentsAvailableInSourceStructureToTargetStructure(List<AttachmentMetadata> attachments) {
        attachments.forEach(attachment -> {
            try {
                if (Files.exists(attachment.sourcePath(), new LinkOption[0])) {
                    Files.copy(attachment.sourcePath(), attachment.targetPath(), StandardCopyOption.REPLACE_EXISTING);
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Could not copy attachment to target structure", e);
            }
        });
    }

    private static Map<String, String> toTargetAttachmentFileNameAndAttachmentPath(List<AttachmentMetadata> attachments) {
        return attachments.stream().collect(Collectors.toMap(attachment -> attachment.targetPath().getFileName().toString(), attachment -> attachment.targetPath().toString()));
    }

    private static Path determineTargetPagePath(AsciidocPagesStructureProvider.AsciidocPage asciidocPage, Path pageAssetsFolder) {
        return AsciidocConfluenceConverter.replaceExtension(pageAssetsFolder.resolve(asciidocPage.path().getFileName()), ".adoc", ".html");
    }

    private static Path determinePageAssetsFolder(Path assetsRootFolder, AsciidocPagesStructureProvider.AsciidocPage asciidocPage) {
        String uniquePageId = AsciidocConfluenceConverter.uniquePageId(asciidocPage.path());
        Path pageAssetsFolder = assetsRootFolder.resolve(uniquePageId);
        return pageAssetsFolder;
    }

    static String uniquePageId(Path asciidocPagePath) {
        return DigestUtils.sha256Hex((String)asciidocPagePath.toAbsolutePath().toString());
    }

    private static Path replaceExtension(Path path, String existingExtension, String newExtension) {
        return Paths.get(path.toString().replace(existingExtension, newExtension), new String[0]);
    }

    private static void extractTemplatesFromClassPathTo(Path targetFolder) {
        AsciidocConfluenceConverter.createTemplatesTargetFolder(targetFolder);
        AsciidocConfluenceConverter.withTemplates(template -> AsciidocConfluenceConverter.copyTemplateTo(targetFolder, template));
    }

    private static void withTemplates(Consumer<Path> templateConsumer) {
        try {
            URI templatePathUri = AsciidocConfluenceConverter.resolveTemplateRootUri();
            if (templatePathUri.getScheme().startsWith("jar")) {
                AsciidocConfluenceConverter.withTemplatesFromJar(templatePathUri, templateConsumer);
            } else {
                AsciidocConfluenceConverter.withTemplatesFromFileSystem(templatePathUri, templateConsumer);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not resolve template root folder", e);
        }
    }

    private static URI resolveTemplateRootUri() throws URISyntaxException {
        URL templateRootUrl = AsciidocConfluencePage.class.getClassLoader().getResource(TEMPLATE_ROOT_CLASS_PATH_LOCATION);
        if (templateRootUrl == null) {
            throw new RuntimeException("Could not load templates from class path 'org/sahli/asciidoc/confluence/publisher/converter/templates'");
        }
        return templateRootUrl.toURI();
    }

    private static void withTemplatesFromFileSystem(URI templatePathUri, Consumer<Path> templateConsumer) throws IOException {
        Files.list(Paths.get(templatePathUri)).forEach(templateConsumer);
    }

    private static void withTemplatesFromJar(URI templatePathUri, Consumer<Path> templateConsumer) throws IOException {
        URI jarFileUri = URI.create(templatePathUri.toString().substring(0, templatePathUri.toString().indexOf(33)));
        try (FileSystem jarFileSystem = FileSystems.newFileSystem(jarFileUri, Collections.emptyMap());){
            Path templateRootFolder = jarFileSystem.getPath("/org/sahli/asciidoc/confluence/publisher/converter/templates", new String[0]);
            Files.list(templateRootFolder).forEach(templateConsumer);
        }
    }

    private static void createTemplatesTargetFolder(Path targetFolder) {
        try {
            Files.createDirectories(targetFolder, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not create template folder", e);
        }
    }

    private static void copyTemplateTo(Path targetFolder, Path template) {
        try {
            Files.copy(template, targetFolder.resolve(template.getFileName().toString()), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not write template to target file", e);
        }
    }

    private static class AttachmentMetadata {
        private final Path sourcePath;
        private final Path targetPath;

        AttachmentMetadata(Path sourcePath, Path targetPath) {
            this.sourcePath = sourcePath;
            this.targetPath = targetPath;
        }

        Path sourcePath() {
            return this.sourcePath;
        }

        Path targetPath() {
            return this.targetPath;
        }
    }
}

