/*
 * Decompiled with CFR 0.152.
 */
package net.oauth.client;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import net.oauth.OAuth;
import net.oauth.OAuthMessage;
import net.oauth.OAuthProblemException;
import net.oauth.http.HttpResponseMessage;

public class OAuthResponseMessage
extends OAuthMessage {
    private final HttpResponseMessage http;

    OAuthResponseMessage(HttpResponseMessage http) throws IOException {
        super(http.method, http.url.toExternalForm(), null);
        this.http = http;
        this.getHeaders().addAll(http.headers);
        for (Map.Entry header : http.headers) {
            if (!"WWW-Authenticate".equalsIgnoreCase((String)header.getKey())) continue;
            for (OAuth.Parameter parameter : OAuthResponseMessage.decodeAuthorization((String)header.getValue())) {
                if ("realm".equalsIgnoreCase(parameter.getKey())) continue;
                this.addParameter(parameter);
            }
        }
    }

    public HttpResponseMessage getHttpResponse() {
        return this.http;
    }

    @Override
    public InputStream getBodyAsStream() throws IOException {
        return this.http.getBody();
    }

    @Override
    public String getBodyEncoding() {
        return this.http.getContentCharset();
    }

    @Override
    public void requireParameters(String ... names) throws OAuthProblemException, IOException {
        try {
            super.requireParameters(names);
        }
        catch (OAuthProblemException problem) {
            problem.getParameters().putAll(this.getDump());
            throw problem;
        }
    }

    public OAuthProblemException toOAuthProblemException() throws IOException {
        OAuthProblemException problem = new OAuthProblemException();
        try {
            this.getParameters();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        problem.getParameters().putAll(this.getDump());
        try {
            InputStream b = this.getBodyAsStream();
            if (b != null) {
                b.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return problem;
    }

    @Override
    protected void completeParameters() throws IOException {
        super.completeParameters();
        String body = this.readBodyAsString();
        if (body != null) {
            this.addParameters(OAuth.decodeForm(body.trim()));
        }
    }

    @Override
    protected void dump(Map<String, Object> into) throws IOException {
        super.dump(into);
        this.http.dump(into);
    }
}

