/*
 * Decompiled with CFR 0.152.
 */
package org.tsugi.http;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtil {
    private static final Logger log = LoggerFactory.getLogger(HttpUtil.class);
    private static final Pattern p = Pattern.compile("<(.*)>; *rel=\"(.*)\"");

    public static void printHeaders(HttpServletRequest request) {
        Enumeration headerNames = request.getHeaderNames();
        System.out.println("Headers for " + request.getRequestURI());
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            System.out.println("Header Name - " + headerName + ", Value - " + request.getHeader(headerName));
        }
    }

    public static void printParameters(HttpServletRequest request) {
        System.out.println("Parameters for " + request.getRequestURI());
        Enumeration params = request.getParameterNames();
        while (params.hasMoreElements()) {
            String paramName = (String)params.nextElement();
            System.out.println("Parameter Name - " + paramName + ", Value - " + request.getParameter(paramName));
        }
    }

    public static String getCookie(HttpServletRequest request, String lookup) {
        if (request == null || lookup == null) {
            return null;
        }
        Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            return null;
        }
        for (int i = 0; i < cookies.length; ++i) {
            Cookie cookie = cookies[i];
            String cookieName = cookie.getName();
            String cookieValue = cookie.getValue();
            if (StringUtils.isEmpty((CharSequence)cookieName) || !cookieName.equalsIgnoreCase(lookup)) continue;
            return cookieValue;
        }
        return null;
    }

    public static String augmentGetURL(String url, Map<String, String> data) {
        if (data == null || data.size() < 1) {
            return url;
        }
        StringBuilder builder = new StringBuilder();
        builder.append(url);
        boolean questionMark = url.contains("?");
        for (Map.Entry<String, String> entry : data.entrySet()) {
            if (!questionMark) {
                builder.append("?");
            } else {
                builder.append("&");
            }
            builder.append(URLEncoder.encode(entry.getKey().toString(), StandardCharsets.UTF_8));
            builder.append("=");
            builder.append(URLEncoder.encode(entry.getValue().toString(), StandardCharsets.UTF_8));
        }
        return builder.toString();
    }

    public static String extractLinkByRel(List<String> allValuesOfLink, String rel) {
        if (rel == null || allValuesOfLink == null) {
            return null;
        }
        for (String value : allValuesOfLink) {
            Matcher m = p.matcher(value);
            if (!m.find() || !rel.equals(m.group(2))) continue;
            return m.group(1);
        }
        return null;
    }

    public static Instant getInstantFromHttp(String headerDate) {
        return null;
    }
}

