/*
 * Decompiled with CFR 0.152.
 */
package org.tsugi.jackson;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JacksonUtil {
    private static final Logger log = LoggerFactory.getLogger(JacksonUtil.class);

    public static String prettyPrint(Object obj) throws JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        ObjectWriter writer = mapper.writerWithDefaultPrettyPrinter();
        return writer.writeValueAsString(obj);
    }

    public static String prettyPrintLog(Object obj) {
        try {
            return JacksonUtil.prettyPrint(obj);
        }
        catch (JsonProcessingException e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static String toString(Object jackson) {
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            String retval = objectMapper.writeValueAsString(jackson);
            return retval;
        }
        catch (JsonProcessingException e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static ObjectMapper getLaxObjectMapper() {
        ObjectMapper mapper = new ObjectMapper().configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true).configure(DeserializationFeature.FAIL_ON_UNRESOLVED_OBJECT_IDS, false).configure(DeserializationFeature.FAIL_ON_INVALID_SUBTYPE, false).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return mapper;
    }
}

