/*
 * Decompiled with CFR 0.152.
 */
package org.tsugi.lti13;

import io.jsonwebtoken.Jws;
import io.jsonwebtoken.Jwts;
import java.security.Key;
import javax.servlet.http.HttpServletRequest;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.tsugi.basiclti.BasicLTIUtil;
import org.tsugi.lti13.LTI13JwtUtil;

public class DeepLinkResponse {
    public static final String DEEP_LINKS = "https://purl.imsglobal.org/spec/lti-dl/claim/content_items";
    public static final String DATA = "https://purl.imsglobal.org/spec/lti-dl/claim/data";
    public static final String ACCEPT_MEDIA_TYPES = "accept_media_types";
    public static String MEDIA_LTILINKITEM = "application/vnd.ims.lti.v1.ltilink";
    public static final String MEDIA_CC_1_1 = "application/vnd.ims.imsccv1p1";
    public static final String MEDIA_CC_1_2 = "application/vnd.ims.imsccv1p2";
    public static final String MEDIA_CC_1_3 = "application/vnd.ims.imsccv1p3";
    public static final String MEDIA_CC = "application/vnd.ims.imsccv1p1,application/vnd.ims.imsccv1p2,application/vnd.ims.imsccv1p3";
    public static final String TYPE = "type";
    public static final String TYPE_LINKITEM = "link";
    public static final String TYPE_LTILINKITEM = "ltiResourceLink";
    public static final String TYPE_CONTENTITEM = "html";
    public static final String TYPE_FILEITEM = "file";
    public static final String TITLE = "title";
    public static final String TEXT = "text";
    public static final String URL = "url";
    public static final String LINEITEM = "lineItem";
    public static final String CUSTOM = "custom";
    public static final String ICON = "icon";
    public static final String AVAILABLE = "available";
    public static final String AVAILABLE_STARTDATETIME = "startDateTime";
    public static final String AVAILABLE_ENDDATETIME = "endDateTime";
    public static final String RESOURCELINK_AVAILABLE_STARTDATETIME = "ResourceLink.available.startDateTime";
    public static final String RESOURCELINK_AVAILABLE_ENDDATETIME = "ResourceLink.available.endDateTime";
    public static final String SUBMISSION = "submission";
    public static final String SUBMISSION_STARTDATETIME = "startDateTime";
    public static final String SUBMISSION_ENDDATETIME = "endDateTime";
    public static final String RESOURCELINK_SUBMISSION_STARTDATETIME = "ResourceLink.submission.startDateTime";
    public static final String RESOURCELINK_SUBMISSION_ENDDATETIME = "ResourceLink.submission.endDateTime";
    private String id_token = null;
    private JSONObject body = null;
    private JSONArray deep_links = null;
    private String returnedData = null;

    public DeepLinkResponse(String id_token) {
        this.id_token = id_token;
        this.body = LTI13JwtUtil.jsonJwtBody(id_token);
        if (this.body == null) {
            throw new RuntimeException("Could not extract body from id_token");
        }
        String message_type = (String)this.body.get((Object)"https://purl.imsglobal.org/spec/lti/claim/message_type");
        if (!"LtiDeepLinkingResponse".equals(message_type)) {
            throw new RuntimeException("Incorrect MESSAGE_TYPE");
        }
        String returnedData = (String)this.body.get((Object)DATA);
        if (returnedData == null || returnedData.length() < 1) {
            throw new RuntimeException("Missing data element from ContentItem return");
        }
        this.deep_links = BasicLTIUtil.getArray(this.body, DEEP_LINKS);
    }

    public static boolean isRequest(HttpServletRequest req) {
        String id_token = req.getParameter("id_token");
        return DeepLinkResponse.isRequest(id_token);
    }

    public static boolean isRequest(String id_token) {
        if (!LTI13JwtUtil.isRequest(id_token)) {
            return false;
        }
        JSONObject body = LTI13JwtUtil.jsonJwtBody(id_token);
        String message_type = (String)body.get((Object)"https://purl.imsglobal.org/spec/lti/claim/message_type");
        return "LtiDeepLinkingResponse".equals(message_type);
    }

    public boolean validate(Key publicKey) {
        Jws claims = Jwts.parser().setSigningKey(publicKey).parseClaimsJws(this.id_token);
        return claims != null;
    }

    public String toString() {
        return this.body.toString();
    }

    public JSONObject getContentItem() {
        return this.body;
    }

    public JSONArray getDeepLinks() {
        return this.deep_links;
    }

    public JSONObject getItemOfType(String itemType) {
        if (this.deep_links == null) {
            return null;
        }
        for (Object i : this.deep_links) {
            JSONObject item;
            String type;
            if (!(i instanceof JSONObject) || (type = BasicLTIUtil.getString(item = (JSONObject)i, TYPE)) == null || !type.equals(itemType)) continue;
            return item;
        }
        return null;
    }
}

