/*
 * Decompiled with CFR 0.152.
 */
package org.tsugi.lti13;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.jsonwebtoken.Jwts;
import java.net.http.HttpResponse;
import java.security.Key;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tsugi.http.HttpClientUtil;
import org.tsugi.jackson.JacksonUtil;
import org.tsugi.lti13.LTI13KeySetUtil;
import org.tsugi.oauth2.objects.AccessToken;
import org.tsugi.oauth2.objects.ClientAssertion;

public class LTI13AccessTokenUtil {
    private static final Logger log = LoggerFactory.getLogger(LTI13AccessTokenUtil.class);

    public static Map getClientAssertion(String[] scopes, KeyPair keyPair, String clientId, String deploymentId, String tokenAudience, StringBuffer dbs) {
        if (dbs != null) {
            dbs.append("getClientAssertion\n");
        }
        TreeMap<String, String> retval = new TreeMap<String, String>();
        retval.put("grant_type", "client_credentials");
        retval.put("client_assertion_type", "urn:ietf:params:oauth:client-assertion-type:jwt-bearer");
        if (scopes != null && scopes.length > 0) {
            retval.put("scope", String.join((CharSequence)" ", scopes));
            if (dbs != null) {
                dbs.append("scopes\n");
                dbs.append((String)retval.get("scope"));
                dbs.append("\n");
            }
        }
        ClientAssertion ca = new ClientAssertion();
        ca.issuer = clientId;
        ca.subject = clientId;
        ca.deployment_id = deploymentId;
        if (!StringUtils.isEmpty((CharSequence)tokenAudience)) {
            ca.audience = tokenAudience;
        }
        String cas = JacksonUtil.toString(ca);
        PrivateKey privateKey = keyPair.getPrivate();
        PublicKey publicKey = keyPair.getPublic();
        String kid = LTI13KeySetUtil.getPublicKID(publicKey);
        log.debug("getClientAssertion kid={} token={}", (Object)kid, (Object)cas);
        if (dbs != null && kid != null && cas != null) {
            dbs.append("kid=");
            dbs.append(kid);
            dbs.append("\n");
            dbs.append(StringUtils.truncate((String)cas, (int)1000));
            dbs.append("\n");
        }
        String jws = Jwts.builder().setHeaderParam("kid", (Object)kid).setPayload(cas).signWith((Key)privateKey).compact();
        retval.put("client_assertion", jws);
        return retval;
    }

    public static AccessToken getScoreToken(String url, KeyPair keyPair, String clientId, String deploymentId, String tokenAudience, StringBuffer dbs) {
        Map assertion = LTI13AccessTokenUtil.getScoreAssertion(keyPair, clientId, deploymentId, tokenAudience, dbs);
        return LTI13AccessTokenUtil.retrieveToken(url, assertion, dbs);
    }

    public static Map getScoreAssertion(KeyPair keyPair, String clientId, String deploymentId, String tokenAudience, StringBuffer dbs) {
        return LTI13AccessTokenUtil.getClientAssertion(new String[]{"https://purl.imsglobal.org/spec/lti-ags/scope/lineitem", "https://purl.imsglobal.org/spec/lti-ags/scope/score", "https://purl.imsglobal.org/spec/lti-ags/scope/result.readonly"}, keyPair, clientId, deploymentId, tokenAudience, dbs);
    }

    public static AccessToken getNRPSToken(String url, KeyPair keyPair, String clientId, String deploymentId, String tokenAudience, StringBuffer dbs) {
        Map assertion = LTI13AccessTokenUtil.getNRPSAssertion(keyPair, clientId, deploymentId, tokenAudience, dbs);
        return LTI13AccessTokenUtil.retrieveToken(url, assertion, dbs);
    }

    public static Map getNRPSAssertion(KeyPair keyPair, String clientId, String deploymentId, String tokenAudience, StringBuffer dbs) {
        return LTI13AccessTokenUtil.getClientAssertion(new String[]{"https://purl.imsglobal.org/spec/lti-nrps/scope/contextmembership.readonly"}, keyPair, clientId, deploymentId, tokenAudience, dbs);
    }

    public static AccessToken getLineItemsToken(String url, KeyPair keyPair, String clientId, String deploymentId, String tokenAudience, StringBuffer dbs) {
        Map assertion = LTI13AccessTokenUtil.getLineItemsAssertion(keyPair, clientId, deploymentId, tokenAudience, dbs);
        return LTI13AccessTokenUtil.retrieveToken(url, assertion, dbs);
    }

    public static Map getLineItemsAssertion(KeyPair keyPair, String clientId, String deploymentId, String tokenAudience, StringBuffer dbs) {
        return LTI13AccessTokenUtil.getClientAssertion(new String[]{"https://purl.imsglobal.org/spec/lti-ags/scope/lineitem"}, keyPair, clientId, deploymentId, tokenAudience, dbs);
    }

    protected static AccessToken retrieveToken(String url, Map assertion, StringBuffer dbs) {
        try {
            ObjectMapper mapper;
            AccessToken accessToken;
            HttpResponse<String> response;
            String responseStr;
            if (dbs != null) {
                dbs.append("retrieveToken\n");
                dbs.append(url);
                dbs.append(assertion.toString());
                dbs.append("\n");
            }
            if ((responseStr = (response = HttpClientUtil.sendPost(url, assertion, null, dbs)).body()) == null) {
                log.info("Empty / null response to POST url={} sent={}", new Object[]{url, assertion, responseStr});
                if (dbs != null) {
                    dbs.append("Empty / null response to POST\n");
                }
                return null;
            }
            if (dbs != null) {
                dbs.append("responseStr\n");
                dbs.append(responseStr);
                dbs.append("\n");
            }
            if ((accessToken = (AccessToken)(mapper = JacksonUtil.getLaxObjectMapper()).readValue(responseStr, AccessToken.class)) == null || StringUtils.isEmpty((CharSequence)accessToken.access_token)) {
                log.info("Failed to parse access token url={} sent={} received={}", new Object[]{url, assertion, responseStr});
                if (dbs != null) {
                    dbs.append("Could not parse access token\n");
                }
                return null;
            }
            if (dbs != null) {
                dbs.append("access_token\n");
                dbs.append(accessToken);
                dbs.append("\n");
            }
            return accessToken;
        }
        catch (Exception e) {
            log.error("Error retrieving token from {}", (Object)url, (Object)e);
            if (dbs != null) {
                dbs.append("Exception retrieving token ");
                dbs.append(e.getMessage());
                dbs.append("\n");
            }
            return null;
        }
    }
}

