/*
 * Decompiled with CFR 0.152.
 */
package org.tsugi.lti13;

import java.io.IOException;
import java.io.PrintWriter;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import java.util.Date;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.servlet.http.HttpServletResponse;
import org.json.simple.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tsugi.basiclti.BasicLTIUtil;
import org.tsugi.jackson.JacksonUtil;
import org.tsugi.lti13.objects.LTI11Transition;
import org.tsugi.lti13.objects.LaunchJWT;

public class LTI13Util {
    private static final Logger log = LoggerFactory.getLogger(LTI13Util.class);

    public static Map<String, String> generateKeys() throws NoSuchAlgorithmException {
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA");
        keyGen.initialize(2048);
        KeyPair kp = keyGen.genKeyPair();
        byte[] publicKey = kp.getPublic().getEncoded();
        byte[] privateKey = kp.getPrivate().getEncoded();
        String publicRSA = "-----BEGIN PUBLIC KEY-----\n" + LTI13Util.base64Encode(privateKey) + "\n-----END PUBLIC KEY-----\n";
        String privateRSA = "-----BEGIN PRIVATE KEY-----\n" + LTI13Util.base64Encode(privateKey) + "\n-----END PRIVATE KEY-----\n";
        TreeMap<String, String> returnMap = new TreeMap<String, String>();
        returnMap.put("platform_public", publicRSA);
        returnMap.put("platform_private", privateRSA);
        keyGen = KeyPairGenerator.getInstance("RSA");
        keyGen.initialize(2048);
        kp = keyGen.genKeyPair();
        publicKey = kp.getPublic().getEncoded();
        privateKey = kp.getPrivate().getEncoded();
        publicRSA = "-----BEGIN RSA PUBLIC KEY-----\n" + LTI13Util.base64Encode(privateKey) + "\n-----END RSA PUBLIC KEY-----\n";
        privateRSA = "-----BEGIN RSA PRIVATE KEY-----\n" + LTI13Util.base64Encode(privateKey) + "\n-----END RSA PRIVATE KEY-----\n";
        returnMap.put("tool_public", publicRSA);
        returnMap.put("tool_private", privateRSA);
        return returnMap;
    }

    public static String base64Encode(byte[] input) {
        Base64.Encoder encoder = Base64.getEncoder();
        String retval = encoder.encodeToString(input);
        return retval;
    }

    public static String stripPKCS8(String input) {
        if (input == null) {
            return input;
        }
        if (!input.startsWith("-----BEGIN")) {
            return input;
        }
        String[] lines = input.split("\n");
        Object retval = "";
        for (String line : lines) {
            if (line.startsWith("----")) continue;
            retval = (String)retval + line.trim();
        }
        return retval;
    }

    public static KeyPair generateKeyPair() {
        try {
            KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA");
            keyGen.initialize(2048);
            KeyPair kp = keyGen.genKeyPair();
            return kp;
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getKeyB64(Key key) {
        byte[] encodeArray = key.getEncoded();
        String publicRSA = LTI13Util.base64Encode(encodeArray);
        return publicRSA;
    }

    public static String getPublicB64(KeyPair kp) {
        return LTI13Util.getKeyB64(kp.getPublic());
    }

    public static String getPublicEncoded(KeyPair kp) {
        return LTI13Util.getPublicEncoded(kp.getPublic());
    }

    public static String getPublicEncoded(Key key) {
        return LTI13Util.getPublicEncoded(LTI13Util.getKeyB64(key));
    }

    public static String getPublicEncoded(String keyStr) {
        if (keyStr.startsWith("-----BEGIN ")) {
            return keyStr;
        }
        String publicRSA = "-----BEGIN PUBLIC KEY-----\n" + LTI13Util.breakKeyIntoLines(keyStr) + "\n-----END PUBLIC KEY-----\n";
        return publicRSA;
    }

    public static String getPrivateB64(KeyPair kp) {
        return LTI13Util.getKeyB64(kp.getPrivate());
    }

    public static String getPrivateB64(Key key) {
        byte[] encodeArray = key.getEncoded();
        String privateRSA = LTI13Util.base64Encode(encodeArray);
        return privateRSA;
    }

    public static String getPrivateEncoded(KeyPair kp) {
        return LTI13Util.getPrivateEncoded(kp.getPrivate());
    }

    public static String getPrivateEncoded(Key key) {
        return LTI13Util.getPrivateEncoded(LTI13Util.getPrivateB64(key));
    }

    public static String getPrivateEncoded(String keyStr) {
        if (keyStr.startsWith("-----BEGIN ")) {
            return keyStr;
        }
        String privateRSA = "-----BEGIN PRIVATE KEY-----\n" + LTI13Util.breakKeyIntoLines(keyStr) + "\n-----END PRIVATE KEY-----\n";
        return privateRSA;
    }

    public static String breakKeyIntoLines(String rawkey) {
        int len = 65;
        StringBuilder ret = new StringBuilder();
        String trimmed = rawkey.trim();
        for (int i = 0; i < trimmed.length(); i += len) {
            int end = i + len;
            if (ret.length() > 0) {
                ret.append("\n");
            }
            if (end > trimmed.length()) {
                end = trimmed.length();
            }
            ret.append(trimmed.substring(i, end));
        }
        return ret.toString();
    }

    public static Key string2PrivateKey(String keyString) {
        if (keyString == null) {
            return null;
        }
        try {
            KeyFactory kf = KeyFactory.getInstance("RSA");
            keyString = LTI13Util.stripPKCS8(keyString);
            PKCS8EncodedKeySpec keySpecPKCS8 = new PKCS8EncodedKeySpec(Base64.getDecoder().decode(keyString.getBytes()));
            return kf.generatePrivate(keySpecPKCS8);
        }
        catch (IllegalArgumentException | InvalidKeySpecException e) {
            return null;
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static Key string2PublicKey(String keyString) {
        if (keyString == null) {
            return null;
        }
        try {
            KeyFactory kf = KeyFactory.getInstance("RSA");
            keyString = LTI13Util.stripPKCS8(keyString);
            X509EncodedKeySpec keySpecX509 = new X509EncodedKeySpec(Base64.getDecoder().decode(keyString));
            return kf.generatePublic(keySpecX509);
        }
        catch (IllegalArgumentException | InvalidKeySpecException e) {
            return null;
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static KeyPair strings2KeyPair(String pubKeyStr, String privKeyStr) {
        if (pubKeyStr == null || privKeyStr == null) {
            return null;
        }
        String pubEncoded = LTI13Util.getPublicEncoded(pubKeyStr);
        String privEncoded = LTI13Util.getPrivateEncoded(privKeyStr);
        if (pubEncoded == null || privEncoded == null) {
            return null;
        }
        PublicKey pubKey = (PublicKey)LTI13Util.string2PublicKey(pubEncoded);
        PrivateKey privKey = (PrivateKey)LTI13Util.string2PrivateKey(privEncoded);
        if (pubKey == null || privKey == null) {
            return null;
        }
        KeyPair retval = new KeyPair(pubKey, privKey);
        return retval;
    }

    public static String serializeKeyPair(KeyPair kp) {
        String pub = LTI13Util.getPublicEncoded(kp);
        String priv = LTI13Util.getPrivateEncoded(kp);
        String concat = pub + "::" + priv;
        return concat;
    }

    public static KeyPair deSerializeKeyPair(String ser) {
        if (ser == null) {
            return null;
        }
        String[] pieces = ser.split("::");
        if (pieces.length != 2) {
            return null;
        }
        return LTI13Util.strings2KeyPair(pieces[0], pieces[1]);
    }

    public static String getLTI11TransitionBase(LaunchJWT lj) {
        String nonce = lj.nonce;
        Long expires = lj.expires;
        String issuer = lj.issuer;
        String client_id = lj.audience;
        String subject = lj.subject;
        String deployment_id = lj.deployment_id;
        if (nonce == null || issuer == null || expires == null || client_id == null || subject == null || deployment_id == null) {
            return null;
        }
        if (lj.lti11_transition == null) {
            return null;
        }
        LTI11Transition lti11_transition = lj.lti11_transition;
        String user_id = lti11_transition.user_id;
        String oauth_consumer_key = lti11_transition.oauth_consumer_key;
        if (user_id == null || oauth_consumer_key == null) {
            return null;
        }
        String base = oauth_consumer_key + "&" + deployment_id + "&" + issuer + "&" + client_id + "&" + expires + "&" + nonce;
        return base;
    }

    public static String signLTI11Transition(LaunchJWT lj, String secret) {
        if (secret == null) {
            return null;
        }
        String base = LTI13Util.getLTI11TransitionBase(lj);
        if (base == null) {
            return null;
        }
        String signature = LTI13Util.compute_HMAC_SHA256(base, secret);
        return signature;
    }

    public static boolean checkLTI11Transition(LaunchJWT lj, String key, String secret) {
        if (key == null) {
            return false;
        }
        if (secret == null) {
            return false;
        }
        LTI11Transition lti11_transition = lj.lti11_transition;
        if (lti11_transition == null) {
            return false;
        }
        String oauth_consumer_key_sign = lti11_transition.oauth_consumer_key_sign;
        if (oauth_consumer_key_sign == null) {
            return false;
        }
        String oauth_consumer_key = lti11_transition.oauth_consumer_key;
        if (oauth_consumer_key == null) {
            return false;
        }
        if (!oauth_consumer_key.equals(key)) {
            return false;
        }
        String base = LTI13Util.getLTI11TransitionBase(lj);
        if (base == null) {
            return false;
        }
        String signature = LTI13Util.compute_HMAC_SHA256(base, secret);
        return oauth_consumer_key_sign.equals(signature);
    }

    public static String sha256(String input) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            String hash = LTI13Util.base64Encode(md.digest(input.getBytes()));
            return hash;
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static String compute_HMAC_SHA256(String message, String secret) {
        try {
            Mac sha256_HMAC = Mac.getInstance("HmacSHA256");
            SecretKeySpec secret_key = new SecretKeySpec(secret.getBytes(), "HmacSHA256");
            sha256_HMAC.init(secret_key);
            String hash = LTI13Util.base64Encode(sha256_HMAC.doFinal(message.getBytes()));
            return hash;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getScoreUrlForLineItem(String lineItemUrl) {
        if (lineItemUrl == null) {
            return lineItemUrl;
        }
        int pos = lineItemUrl.indexOf("?");
        if (pos < 0) {
            return lineItemUrl + "/scores";
        }
        return lineItemUrl.substring(0, pos) + "/scores?" + lineItemUrl.substring(pos + 1);
    }

    public static void return400(HttpServletResponse response, String error) {
        LTI13Util.return4XX(response, error, null, 400);
    }

    public static void return400(HttpServletResponse response, String error, String detail) {
        LTI13Util.return4XX(response, error, detail, 400);
    }

    public static void return403(HttpServletResponse response, String error) {
        LTI13Util.return4XX(response, error, null, 403);
    }

    public static void return403(HttpServletResponse response, String error, String detail) {
        LTI13Util.return4XX(response, error, detail, 403);
    }

    public static void return404(HttpServletResponse response, String error) {
        LTI13Util.return4XX(response, error, null, 404);
    }

    public static void return404(HttpServletResponse response, String error, String detail) {
        LTI13Util.return4XX(response, error, detail, 404);
    }

    public static void return4XX(HttpServletResponse response, String error, String detail, int httpStatus) {
        response.setContentType("application/json;charset=UTF-8");
        response.setHeader("Cache-Control", "no-store");
        response.setStatus(httpStatus);
        if (detail != null) {
            response.setHeader("X-Tsugi-LTI13-Error-Detail", detail);
        }
        JSONObject job = new JSONObject();
        job.put((Object)"error", (Object)error);
        String retval = JacksonUtil.toString(job);
        try {
            PrintWriter out = response.getWriter();
            out.println(retval);
        }
        catch (IOException e) {
            response.setStatus(400);
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public static void substituteCustom(Properties custom, Properties lti2subst) {
        if (custom == null || lti2subst == null) {
            return;
        }
        Enumeration<?> e = custom.propertyNames();
        while (e.hasMoreElements()) {
            String newValue;
            String key = (String)e.nextElement();
            String value = custom.getProperty(key);
            if (value == null || value.length() < 1) continue;
            if (value.startsWith("$") && value.length() > 1) {
                value = value.substring(1);
            }
            if ((newValue = lti2subst.getProperty(value)) == null || newValue.length() < 1) continue;
            LTI13Util.setProperty(custom, key, newValue);
        }
    }

    public static void addCustomToLaunch(Properties ltiProps, Properties custom) {
        Enumeration<?> e = custom.propertyNames();
        while (e.hasMoreElements()) {
            String keyStr = (String)e.nextElement();
            String value = custom.getProperty(keyStr);
            LTI13Util.setProperty(ltiProps, "custom_" + keyStr, value);
            String mapKeyStr = BasicLTIUtil.mapKeyName(keyStr);
            if (mapKeyStr.equals(keyStr)) continue;
            LTI13Util.setProperty(ltiProps, "custom_" + mapKeyStr, value);
        }
    }

    public static void setProperty(Properties props, String key, String value) {
        BasicLTIUtil.setProperty(props, key, value);
    }

    public static String timeStamp(String token) {
        long now = new Date().getTime() / 1000L;
        String retval = now + ":" + token;
        return retval;
    }

    public static boolean timeStampCheck(String token, int seconds) {
        long token_now;
        String[] pieces = token.split(":");
        if (pieces.length < 2) {
            return false;
        }
        long now = new Date().getTime() / 1000L;
        long delta = now - (token_now = LTI13Util.getLong(pieces[0]).longValue());
        boolean retval = delta >= 0L && delta <= (long)seconds;
        return retval;
    }

    public static String timeStampSign(String token, String secret) {
        String timeStamped = LTI13Util.timeStamp(token);
        String base_string = timeStamped + ":" + secret;
        String signature = LTI13Util.sha256(base_string);
        String retval = timeStamped + ":" + signature;
        return retval;
    }

    public static boolean timeStampCheckSign(String token, String secret, int seconds) {
        if (!LTI13Util.timeStampCheck(token, seconds)) {
            return false;
        }
        String[] pieces = token.split(":");
        if (pieces.length != 3) {
            return false;
        }
        String token_signature = pieces[2];
        String base_string = pieces[0] + ":" + pieces[1] + ":" + secret;
        String signature = LTI13Util.sha256(base_string);
        return signature.equals(token_signature);
    }

    public static String toNull(String str) {
        return BasicLTIUtil.toNull(str);
    }

    public static int getInt(Object o) {
        if (o instanceof String) {
            try {
                return new Integer((String)o);
            }
            catch (NumberFormatException e) {
                return -1;
            }
        }
        if (o instanceof Number) {
            return ((Number)o).intValue();
        }
        return -1;
    }

    public static Long getLongKey(Object key) {
        return LTI13Util.getLong(key);
    }

    public static Long getLong(Object key) {
        Long retval = LTI13Util.getLongNull(key);
        if (retval != null) {
            return retval;
        }
        return new Long(-1L);
    }

    public static Long getLongNull(Object key) {
        if (key == null) {
            return null;
        }
        if (key instanceof Number) {
            return new Long(((Number)key).longValue());
        }
        if (key instanceof String) {
            if (((String)key).length() < 1) {
                return new Long(-1L);
            }
            try {
                return new Long((String)key);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }

    public static Double getDoubleNull(Object key) {
        if (key == null) {
            return null;
        }
        if (key instanceof Number) {
            return ((Number)key).doubleValue();
        }
        if (key instanceof String) {
            if (((String)key).length() < 1) {
                return null;
            }
            try {
                return new Double((String)key);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }

    public static String getStringNull(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        return null;
    }
}

