/*
 * Decompiled with CFR 0.152.
 */
package org.tsugi.lti13.objects;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.tsugi.lti13.LTI13ConstantsUtil;
import org.tsugi.lti13.objects.BaseJWT;
import org.tsugi.lti13.objects.BasicOutcome;
import org.tsugi.lti13.objects.Context;
import org.tsugi.lti13.objects.DeepLink;
import org.tsugi.lti13.objects.Endpoint;
import org.tsugi.lti13.objects.ForUser;
import org.tsugi.lti13.objects.LTI11Transition;
import org.tsugi.lti13.objects.LaunchLIS;
import org.tsugi.lti13.objects.LaunchPresentation;
import org.tsugi.lti13.objects.NamesAndRoles;
import org.tsugi.lti13.objects.ResourceLink;
import org.tsugi.lti13.objects.ToolPlatform;

@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
public class LaunchJWT
extends BaseJWT {
    public static String CLAIM_PREFIX = "https://purl.imsglobal.org/spec/lti/claim/";
    public static final String MESSAGE_TYPE_LAUNCH = "LtiResourceLinkRequest";
    public static final String MESSAGE_TYPE_DEEP_LINK = "LtiDeepLinkingRequest";
    public static final String ROLE_LEARNER = LTI13ConstantsUtil.ROLE_LEARNER;
    public static final String ROLE_INSTRUCTOR = LTI13ConstantsUtil.ROLE_INSTRUCTOR;
    public static final String MESSAGE_TYPE_LTI_SUBMISSION_REVIEW_REQUEST = "LtiSubmissionReviewRequest";
    public static final String MESSAGE_TYPE_LTI_DATA_PRIVACY_LAUNCH_REQUEST = "LtiDataPrivacyLaunchRequest";
    public static final String MESSAGE_TYPE_LTI_CONTEXT = "LtiContextLaunchRequest";
    @JsonProperty(value="https://purl.imsglobal.org/spec/lti/claim/deployment_id")
    public String deployment_id;
    @JsonProperty(value="https://purl.imsglobal.org/spec/lti/claim/target_link_uri")
    public String target_link_uri;
    @JsonProperty(value="https://purl.imsglobal.org/spec/lti/claim/message_type")
    public String message_type;
    @JsonProperty(value="https://purl.imsglobal.org/spec/lti/claim/version")
    public String version;
    @JsonProperty(value="given_name")
    public String given_name;
    @JsonProperty(value="family_name")
    public String family_name;
    @JsonProperty(value="middle_name")
    public String middle_name;
    @JsonProperty(value="picture")
    public String picture;
    @JsonProperty(value="email")
    public String email;
    @JsonProperty(value="name")
    public String name;
    @JsonProperty(value="locale")
    public String locale;
    @JsonProperty(value="https://purl.imsglobal.org/spec/lti/claim/custom")
    public Map<String, String> custom;
    @JsonProperty(value="https://purl.imsglobal.org/spec/lti/claim/roles")
    public List<String> roles = new ArrayList<String>();
    @JsonProperty(value="https://purl.imsglobal.org/spec/lti/claim/role_scope_mentor")
    public List<String> role_scope_mentor = new ArrayList<String>();
    @JsonProperty(value="https://purl.imsglobal.org/spec/lti/claim/launch_presentation")
    public LaunchPresentation launch_presentation;
    @JsonProperty(value="https://purl.imsglobal.org/spec/lti/claim/resource_link")
    public ResourceLink resource_link;
    @JsonProperty(value="https://purl.imsglobal.org/spec/lti/claim/context")
    public Context context;
    @JsonProperty(value="https://purl.imsglobal.org/spec/lti/claim/tool_platform")
    public ToolPlatform tool_platform;
    @JsonProperty(value="https://purl.imsglobal.org/spec/lti/claim/lis")
    public LaunchLIS lis;
    @JsonProperty(value="https://purl.imsglobal.org/spec/lti-ags/claim/endpoint")
    public Endpoint endpoint;
    @JsonProperty(value="https://purl.imsglobal.org/spec/lti-bo/claim/basicoutcome")
    public BasicOutcome basicoutcome;
    @JsonProperty(value="https://purl.imsglobal.org/spec/lti-nrps/claim/namesroleservice")
    public NamesAndRoles names_and_roles;
    @JsonProperty(value="https://purl.imsglobal.org/spec/lti-dl/claim/deep_linking_settings")
    public DeepLink deep_link;
    @JsonProperty(value="https://purl.imsglobal.org/spec/lti/claim/lti1p1")
    public LTI11Transition lti11_transition;
    @JsonProperty(value="https://purl.imsglobal.org/spec/lti/claim/for_user")
    public ForUser for_user;
    @JsonProperty(value="nonce")
    public String nonce;

    public LaunchJWT() {
        this(MESSAGE_TYPE_LAUNCH);
    }

    public LaunchJWT(String messageType) {
        this.message_type = messageType;
        this.version = "1.3.0";
        this.launch_presentation = new LaunchPresentation();
        this.nonce = this.jti;
    }

    @JsonIgnore
    public String getDisplayName() {
        if (this.name != null) {
            return this.name;
        }
        Object display_name = "";
        if (this.given_name != null) {
            display_name = this.given_name;
        }
        if (this.middle_name != null) {
            if (((String)display_name).length() > 0) {
                display_name = (String)display_name + " ";
            }
            display_name = (String)display_name + this.middle_name;
        }
        if (this.family_name != null) {
            if (((String)display_name).length() > 0) {
                display_name = (String)display_name + " ";
            }
            display_name = (String)display_name + this.family_name;
        }
        if (((String)(display_name = ((String)display_name).trim())).length() < 1) {
            display_name = null;
        }
        return display_name;
    }

    @JsonIgnore
    public boolean isInstructor() {
        if (this.roles == null) {
            return false;
        }
        return this.roles.contains(ROLE_INSTRUCTOR);
    }

    @JsonIgnore
    public String getLTI11Roles() {
        if (this.roles == null) {
            return null;
        }
        StringBuilder roleStr = new StringBuilder();
        for (String role : this.roles) {
            if (roleStr.length() > 0) {
                roleStr.append(',');
            }
            roleStr.append(role);
        }
        return roleStr.toString();
    }
}

