/*
 * Decompiled with CFR 0.152.
 */
package sangria.execution;

import java.io.Serializable;
import sangria.ast.AstNode;
import sangria.ast.Document;
import sangria.ast.Field;
import sangria.ast.OperationDefinition;
import sangria.ast.SelectionContainer;
import sangria.execution.CollectedField;
import sangria.execution.CollectedFields;
import sangria.execution.DeprecationTracker;
import sangria.execution.DeprecationTracker$;
import sangria.execution.ExceptionHandler;
import sangria.execution.ExceptionHandler$;
import sangria.execution.ExecutionPath;
import sangria.execution.ExecutionPath$;
import sangria.execution.Executor$;
import sangria.execution.FieldCollector;
import sangria.execution.Middleware;
import sangria.execution.Middleware$;
import sangria.execution.QueryReducer;
import sangria.execution.QueryReducingError;
import sangria.execution.StopWatch;
import sangria.execution.StopWatch$;
import sangria.execution.TimeMeasurement;
import sangria.execution.TimeMeasurement$;
import sangria.execution.ValidationError;
import sangria.execution.ValueCollector;
import sangria.execution.VariableValue;
import sangria.marshalling.InputUnmarshaller$;
import sangria.schema.AbstractType;
import sangria.schema.Argument;
import sangria.schema.EnumType;
import sangria.schema.FutureValue;
import sangria.schema.InputType;
import sangria.schema.ListType;
import sangria.schema.ObjectType;
import sangria.schema.OptionType;
import sangria.schema.OutputType;
import sangria.schema.ReduceAction;
import sangria.schema.ScalarAlias;
import sangria.schema.ScalarType;
import sangria.schema.Schema;
import sangria.schema.TryValue;
import sangria.schema.Value;
import sangria.validation.QueryValidator;
import sangria.validation.QueryValidator$;
import sangria.validation.Violation;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.java8.JFunction1;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.control.NonFatal$;

public final class QueryReducerExecutor$ {
    public static QueryReducerExecutor$ MODULE$;

    static {
        new QueryReducerExecutor$();
    }

    public <Ctx, Root> Future<Tuple2<Ctx, TimeMeasurement>> reduceQueryWithoutVariables(Schema<Ctx, Root> schema, Document queryAst2, Ctx userContext, List<QueryReducer<Ctx, ?>> queryReducers, Option<String> operationName, QueryValidator queryValidator, ExceptionHandler exceptionHandler, DeprecationTracker deprecationTracker, List<Middleware<Ctx>> middleware, ExecutionContext executionContext) {
        Future future;
        Vector<Violation> violations = queryValidator.validateQuery(schema, queryAst2);
        if (violations.nonEmpty()) {
            future = Future$.MODULE$.failed((Throwable)new ValidationError(violations, exceptionHandler));
        } else {
            Future future2;
            Option<Function2<Object, InputType<?>, Option<Either<Violation, Object>>>> scalarMiddleware = Middleware$.MODULE$.composeFromScalarMiddleware(middleware, userContext);
            ValueCollector valueCollector = new ValueCollector(schema, InputUnmarshaller$.MODULE$.emptyMapVars(), queryAst2.sourceMapper(), deprecationTracker, userContext, exceptionHandler, scalarMiddleware, true, InputUnmarshaller$.MODULE$.scalaInputUnmarshaller());
            Try executionResult = Executor$.MODULE$.getOperation(exceptionHandler, queryAst2, operationName).map((Function1 & Serializable & scala.Serializable)operation -> {
                FieldCollector fieldCollector = new FieldCollector(schema, queryAst2, (Map<String, VariableValue>)Predef$.MODULE$.Map().empty(), queryAst2.sourceMapper(), valueCollector, exceptionHandler);
                return new Tuple2(operation, fieldCollector);
            }).flatMap((Function1 & Serializable & scala.Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                OperationDefinition operation = (OperationDefinition)tuple2._1();
                FieldCollector fieldCollector = (FieldCollector)tuple2._2();
                Try try_ = Executor$.MODULE$.getOperationRootType(schema, exceptionHandler, operation, queryAst2.sourceMapper()).flatMap((Function1 & Serializable & scala.Serializable)tpe -> fieldCollector.collectFields(ExecutionPath$.MODULE$.empty(), tpe, (Vector<SelectionContainer>)((Vector)package$.MODULE$.Vector().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new OperationDefinition[]{operation})))).map((Function1 & Serializable & scala.Serializable)fields -> MODULE$.reduceQuery(schema, queryReducers, exceptionHandler, fieldCollector, valueCollector, (Map<String, VariableValue>)Predef$.MODULE$.Map().empty(), (ObjectType)tpe, (CollectedFields)fields, userContext, executionContext)));
                return try_;
            });
            Try try_ = executionResult;
            if (try_ instanceof Success) {
                Future future3;
                Success success = (Success)try_;
                future2 = future3 = (Future)success.value();
            } else if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable error = failure.exception();
                future2 = Future$.MODULE$.failed(error);
            } else {
                throw new MatchError((Object)try_);
            }
            future = future2;
        }
        return future;
    }

    public <Ctx, Root, Val> Future<Tuple2<Ctx, TimeMeasurement>> reduceQuery(Schema<Ctx, Root> schema, List<QueryReducer<Ctx, ?>> queryReducers, ExceptionHandler exceptionHandler, FieldCollector<Ctx, Root> fieldCollector, ValueCollector<Ctx, ?> valueCollector, Map<String, VariableValue> variables, ObjectType<Ctx, Root> rootTpe, CollectedFields fields, Ctx userContext, ExecutionContext executionContext) {
        Future future;
        if (queryReducers.nonEmpty()) {
            StopWatch sw = StopWatch$.MODULE$.start();
            future = this.reduceQueryUnsafe(schema, fieldCollector, valueCollector, variables, rootTpe, fields, queryReducers.toVector(), userContext, executionContext).map((Function1 & Serializable & scala.Serializable)x$2 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$2), (Object)sw.stop()), executionContext).recover((PartialFunction)new scala.Serializable(exceptionHandler){
                public static final long serialVersionUID = 0L;
                private final ExceptionHandler exceptionHandler$2;

                public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    if (A1 != null) {
                        A1 A12 = A1;
                        throw new QueryReducingError(A12, this.exceptionHandler$2);
                    }
                    Object object = function1.apply(x1);
                    return (B1)object;
                }

                public final boolean isDefinedAt(Throwable x1) {
                    Throwable throwable = x1;
                    boolean bl = throwable != null;
                    return bl;
                }
                {
                    this.exceptionHandler$2 = exceptionHandler$2;
                }
            }, executionContext);
        } else {
            future = Future$.MODULE$.successful((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(userContext), (Object)TimeMeasurement$.MODULE$.empty()));
        }
        return future;
    }

    public <Ctx, Root> Option<String> reduceQueryWithoutVariables$default$5() {
        return None$.MODULE$;
    }

    public <Ctx, Root> QueryValidator reduceQueryWithoutVariables$default$6() {
        return QueryValidator$.MODULE$.default();
    }

    public <Ctx, Root> ExceptionHandler reduceQueryWithoutVariables$default$7() {
        return ExceptionHandler$.MODULE$.empty();
    }

    public <Ctx, Root> DeprecationTracker reduceQueryWithoutVariables$default$8() {
        return DeprecationTracker$.MODULE$.empty();
    }

    public <Ctx, Root> Nil$ reduceQueryWithoutVariables$default$9() {
        return Nil$.MODULE$;
    }

    private <Ctx, Val> Future<Ctx> reduceQueryUnsafe(Schema<Ctx, ?> schema, FieldCollector<Ctx, Val> fieldCollector, ValueCollector<Ctx, ?> valueCollector, Map<String, VariableValue> variables, ObjectType<Ctx, ?> rootTpe, CollectedFields fields, Vector<QueryReducer<Ctx, ?>> reducers, Ctx userContext, ExecutionContext executionContext) {
        Future future;
        Object newContext;
        Object object;
        Function3 & Serializable & scala.Serializable argumentValuesFn = (Function3 & Serializable & scala.Serializable)(path, argumentDefs, argumentAsts) -> valueCollector.getFieldArgumentValues((ExecutionPath)path, (Option<AstNode>)None$.MODULE$, (List<Argument<?>>)argumentDefs, (Vector<sangria.ast.Argument>)argumentAsts, variables);
        Vector initialValues = (Vector)reducers.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.initial(), Vector$.MODULE$.canBuildFrom());
        Object[] reduced = (Object[])fields.fields().foldLeft(Array$.MODULE$.apply((Seq)initialValues, ClassTag$.MODULE$.Any()), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                Success success;
                Vector astFields;
                Try<Vector<Field>> try_;
                Object[] acc = (Object[])tuple2._1();
                CollectedField collectedField = (CollectedField)tuple2._2();
                if (collectedField != null && (try_ = collectedField.allFields()) instanceof Success && rootTpe.getField(schema, ((Field)(astFields = (Vector)(success = (Success)try_).value()).head()).name()).nonEmpty()) {
                    Field astField = (Field)astFields.head();
                    sangria.schema.Field field = (sangria.schema.Field)rootTpe.getField(schema, astField.name()).head();
                    ExecutionPath path = ExecutionPath$.MODULE$.empty().add(astField, rootTpe);
                    Seq childReduced = this.loop$1(path, field.fieldType(), astFields, fieldCollector, initialValues, schema, reducers, userContext, argumentValuesFn);
                    reducers.indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                        QueryReducer reducer = (QueryReducer)reducers.apply(i);
                        acc$2[i] = reducer.reduceField(acc[i], childReduced.apply(i), path, userContext, (Vector<Field>)astFields, rootTpe, field, argumentValuesFn);
                    });
                    return acc;
                }
            }
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            Object[] acc = (Object[])tuple2._1();
            return acc;
        });
        try {
            object = ((TraversableOnce)reducers.zipWithIndex(Vector$.MODULE$.canBuildFrom())).foldLeft(userContext, (Function2 & Serializable & scala.Serializable)(x0$2, x1$2) -> {
                Tuple2 tuple2 = new Tuple2(x0$2, x1$2);
                if (tuple2 != null) {
                    Object acc = tuple2._1();
                    Tuple2 tuple22 = (Tuple2)tuple2._2();
                    if (acc instanceof Future) {
                        Future future = (Future)acc;
                        if (tuple22 != null) {
                            QueryReducer reducer = (QueryReducer)tuple22._1();
                            int idx = tuple22._2$mcI$sp();
                            return future.flatMap((Function1 & Serializable & scala.Serializable)a -> {
                                Future future;
                                ReduceAction reduceAction = reducer.reduceCtx(reduced[idx], a);
                                if (reduceAction instanceof FutureValue) {
                                    Future future2;
                                    FutureValue futureValue = (FutureValue)reduceAction;
                                    future = future2 = futureValue.value();
                                } else if (reduceAction instanceof Value) {
                                    Value value = (Value)reduceAction;
                                    Object value2 = value.value();
                                    future = Future$.MODULE$.successful(value2);
                                } else if (reduceAction instanceof TryValue) {
                                    TryValue tryValue = (TryValue)reduceAction;
                                    Try value = tryValue.value();
                                    future = Future$.MODULE$.fromTry(value);
                                } else {
                                    throw new MatchError(reduceAction);
                                }
                                return future;
                            }, executionContext);
                        }
                    }
                }
                if (tuple2 != null) {
                    Object acc = tuple2._1();
                    Tuple2 tuple23 = (Tuple2)tuple2._2();
                    if (acc instanceof Object) {
                        Object object = acc;
                        if (tuple23 != null) {
                            void var5_22;
                            int idx;
                            QueryReducer reducer = (QueryReducer)tuple23._1();
                            ReduceAction reduceAction = reducer.reduceCtx(reduced[idx = tuple23._2$mcI$sp()], object);
                            if (reduceAction instanceof FutureValue) {
                                Future future;
                                FutureValue futureValue = (FutureValue)reduceAction;
                                Future future2 = future = futureValue.value();
                                return var5_22;
                            } else if (reduceAction instanceof Value) {
                                Object value;
                                Value value2 = (Value)reduceAction;
                                Object Val = value = value2.value();
                                return var5_22;
                            } else {
                                if (!(reduceAction instanceof TryValue)) throw new MatchError(reduceAction);
                                TryValue tryValue = (TryValue)reduceAction;
                                Try value = tryValue.value();
                                Object object2 = value.get();
                            }
                            return var5_22;
                        }
                    }
                }
                if (tuple2 == null) throw new MatchError((Object)tuple2);
                Object acc = tuple2._1();
                return Future$.MODULE$.failed((Throwable)new IllegalStateException(new StringBuilder(35).append("Invalid shape of the user context! ").append(acc).toString()));
            });
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable error = (Throwable)option.get();
            Future future2 = Future$.MODULE$.failed(error);
            object = future2;
        }
        Object object2 = newContext = object;
        Future future3 = object2 instanceof Future ? (future = (Future)object2) : Future$.MODULE$.successful(object2);
        return future3;
    }

    private final Seq loop$1(ExecutionPath path, OutputType tpe, Vector astFields, FieldCollector fieldCollector$2, Vector initialValues$1, Schema schema$2, Vector reducers$1, Object userContext$2, Function3 argumentValuesFn$1) {
        Vector vector;
        OutputType outputType;
        while (true) {
            if ((outputType = tpe) instanceof OptionType) {
                OutputType ofType;
                OptionType optionType = (OptionType)outputType;
                tpe = ofType = optionType.ofType();
                continue;
            }
            if (!(outputType instanceof ListType)) break;
            ListType listType = (ListType)outputType;
            OutputType ofType = listType.ofType();
            tpe = ofType;
        }
        if (outputType instanceof ObjectType) {
            Vector vector2;
            ObjectType objectType = (ObjectType)outputType;
            Try<CollectedFields> try_ = fieldCollector$2.collectFields(path, objectType, (Vector<SelectionContainer>)astFields);
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                CollectedFields ff = (CollectedFields)success.value();
                vector2 = Predef$.MODULE$.genericWrapArray(ff.fields().foldLeft(Array$.MODULE$.apply((Seq)initialValues$1, ClassTag$.MODULE$.Any()), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
                    Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
                    if (tuple2 != null) {
                        Success success;
                        Vector fields;
                        Try<Vector<Field>> try_;
                        Object[] acc = (Object[])tuple2._1();
                        CollectedField collectedField = (CollectedField)tuple2._2();
                        if (collectedField != null && (try_ = collectedField.allFields()) instanceof Success && objectType.getField(schema$2, ((Field)(fields = (Vector)(success = (Success)try_).value()).head()).name()).nonEmpty()) {
                            Field astField = (Field)fields.head();
                            sangria.schema.Field field = (sangria.schema.Field)objectType.getField(schema$2, astField.name()).head();
                            ExecutionPath newPath = path.add(astField, objectType);
                            Seq childReduced = this.loop$1(newPath, field.fieldType(), fields, fieldCollector$2, initialValues$1, schema$2, reducers$1, userContext$2, argumentValuesFn$1);
                            reducers$1.indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                                QueryReducer reducer = (QueryReducer)reducers$1.apply(i);
                                acc$1[i] = reducer.reduceField(acc[i], childReduced.apply(i), newPath, userContext$2, (Vector<Field>)fields, objectType, field, argumentValuesFn$1);
                            });
                            return acc;
                        }
                    }
                    if (tuple2 == null) throw new MatchError((Object)tuple2);
                    Object[] acc = (Object[])tuple2._1();
                    return acc;
                }));
            } else if (try_ instanceof Failure) {
                vector2 = initialValues$1;
            } else {
                throw new MatchError(try_);
            }
            vector = vector2;
        } else if (outputType instanceof AbstractType) {
            AbstractType abstractType = (AbstractType)((Object)outputType);
            vector = (Seq)schema$2.possibleTypes().get((Object)abstractType.name()).map((Function1 & Serializable & scala.Serializable)types -> (Vector)((TraversableLike)((IterableLike)((GenericTraversableTemplate)types.map((Function1 & Serializable & scala.Serializable)x$4 -> this.loop$1(path, (OutputType)x$4, astFields, fieldCollector$2, initialValues$1, schema$2, reducers$1, userContext$2, argumentValuesFn$1), Vector$.MODULE$.canBuildFrom())).transpose((Function1)Predef$.MODULE$.$conforms())).zipWithIndex(Vector$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Vector values = (Vector)tuple2._1();
                int idx = tuple2._2$mcI$sp();
                QueryReducer reducer = (QueryReducer)reducers$1.apply(idx);
                Object object = reducer.reduceAlternatives((Seq<Object>)values);
                return object;
            }, Vector$.MODULE$.canBuildFrom())).getOrElse((Function0 & Serializable & scala.Serializable)() -> initialValues$1);
        } else if (outputType instanceof ScalarType) {
            ScalarType scalarType = (ScalarType)outputType;
            vector = (Seq)reducers$1.map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.reduceScalar(path, userContext$2, scalarType), Vector$.MODULE$.canBuildFrom());
        } else if (outputType instanceof ScalarAlias) {
            ScalarAlias scalarAlias = (ScalarAlias)outputType;
            ScalarType aliasFor = scalarAlias.aliasFor();
            vector = (Seq)reducers$1.map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.reduceScalar(path, userContext$2, aliasFor), Vector$.MODULE$.canBuildFrom());
        } else if (outputType instanceof EnumType) {
            EnumType enumType = (EnumType)outputType;
            vector = (Seq)reducers$1.map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.reduceEnum(path, userContext$2, enumType), Vector$.MODULE$.canBuildFrom());
        } else {
            vector = initialValues$1;
        }
        return vector;
    }

    private QueryReducerExecutor$() {
        MODULE$ = this;
    }
}

