/*
 * Decompiled with CFR 0.152.
 */
package sangria.introspection;

import java.io.Serializable;
import sangria.introspection.IntrospectionDirective;
import sangria.introspection.IntrospectionEnumType;
import sangria.introspection.IntrospectionEnumValue;
import sangria.introspection.IntrospectionField;
import sangria.introspection.IntrospectionInputObjectType;
import sangria.introspection.IntrospectionInputValue;
import sangria.introspection.IntrospectionInterfaceType;
import sangria.introspection.IntrospectionListTypeRef;
import sangria.introspection.IntrospectionNamedTypeRef;
import sangria.introspection.IntrospectionNonNullTypeRef;
import sangria.introspection.IntrospectionObjectType;
import sangria.introspection.IntrospectionScalarType;
import sangria.introspection.IntrospectionSchema;
import sangria.introspection.IntrospectionType;
import sangria.introspection.IntrospectionTypeRef;
import sangria.introspection.IntrospectionUnionType;
import sangria.introspection.package$TypeKind$;
import sangria.marshalling.InputUnmarshaller;
import sangria.parser.DeliveryScheme;
import sangria.schema.DirectiveLocation$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

public final class IntrospectionParser$ {
    public static IntrospectionParser$ MODULE$;

    static {
        new IntrospectionParser$();
    }

    public <In> Object parse(In introspectionResult, InputUnmarshaller<In> iu, DeliveryScheme<IntrospectionSchema> scheme) {
        Object object;
        try {
            this.checkErrors(introspectionResult, iu);
            object = scheme.success(this.parseSchema(this.mapField(this.mapField(introspectionResult, "data", this.mapField$default$3(), iu), "__schema", (Vector<String>)((Vector)package$.MODULE$.Vector().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"data"}))), iu), (Vector<String>)((Vector)package$.MODULE$.Vector().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"data", "__schema"}))), iu));
        }
        catch (IllegalAccessException e) {
            object = scheme.failure(e);
        }
        return object;
    }

    private <In> IntrospectionInputValue parseInputValue(In value, Vector<String> path, InputUnmarshaller<In> evidence$1) {
        return new IntrospectionInputValue(this.mapStringField(value, "name", path, evidence$1), this.mapStringFieldOpt(value, "description", this.mapStringFieldOpt$default$3(), evidence$1), this.parseTypeRef(this.mapField(value, "type", path, evidence$1), (Vector<String>)((Vector)path.$colon$plus((Object)"type", Vector$.MODULE$.canBuildFrom())), evidence$1), this.mapStringFieldOpt(value, "defaultValue", this.mapStringFieldOpt$default$3(), evidence$1));
    }

    private <In> IntrospectionField parseField(In field, Vector<String> path, InputUnmarshaller<In> evidence$2) {
        InputUnmarshaller inputUnmarshaller = this.um(evidence$2);
        return new IntrospectionField(this.mapStringField(field, "name", path, evidence$2), this.mapStringFieldOpt(field, "description", this.mapStringFieldOpt$default$3(), evidence$2), (Seq<IntrospectionInputValue>)((Seq)((TraversableLike)this.mapFieldOpt(field, "args", evidence$2).map((Function1 & Serializable & scala.Serializable)node -> inputUnmarshaller.getListValue(node)).getOrElse((Function0 & Serializable & scala.Serializable)() -> package$.MODULE$.Vector().empty())).map((Function1 & Serializable & scala.Serializable)arg -> MODULE$.parseInputValue(arg, (Vector<String>)((Vector)path.$colon$plus((Object)"args", Vector$.MODULE$.canBuildFrom())), evidence$2), Seq$.MODULE$.canBuildFrom())), this.parseTypeRef(this.mapField(field, "type", path, evidence$2), (Vector<String>)((Vector)path.$colon$plus((Object)"type", Vector$.MODULE$.canBuildFrom())), evidence$2), this.mapBooleanField(field, "isDeprecated", path, evidence$2), this.mapStringFieldOpt(field, "deprecationReason", this.mapStringFieldOpt$default$3(), evidence$2));
    }

    private <In> IntrospectionObjectType parseObject(In tpe, Vector<String> path, InputUnmarshaller<In> evidence$3) {
        InputUnmarshaller inputUnmarshaller = this.um(evidence$3);
        InputUnmarshaller inputUnmarshaller2 = this.um(evidence$3);
        return new IntrospectionObjectType(this.mapStringField(tpe, "name", path, evidence$3), this.mapStringFieldOpt(tpe, "description", path, evidence$3), (Seq<IntrospectionField>)((Seq)((TraversableLike)this.mapFieldOpt(tpe, "fields", evidence$3).map((Function1 & Serializable & scala.Serializable)node -> inputUnmarshaller.getListValue(node)).getOrElse((Function0 & Serializable & scala.Serializable)() -> package$.MODULE$.Vector().empty())).map((Function1 & Serializable & scala.Serializable)field -> MODULE$.parseField(field, (Vector<String>)((Vector)path.$colon$plus((Object)"fields", Vector$.MODULE$.canBuildFrom())), evidence$3), Seq$.MODULE$.canBuildFrom())), (Seq<IntrospectionNamedTypeRef>)((Seq)((TraversableLike)this.mapFieldOpt(tpe, "interfaces", evidence$3).map((Function1 & Serializable & scala.Serializable)node -> inputUnmarshaller2.getListValue(node)).getOrElse((Function0 & Serializable & scala.Serializable)() -> package$.MODULE$.Vector().empty())).map((Function1 & Serializable & scala.Serializable)i -> MODULE$.parseNamedTypeRef(i, (Vector<String>)((Vector)path.$colon$plus((Object)"interfaces", Vector$.MODULE$.canBuildFrom())), evidence$3), Seq$.MODULE$.canBuildFrom())));
    }

    private <In> IntrospectionInterfaceType parseInterface(In tpe, Vector<String> path, InputUnmarshaller<In> evidence$4) {
        InputUnmarshaller inputUnmarshaller = this.um(evidence$4);
        InputUnmarshaller inputUnmarshaller2 = this.um(evidence$4);
        return new IntrospectionInterfaceType(this.mapStringField(tpe, "name", path, evidence$4), this.mapStringFieldOpt(tpe, "description", path, evidence$4), (Seq<IntrospectionField>)((Seq)((TraversableLike)this.mapFieldOpt(tpe, "fields", evidence$4).map((Function1 & Serializable & scala.Serializable)node -> inputUnmarshaller.getListValue(node)).getOrElse((Function0 & Serializable & scala.Serializable)() -> package$.MODULE$.Vector().empty())).map((Function1 & Serializable & scala.Serializable)field -> MODULE$.parseField(field, (Vector<String>)((Vector)path.$colon$plus((Object)"fields", Vector$.MODULE$.canBuildFrom())), evidence$4), Seq$.MODULE$.canBuildFrom())), (Seq<IntrospectionNamedTypeRef>)((Seq)((TraversableLike)this.mapFieldOpt(tpe, "possibleTypes", evidence$4).map((Function1 & Serializable & scala.Serializable)node -> inputUnmarshaller2.getListValue(node)).getOrElse((Function0 & Serializable & scala.Serializable)() -> package$.MODULE$.Vector().empty())).map((Function1 & Serializable & scala.Serializable)i -> MODULE$.parseNamedTypeRef(i, (Vector<String>)((Vector)path.$colon$plus((Object)"possibleTypes", Vector$.MODULE$.canBuildFrom())), evidence$4), Seq$.MODULE$.canBuildFrom())));
    }

    private <In> IntrospectionUnionType parseUnion(In tpe, Vector<String> path, InputUnmarshaller<In> evidence$5) {
        InputUnmarshaller inputUnmarshaller = this.um(evidence$5);
        return new IntrospectionUnionType(this.mapStringField(tpe, "name", path, evidence$5), this.mapStringFieldOpt(tpe, "description", path, evidence$5), (Seq<IntrospectionNamedTypeRef>)((Seq)((TraversableLike)this.mapFieldOpt(tpe, "possibleTypes", evidence$5).map((Function1 & Serializable & scala.Serializable)node -> inputUnmarshaller.getListValue(node)).getOrElse((Function0 & Serializable & scala.Serializable)() -> package$.MODULE$.Vector().empty())).map((Function1 & Serializable & scala.Serializable)i -> MODULE$.parseNamedTypeRef(i, (Vector<String>)((Vector)path.$colon$plus((Object)"possibleTypes", Vector$.MODULE$.canBuildFrom())), evidence$5), Seq$.MODULE$.canBuildFrom())));
    }

    private <In> IntrospectionInputObjectType parseInputObject(In tpe, Vector<String> path, InputUnmarshaller<In> evidence$6) {
        InputUnmarshaller inputUnmarshaller = this.um(evidence$6);
        return new IntrospectionInputObjectType(this.mapStringField(tpe, "name", path, evidence$6), this.mapStringFieldOpt(tpe, "description", path, evidence$6), (Seq<IntrospectionInputValue>)((Seq)((TraversableLike)this.mapFieldOpt(tpe, "inputFields", evidence$6).map((Function1 & Serializable & scala.Serializable)node -> inputUnmarshaller.getListValue(node)).getOrElse((Function0 & Serializable & scala.Serializable)() -> package$.MODULE$.Vector().empty())).map((Function1 & Serializable & scala.Serializable)arg -> MODULE$.parseInputValue(arg, (Vector<String>)((Vector)path.$colon$plus((Object)"inputFields", Vector$.MODULE$.canBuildFrom())), evidence$6), Seq$.MODULE$.canBuildFrom())));
    }

    private <In> IntrospectionScalarType parseScalar(In tpe, Vector<String> path, InputUnmarshaller<In> evidence$7) {
        return new IntrospectionScalarType(this.mapStringField(tpe, "name", path, evidence$7), this.mapStringFieldOpt(tpe, "description", path, evidence$7));
    }

    private <In> IntrospectionEnumValue parseEnumValue(In value, Vector<String> path, InputUnmarshaller<In> evidence$8) {
        return new IntrospectionEnumValue(this.mapStringField(value, "name", path, evidence$8), this.mapStringFieldOpt(value, "description", path, evidence$8), this.mapBooleanField(value, "isDeprecated", path, evidence$8), this.mapStringFieldOpt(value, "deprecationReason", this.mapStringFieldOpt$default$3(), evidence$8));
    }

    private <In> IntrospectionEnumType parseEnum(In tpe, Vector<String> path, InputUnmarshaller<In> evidence$9) {
        return new IntrospectionEnumType(this.mapStringField(tpe, "name", path, evidence$9), this.mapStringFieldOpt(tpe, "description", path, evidence$9), (Seq<IntrospectionEnumValue>)((Seq)this.um(evidence$9).getListValue(this.mapField(tpe, "enumValues", path, evidence$9)).map((Function1 & Serializable & scala.Serializable)x$1 -> MODULE$.parseEnumValue(x$1, (Vector<String>)((Vector)path.$colon$plus((Object)"enumValues", Vector$.MODULE$.canBuildFrom())), evidence$9), Seq$.MODULE$.canBuildFrom())));
    }

    private <In> IntrospectionDirective parseDirective(In directive, Vector<String> path, InputUnmarshaller<In> evidence$10) {
        InputUnmarshaller inputUnmarshaller = this.um(evidence$10);
        return new IntrospectionDirective(this.mapStringField(directive, "name", path, evidence$10), this.mapStringFieldOpt(directive, "description", this.mapStringFieldOpt$default$3(), evidence$10), (Set<Enumeration.Value>)((TraversableOnce)this.um(evidence$10).getListValue(this.mapField(directive, "locations", this.mapField$default$3(), evidence$10)).map((Function1 & Serializable & scala.Serializable)v -> DirectiveLocation$.MODULE$.fromString(MODULE$.stringValue(v, (Vector<String>)((Vector)path.$colon$plus((Object)"locations", Vector$.MODULE$.canBuildFrom())), evidence$10)), Seq$.MODULE$.canBuildFrom())).toSet(), (Seq<IntrospectionInputValue>)((Seq)((TraversableLike)this.mapFieldOpt(directive, "args", evidence$10).map((Function1 & Serializable & scala.Serializable)node -> inputUnmarshaller.getListValue(node)).getOrElse((Function0 & Serializable & scala.Serializable)() -> package$.MODULE$.Vector().empty())).map((Function1 & Serializable & scala.Serializable)arg -> MODULE$.parseInputValue(arg, (Vector<String>)((Vector)path.$colon$plus((Object)"args", Vector$.MODULE$.canBuildFrom())), evidence$10), Seq$.MODULE$.canBuildFrom())));
    }

    private <In> Product parseType(In tpe, Vector<String> path, InputUnmarshaller<In> evidence$11) {
        IntrospectionType introspectionType;
        String string = this.mapStringField(tpe, "kind", path, evidence$11);
        if ("OBJECT".equals(string)) {
            introspectionType = this.parseObject(tpe, path, evidence$11);
        } else if ("UNION".equals(string)) {
            introspectionType = this.parseUnion(tpe, path, evidence$11);
        } else if ("INTERFACE".equals(string)) {
            introspectionType = this.parseInterface(tpe, path, evidence$11);
        } else if ("INPUT_OBJECT".equals(string)) {
            introspectionType = this.parseInputObject(tpe, path, evidence$11);
        } else if ("SCALAR".equals(string)) {
            introspectionType = this.parseScalar(tpe, path, evidence$11);
        } else if ("ENUM".equals(string)) {
            introspectionType = this.parseEnum(tpe, path, evidence$11);
        } else {
            throw this.error(new StringBuilder(18).append("Unsupported kind: ").append(string).toString());
        }
        return introspectionType;
    }

    private <In> IntrospectionSchema parseSchema(In schema, Vector<String> path, InputUnmarshaller<In> evidence$12) {
        InputUnmarshaller inputUnmarshaller = this.um(evidence$12);
        return new IntrospectionSchema(this.parseNamedTypeRef(this.mapField(schema, "queryType", path, evidence$12), (Vector<String>)((Vector)path.$colon$plus((Object)"queryType", Vector$.MODULE$.canBuildFrom())), evidence$12), (Option<IntrospectionNamedTypeRef>)this.mapFieldOpt(schema, "mutationType", evidence$12).map((Function1 & Serializable & scala.Serializable)x$2 -> MODULE$.parseNamedTypeRef(x$2, (Vector<String>)((Vector)path.$colon$plus((Object)"mutationType", Vector$.MODULE$.canBuildFrom())), evidence$12)), (Option<IntrospectionNamedTypeRef>)this.mapFieldOpt(schema, "subscriptionType", evidence$12).map((Function1 & Serializable & scala.Serializable)x$3 -> MODULE$.parseNamedTypeRef(x$3, (Vector<String>)((Vector)path.$colon$plus((Object)"subscriptionType", Vector$.MODULE$.canBuildFrom())), evidence$12)), (Seq<IntrospectionType>)((Seq)this.um(evidence$12).getListValue(this.mapField(schema, "types", path, evidence$12)).map((Function1 & Serializable & scala.Serializable)x$4 -> MODULE$.parseType(x$4, (Vector<String>)((Vector)path.$colon$plus((Object)"types", Vector$.MODULE$.canBuildFrom())), evidence$12), Seq$.MODULE$.canBuildFrom())), (Seq<IntrospectionDirective>)((Seq)((TraversableLike)this.mapFieldOpt(schema, "directives", evidence$12).map((Function1 & Serializable & scala.Serializable)node -> inputUnmarshaller.getListValue(node)).getOrElse((Function0 & Serializable & scala.Serializable)() -> package$.MODULE$.Vector().empty())).map((Function1 & Serializable & scala.Serializable)i -> MODULE$.parseDirective(i, (Vector<String>)((Vector)path.$colon$plus((Object)"directives", Vector$.MODULE$.canBuildFrom())), evidence$12), Seq$.MODULE$.canBuildFrom())), this.mapStringFieldOpt(schema, "description", path, evidence$12));
    }

    private <In> IntrospectionNamedTypeRef parseNamedTypeRef(In in, Vector<String> path, InputUnmarshaller<In> evidence$13) {
        return new IntrospectionNamedTypeRef((Enumeration.Value)this.mapStringFieldOpt(in, "kind", path, evidence$13).map((Function1 & Serializable & scala.Serializable)kind -> package$TypeKind$.MODULE$.fromString((String)kind)).getOrElse((Function0 & Serializable & scala.Serializable)() -> package$TypeKind$.MODULE$.Object()), this.mapStringField(in, "name", path, evidence$13));
    }

    private <In> IntrospectionTypeRef parseTypeRef(In in, Vector<String> path, InputUnmarshaller<In> evidence$14) {
        String string = this.mapStringField(in, "kind", path, evidence$14);
        IntrospectionTypeRef introspectionTypeRef = "LIST".equals(string) ? new IntrospectionListTypeRef(this.parseTypeRef(this.mapField(in, "ofType", path, evidence$14), (Vector<String>)((Vector)path.$colon$plus((Object)"ofType", Vector$.MODULE$.canBuildFrom())), evidence$14)) : ("NON_NULL".equals(string) ? new IntrospectionNonNullTypeRef(this.parseTypeRef(this.mapField(in, "ofType", path, evidence$14), (Vector<String>)((Vector)path.$colon$plus((Object)"ofType", Vector$.MODULE$.canBuildFrom())), evidence$14)) : this.parseNamedTypeRef(in, path, evidence$14));
        return introspectionTypeRef;
    }

    private <T> T required(Option<T> obj, Vector<String> path) {
        Object o;
        Option<T> option = obj;
        if (!(option instanceof Some)) {
            if (None$.MODULE$.equals(option)) {
                throw this.error(new StringBuilder(38).append("Required property is missing at path: ").append(path.mkString(".")).toString());
            }
            throw new MatchError(option);
        }
        Some some = (Some)option;
        Object object = o = some.value();
        return (T)object;
    }

    private <In> void checkErrors(In introspectionResult, InputUnmarshaller<In> evidence$15) {
        Option option = this.um(evidence$15).getRootMapValue(introspectionResult, "errors");
        if (option instanceof Some) {
            Some some = (Some)option;
            Object errors = some.value();
            throw new IllegalArgumentException(new StringBuilder(62).append("Can't parse introspection results because it contains errors: ").append(this.um(evidence$15).render(errors)).toString());
        }
        if (!None$.MODULE$.equals(option)) {
            throw new MatchError((Object)option);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private <In> String stringValue(In value, Vector<String> path, InputUnmarshaller<In> evidence$16) {
        String string;
        Object object = this.um(evidence$16).getScalaScalarValue(value);
        if (!(object instanceof String)) {
            throw this.error(new StringBuilder(35).append("Expected String but got '").append(this.um(evidence$16).render(value)).append("' at path ").append(path.mkString(".")).toString());
        }
        String string2 = string = (String)object;
        return string2;
    }

    private <In> boolean booleanValue(In value, Vector<String> path, InputUnmarshaller<In> evidence$17) {
        boolean bl;
        Object object = this.um(evidence$17).getScalaScalarValue(value);
        if (!(object instanceof Boolean)) {
            throw this.error(new StringBuilder(36).append("Expected Boolean but got '").append(this.um(evidence$17).render(value)).append("' at path ").append(path.mkString(".")).toString());
        }
        boolean bl2 = bl = BoxesRunTime.unboxToBoolean((Object)object);
        return bl2;
    }

    private <In> In mapField(In map2, String name, Vector<String> path, InputUnmarshaller<In> evidence$18) {
        return (In)this.required(this.um(evidence$18).getMapValue(map2, name), (Vector<String>)((Vector)path.$colon$plus((Object)name, Vector$.MODULE$.canBuildFrom())));
    }

    private <In> Vector<String> mapField$default$3() {
        return package$.MODULE$.Vector().empty();
    }

    private <In> String mapStringField(In map2, String name, Vector<String> path, InputUnmarshaller<In> evidence$19) {
        return this.stringValue(this.mapField(map2, name, path, evidence$19), (Vector<String>)((Vector)path.$colon$plus((Object)name, Vector$.MODULE$.canBuildFrom())), evidence$19);
    }

    private <In> boolean mapBooleanField(In map2, String name, Vector<String> path, InputUnmarshaller<In> evidence$20) {
        return this.booleanValue(this.mapField(map2, name, path, evidence$20), (Vector<String>)((Vector)path.$colon$plus((Object)name, Vector$.MODULE$.canBuildFrom())), evidence$20);
    }

    private <In> Option<In> mapFieldOpt(In map2, String name, InputUnmarshaller<In> evidence$21) {
        InputUnmarshaller inputUnmarshaller = this.um(evidence$21);
        return this.um(evidence$21).getMapValue(map2, name).filter((Function1 & Serializable & scala.Serializable)node -> BoxesRunTime.boxToBoolean((boolean)inputUnmarshaller.isDefined(node)));
    }

    private <In> Option<String> mapStringFieldOpt(In map2, String name, Vector<String> path, InputUnmarshaller<In> evidence$22) {
        InputUnmarshaller inputUnmarshaller = this.um(evidence$22);
        return this.mapFieldOpt(map2, name, evidence$22).filter((Function1 & Serializable & scala.Serializable)node -> BoxesRunTime.boxToBoolean((boolean)inputUnmarshaller.isDefined(node))).map((Function1 & Serializable & scala.Serializable)s -> MODULE$.stringValue(s, (Vector<String>)((Vector)path.$colon$plus((Object)name, Vector$.MODULE$.canBuildFrom())), evidence$22));
    }

    private <In> Vector<String> mapStringFieldOpt$default$3() {
        return package$.MODULE$.Vector().empty();
    }

    private <T> InputUnmarshaller<T> um(InputUnmarshaller<T> evidence$23) {
        return (InputUnmarshaller)Predef$.MODULE$.implicitly(evidence$23);
    }

    private Nothing$ error(String message) {
        throw new IllegalArgumentException(message);
    }

    private IntrospectionParser$() {
        MODULE$ = this;
    }
}

