/*
 * Decompiled with CFR 0.152.
 */
package sangria.renderer;

import java.io.Serializable;
import sangria.ast.Argument;
import sangria.ast.AstLocation;
import sangria.ast.AstNode;
import sangria.ast.BigDecimalValue;
import sangria.ast.BigIntValue;
import sangria.ast.BooleanValue;
import sangria.ast.Comment;
import sangria.ast.Definition;
import sangria.ast.Directive;
import sangria.ast.DirectiveDefinition;
import sangria.ast.DirectiveLocation;
import sangria.ast.Document;
import sangria.ast.EnumTypeDefinition;
import sangria.ast.EnumTypeExtensionDefinition;
import sangria.ast.EnumValue;
import sangria.ast.EnumValueDefinition;
import sangria.ast.Field;
import sangria.ast.FieldDefinition;
import sangria.ast.FloatValue;
import sangria.ast.FragmentDefinition;
import sangria.ast.FragmentSpread;
import sangria.ast.InlineFragment;
import sangria.ast.InputDocument;
import sangria.ast.InputObjectTypeDefinition;
import sangria.ast.InputObjectTypeExtensionDefinition;
import sangria.ast.InputValueDefinition;
import sangria.ast.IntValue;
import sangria.ast.InterfaceTypeDefinition;
import sangria.ast.InterfaceTypeExtensionDefinition;
import sangria.ast.ListType;
import sangria.ast.ListValue;
import sangria.ast.NamedType;
import sangria.ast.NotNullType;
import sangria.ast.NullValue;
import sangria.ast.ObjectField;
import sangria.ast.ObjectTypeDefinition;
import sangria.ast.ObjectTypeExtensionDefinition;
import sangria.ast.ObjectValue;
import sangria.ast.OperationDefinition;
import sangria.ast.OperationType;
import sangria.ast.OperationType$Mutation$;
import sangria.ast.OperationType$Query$;
import sangria.ast.OperationType$Subscription$;
import sangria.ast.OperationTypeDefinition;
import sangria.ast.ScalarTypeDefinition;
import sangria.ast.ScalarTypeExtensionDefinition;
import sangria.ast.SchemaDefinition;
import sangria.ast.SchemaExtensionDefinition;
import sangria.ast.Selection;
import sangria.ast.StringValue;
import sangria.ast.Type;
import sangria.ast.UnionTypeDefinition;
import sangria.ast.UnionTypeExtensionDefinition;
import sangria.ast.Value;
import sangria.ast.VariableDefinition;
import sangria.ast.VariableValue;
import sangria.ast.WithComments;
import sangria.ast.WithDescription;
import sangria.ast.WithTrailingComments;
import sangria.renderer.Indent;
import sangria.renderer.QueryRendererConfig;
import sangria.util.StringUtil$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.collection.mutable.ArrayOps;
import scala.math.BigDecimal;
import scala.math.BigInt;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichChar$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class QueryRenderer$ {
    public static QueryRenderer$ MODULE$;
    private final QueryRendererConfig Pretty;
    private final QueryRendererConfig PrettyInput;
    private final QueryRendererConfig Compact;

    static {
        new QueryRenderer$();
    }

    public QueryRendererConfig Pretty() {
        return this.Pretty;
    }

    public QueryRendererConfig PrettyInput() {
        return this.PrettyInput;
    }

    public QueryRendererConfig Compact() {
        return this.Compact;
    }

    public String renderSelections(Vector<Selection> sels, WithTrailingComments tc, Indent indent, QueryRendererConfig config) {
        String string;
        if (sels.nonEmpty()) {
            String rendered = ((TraversableOnce)((TraversableLike)sels.zipWithIndex(Vector$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Selection sel = (Selection)tuple2._1();
                int idx = tuple2._2$mcI$sp();
                None$ prev = idx == 0 ? None$.MODULE$ : new Some(sels.apply(idx - 1));
                None$ next = idx == sels.size() - 1 ? None$.MODULE$ : new Some(sels.apply(idx + 1));
                Option trailingNext = next.flatMap((Function1 & Serializable & scala.Serializable)n -> n.comments().headOption().flatMap((Function1 & Serializable & scala.Serializable)c -> c.location().flatMap((Function1 & Serializable & scala.Serializable)cp -> sel.location().withFilter((Function1 & Serializable & scala.Serializable)sp -> BoxesRunTime.boxToBoolean((boolean)QueryRenderer$.$anonfun$renderSelections$5(cp, sp))).map((Function1 & Serializable & scala.Serializable)sp -> c))));
                Option trailing = trailingNext.orElse((Function0 & Serializable & scala.Serializable)() -> tc.trailingComments().headOption().flatMap((Function1 & Serializable & scala.Serializable)c -> c.location().flatMap((Function1 & Serializable & scala.Serializable)cp -> sel.location().withFilter((Function1 & Serializable & scala.Serializable)sp -> BoxesRunTime.boxToBoolean((boolean)QueryRenderer$.$anonfun$renderSelections$10(cp, sp))).map((Function1 & Serializable & scala.Serializable)sp -> c))));
                Selection x$1 = sel;
                QueryRendererConfig x$2 = config;
                Indent x$3 = indent.inc();
                None$ x$4 = prev;
                Option<String> x$5 = MODULE$.renderNode$default$4();
                String string = new StringBuilder(0).append(idx != 0 && MODULE$.shouldRenderComment(sel, (Option<AstNode>)prev, config) ? config.lineBreak() : "").append(MODULE$.renderNode(x$1, x$2, x$3, x$5, (Option<AstNode>)x$4)).append(trailing.fold((Function0 & Serializable & scala.Serializable)() -> "", (Function1 & Serializable & scala.Serializable)c -> MODULE$.renderIndividualComment((Comment)c, " ", config))).toString();
                return string;
            }, Vector$.MODULE$.canBuildFrom())).mkString(config.mandatoryLineBreak());
            string = new StringBuilder(2).append("{").append(config.lineBreak()).append(rendered).append(this.renderTrailingComment(tc, (Option<AstNode>)sels.lastOption(), indent.inc(), config)).append(this.trailingLineBreak(tc, config)).append(indent.str()).append("}").toString();
        } else {
            string = "";
        }
        return string;
    }

    public String renderFieldDefinitions(Vector<FieldDefinition> fields, WithTrailingComments tc, Indent indent, QueryRendererConfig config, boolean frontSep) {
        String string;
        if (fields.nonEmpty()) {
            String rendered = ((TraversableOnce)((TraversableLike)fields.zipWithIndex(Vector$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                FieldDefinition field = (FieldDefinition)tuple2._1();
                int idx = tuple2._2$mcI$sp();
                None$ prev = idx == 0 ? None$.MODULE$ : new Some(fields.apply(idx - 1));
                None$ next = idx == fields.size() - 1 ? None$.MODULE$ : new Some(fields.apply(idx + 1));
                Option trailingNext = next.flatMap((Function1 & Serializable & scala.Serializable)n -> ((TraversableLike)n.description().fold((Function0 & Serializable & scala.Serializable)() -> n.comments(), (Function1 & Serializable & scala.Serializable)x$1 -> x$1.comments())).headOption().flatMap((Function1 & Serializable & scala.Serializable)c -> c.location().flatMap((Function1 & Serializable & scala.Serializable)cp -> field.location().withFilter((Function1 & Serializable & scala.Serializable)sp -> BoxesRunTime.boxToBoolean((boolean)QueryRenderer$.$anonfun$renderFieldDefinitions$7(cp, sp))).map((Function1 & Serializable & scala.Serializable)sp -> c))));
                Option trailing = trailingNext.orElse((Function0 & Serializable & scala.Serializable)() -> tc.trailingComments().headOption().flatMap((Function1 & Serializable & scala.Serializable)c -> c.location().flatMap((Function1 & Serializable & scala.Serializable)cp -> field.location().withFilter((Function1 & Serializable & scala.Serializable)sp -> BoxesRunTime.boxToBoolean((boolean)QueryRenderer$.$anonfun$renderFieldDefinitions$12(cp, sp))).map((Function1 & Serializable & scala.Serializable)sp -> c))));
                FieldDefinition x$1 = field;
                QueryRendererConfig x$2 = config;
                Indent x$3 = indent.inc();
                None$ x$4 = prev;
                Option<String> x$5 = MODULE$.renderNode$default$4();
                String string = new StringBuilder(0).append(idx != 0 && (MODULE$.shouldRenderComment(field, (Option<AstNode>)prev, config) || MODULE$.shouldRenderDescription(field)) ? config.lineBreak() : "").append(MODULE$.renderNode(x$1, x$2, x$3, x$5, (Option<AstNode>)x$4)).append(trailing.fold((Function0 & Serializable & scala.Serializable)() -> "", (Function1 & Serializable & scala.Serializable)c -> MODULE$.renderIndividualComment((Comment)c, " ", config))).toString();
                return string;
            }, Vector$.MODULE$.canBuildFrom())).mkString(config.mandatoryLineBreak());
            string = new StringBuilder(2).append(frontSep ? config.separator() : "").append("{").append(config.lineBreak()).append(rendered).append(this.renderTrailingComment(tc, (Option<AstNode>)fields.lastOption(), indent.inc(), config)).append(this.trailingLineBreak(tc, config)).append(indent.str()).append("}").toString();
        } else {
            string = "";
        }
        return string;
    }

    public String renderInputFieldDefinitions(Vector<InputValueDefinition> fields, WithTrailingComments tc, Indent indent, QueryRendererConfig config, boolean frontSep) {
        return fields.nonEmpty() ? new StringBuilder(2).append(frontSep ? config.separator() : "").append("{").append(config.lineBreak()).append(this.renderInputObjectFieldDefs(fields, tc, indent, config)).append(this.renderTrailingComment(tc, (Option<AstNode>)fields.lastOption(), indent.inc(), config)).append(this.trailingLineBreak(tc, config)).append(indent.str()).append("}").toString() : "";
    }

    public String renderEnumValues(Vector<EnumValueDefinition> values, WithTrailingComments tc, Indent indent, QueryRendererConfig config, boolean frontSep) {
        String string;
        if (values.nonEmpty()) {
            String renderedValues = ((TraversableOnce)((TraversableLike)values.zipWithIndex(Vector$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                EnumValueDefinition value = (EnumValueDefinition)tuple2._1();
                int idx = tuple2._2$mcI$sp();
                None$ prev = idx == 0 ? None$.MODULE$ : new Some(values.apply(idx - 1));
                None$ next = idx == values.size() - 1 ? None$.MODULE$ : new Some(values.apply(idx + 1));
                Option trailingNext = next.flatMap((Function1 & Serializable & scala.Serializable)n -> ((TraversableLike)n.description().fold((Function0 & Serializable & scala.Serializable)() -> n.comments(), (Function1 & Serializable & scala.Serializable)x$2 -> x$2.comments())).headOption().flatMap((Function1 & Serializable & scala.Serializable)c -> c.location().flatMap((Function1 & Serializable & scala.Serializable)cp -> value.location().withFilter((Function1 & Serializable & scala.Serializable)sp -> BoxesRunTime.boxToBoolean((boolean)QueryRenderer$.$anonfun$renderEnumValues$7(cp, sp))).map((Function1 & Serializable & scala.Serializable)sp -> c))));
                Option trailing = trailingNext.orElse((Function0 & Serializable & scala.Serializable)() -> tc.trailingComments().headOption().flatMap((Function1 & Serializable & scala.Serializable)c -> c.location().flatMap((Function1 & Serializable & scala.Serializable)cp -> value.location().withFilter((Function1 & Serializable & scala.Serializable)sp -> BoxesRunTime.boxToBoolean((boolean)QueryRenderer$.$anonfun$renderEnumValues$12(cp, sp))).map((Function1 & Serializable & scala.Serializable)sp -> c))));
                EnumValueDefinition x$1 = value;
                QueryRendererConfig x$2 = config;
                Indent x$3 = indent.inc();
                None$ x$4 = prev;
                Option<String> x$5 = MODULE$.renderNode$default$4();
                String string = new StringBuilder(0).append(idx != 0 && (MODULE$.shouldRenderComment(value, (Option<AstNode>)prev, config) || MODULE$.shouldRenderDescription(value)) ? config.lineBreak() : "").append(MODULE$.renderNode(x$1, x$2, x$3, x$5, (Option<AstNode>)x$4)).append(trailing.fold((Function0 & Serializable & scala.Serializable)() -> "", (Function1 & Serializable & scala.Serializable)c -> MODULE$.renderIndividualComment((Comment)c, " ", config))).toString();
                return string;
            }, Vector$.MODULE$.canBuildFrom())).mkString(config.mandatoryLineBreak());
            string = new StringBuilder(2).append(frontSep ? config.separator() : "").append("{").append(config.lineBreak()).append(renderedValues).append(this.renderTrailingComment(tc, (Option<AstNode>)values.lastOption(), indent.inc(), config)).append(this.trailingLineBreak(tc, config)).append(indent.str()).append("}").toString();
        } else {
            string = "";
        }
        return string;
    }

    public String renderOperationTypeDefinitions(Vector<OperationTypeDefinition> ops, WithTrailingComments tc, Indent indent, QueryRendererConfig config, boolean frontSep) {
        String string;
        if (ops.nonEmpty()) {
            String renderedOps = ((TraversableOnce)((TraversableLike)ops.zipWithIndex(Vector$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                OperationTypeDefinition op = (OperationTypeDefinition)tuple2._1();
                int idx = tuple2._2$mcI$sp();
                String string = new StringBuilder(0).append(idx != 0 && MODULE$.shouldRenderComment(op, (Option<AstNode>)None$.MODULE$, config) ? config.lineBreak() : "").append(MODULE$.renderNode(op, config, indent.inc(), MODULE$.renderNode$default$4(), MODULE$.renderNode$default$5())).toString();
                return string;
            }, Vector$.MODULE$.canBuildFrom())).mkString(config.mandatoryLineBreak());
            string = new StringBuilder(2).append(frontSep ? config.separator() : "").append("{").append(config.lineBreak()).append(renderedOps).append(this.renderTrailingComment(tc, (Option<AstNode>)None$.MODULE$, indent.inc(), config)).append(this.trailingLineBreak(tc, config)).append(indent.str()).append("}").toString();
        } else {
            string = "";
        }
        return string;
    }

    public String renderDirs(Vector<Directive> dirs, QueryRendererConfig config, Indent indent, boolean frontSep, boolean withSep) {
        return new StringBuilder(0).append(dirs.nonEmpty() && frontSep && withSep ? config.separator() : "").append(((TraversableOnce)dirs.map((Function1 & Serializable & scala.Serializable)x$3 -> MODULE$.renderNode((AstNode)x$3, config, indent.zero(), MODULE$.renderNode$default$4(), MODULE$.renderNode$default$5()), Vector$.MODULE$.canBuildFrom())).mkString(config.separator())).append((Object)(dirs.nonEmpty() && !frontSep && withSep ? config.separator() : "")).toString();
    }

    public String renderArgs(Vector<Argument> args, Indent indent, QueryRendererConfig config, boolean withSep) {
        String string;
        if (args.nonEmpty()) {
            Vector argsRendered = (Vector)((TraversableLike)args.zipWithIndex(Vector$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Argument a = (Argument)tuple2._1();
                int idx = tuple2._2$mcI$sp();
                String string = new StringBuilder(0).append(idx != 0 && MODULE$.shouldRenderComment(a, (Option<AstNode>)None$.MODULE$, config) ? config.lineBreak() : "").append((Object)(MODULE$.shouldRenderComment(a, (Option<AstNode>)None$.MODULE$, config) ? config.mandatoryLineBreak() : (idx != 0 ? config.separator() : ""))).append(MODULE$.renderNode(a, config, MODULE$.shouldRenderComment(a, (Option<AstNode>)None$.MODULE$, config) ? indent.inc() : indent.zero(), MODULE$.renderNode$default$4(), MODULE$.renderNode$default$5())).toString();
                return string;
            }, Vector$.MODULE$.canBuildFrom());
            string = new StringBuilder(2).append("(").append(argsRendered.mkString(",")).append(")").append((Object)(withSep ? config.separator() : "")).toString();
        } else {
            string = "";
        }
        return string;
    }

    public String renderInputValueDefs(Vector<InputValueDefinition> args, Indent indent, QueryRendererConfig config, boolean withSep) {
        String string;
        if (args.nonEmpty()) {
            Vector argsRendered = (Vector)((TraversableLike)args.zipWithIndex(Vector$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                InputValueDefinition a = (InputValueDefinition)tuple2._1();
                int idx = tuple2._2$mcI$sp();
                String string = new StringBuilder(0).append(idx != 0 && (MODULE$.shouldRenderComment(a, (Option<AstNode>)None$.MODULE$, config) || MODULE$.shouldRenderDescription(a)) ? config.lineBreak() : "").append((Object)(MODULE$.shouldRenderComment(a, (Option<AstNode>)None$.MODULE$, config) || MODULE$.shouldRenderDescription(a) ? config.mandatoryLineBreak() : (idx != 0 ? config.separator() : ""))).append(MODULE$.renderNode(a, config, MODULE$.shouldRenderComment(a, (Option<AstNode>)None$.MODULE$, config) || MODULE$.shouldRenderDescription(a) ? indent.inc() : indent.zero(), MODULE$.renderNode$default$4(), MODULE$.renderNode$default$5())).toString();
                return string;
            }, Vector$.MODULE$.canBuildFrom());
            string = new StringBuilder(2).append("(").append(argsRendered.mkString(",")).append(")").append((Object)(withSep ? config.separator() : "")).toString();
        } else {
            string = "";
        }
        return string;
    }

    public String renderVarDefs(Vector<VariableDefinition> vars, Indent indent, QueryRendererConfig config, boolean withSep) {
        String string;
        if (vars.nonEmpty()) {
            Vector varsRendered = (Vector)((TraversableLike)vars.zipWithIndex(Vector$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                VariableDefinition v = (VariableDefinition)tuple2._1();
                int idx = tuple2._2$mcI$sp();
                String string = new StringBuilder(0).append(idx != 0 && MODULE$.shouldRenderComment(v, (Option<AstNode>)None$.MODULE$, config) ? config.lineBreak() : "").append((Object)(MODULE$.shouldRenderComment(v, (Option<AstNode>)None$.MODULE$, config) ? config.mandatoryLineBreak() : (idx != 0 ? config.separator() : ""))).append(MODULE$.renderNode(v, config, MODULE$.shouldRenderComment(v, (Option<AstNode>)None$.MODULE$, config) ? indent.$plus(2) : indent.zero(), MODULE$.renderNode$default$4(), MODULE$.renderNode$default$5())).toString();
                return string;
            }, Vector$.MODULE$.canBuildFrom());
            string = new StringBuilder(2).append("(").append(varsRendered.mkString(",")).append(")").append((Object)(withSep ? config.separator() : "")).toString();
        } else {
            string = "";
        }
        return string;
    }

    public String renderInputObjectFieldDefs(Vector<InputValueDefinition> fields, WithTrailingComments tc, Indent indent, QueryRendererConfig config) {
        Vector fieldsRendered = (Vector)((TraversableLike)fields.zipWithIndex(Vector$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            InputValueDefinition f = (InputValueDefinition)tuple2._1();
            int idx = tuple2._2$mcI$sp();
            None$ prev = idx == 0 ? None$.MODULE$ : new Some(fields.apply(idx - 1));
            None$ next = idx == fields.size() - 1 ? None$.MODULE$ : new Some(fields.apply(idx + 1));
            Option trailingNext = next.flatMap((Function1 & Serializable & scala.Serializable)n -> ((TraversableLike)n.description().fold((Function0 & Serializable & scala.Serializable)() -> n.comments(), (Function1 & Serializable & scala.Serializable)x$4 -> x$4.comments())).headOption().flatMap((Function1 & Serializable & scala.Serializable)c -> c.location().flatMap((Function1 & Serializable & scala.Serializable)cp -> f.location().withFilter((Function1 & Serializable & scala.Serializable)sp -> BoxesRunTime.boxToBoolean((boolean)QueryRenderer$.$anonfun$renderInputObjectFieldDefs$7(cp, sp))).map((Function1 & Serializable & scala.Serializable)sp -> c))));
            Option trailing = trailingNext.orElse((Function0 & Serializable & scala.Serializable)() -> tc.trailingComments().headOption().flatMap((Function1 & Serializable & scala.Serializable)c -> c.location().flatMap((Function1 & Serializable & scala.Serializable)cp -> f.location().withFilter((Function1 & Serializable & scala.Serializable)sp -> BoxesRunTime.boxToBoolean((boolean)QueryRenderer$.$anonfun$renderInputObjectFieldDefs$12(cp, sp))).map((Function1 & Serializable & scala.Serializable)sp -> c))));
            InputValueDefinition x$1 = f;
            QueryRendererConfig x$2 = config;
            Indent x$3 = indent.inc();
            None$ x$4 = prev;
            Option<String> x$5 = MODULE$.renderNode$default$4();
            String string = new StringBuilder(0).append(idx != 0 && (MODULE$.shouldRenderComment(f, (Option<AstNode>)prev, config) || MODULE$.shouldRenderDescription(f)) ? config.lineBreak() : "").append(MODULE$.renderNode(x$1, x$2, x$3, x$5, (Option<AstNode>)x$4)).append(trailing.fold((Function0 & Serializable & scala.Serializable)() -> "", (Function1 & Serializable & scala.Serializable)c -> MODULE$.renderIndividualComment((Comment)c, " ", config))).toString();
            return string;
        }, Vector$.MODULE$.canBuildFrom());
        return fieldsRendered.mkString(config.mandatoryLineBreak());
    }

    public String renderInterfaces(Vector<NamedType> interfaces, QueryRendererConfig config, Indent indent, boolean frontSep, boolean withSep) {
        return interfaces.nonEmpty() ? new StringBuilder(10).append(frontSep ? config.mandatorySeparator() : "").append("implements").append(config.mandatorySeparator()).append(((TraversableOnce)interfaces.map((Function1 & Serializable & scala.Serializable)x$5 -> MODULE$.renderNode((AstNode)x$5, config, indent.zero(), MODULE$.renderNode$default$4(), MODULE$.renderNode$default$5()), Vector$.MODULE$.canBuildFrom())).mkString(config.legacyImplementsInterface() ? new StringBuilder(1).append(",").append(config.separator()).toString() : new StringBuilder(1).append(config.separator()).append("&").append(config.separator()).toString())).append((Object)(withSep ? config.separator() : "")).toString() : "";
    }

    public String renderOpType(OperationType operationType) {
        String string;
        OperationType operationType2 = operationType;
        if (OperationType$Query$.MODULE$.equals(operationType2)) {
            string = "query";
        } else if (OperationType$Mutation$.MODULE$.equals(operationType2)) {
            string = "mutation";
        } else if (OperationType$Subscription$.MODULE$.equals(operationType2)) {
            string = "subscription";
        } else {
            throw new MatchError((Object)operationType2);
        }
        return string;
    }

    public Vector<Comment> actualComments(WithComments node, Option<AstNode> prev) {
        Some some;
        boolean bl;
        Option ignoreFirst = prev.flatMap((Function1 & Serializable & scala.Serializable)ls -> ls.location().flatMap((Function1 & Serializable & scala.Serializable)p -> node.comments().headOption().flatMap((Function1 & Serializable & scala.Serializable)c -> c.location().map((Function1 & Serializable & scala.Serializable)cp -> BoxesRunTime.boxToBoolean((boolean)QueryRenderer$.$anonfun$actualComments$4(p, cp))))));
        Option option = ignoreFirst;
        Vector vector = option instanceof Some && (bl = BoxesRunTime.unboxToBoolean((Object)(some = (Some)option).value())) ? node.comments().tail() : node.comments();
        return vector;
    }

    public boolean shouldRenderComment(WithComments node, Option<AstNode> prev, QueryRendererConfig config) {
        Vector<Comment> comments = this.actualComments(node, prev);
        return config.renderComments() && comments.nonEmpty();
    }

    public boolean shouldRenderDescription(WithDescription node) {
        return BoxesRunTime.unboxToBoolean((Object)node.description().fold((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false, (Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)QueryRenderer$.$anonfun$shouldRenderDescription$2(x$6))));
    }

    public boolean shouldRenderComment(WithTrailingComments node, QueryRendererConfig config) {
        return config.renderComments() && node.trailingComments().nonEmpty();
    }

    public boolean shouldRenderComment(Vector<Comment> comments, QueryRendererConfig config) {
        return config.renderComments() && comments.nonEmpty();
    }

    private boolean startsWithWhitespace(String text) {
        return RichChar$.MODULE$.isWhitespace$extension(Predef$.MODULE$.charWrapper(text.charAt(0)));
    }

    public String renderIndividualComment(Comment node, String indent, QueryRendererConfig config) {
        return new StringBuilder(1).append(indent).append("#").append((Object)(new StringOps(Predef$.MODULE$.augmentString(node.text().trim())).nonEmpty() && !this.startsWithWhitespace(node.text()) ? " " : "")).append(node.text()).toString();
    }

    public String renderDescription(WithDescription node, Option<AstNode> prev, Indent indent, QueryRendererConfig config) {
        String string;
        Option<StringValue> option = node.description();
        if (option instanceof Some) {
            Some some = (Some)option;
            StringValue description = (StringValue)some.value();
            string = new StringBuilder(0).append(this.renderComment(description, prev, indent, config)).append(indent.str()).append(this.renderStringValue(description, indent, config, false)).append(config.mandatoryLineBreak()).toString();
        } else if (None$.MODULE$.equals(option)) {
            string = "";
        } else {
            throw new MatchError(option);
        }
        return string;
    }

    public String renderComment(WithComments node, Option<AstNode> prev, Indent indent, QueryRendererConfig config) {
        String string;
        Vector<Comment> comments = this.actualComments(node, prev);
        if (this.shouldRenderComment(comments, config)) {
            Vector<String> lines = this.renderCommentLines(comments, node.location(), indent, config);
            string = lines.mkString("", config.mandatoryLineBreak(), config.mandatoryLineBreak());
        } else {
            string = "";
        }
        return string;
    }

    public Vector<String> renderCommentLines(Vector<Comment> comments, Option<AstLocation> nodePos, Indent indent, QueryRendererConfig config) {
        int nodeLine = BoxesRunTime.unboxToInt((Object)nodePos.map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToInteger((int)x$7.line())).orElse((Function0 & Serializable & scala.Serializable)() -> ((Comment)comments.last()).location().map((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToInteger((int)QueryRenderer$.$anonfun$renderCommentLines$3(x$8)))).fold((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 1, (Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)x -> BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.identity((Object)BoxesRunTime.boxToInteger((int)x)))));
        return (Vector)((Tuple2)comments.foldRight((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)nodeLine), (Object)package$.MODULE$.Vector().empty()), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2;
            Comment c;
            block3: {
                Tuple2 tuple22;
                block2: {
                    tuple22 = new Tuple2(x0$1, x1$1);
                    if (tuple22 == null) break block2;
                    c = (Comment)tuple22._1();
                    tuple2 = (Tuple2)tuple22._2();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple22);
            }
            int lastLine = tuple2._1$mcI$sp();
            Vector acc = (Vector)tuple2._2();
            int currLine = BoxesRunTime.unboxToInt((Object)c.location().fold((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> lastLine - 1, (Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToInteger((int)x$9.line())));
            int diffLines = lastLine - currLine;
            String fill = diffLines > 1 ? config.lineBreak() : "";
            String string = new StringBuilder(0).append(MODULE$.renderIndividualComment(c, indent.str(), config)).append(fill).toString();
            Tuple2 tuple23 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)currLine)), acc.$plus$colon((Object)string, Vector$.MODULE$.canBuildFrom()));
            return tuple23;
        }))._2();
    }

    public String renderTrailingComment(WithTrailingComments node, Option<AstNode> lastSelection, Indent indent, QueryRendererConfig config) {
        String string;
        Some some;
        boolean bl;
        Option ignoreFirst = lastSelection.flatMap((Function1 & Serializable & scala.Serializable)ls -> ls.location().flatMap((Function1 & Serializable & scala.Serializable)p -> node.trailingComments().headOption().flatMap((Function1 & Serializable & scala.Serializable)c -> c.location().map((Function1 & Serializable & scala.Serializable)cp -> BoxesRunTime.boxToBoolean((boolean)QueryRenderer$.$anonfun$renderTrailingComment$4(p, cp))))));
        Option option = ignoreFirst;
        Vector vector = option instanceof Some && true == (bl = BoxesRunTime.unboxToBoolean((Object)(some = (Some)option).value())) ? node.trailingComments().tail() : node.trailingComments();
        Vector comments = vector;
        if (this.shouldRenderComment(comments, config)) {
            Vector<String> lines = this.renderCommentLines((Vector<Comment>)comments, (Option<AstLocation>)None$.MODULE$, indent, config);
            string = lines.mkString(new StringBuilder(0).append(config.lineBreak()).append(config.mandatoryLineBreak()).toString(), config.mandatoryLineBreak(), "");
        } else {
            string = "";
        }
        return string;
    }

    public String renderInputComment(WithComments node, Indent indent, QueryRendererConfig config) {
        return config.formatInputValues() && this.shouldRenderComment(node, (Option<AstNode>)None$.MODULE$, config) ? new StringBuilder(0).append(this.renderComment(node, (Option<AstNode>)None$.MODULE$, indent, config)).append(indent.str()).toString() : "";
    }

    public String renderStringValue(StringValue node, Indent indent, QueryRendererConfig config, boolean extraIndent) {
        return node.block() && config.formatBlockStrings() ? this.renderBlockString(node, indent, config, extraIndent) : this.renderNonBlockString(node, indent, config);
    }

    public String renderNonBlockString(StringValue node, Indent indent, QueryRendererConfig config) {
        return new StringBuilder(2).append("\"").append(StringUtil$.MODULE$.escapeString(node.value())).append("\"").toString();
    }

    public String renderBlockString(StringValue node, Indent indent, QueryRendererConfig config, boolean extraIndent) {
        String string;
        if (new StringOps(Predef$.MODULE$.augmentString(node.value().trim())).nonEmpty()) {
            String ind = extraIndent ? indent.incForce().str() : indent.strForce();
            String[] lines = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])StringUtil$.MODULE$.escapeBlockString(node.value()).split("\n"))).map((Function1 & Serializable & scala.Serializable)x$11 -> new StringBuilder(0).append(ind).append((String)x$11).toString(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
            string = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])lines)).mkString(new StringBuilder(3).append("\"\"\"").append(config.mandatoryLineBreak()).toString(), config.mandatoryLineBreak(), new StringBuilder(3).append(config.mandatoryLineBreak()).append(ind).append("\"\"\"").toString());
        } else {
            string = "\"\"";
        }
        return string;
    }

    public String render(AstNode node, QueryRendererConfig config, int indentLevel) {
        return this.renderNode(node, config, new Indent(config, indentLevel, indentLevel), this.renderNode$default$4(), this.renderNode$default$5());
    }

    public boolean renderFieldDefinitions$default$5() {
        return false;
    }

    public boolean renderInputFieldDefinitions$default$5() {
        return false;
    }

    public boolean renderEnumValues$default$5() {
        return false;
    }

    public boolean renderOperationTypeDefinitions$default$5() {
        return false;
    }

    public boolean renderDirs$default$4() {
        return false;
    }

    public boolean renderDirs$default$5() {
        return true;
    }

    public boolean renderArgs$default$4() {
        return true;
    }

    public boolean renderInputValueDefs$default$4() {
        return true;
    }

    public boolean renderVarDefs$default$4() {
        return true;
    }

    public boolean renderInterfaces$default$4() {
        return false;
    }

    public boolean renderInterfaces$default$5() {
        return true;
    }

    public boolean renderStringValue$default$4() {
        return true;
    }

    public boolean renderBlockString$default$4() {
        return true;
    }

    public QueryRendererConfig render$default$2() {
        return this.Pretty();
    }

    public int render$default$3() {
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String renderNode(AstNode node, QueryRendererConfig config, Indent indent, Option<String> prefix, Option<AstNode> prev) {
        boolean bl = false;
        OperationDefinition operationDefinition = null;
        AstNode astNode = node;
        if (astNode instanceof Document) {
            Document document = (Document)astNode;
            Vector<Definition> defs = document.definitions();
            return new StringBuilder(0).append(((TraversableOnce)defs.map((Function1 & Serializable & scala.Serializable)x$12 -> MODULE$.renderNode((AstNode)x$12, config, indent, MODULE$.renderNode$default$4(), MODULE$.renderNode$default$5()), Vector$.MODULE$.canBuildFrom())).mkString(config.definitionSeparator())).append(this.renderTrailingComment(document, (Option<AstNode>)None$.MODULE$, indent, config)).toString();
        }
        if (astNode instanceof InputDocument) {
            InputDocument inputDocument = (InputDocument)astNode;
            Vector<Value> defs = inputDocument.values();
            return new StringBuilder(0).append(((TraversableOnce)defs.map((Function1 & Serializable & scala.Serializable)x$13 -> MODULE$.renderNode((AstNode)x$13, config, indent, MODULE$.renderNode$default$4(), MODULE$.renderNode$default$5()), Vector$.MODULE$.canBuildFrom())).mkString(config.definitionSeparator())).append(this.renderTrailingComment(inputDocument, (Option<AstNode>)None$.MODULE$, indent, config)).toString();
        }
        if (astNode instanceof OperationDefinition) {
            bl = true;
            operationDefinition = (OperationDefinition)astNode;
            OperationType operationType = operationDefinition.operationType();
            Option<String> option = operationDefinition.name();
            Vector<VariableDefinition> vars = operationDefinition.variables();
            Vector<Directive> dirs = operationDefinition.directives();
            Vector<Selection> sels = operationDefinition.selections();
            if (OperationType$Query$.MODULE$.equals(operationType) && None$.MODULE$.equals(option) && vars.isEmpty() && dirs.isEmpty()) {
                return new StringBuilder(0).append(this.renderComment(operationDefinition, prev, indent, config)).append(indent.str()).append(this.renderSelections(sels, operationDefinition, indent, config)).toString();
            }
        }
        if (bl) {
            OperationType opType = operationDefinition.operationType();
            Option<String> name = operationDefinition.name();
            Vector<VariableDefinition> vars = operationDefinition.variables();
            Vector<Directive> dirs = operationDefinition.directives();
            Vector<Selection> sels = operationDefinition.selections();
            return new StringBuilder(0).append(this.renderComment(operationDefinition, prev, indent, config)).append(indent.str()).append(this.renderOpType(opType)).append(config.mandatorySeparator()).append(name.getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).append(this.renderVarDefs(vars, indent, config, false)).append(config.separator()).append(this.renderDirs(dirs, config, indent, this.renderDirs$default$4(), this.renderDirs$default$5())).append(this.renderSelections(sels, operationDefinition, indent, config)).toString();
        }
        if (astNode instanceof FragmentDefinition) {
            FragmentDefinition fragmentDefinition = (FragmentDefinition)astNode;
            String name = fragmentDefinition.name();
            NamedType typeCondition = fragmentDefinition.typeCondition();
            Vector<Directive> dirs = fragmentDefinition.directives();
            Vector<Selection> sels = fragmentDefinition.selections();
            Vector<VariableDefinition> vars = fragmentDefinition.variables();
            return new StringBuilder(10).append(this.renderComment(fragmentDefinition, prev, indent, config)).append(indent.str()).append("fragment").append(config.mandatorySeparator()).append(name).append(this.renderVarDefs(vars, indent, config, false)).append(config.mandatorySeparator()).append("on").append(config.mandatorySeparator()).append(typeCondition.name()).append(config.separator()).append(this.renderDirs(dirs, config, indent, this.renderDirs$default$4(), this.renderDirs$default$5())).append(this.renderSelections(sels, fragmentDefinition, indent, config)).toString();
        }
        if (astNode instanceof VariableDefinition) {
            VariableDefinition variableDefinition = (VariableDefinition)astNode;
            String name = variableDefinition.name();
            Type tpe = variableDefinition.tpe();
            Option<Value> defaultValue = variableDefinition.defaultValue();
            Vector<Directive> dirs = variableDefinition.directives();
            return new StringBuilder(2).append(this.renderComment(variableDefinition, prev, indent, config)).append(indent.str()).append("$").append(name).append(":").append(config.separator()).append(this.renderNode(tpe, config, indent.zero(), this.renderNode$default$4(), this.renderNode$default$5())).append(defaultValue.map((Function1 & Serializable & scala.Serializable)v -> new StringBuilder(1).append(config.separator()).append("=").append(config.separator()).append(MODULE$.renderNode((AstNode)v, config, indent.zero(), MODULE$.renderNode$default$4(), MODULE$.renderNode$default$5())).toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).append(this.renderDirs(dirs, config, indent, true, this.renderDirs$default$5())).toString();
        }
        if (astNode instanceof NotNullType) {
            NotNullType notNullType = (NotNullType)astNode;
            Type ofType = notNullType.ofType();
            return new StringBuilder(1).append(this.renderNode(ofType, config, indent.zero(), this.renderNode$default$4(), this.renderNode$default$5())).append("!").toString();
        }
        if (astNode instanceof ListType) {
            ListType listType = (ListType)astNode;
            Type ofType = listType.ofType();
            return new StringBuilder(2).append("[").append(this.renderNode(ofType, config, indent.zero(), this.renderNode$default$4(), this.renderNode$default$5())).append("]").toString();
        }
        if (astNode instanceof NamedType) {
            NamedType namedType = (NamedType)astNode;
            String name = namedType.name();
            return name;
        }
        if (astNode instanceof Field) {
            Field field = (Field)astNode;
            Option<String> alias = field.alias();
            String name = field.name();
            Vector<Argument> args = field.arguments();
            Vector<Directive> dirs = field.directives();
            Vector<Selection> sels = field.selections();
            Vector<Directive> x$1 = dirs;
            QueryRendererConfig x$2 = config;
            Indent x$3 = indent;
            boolean x$4 = sels.nonEmpty();
            boolean x$5 = this.renderDirs$default$4();
            return new StringBuilder(0).append(this.renderComment(field, prev, indent, config)).append(indent.str()).append(alias.map((Function1 & Serializable & scala.Serializable)x$14 -> new StringBuilder(1).append((String)x$14).append(":").append(config.separator()).toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).append(name).append(this.renderArgs(args, indent, config, false)).append((Object)(dirs.nonEmpty() || sels.nonEmpty() ? config.separator() : "")).append(this.renderDirs(x$1, x$2, x$3, x$5, x$4)).append(this.renderSelections(sels, field, indent, config)).toString();
        }
        if (astNode instanceof FragmentSpread) {
            FragmentSpread fragmentSpread = (FragmentSpread)astNode;
            String name = fragmentSpread.name();
            Vector<Directive> dirs = fragmentSpread.directives();
            return new StringBuilder(3).append(this.renderComment(fragmentSpread, prev, indent, config)).append(indent.str()).append("...").append(name).append(this.renderDirs(dirs, config, indent, true, this.renderDirs$default$5())).toString();
        }
        if (astNode instanceof InlineFragment) {
            InlineFragment inlineFragment = (InlineFragment)astNode;
            Option<NamedType> typeCondition = inlineFragment.typeCondition();
            Vector<Directive> dirs = inlineFragment.directives();
            Vector<Selection> sels = inlineFragment.selections();
            return new StringBuilder(3).append(this.renderComment(inlineFragment, prev, indent, config)).append(indent.str()).append("...").append(config.mandatorySeparator()).append(typeCondition.fold((Function0 & Serializable & scala.Serializable)() -> "", (Function1 & Serializable & scala.Serializable)x$15 -> new StringBuilder(2).append("on").append(config.mandatorySeparator()).append(x$15.name()).toString())).append(config.separator()).append(this.renderDirs(dirs, config, indent, this.renderDirs$default$4(), this.renderDirs$default$5())).append(this.renderSelections(sels, inlineFragment, indent, config)).toString();
        }
        if (astNode instanceof Directive) {
            Directive directive = (Directive)astNode;
            String name = directive.name();
            Vector<Argument> args = directive.arguments();
            boolean x$6 = false;
            String x$7 = config.copy$default$1();
            String x$8 = config.copy$default$2();
            String x$9 = config.copy$default$3();
            String x$10 = config.copy$default$4();
            String x$11 = config.copy$default$5();
            String x$122 = config.copy$default$6();
            String x$132 = config.copy$default$7();
            String x$142 = config.copy$default$8();
            boolean x$152 = config.copy$default$9();
            boolean x$162 = config.copy$default$10();
            boolean x$172 = config.copy$default$12();
            return new StringBuilder(1).append(indent.str()).append("@").append(name).append(this.renderArgs(args, indent, config.copy(x$7, x$8, x$9, x$10, x$11, x$122, x$132, x$142, x$152, x$162, x$6, x$172), false)).toString();
        }
        if (astNode instanceof Argument) {
            Argument argument = (Argument)astNode;
            String name = argument.name();
            Value value = argument.value();
            return new StringBuilder(1).append(this.renderComment(argument, prev, indent, config)).append(indent.str()).append(name).append(":").append(config.separator()).append(this.renderNode(value, config, indent.zero(), this.renderNode$default$4(), this.renderNode$default$5())).toString();
        }
        if (astNode instanceof IntValue) {
            IntValue intValue = (IntValue)astNode;
            int value = intValue.value();
            return new StringBuilder(0).append(this.renderInputComment(intValue, indent, config)).append(value).toString();
        }
        if (astNode instanceof BigIntValue) {
            BigIntValue bigIntValue = (BigIntValue)astNode;
            BigInt value = bigIntValue.value();
            return new StringBuilder(0).append(this.renderInputComment(bigIntValue, indent, config)).append(value).toString();
        }
        if (astNode instanceof FloatValue) {
            FloatValue floatValue = (FloatValue)astNode;
            double value = floatValue.value();
            return new StringBuilder(0).append(this.renderInputComment(floatValue, indent, config)).append(value).toString();
        }
        if (astNode instanceof BigDecimalValue) {
            BigDecimalValue bigDecimalValue = (BigDecimalValue)astNode;
            BigDecimal value = bigDecimalValue.value();
            return new StringBuilder(0).append(this.renderInputComment(bigDecimalValue, indent, config)).append(value).toString();
        }
        if (astNode instanceof BooleanValue) {
            BooleanValue booleanValue = (BooleanValue)astNode;
            boolean value = booleanValue.value();
            return new StringBuilder(0).append(this.renderInputComment(booleanValue, indent, config)).append(value).toString();
        }
        if (astNode instanceof NullValue) {
            NullValue nullValue = (NullValue)astNode;
            return new StringBuilder(4).append(this.renderInputComment(nullValue, indent, config)).append("null").toString();
        }
        if (astNode instanceof EnumValue) {
            EnumValue enumValue = (EnumValue)astNode;
            String value = enumValue.value();
            return new StringBuilder(0).append(this.renderInputComment(enumValue, indent, config)).append(value).toString();
        }
        if (astNode instanceof StringValue) {
            StringValue stringValue = (StringValue)astNode;
            return new StringBuilder(0).append(this.renderInputComment(stringValue, indent, config)).append(this.renderStringValue(stringValue, indent, config, this.renderStringValue$default$4())).toString();
        }
        if (astNode instanceof ListValue) {
            ListValue listValue = (ListValue)astNode;
            Vector<Value> value = listValue.values();
            return new StringBuilder(2).append(this.renderInputComment(listValue, indent, config)).append("[").append(((TraversableOnce)((TraversableLike)value.zipWithIndex(Vector$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Value v = (Value)tuple2._1();
                int idx = tuple2._2$mcI$sp();
                String string = this.renderValue$1(v, idx, config, indent);
                return string;
            }, Vector$.MODULE$.canBuildFrom())).mkString(config.inputListSeparator())).append("]").toString();
        }
        if (astNode instanceof ObjectValue) {
            ObjectValue objectValue = (ObjectValue)astNode;
            Vector<ObjectField> value = objectValue.fields();
            return new StringBuilder(2).append(this.renderInputComment(objectValue, indent, config)).append("{").append(this.inputLineBreak(config)).append(((TraversableOnce)((TraversableLike)value.zipWithIndex(Vector$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                ObjectField v = (ObjectField)tuple2._1();
                int idx = tuple2._2$mcI$sp();
                String string = new StringBuilder(0).append(idx != 0 && config.formatInputValues() && MODULE$.shouldRenderComment(v, (Option<AstNode>)None$.MODULE$, config) ? config.lineBreak() : "").append(MODULE$.renderNode(v, config, MODULE$.inputFieldIndent(config, indent), MODULE$.renderNode$default$4(), MODULE$.renderNode$default$5())).toString();
                return string;
            }, Vector$.MODULE$.canBuildFrom())).mkString(config.inputFieldSeparator())).append(this.inputLineBreak(config)).append(this.inputIndent(config, indent)).append("}").toString();
        }
        if (astNode instanceof VariableValue) {
            VariableValue variableValue = (VariableValue)astNode;
            String name = variableValue.name();
            return new StringBuilder(1).append(indent.str()).append("$").append(name).toString();
        }
        if (astNode instanceof ObjectField) {
            ObjectField objectField = (ObjectField)astNode;
            String name = objectField.name();
            Value value = objectField.value();
            String rendered = config.formatInputValues() && this.shouldRenderComment(value, (Option<AstNode>)None$.MODULE$, config) ? new StringBuilder(0).append(config.lineBreak()).append(this.renderNode(value, config, indent.inc(), this.renderNode$default$4(), this.renderNode$default$5())).toString() : new StringBuilder(0).append(config.separator()).append(this.renderNode(value, config, indent, this.renderNode$default$4(), this.renderNode$default$5())).toString();
            return new StringBuilder(1).append(config.formatInputValues() ? this.renderComment(objectField, prev, indent, config) : "").append(indent.str()).append(name).append(":").append(rendered).toString();
        }
        if (astNode instanceof Comment) {
            Comment comment = (Comment)astNode;
            return this.renderIndividualComment(comment, indent.str(), config);
        }
        if (astNode instanceof ScalarTypeDefinition) {
            ScalarTypeDefinition scalarTypeDefinition = (ScalarTypeDefinition)astNode;
            String name = scalarTypeDefinition.name();
            Vector<Directive> dirs = scalarTypeDefinition.directives();
            Option<StringValue> description = scalarTypeDefinition.description();
            return new StringBuilder(6).append(this.renderDescription(scalarTypeDefinition, prev, indent, config)).append(this.renderComment(scalarTypeDefinition, (Option<AstNode>)description.orElse((Function0 & Serializable & scala.Serializable)() -> prev), indent, config)).append(indent.str()).append("scalar").append(config.mandatorySeparator()).append(name).append(this.renderDirs(dirs, config, indent, true, this.renderDirs$default$5())).toString();
        }
        if (astNode instanceof ObjectTypeDefinition) {
            ObjectTypeDefinition objectTypeDefinition = (ObjectTypeDefinition)astNode;
            String name = objectTypeDefinition.name();
            Vector<NamedType> interfaces = objectTypeDefinition.interfaces();
            Vector<FieldDefinition> fields = objectTypeDefinition.fields();
            Vector<Directive> dirs = objectTypeDefinition.directives();
            Option<StringValue> description = objectTypeDefinition.description();
            Vector<Directive> x$18 = dirs;
            QueryRendererConfig x$19 = config;
            Indent x$20 = indent;
            boolean x$21 = fields.nonEmpty();
            boolean x$22 = this.renderDirs$default$4();
            return new StringBuilder(4).append(this.renderDescription(objectTypeDefinition, prev, indent, config)).append(this.renderComment(objectTypeDefinition, (Option<AstNode>)description.orElse((Function0 & Serializable & scala.Serializable)() -> prev), indent, config)).append(indent.str()).append(prefix.getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).append("type").append(config.mandatorySeparator()).append(name).append(config.mandatorySeparator()).append(this.renderInterfaces(interfaces, config, indent, this.renderInterfaces$default$4(), this.renderInterfaces$default$5())).append(this.renderDirs(x$18, x$19, x$20, x$22, x$21)).append(this.renderFieldDefinitions(fields, objectTypeDefinition, indent, config, this.renderFieldDefinitions$default$5())).toString();
        }
        if (astNode instanceof InputObjectTypeDefinition) {
            InputObjectTypeDefinition inputObjectTypeDefinition = (InputObjectTypeDefinition)astNode;
            String name = inputObjectTypeDefinition.name();
            Vector<InputValueDefinition> fields = inputObjectTypeDefinition.fields();
            Vector<Directive> dirs = inputObjectTypeDefinition.directives();
            Option<StringValue> description = inputObjectTypeDefinition.description();
            return new StringBuilder(5).append(this.renderDescription(inputObjectTypeDefinition, prev, indent, config)).append(this.renderComment(inputObjectTypeDefinition, (Option<AstNode>)description.orElse((Function0 & Serializable & scala.Serializable)() -> prev), indent, config)).append(indent.str()).append("input").append(config.mandatorySeparator()).append(name).append(this.renderDirs(dirs, config, indent, true, this.renderDirs$default$5())).append(this.renderInputFieldDefinitions(fields, inputObjectTypeDefinition, indent, config, true)).toString();
        }
        if (astNode instanceof InterfaceTypeDefinition) {
            InterfaceTypeDefinition interfaceTypeDefinition = (InterfaceTypeDefinition)astNode;
            String name = interfaceTypeDefinition.name();
            Vector<FieldDefinition> fields = interfaceTypeDefinition.fields();
            Vector<Directive> dirs = interfaceTypeDefinition.directives();
            Option<StringValue> description = interfaceTypeDefinition.description();
            return new StringBuilder(9).append(this.renderDescription(interfaceTypeDefinition, prev, indent, config)).append(this.renderComment(interfaceTypeDefinition, (Option<AstNode>)description.orElse((Function0 & Serializable & scala.Serializable)() -> prev), indent, config)).append(indent.str()).append("interface").append(config.mandatorySeparator()).append(name).append(this.renderDirs(dirs, config, indent, true, this.renderDirs$default$5())).append(this.renderFieldDefinitions(fields, interfaceTypeDefinition, indent, config, true)).toString();
        }
        if (astNode instanceof UnionTypeDefinition) {
            UnionTypeDefinition unionTypeDefinition = (UnionTypeDefinition)astNode;
            String name = unionTypeDefinition.name();
            Vector<NamedType> types = unionTypeDefinition.types();
            Vector<Directive> dirs = unionTypeDefinition.directives();
            Option<StringValue> description = unionTypeDefinition.description();
            String typesString = types.nonEmpty() ? new StringBuilder(1).append(config.separator()).append("=").append(config.separator()).append(((TraversableOnce)types.map((Function1 & Serializable & scala.Serializable)x$16 -> MODULE$.renderNode((AstNode)x$16, config, indent.zero(), MODULE$.renderNode$default$4(), MODULE$.renderNode$default$5()), Vector$.MODULE$.canBuildFrom())).mkString(new StringBuilder(1).append(config.separator()).append("|").append(config.separator()).toString())).toString() : "";
            return new StringBuilder(5).append(this.renderDescription(unionTypeDefinition, prev, indent, config)).append(this.renderComment(unionTypeDefinition, (Option<AstNode>)description.orElse((Function0 & Serializable & scala.Serializable)() -> prev), indent, config)).append(indent.str()).append("union").append(config.mandatorySeparator()).append(name).append(this.renderDirs(dirs, config, indent, true, this.renderDirs$default$5())).append(typesString).toString();
        }
        if (astNode instanceof EnumTypeDefinition) {
            EnumTypeDefinition enumTypeDefinition = (EnumTypeDefinition)astNode;
            String name = enumTypeDefinition.name();
            Vector<EnumValueDefinition> values = enumTypeDefinition.values();
            Vector<Directive> dirs = enumTypeDefinition.directives();
            Option<StringValue> description = enumTypeDefinition.description();
            return new StringBuilder(4).append(this.renderDescription(enumTypeDefinition, prev, indent, config)).append(this.renderComment(enumTypeDefinition, (Option<AstNode>)description.orElse((Function0 & Serializable & scala.Serializable)() -> prev), indent, config)).append(indent.str()).append("enum").append(config.mandatorySeparator()).append(name).append(this.renderDirs(dirs, config, indent, true, this.renderDirs$default$5())).append(this.renderEnumValues(values, enumTypeDefinition, indent, config, true)).toString();
        }
        if (astNode instanceof EnumValueDefinition) {
            EnumValueDefinition enumValueDefinition = (EnumValueDefinition)astNode;
            String name = enumValueDefinition.name();
            Vector<Directive> dirs = enumValueDefinition.directives();
            Option<StringValue> description = enumValueDefinition.description();
            return new StringBuilder(0).append(this.renderDescription(enumValueDefinition, prev, indent, config)).append(this.renderComment(enumValueDefinition, (Option<AstNode>)description.orElse((Function0 & Serializable & scala.Serializable)() -> prev), indent, config)).append(indent.str()).append(name).append(this.renderDirs(dirs, config, indent, true, this.renderDirs$default$5())).toString();
        }
        if (astNode instanceof FieldDefinition) {
            FieldDefinition fieldDefinition = (FieldDefinition)astNode;
            String name = fieldDefinition.name();
            Type fieldType = fieldDefinition.fieldType();
            Vector<InputValueDefinition> args = fieldDefinition.arguments();
            Vector<Directive> dirs = fieldDefinition.directives();
            Option<StringValue> description = fieldDefinition.description();
            return new StringBuilder(1).append(this.renderDescription(fieldDefinition, prev, indent, config)).append(this.renderComment(fieldDefinition, (Option<AstNode>)description.orElse((Function0 & Serializable & scala.Serializable)() -> prev), indent, config)).append(indent.str()).append(name).append(this.renderInputValueDefs(args, indent, config, false)).append(":").append(config.separator()).append(this.renderNode(fieldType, config, indent.zero(), this.renderNode$default$4(), this.renderNode$default$5())).append(this.renderDirs(dirs, config, indent, true, this.renderDirs$default$5())).toString();
        }
        if (astNode instanceof InputValueDefinition) {
            InputValueDefinition inputValueDefinition = (InputValueDefinition)astNode;
            String name = inputValueDefinition.name();
            Type valueType = inputValueDefinition.valueType();
            Option<Value> option = inputValueDefinition.defaultValue();
            Vector<Directive> dirs = inputValueDefinition.directives();
            Option<StringValue> description = inputValueDefinition.description();
            return new StringBuilder(1).append(this.renderDescription(inputValueDefinition, prev, indent, config)).append(this.renderComment(inputValueDefinition, (Option<AstNode>)description.orElse((Function0 & Serializable & scala.Serializable)() -> prev), indent, config)).append(indent.str()).append(name).append(":").append(config.separator()).append(this.renderNode(valueType, config, indent.zero(), this.renderNode$default$4(), this.renderNode$default$5())).append(option.fold((Function0 & Serializable & scala.Serializable)() -> "", (Function1 & Serializable & scala.Serializable)d -> new StringBuilder(1).append(config.separator()).append("=").append(config.separator()).append(MODULE$.renderNode((AstNode)d, config, indent.zero(), MODULE$.renderNode$default$4(), MODULE$.renderNode$default$5())).toString())).append(this.renderDirs(dirs, config, indent, true, this.renderDirs$default$5())).toString();
        }
        if (astNode instanceof ObjectTypeExtensionDefinition) {
            Vector<Directive> dirs;
            ObjectTypeExtensionDefinition objectTypeExtensionDefinition = (ObjectTypeExtensionDefinition)astNode;
            String name = objectTypeExtensionDefinition.name();
            Vector<NamedType> interfaces = objectTypeExtensionDefinition.interfaces();
            Vector<FieldDefinition> fields = objectTypeExtensionDefinition.fields();
            Vector<Directive> x$23 = dirs = objectTypeExtensionDefinition.directives();
            QueryRendererConfig x$24 = config;
            Indent x$25 = indent;
            boolean x$26 = fields.nonEmpty();
            boolean x$27 = this.renderDirs$default$4();
            return new StringBuilder(10).append(this.renderComment(objectTypeExtensionDefinition, prev, indent, config)).append(indent.str()).append(prefix.getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).append("extend").append(config.mandatorySeparator()).append("type").append(config.mandatorySeparator()).append(name).append(config.mandatorySeparator()).append(this.renderInterfaces(interfaces, config, indent, this.renderInterfaces$default$4(), this.renderInterfaces$default$5())).append(this.renderDirs(x$23, x$24, x$25, x$27, x$26)).append(this.renderFieldDefinitions(fields, objectTypeExtensionDefinition, indent, config, this.renderFieldDefinitions$default$5())).toString();
        }
        if (astNode instanceof InterfaceTypeExtensionDefinition) {
            InterfaceTypeExtensionDefinition interfaceTypeExtensionDefinition = (InterfaceTypeExtensionDefinition)astNode;
            String name = interfaceTypeExtensionDefinition.name();
            Vector<FieldDefinition> fields = interfaceTypeExtensionDefinition.fields();
            Vector<Directive> dirs = interfaceTypeExtensionDefinition.directives();
            return new StringBuilder(15).append(this.renderComment(interfaceTypeExtensionDefinition, prev, indent, config)).append(indent.str()).append("extend").append(config.mandatorySeparator()).append("interface").append(config.mandatorySeparator()).append(name).append(this.renderDirs(dirs, config, indent, true, this.renderDirs$default$5())).append(this.renderFieldDefinitions(fields, interfaceTypeExtensionDefinition, indent, config, true)).toString();
        }
        if (astNode instanceof UnionTypeExtensionDefinition) {
            UnionTypeExtensionDefinition unionTypeExtensionDefinition = (UnionTypeExtensionDefinition)astNode;
            String name = unionTypeExtensionDefinition.name();
            Vector<NamedType> types = unionTypeExtensionDefinition.types();
            Vector<Directive> dirs = unionTypeExtensionDefinition.directives();
            String typesString = types.nonEmpty() ? new StringBuilder(1).append(config.separator()).append("=").append(config.separator()).append(((TraversableOnce)types.map((Function1 & Serializable & scala.Serializable)x$17 -> MODULE$.renderNode((AstNode)x$17, config, indent.zero(), MODULE$.renderNode$default$4(), MODULE$.renderNode$default$5()), Vector$.MODULE$.canBuildFrom())).mkString(new StringBuilder(1).append(config.separator()).append("|").append(config.separator()).toString())).toString() : "";
            return new StringBuilder(11).append(this.renderComment(unionTypeExtensionDefinition, prev, indent, config)).append(indent.str()).append("extend").append(config.mandatorySeparator()).append("union").append(config.mandatorySeparator()).append(name).append(this.renderDirs(dirs, config, indent, true, this.renderDirs$default$5())).append(typesString).toString();
        }
        if (astNode instanceof InputObjectTypeExtensionDefinition) {
            InputObjectTypeExtensionDefinition inputObjectTypeExtensionDefinition = (InputObjectTypeExtensionDefinition)astNode;
            String name = inputObjectTypeExtensionDefinition.name();
            Vector<InputValueDefinition> fields = inputObjectTypeExtensionDefinition.fields();
            Vector<Directive> dirs = inputObjectTypeExtensionDefinition.directives();
            return new StringBuilder(11).append(this.renderComment(inputObjectTypeExtensionDefinition, prev, indent, config)).append(indent.str()).append("extend").append(config.mandatorySeparator()).append("input").append(config.mandatorySeparator()).append(name).append(this.renderDirs(dirs, config, indent, true, this.renderDirs$default$5())).append(this.renderInputFieldDefinitions(fields, inputObjectTypeExtensionDefinition, indent, config, true)).toString();
        }
        if (astNode instanceof EnumTypeExtensionDefinition) {
            EnumTypeExtensionDefinition enumTypeExtensionDefinition = (EnumTypeExtensionDefinition)astNode;
            String name = enumTypeExtensionDefinition.name();
            Vector<EnumValueDefinition> values = enumTypeExtensionDefinition.values();
            Vector<Directive> dirs = enumTypeExtensionDefinition.directives();
            return new StringBuilder(10).append(this.renderComment(enumTypeExtensionDefinition, prev, indent, config)).append(indent.str()).append("extend").append(config.mandatorySeparator()).append("enum").append(config.mandatorySeparator()).append(name).append(this.renderDirs(dirs, config, indent, true, this.renderDirs$default$5())).append(this.renderEnumValues(values, enumTypeExtensionDefinition, indent, config, true)).toString();
        }
        if (astNode instanceof ScalarTypeExtensionDefinition) {
            ScalarTypeExtensionDefinition scalarTypeExtensionDefinition = (ScalarTypeExtensionDefinition)astNode;
            String name = scalarTypeExtensionDefinition.name();
            Vector<Directive> dirs = scalarTypeExtensionDefinition.directives();
            return new StringBuilder(12).append(this.renderComment(scalarTypeExtensionDefinition, prev, indent, config)).append(indent.str()).append("extend").append(config.mandatorySeparator()).append("scalar").append(config.mandatorySeparator()).append(name).append(this.renderDirs(dirs, config, indent, true, this.renderDirs$default$5())).toString();
        }
        if (astNode instanceof SchemaExtensionDefinition) {
            SchemaExtensionDefinition schemaExtensionDefinition = (SchemaExtensionDefinition)astNode;
            Vector<OperationTypeDefinition> ops = schemaExtensionDefinition.operationTypes();
            Vector<Directive> dirs = schemaExtensionDefinition.directives();
            return new StringBuilder(12).append(this.renderComment(schemaExtensionDefinition, prev, indent, config)).append(indent.str()).append("extend").append(config.mandatorySeparator()).append("schema").append(this.renderDirs(dirs, config, indent, true, this.renderDirs$default$5())).append(this.renderOperationTypeDefinitions(ops, schemaExtensionDefinition, indent, config, true)).toString();
        }
        if (astNode instanceof DirectiveDefinition) {
            DirectiveDefinition directiveDefinition = (DirectiveDefinition)astNode;
            String name = directiveDefinition.name();
            Vector<InputValueDefinition> args = directiveDefinition.arguments();
            Vector<DirectiveLocation> locations = directiveDefinition.locations();
            Option<StringValue> description = directiveDefinition.description();
            Vector locsRendered = (Vector)((TraversableLike)locations.zipWithIndex(Vector$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$3 -> {
                Tuple2 tuple2 = x0$3;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                DirectiveLocation l = (DirectiveLocation)tuple2._1();
                int idx = tuple2._2$mcI$sp();
                String string = new StringBuilder(0).append(idx != 0 && MODULE$.shouldRenderComment(l, (Option<AstNode>)None$.MODULE$, config) ? config.lineBreak() : "").append((Object)(MODULE$.shouldRenderComment(l, (Option<AstNode>)None$.MODULE$, config) ? config.lineBreak() : (idx != 0 ? config.separator() : ""))).append(MODULE$.renderNode(l, config, MODULE$.shouldRenderComment(l, (Option<AstNode>)None$.MODULE$, config) ? indent.inc() : indent.zero(), MODULE$.renderNode$default$4(), MODULE$.renderNode$default$5())).toString();
                return string;
            }, Vector$.MODULE$.canBuildFrom());
            return new StringBuilder(12).append(this.renderDescription(directiveDefinition, prev, indent, config)).append(this.renderComment(directiveDefinition, (Option<AstNode>)description.orElse((Function0 & Serializable & scala.Serializable)() -> prev), indent, config)).append(indent.str()).append("directive").append(config.separator()).append("@").append(name).append(this.renderInputValueDefs(args, indent, config, this.renderInputValueDefs$default$4())).append((Object)(args.isEmpty() ? config.mandatorySeparator() : "")).append("on").append((Object)(this.shouldRenderComment((WithComments)locations.head(), (Option<AstNode>)None$.MODULE$, config) ? "" : config.mandatorySeparator())).append(locsRendered.mkString(new StringBuilder(1).append(config.separator()).append("|").toString())).toString();
        }
        if (astNode instanceof DirectiveLocation) {
            DirectiveLocation directiveLocation = (DirectiveLocation)astNode;
            String name = directiveLocation.name();
            return new StringBuilder(0).append(this.renderComment(directiveLocation, prev, indent, config)).append(indent.str()).append(name).toString();
        }
        if (astNode instanceof SchemaDefinition) {
            SchemaDefinition schemaDefinition = (SchemaDefinition)astNode;
            Vector<OperationTypeDefinition> ops = schemaDefinition.operationTypes();
            Vector<Directive> dirs = schemaDefinition.directives();
            Option<StringValue> description = schemaDefinition.description();
            return new StringBuilder(6).append(this.renderDescription(schemaDefinition, prev, indent, config)).append(this.renderComment(schemaDefinition, (Option<AstNode>)description.orElse((Function0 & Serializable & scala.Serializable)() -> prev), indent, config)).append(indent.str()).append("schema").append(config.separator()).append(this.renderDirs(dirs, config, indent, this.renderDirs$default$4(), this.renderDirs$default$5())).append(this.renderOperationTypeDefinitions(ops, schemaDefinition, indent, config, this.renderOperationTypeDefinitions$default$5())).toString();
        }
        if (!(astNode instanceof OperationTypeDefinition)) throw new MatchError((Object)astNode);
        OperationTypeDefinition operationTypeDefinition = (OperationTypeDefinition)astNode;
        OperationType op = operationTypeDefinition.operation();
        NamedType tpe = operationTypeDefinition.tpe();
        return new StringBuilder(1).append(this.renderComment(operationTypeDefinition, prev, indent, config)).append(indent.str()).append(this.renderOpType(op)).append(":").append(config.separator()).append(this.renderNode(tpe, config, indent.zero(), this.renderNode$default$4(), this.renderNode$default$5())).toString();
    }

    public Option<String> renderNode$default$4() {
        return None$.MODULE$;
    }

    public Option<AstNode> renderNode$default$5() {
        return None$.MODULE$;
    }

    private String trailingLineBreak(WithTrailingComments tc, QueryRendererConfig config) {
        return this.shouldRenderComment(tc, config) ? config.mandatoryLineBreak() : config.lineBreak();
    }

    public String inputLineBreak(QueryRendererConfig config) {
        return config.formatInputValues() ? config.lineBreak() : "";
    }

    public Indent inputFieldIndent(QueryRendererConfig config, Indent indent) {
        return config.formatInputValues() ? indent.inc() : indent.zero();
    }

    public String inputIndent(QueryRendererConfig config, Indent indent) {
        return config.formatInputValues() ? indent.str() : "";
    }

    public static final /* synthetic */ boolean $anonfun$renderSelections$5(AstLocation cp$1, AstLocation sp) {
        return cp$1.line() == sp.line();
    }

    public static final /* synthetic */ boolean $anonfun$renderSelections$10(AstLocation cp$2, AstLocation sp) {
        return cp$2.line() == sp.line();
    }

    public static final /* synthetic */ boolean $anonfun$renderFieldDefinitions$7(AstLocation cp$3, AstLocation sp) {
        return cp$3.line() == sp.line();
    }

    public static final /* synthetic */ boolean $anonfun$renderFieldDefinitions$12(AstLocation cp$4, AstLocation sp) {
        return cp$4.line() == sp.line();
    }

    public static final /* synthetic */ boolean $anonfun$renderEnumValues$7(AstLocation cp$5, AstLocation sp) {
        return cp$5.line() == sp.line();
    }

    public static final /* synthetic */ boolean $anonfun$renderEnumValues$12(AstLocation cp$6, AstLocation sp) {
        return cp$6.line() == sp.line();
    }

    public static final /* synthetic */ boolean $anonfun$renderInputObjectFieldDefs$7(AstLocation cp$7, AstLocation sp) {
        return cp$7.line() == sp.line();
    }

    public static final /* synthetic */ boolean $anonfun$renderInputObjectFieldDefs$12(AstLocation cp$8, AstLocation sp) {
        return cp$8.line() == sp.line();
    }

    public static final /* synthetic */ boolean $anonfun$actualComments$4(AstLocation p$1, AstLocation cp) {
        return cp.line() == p$1.line();
    }

    public static final /* synthetic */ boolean $anonfun$shouldRenderDescription$2(StringValue x$6) {
        return new StringOps(Predef$.MODULE$.augmentString(x$6.value().trim())).nonEmpty();
    }

    public static final /* synthetic */ int $anonfun$renderCommentLines$3(AstLocation x$8) {
        return x$8.line() + 1;
    }

    public static final /* synthetic */ boolean $anonfun$renderTrailingComment$4(AstLocation p$2, AstLocation cp) {
        return cp.line() == p$2.line();
    }

    private static final boolean addIdent$1(Value v) {
        Value value = v;
        boolean bl = !(value instanceof ObjectValue);
        return bl;
    }

    private final String renderValue$1(Value v, int idx, QueryRendererConfig config$12, Indent indent$12) {
        return config$12.formatInputValues() && this.shouldRenderComment(v, (Option<AstNode>)None$.MODULE$, config$12) ? new StringBuilder(0).append(idx != 0 ? config$12.lineBreak() : "").append(config$12.lineBreak()).append(this.renderNode(v, config$12, indent$12.$plus(QueryRenderer$.addIdent$1(v) ? 1 : 0), this.renderNode$default$4(), this.renderNode$default$5())).toString() : new StringBuilder(0).append(idx != 0 ? config$12.separator() : "").append(this.renderNode(v, config$12, indent$12, this.renderNode$default$4(), this.renderNode$default$5())).toString();
    }

    private QueryRenderer$() {
        MODULE$ = this;
        String x$1 = "  ";
        String x$2 = "\n";
        String x$3 = " ";
        String x$4 = " ";
        String x$5 = "\n";
        String x$6 = "\n\n";
        String x$7 = ", ";
        String x$8 = ",";
        boolean x$9 = false;
        boolean x$10 = true;
        boolean x$11 = true;
        boolean x$12 = false;
        this.Pretty = new QueryRendererConfig(x$1, x$2, x$4, x$5, x$3, x$6, x$7, x$8, x$9, x$11, x$10, x$12);
        String x$13 = "\n";
        boolean x$14 = true;
        boolean x$15 = true;
        boolean x$16 = false;
        String x$17 = this.Pretty().copy$default$1();
        String x$18 = this.Pretty().copy$default$2();
        String x$19 = this.Pretty().copy$default$3();
        String x$20 = this.Pretty().copy$default$4();
        String x$21 = this.Pretty().copy$default$5();
        String x$22 = this.Pretty().copy$default$6();
        String x$23 = this.Pretty().copy$default$8();
        boolean x$24 = this.Pretty().copy$default$10();
        this.PrettyInput = this.Pretty().copy(x$17, x$18, x$19, x$20, x$21, x$22, x$13, x$23, x$14, x$24, x$15, x$16);
        String x$25 = "";
        String x$26 = "";
        String x$27 = "";
        String x$28 = " ";
        String x$29 = " ";
        String x$30 = "\n";
        String x$31 = ",";
        String x$32 = ",";
        boolean x$33 = false;
        boolean x$34 = false;
        boolean x$35 = false;
        boolean x$36 = false;
        this.Compact = new QueryRendererConfig(x$25, x$26, x$28, x$29, x$27, x$30, x$31, x$32, x$33, x$35, x$34, x$36);
    }
}

