/*
 * Decompiled with CFR 0.152.
 */
package sangria.schema;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import sangria.ast.AstNode$;
import sangria.ast.Value;
import sangria.execution.ValueCoercionHelper;
import sangria.execution.ValueCoercionHelper$;
import sangria.marshalling.ToInput;
import sangria.renderer.SchemaRenderer$;
import sangria.schema.Argument;
import sangria.schema.DefaultValueRenderer$;
import sangria.schema.Directive;
import sangria.schema.EnumType;
import sangria.schema.EnumValue;
import sangria.schema.Field;
import sangria.schema.HasDeprecation;
import sangria.schema.HasDescription;
import sangria.schema.InputField;
import sangria.schema.InputObjectType;
import sangria.schema.InputType;
import sangria.schema.InterfaceType;
import sangria.schema.ObjectLikeType;
import sangria.schema.ObjectType;
import sangria.schema.OptionInputType;
import sangria.schema.OptionType;
import sangria.schema.OutputType;
import sangria.schema.ScalarType;
import sangria.schema.Schema;
import sangria.schema.SchemaChange;
import sangria.schema.SchemaChange$SchemaDescriptionChanged$;
import sangria.schema.Type;
import sangria.schema.UnionType;
import scala.Enumeration;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.Function4;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenSet;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.package$;
import scala.runtime.BoxesRunTime;

public final class SchemaComparator$ {
    public static SchemaComparator$ MODULE$;
    private final ValueCoercionHelper<Object> coercionHelper;

    static {
        new SchemaComparator$();
    }

    public Vector<SchemaChange> compare(Schema<?, ?> oldSchema, Schema<?, ?> newSchema) {
        return this.findChanges(oldSchema, newSchema);
    }

    private Vector<SchemaChange> findChanges(Schema<?, ?> oldSchema, Schema<?, ?> newSchema) {
        Set oldTypes = oldSchema.availableTypeNames().toSet();
        Set newTypes = newSchema.availableTypeNames().toSet();
        Vector removed = (Vector)oldTypes.diff((GenSet)newTypes).toVector().map((Function1 & Serializable & scala.Serializable)name -> new SchemaChange.TypeRemoved((Type)((Tuple2)oldSchema.types().apply(name))._2()), Vector$.MODULE$.canBuildFrom());
        Vector added = (Vector)newTypes.diff((GenSet)oldTypes).toVector().map((Function1 & Serializable & scala.Serializable)name -> new SchemaChange.TypeAdded((Type)((Tuple2)newSchema.types().apply(name))._2()), Vector$.MODULE$.canBuildFrom());
        Set changed = (Set)((TraversableLike)oldTypes.intersect((GenSet)newTypes)).flatMap((Function1 & Serializable & scala.Serializable)name -> {
            Type oldType = (Type)((Tuple2)oldSchema.types().apply(name))._2();
            Type newType = (Type)((Tuple2)newSchema.types().apply(name))._2();
            Class<?> clazz = oldType.getClass();
            Class<?> clazz2 = newType.getClass();
            return !(clazz != null ? !clazz.equals(clazz2) : clazz2 != null) ? MODULE$.findChangesInTypes(oldType, newType) : (Vector)package$.MODULE$.Vector().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SchemaChange.TypeKindChanged[]{new SchemaChange.TypeKindChanged(newType, oldType)}));
        }, Set$.MODULE$.canBuildFrom());
        return (Vector)((Vector)((Vector)((Vector)removed.$plus$plus((GenTraversableOnce)added, Vector$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)changed, Vector$.MODULE$.canBuildFrom())).$plus$plus(this.findChangesInSchema(oldSchema, newSchema), Vector$.MODULE$.canBuildFrom())).$plus$plus(this.findInDirectives(oldSchema, newSchema), Vector$.MODULE$.canBuildFrom());
    }

    private Vector<SchemaChange> findInDirectives(Schema<?, ?> oldSchema, Schema<?, ?> newSchema) {
        Set oldDirs = ((TraversableOnce)oldSchema.directives().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.name(), List$.MODULE$.canBuildFrom())).toSet();
        Set newDirs = ((TraversableOnce)newSchema.directives().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.name(), List$.MODULE$.canBuildFrom())).toSet();
        Vector removed = (Vector)oldDirs.diff((GenSet)newDirs).toVector().map((Function1 & Serializable & scala.Serializable)name -> new SchemaChange.DirectiveRemoved((Directive)oldSchema.directivesByName().apply(name)), Vector$.MODULE$.canBuildFrom());
        Vector added = (Vector)newDirs.diff((GenSet)oldDirs).toVector().map((Function1 & Serializable & scala.Serializable)name -> new SchemaChange.DirectiveAdded((Directive)newSchema.directivesByName().apply(name)), Vector$.MODULE$.canBuildFrom());
        Set changed = (Set)((TraversableLike)oldDirs.intersect((GenSet)newDirs)).flatMap((Function1 & Serializable & scala.Serializable)name -> {
            Directive oldDir = (Directive)oldSchema.directivesByName().apply(name);
            Directive newDir = (Directive)newSchema.directivesByName().apply(name);
            return (Vector)MODULE$.findDescriptionChanged(oldDir, newDir, (Function2<Option<String>, Option<String>, SchemaChange>)(Function2 & Serializable & scala.Serializable)(x$3, x$4) -> new SchemaChange.DirectiveDescriptionChanged(newDir, (Option<String>)x$3, (Option<String>)x$4)).$plus$plus(MODULE$.findInDirective(oldDir, newDir), Vector$.MODULE$.canBuildFrom());
        }, Set$.MODULE$.canBuildFrom());
        return (Vector)((Vector)removed.$plus$plus((GenTraversableOnce)added, Vector$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)changed, Vector$.MODULE$.canBuildFrom());
    }

    private Vector<SchemaChange> findInDirective(Directive oldDir, Directive newDir) {
        Vector<SchemaChange> locationChanges = this.findInDirectiveLocations(oldDir, newDir);
        Vector<SchemaChange> fieldChanges = this.findInArgs(oldDir.arguments(), newDir.arguments(), (Function2 & Serializable & scala.Serializable)(x$5, x$6) -> SchemaComparator$.$anonfun$findInDirective$1(newDir, x$5, BoxesRunTime.unboxToBoolean((Object)x$6)), (Function1 & Serializable & scala.Serializable)x$7 -> new SchemaChange.DirectiveArgumentRemoved(oldDir, (Argument<?>)x$7), (Function3 & Serializable & scala.Serializable)(x$8, x$9, x$10) -> new SchemaChange.DirectiveArgumentDescriptionChanged(newDir, (Argument<?>)x$8, (Option<String>)x$9, (Option<String>)x$10), (Function3 & Serializable & scala.Serializable)(x$11, x$12, x$13) -> new SchemaChange.DirectiveArgumentDefaultChanged(newDir, (Argument<?>)x$11, (Option<Value>)x$12, (Option<Value>)x$13), (Function4 & Serializable & scala.Serializable)(x$14, x$15, x$16, x$17) -> SchemaComparator$.$anonfun$findInDirective$5(newDir, x$14, BoxesRunTime.unboxToBoolean((Object)x$15), x$16, x$17), (Function2 & Serializable & scala.Serializable)(x$18, x$19) -> new SchemaChange.DirectiveArgumentAstDirectiveAdded(newDir, (Argument<?>)x$18, (sangria.ast.Directive)x$19), (Function2 & Serializable & scala.Serializable)(x$20, x$21) -> new SchemaChange.DirectiveArgumentAstDirectiveRemoved(newDir, (Argument<?>)x$20, (sangria.ast.Directive)x$21));
        return (Vector)locationChanges.$plus$plus(fieldChanges, Vector$.MODULE$.canBuildFrom());
    }

    private Vector<SchemaChange> findInDirectiveLocations(Directive oldDir, Directive newDir) {
        Set<Enumeration.Value> oldLocs = oldDir.locations();
        Set<Enumeration.Value> newLocs = newDir.locations();
        Vector removed = (Vector)oldLocs.diff(newLocs).toVector().map((Function1 & Serializable & scala.Serializable)loc -> new SchemaChange.DirectiveLocationRemoved(oldDir, (Enumeration.Value)loc), Vector$.MODULE$.canBuildFrom());
        Vector added = (Vector)newLocs.diff(oldLocs).toVector().map((Function1 & Serializable & scala.Serializable)loc -> new SchemaChange.DirectiveLocationAdded(newDir, (Enumeration.Value)loc), Vector$.MODULE$.canBuildFrom());
        return (Vector)removed.$plus$plus((GenTraversableOnce)added, Vector$.MODULE$.canBuildFrom());
    }

    public Vector<SchemaChange> findChangesInSchema(Schema<?, ?> oldSchema, Schema<?, ?> newSchema) {
        String string = oldSchema.query().name();
        String string2 = newSchema.query().name();
        Vector withQuery = (string == null ? string2 != null : !string.equals(string2)) ? (Vector)package$.MODULE$.Vector().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SchemaChange.SchemaQueryTypeChanged[]{new SchemaChange.SchemaQueryTypeChanged(oldSchema.query(), newSchema.query())})) : package$.MODULE$.Vector().empty();
        Option option = oldSchema.mutation().map((Function1 & Serializable & scala.Serializable)x$22 -> x$22.name());
        Option option2 = newSchema.mutation().map((Function1 & Serializable & scala.Serializable)x$23 -> x$23.name());
        Vector withMutation = (option == null ? option2 != null : !option.equals(option2)) ? (Vector)withQuery.$colon$plus((Object)new SchemaChange.SchemaMutationTypeChanged(oldSchema.mutation(), newSchema.mutation()), Vector$.MODULE$.canBuildFrom()) : withQuery;
        Option option3 = oldSchema.subscription().map((Function1 & Serializable & scala.Serializable)x$24 -> x$24.name());
        Option option4 = newSchema.subscription().map((Function1 & Serializable & scala.Serializable)x$25 -> x$25.name());
        Vector withSubscription = (option3 == null ? option4 != null : !option3.equals(option4)) ? (Vector)withMutation.$colon$plus((Object)new SchemaChange.SchemaSubscriptionTypeChanged(oldSchema.subscription(), newSchema.subscription()), Vector$.MODULE$.canBuildFrom()) : withMutation;
        Vector<SchemaChange> directiveChanges = this.findInAstDirs(oldSchema.astDirectives(), newSchema.astDirectives(), (Function1<sangria.ast.Directive, SchemaChange>)(Function1 & Serializable & scala.Serializable)x$26 -> new SchemaChange.SchemaAstDirectiveAdded(newSchema, (sangria.ast.Directive)x$26), (Function1<sangria.ast.Directive, SchemaChange>)(Function1 & Serializable & scala.Serializable)x$27 -> new SchemaChange.SchemaAstDirectiveRemoved(newSchema, (sangria.ast.Directive)x$27));
        Vector<SchemaChange> descriptionChanges = this.findDescriptionChanged(oldSchema, newSchema, (Function2<Option<String>, Option<String>, SchemaChange>)SchemaChange$SchemaDescriptionChanged$.MODULE$);
        return (Vector)((Vector)withSubscription.$plus$plus(directiveChanges, Vector$.MODULE$.canBuildFrom())).$plus$plus(descriptionChanges, Vector$.MODULE$.canBuildFrom());
    }

    /*
     * Unable to fully structure code
     */
    public Vector<SchemaChange> findChangesInTypes(Type oldType, Type newType) {
        block3: {
            block7: {
                block6: {
                    block5: {
                        block4: {
                            block2: {
                                var5_3 = new Tuple2((Object)oldType, (Object)newType);
                                if (var5_3 == null) break block2;
                                o = (Type)var5_3._1();
                                n = (Type)var5_3._2();
                                if (!(o instanceof EnumType)) break block2;
                                var8_6 = (EnumType)o;
                                if (!(n instanceof EnumType)) break block2;
                                var9_7 = (EnumType)n;
                                var3_8 = this.findInEnumTypes(var8_6, var9_7);
                                break block3;
                            }
                            if (var5_3 == null) break block4;
                            o = (Type)var5_3._1();
                            n = (Type)var5_3._2();
                            if (!(o instanceof UnionType)) break block4;
                            var12_11 = (UnionType)o;
                            if (!(n instanceof UnionType)) break block4;
                            var13_12 = (UnionType)n;
                            var3_8 = this.findInUnionTypes(var12_11, var13_12);
                            break block3;
                        }
                        if (var5_3 == null) break block5;
                        o = (Type)var5_3._1();
                        n = (Type)var5_3._2();
                        if (!(o instanceof ScalarType)) break block5;
                        var16_15 = (ScalarType)o;
                        if (!(n instanceof ScalarType)) break block5;
                        var17_16 = (ScalarType)n;
                        var3_8 = this.findInScalarTypes(var16_15, var17_16);
                        break block3;
                    }
                    if (var5_3 == null) break block6;
                    o = (Type)var5_3._1();
                    n = (Type)var5_3._2();
                    if (!(o instanceof InputObjectType)) break block6;
                    var20_19 = (InputObjectType)o;
                    if (!(n instanceof InputObjectType)) break block6;
                    var21_20 = (InputObjectType)n;
                    var3_8 = this.findInInputObjectTypes(var20_19, var21_20);
                    break block3;
                }
                if (var5_3 == null) break block7;
                o = (Type)var5_3._1();
                n = (Type)var5_3._2();
                if (!(o instanceof ObjectType)) break block7;
                var24_23 = (ObjectType)o;
                if (!(n instanceof ObjectType)) break block7;
                var25_24 = (ObjectType)n;
                var3_8 = this.findInObjectTypes(var24_23, var25_24);
                break block3;
            }
            if (var5_3 == null) ** GOTO lbl-1000
            o = (Type)var5_3._1();
            n = (Type)var5_3._2();
            if (!(o instanceof InterfaceType)) ** GOTO lbl-1000
            var28_27 = (InterfaceType)o;
            if (n instanceof InterfaceType) {
                var29_28 = (InterfaceType)n;
                var3_8 = this.findInInterfaceTypes(var28_27, var29_28);
            } else lbl-1000:
            // 3 sources

            {
                var3_8 = package$.MODULE$.Vector().empty();
            }
        }
        typeChanges = var3_8;
        return (Vector)typeChanges.$plus$plus(this.findDescriptionChanged((HasDescription)oldType, (HasDescription)newType, (Function2<Option<String>, Option<String>, SchemaChange>)(Function2 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$findChangesInTypes$1(sangria.schema.Type scala.Option scala.Option ), (Lscala/Option;Lscala/Option;)Lsangria/schema/SchemaChange$TypeDescriptionChanged;)((Type)newType)), Vector$.MODULE$.canBuildFrom());
    }

    private Vector<SchemaChange> findInUnionTypes(UnionType<?> oldType, UnionType<?> newType) {
        Set oldTypes = ((TraversableOnce)oldType.types().map((Function1 & Serializable & scala.Serializable)x$30 -> x$30.name(), List$.MODULE$.canBuildFrom())).toSet();
        Set newTypes = ((TraversableOnce)newType.types().map((Function1 & Serializable & scala.Serializable)x$31 -> x$31.name(), List$.MODULE$.canBuildFrom())).toSet();
        Vector removed = (Vector)oldTypes.diff((GenSet)newTypes).toVector().map((Function1 & Serializable & scala.Serializable)name -> new SchemaChange.UnionMemberRemoved(oldType, (ObjectType)oldType.types().find((Function1 & Serializable & scala.Serializable)x$32 -> BoxesRunTime.boxToBoolean((boolean)SchemaComparator$.$anonfun$findInUnionTypes$4(name, x$32))).get()), Vector$.MODULE$.canBuildFrom());
        Vector added = (Vector)newTypes.diff((GenSet)oldTypes).toVector().map((Function1 & Serializable & scala.Serializable)name -> new SchemaChange.UnionMemberAdded(newType, (ObjectType)newType.types().find((Function1 & Serializable & scala.Serializable)x$33 -> BoxesRunTime.boxToBoolean((boolean)SchemaComparator$.$anonfun$findInUnionTypes$6(name, x$33))).get()), Vector$.MODULE$.canBuildFrom());
        Vector<SchemaChange> directiveChanges = this.findInAstDirs(oldType.astDirectives(), newType.astDirectives(), (Function1<sangria.ast.Directive, SchemaChange>)(Function1 & Serializable & scala.Serializable)x$34 -> new SchemaChange.UnionTypeAstDirectiveAdded(newType, (sangria.ast.Directive)x$34), (Function1<sangria.ast.Directive, SchemaChange>)(Function1 & Serializable & scala.Serializable)x$35 -> new SchemaChange.UnionTypeAstDirectiveRemoved(newType, (sangria.ast.Directive)x$35));
        return (Vector)((Vector)removed.$plus$plus((GenTraversableOnce)added, Vector$.MODULE$.canBuildFrom())).$plus$plus(directiveChanges, Vector$.MODULE$.canBuildFrom());
    }

    private Vector<SchemaChange> findInScalarTypes(ScalarType<?> oldType, ScalarType<?> newType) {
        return this.findInAstDirs(oldType.astDirectives(), newType.astDirectives(), (Function1<sangria.ast.Directive, SchemaChange>)(Function1 & Serializable & scala.Serializable)x$36 -> new SchemaChange.ScalarTypeAstDirectiveAdded(newType, (sangria.ast.Directive)x$36), (Function1<sangria.ast.Directive, SchemaChange>)(Function1 & Serializable & scala.Serializable)x$37 -> new SchemaChange.ScalarTypeAstDirectiveRemoved(newType, (sangria.ast.Directive)x$37));
    }

    private Vector<SchemaChange> findInEnumTypes(EnumType<?> oldType, EnumType<?> newType) {
        Set oldValues = ((TraversableOnce)oldType.values().map((Function1 & Serializable & scala.Serializable)x$38 -> x$38.name(), List$.MODULE$.canBuildFrom())).toSet();
        Set newValues = ((TraversableOnce)newType.values().map((Function1 & Serializable & scala.Serializable)x$39 -> x$39.name(), List$.MODULE$.canBuildFrom())).toSet();
        Vector removed = (Vector)oldValues.diff((GenSet)newValues).toVector().map((Function1 & Serializable & scala.Serializable)name -> new SchemaChange.EnumValueRemoved(oldType, (EnumValue)oldType.byName().apply(name)), Vector$.MODULE$.canBuildFrom());
        Vector added = (Vector)newValues.diff((GenSet)oldValues).toVector().map((Function1 & Serializable & scala.Serializable)name -> new SchemaChange.EnumValueAdded(newType, (EnumValue)newType.byName().apply(name)), Vector$.MODULE$.canBuildFrom());
        Set changed = (Set)((TraversableLike)oldValues.intersect((GenSet)newValues)).flatMap((Function1 & Serializable & scala.Serializable)name -> {
            EnumValue oldValue = (EnumValue)oldType.byName().apply(name);
            EnumValue newValue = (EnumValue)newType.byName().apply(name);
            Vector<SchemaChange> directiveChanges = MODULE$.findInAstDirs(oldValue.astDirectives(), newValue.astDirectives(), (Function1<sangria.ast.Directive, SchemaChange>)(Function1 & Serializable & scala.Serializable)x$40 -> new SchemaChange.EnumValueAstDirectiveAdded(newType, newValue, (sangria.ast.Directive)x$40), (Function1<sangria.ast.Directive, SchemaChange>)(Function1 & Serializable & scala.Serializable)x$41 -> new SchemaChange.EnumValueAstDirectiveRemoved(newType, newValue, (sangria.ast.Directive)x$41));
            return (Vector)((Vector)MODULE$.findDescriptionChanged(oldValue, newValue, (Function2<Option<String>, Option<String>, SchemaChange>)(Function2 & Serializable & scala.Serializable)(x$42, x$43) -> new SchemaChange.EnumValueDescriptionChanged(newType, newValue, (Option<String>)x$42, (Option<String>)x$43)).$plus$plus(MODULE$.findDeprecationChanged(oldValue, newValue, (Function2<Option<String>, Option<String>, SchemaChange>)(Function2 & Serializable & scala.Serializable)(x$44, x$45) -> new SchemaChange.EnumValueDeprecated(newType, newValue, (Option<String>)x$44, (Option<String>)x$45)), Vector$.MODULE$.canBuildFrom())).$plus$plus(directiveChanges, Vector$.MODULE$.canBuildFrom());
        }, Set$.MODULE$.canBuildFrom());
        Vector<SchemaChange> directiveChanges = this.findInAstDirs(oldType.astDirectives(), newType.astDirectives(), (Function1<sangria.ast.Directive, SchemaChange>)(Function1 & Serializable & scala.Serializable)x$46 -> new SchemaChange.EnumTypeAstDirectiveAdded(newType, (sangria.ast.Directive)x$46), (Function1<sangria.ast.Directive, SchemaChange>)(Function1 & Serializable & scala.Serializable)x$47 -> new SchemaChange.EnumTypeAstDirectiveRemoved(newType, (sangria.ast.Directive)x$47));
        return (Vector)((Vector)((Vector)removed.$plus$plus((GenTraversableOnce)added, Vector$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)changed, Vector$.MODULE$.canBuildFrom())).$plus$plus(directiveChanges, Vector$.MODULE$.canBuildFrom());
    }

    private Vector<SchemaChange> findInInputObjectTypes(InputObjectType<?> oldType, InputObjectType<?> newType) {
        Set oldFields = ((TraversableOnce)oldType.fields().map((Function1 & Serializable & scala.Serializable)x$48 -> x$48.name(), List$.MODULE$.canBuildFrom())).toSet();
        Set newFields = ((TraversableOnce)newType.fields().map((Function1 & Serializable & scala.Serializable)x$49 -> x$49.name(), List$.MODULE$.canBuildFrom())).toSet();
        Vector removed = (Vector)oldFields.diff((GenSet)newFields).toVector().map((Function1 & Serializable & scala.Serializable)name -> new SchemaChange.InputFieldRemoved(oldType, (InputField)oldType.fieldsByName().apply(name)), Vector$.MODULE$.canBuildFrom());
        Vector added = (Vector)newFields.diff((GenSet)oldFields).toVector().map((Function1 & Serializable & scala.Serializable)name -> {
            InputField field;
            return new SchemaChange.InputFieldAdded(newType, field, !MODULE$.isOptional(field = (InputField)newType.fieldsByName().apply(name)));
        }, Vector$.MODULE$.canBuildFrom());
        Set changed = (Set)((TraversableLike)oldFields.intersect((GenSet)newFields)).flatMap((Function1 & Serializable & scala.Serializable)name -> {
            InputField oldField = (InputField)oldType.fieldsByName().apply(name);
            InputField newField = (InputField)newType.fieldsByName().apply(name);
            return (Vector)MODULE$.findDescriptionChanged(oldField, newField, (Function2<Option<String>, Option<String>, SchemaChange>)(Function2 & Serializable & scala.Serializable)(x$50, x$51) -> new SchemaChange.InputFieldDescriptionChanged(newType, newField, (Option<String>)x$50, (Option<String>)x$51)).$plus$plus(MODULE$.findInInputFields(oldType, newType, oldField, newField), Vector$.MODULE$.canBuildFrom());
        }, Set$.MODULE$.canBuildFrom());
        Vector<SchemaChange> directiveChanges = this.findInAstDirs(oldType.astDirectives(), newType.astDirectives(), (Function1<sangria.ast.Directive, SchemaChange>)(Function1 & Serializable & scala.Serializable)x$52 -> new SchemaChange.InputObjectTypeAstDirectiveAdded(newType, (sangria.ast.Directive)x$52), (Function1<sangria.ast.Directive, SchemaChange>)(Function1 & Serializable & scala.Serializable)x$53 -> new SchemaChange.InputObjectTypeAstDirectiveRemoved(newType, (sangria.ast.Directive)x$53));
        return (Vector)((Vector)((Vector)removed.$plus$plus((GenTraversableOnce)added, Vector$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)changed, Vector$.MODULE$.canBuildFrom())).$plus$plus(directiveChanges, Vector$.MODULE$.canBuildFrom());
    }

    private Vector<SchemaChange> findInObjectTypes(ObjectType<?, ?> oldType, ObjectType<?, ?> newType) {
        Vector<SchemaChange> interfaceChanges = this.findInObjectTypeInterfaces(oldType, newType);
        Vector<SchemaChange> fieldChanges = this.findInObjectTypeFields(oldType, newType);
        Vector<SchemaChange> directiveChanges = this.findInAstDirs(oldType.astDirectives(), newType.astDirectives(), (Function1<sangria.ast.Directive, SchemaChange>)(Function1 & Serializable & scala.Serializable)x$54 -> new SchemaChange.ObjectTypeAstDirectiveAdded(newType, (sangria.ast.Directive)x$54), (Function1<sangria.ast.Directive, SchemaChange>)(Function1 & Serializable & scala.Serializable)x$55 -> new SchemaChange.ObjectTypeAstDirectiveRemoved(newType, (sangria.ast.Directive)x$55));
        return (Vector)((Vector)interfaceChanges.$plus$plus(fieldChanges, Vector$.MODULE$.canBuildFrom())).$plus$plus(directiveChanges, Vector$.MODULE$.canBuildFrom());
    }

    private Vector<SchemaChange> findInInterfaceTypes(InterfaceType<?, ?> oldType, InterfaceType<?, ?> newType) {
        return (Vector)this.findInObjectTypeFields(oldType, newType).$plus$plus(this.findInAstDirs(oldType.astDirectives(), newType.astDirectives(), (Function1<sangria.ast.Directive, SchemaChange>)(Function1 & Serializable & scala.Serializable)x$56 -> new SchemaChange.InterfaceTypeAstDirectiveAdded(newType, (sangria.ast.Directive)x$56), (Function1<sangria.ast.Directive, SchemaChange>)(Function1 & Serializable & scala.Serializable)x$57 -> new SchemaChange.InterfaceTypeAstDirectiveRemoved(newType, (sangria.ast.Directive)x$57)), Vector$.MODULE$.canBuildFrom());
    }

    private Vector<SchemaChange> findInObjectTypeInterfaces(ObjectType<?, ?> oldType, ObjectType<?, ?> newType) {
        Set oldInts = ((TraversableOnce)oldType.allInterfaces().map((Function1 & Serializable & scala.Serializable)x$58 -> x$58.name(), Vector$.MODULE$.canBuildFrom())).toSet();
        Set newInts = ((TraversableOnce)newType.allInterfaces().map((Function1 & Serializable & scala.Serializable)x$59 -> x$59.name(), Vector$.MODULE$.canBuildFrom())).toSet();
        Vector removed = (Vector)oldInts.diff((GenSet)newInts).toVector().map((Function1 & Serializable & scala.Serializable)name -> new SchemaChange.ObjectTypeInterfaceRemoved(oldType, (InterfaceType)oldType.interfaces().find((Function1 & Serializable & scala.Serializable)x$60 -> BoxesRunTime.boxToBoolean((boolean)SchemaComparator$.$anonfun$findInObjectTypeInterfaces$4(name, x$60))).get()), Vector$.MODULE$.canBuildFrom());
        Vector added = (Vector)newInts.diff((GenSet)oldInts).toVector().map((Function1 & Serializable & scala.Serializable)name -> new SchemaChange.ObjectTypeInterfaceAdded(newType, (InterfaceType)newType.interfaces().find((Function1 & Serializable & scala.Serializable)x$61 -> BoxesRunTime.boxToBoolean((boolean)SchemaComparator$.$anonfun$findInObjectTypeInterfaces$6(name, x$61))).get()), Vector$.MODULE$.canBuildFrom());
        return (Vector)removed.$plus$plus((GenTraversableOnce)added, Vector$.MODULE$.canBuildFrom());
    }

    private Vector<SchemaChange> findInObjectTypeFields(ObjectLikeType<?, ?> oldType, ObjectLikeType<?, ?> newType) {
        Set oldFields = ((TraversableOnce)oldType.fields().map((Function1 & Serializable & scala.Serializable)x$62 -> x$62.name(), Vector$.MODULE$.canBuildFrom())).toSet();
        Set newFields = ((TraversableOnce)newType.fields().map((Function1 & Serializable & scala.Serializable)x$63 -> x$63.name(), Vector$.MODULE$.canBuildFrom())).toSet();
        Vector removed = (Vector)oldFields.diff((GenSet)newFields).toVector().map((Function1 & Serializable & scala.Serializable)name -> new SchemaChange.FieldRemoved(oldType, (Field)((Vector)oldType.fieldsByName().apply(name)).head()), Vector$.MODULE$.canBuildFrom());
        Vector added = (Vector)newFields.diff((GenSet)oldFields).toVector().map((Function1 & Serializable & scala.Serializable)name -> new SchemaChange.FieldAdded(newType, (Field)((Vector)newType.fieldsByName().apply(name)).head()), Vector$.MODULE$.canBuildFrom());
        Set changed = (Set)((TraversableLike)oldFields.intersect((GenSet)newFields)).flatMap((Function1 & Serializable & scala.Serializable)name -> {
            Field oldField = (Field)((Vector)oldType.fieldsByName().apply(name)).head();
            Field newField = (Field)((Vector)newType.fieldsByName().apply(name)).head();
            return (Vector)((Vector)MODULE$.findDescriptionChanged(oldField, newField, (Function2<Option<String>, Option<String>, SchemaChange>)(Function2 & Serializable & scala.Serializable)(x$64, x$65) -> new SchemaChange.FieldDescriptionChanged(newType, newField, (Option<String>)x$64, (Option<String>)x$65)).$plus$plus(MODULE$.findDeprecationChanged(oldField, newField, (Function2<Option<String>, Option<String>, SchemaChange>)(Function2 & Serializable & scala.Serializable)(x$66, x$67) -> new SchemaChange.FieldDeprecationChanged(newType, newField, (Option<String>)x$66, (Option<String>)x$67)), Vector$.MODULE$.canBuildFrom())).$plus$plus(MODULE$.findInFields(oldType, newType, oldField, newField), Vector$.MODULE$.canBuildFrom());
        }, Set$.MODULE$.canBuildFrom());
        return (Vector)((Vector)removed.$plus$plus((GenTraversableOnce)added, Vector$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)changed, Vector$.MODULE$.canBuildFrom());
    }

    private Vector<SchemaChange> findInFields(ObjectLikeType<?, ?> oldType, ObjectLikeType<?, ?> newType, Field<?, ?> oldField, Field<?, ?> newField) {
        Vector vector;
        String oldFieldType = SchemaRenderer$.MODULE$.renderTypeName(oldField.fieldType(), SchemaRenderer$.MODULE$.renderTypeName$default$2());
        String newFieldType = SchemaRenderer$.MODULE$.renderTypeName(newField.fieldType(), SchemaRenderer$.MODULE$.renderTypeName$default$2());
        String string = oldFieldType;
        String string2 = newFieldType;
        if (string == null ? string2 != null : !string.equals(string2)) {
            SchemaChange.FieldTypeChanged[] fieldTypeChangedArray = new SchemaChange.FieldTypeChanged[1];
            String string3 = SchemaRenderer$.MODULE$.renderTypeName(this.nonContainer(oldField), SchemaRenderer$.MODULE$.renderTypeName$default$2());
            String string4 = newFieldType;
            fieldTypeChangedArray[0] = new SchemaChange.FieldTypeChanged(newType, newField, string3 == null ? string4 != null : !string3.equals(string4), oldField.fieldType(), newField.fieldType());
            vector = (Vector)package$.MODULE$.Vector().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])fieldTypeChangedArray));
        } else {
            vector = package$.MODULE$.Vector().empty();
        }
        Vector typeChanges = vector;
        Vector<SchemaChange> directiveChanges = this.findInAstDirs(oldField.astDirectives(), newField.astDirectives(), (Function1<sangria.ast.Directive, SchemaChange>)(Function1 & Serializable & scala.Serializable)x$68 -> new SchemaChange.FieldAstDirectiveAdded(newType, newField, (sangria.ast.Directive)x$68), (Function1<sangria.ast.Directive, SchemaChange>)(Function1 & Serializable & scala.Serializable)x$69 -> new SchemaChange.FieldAstDirectiveRemoved(newType, newField, (sangria.ast.Directive)x$69));
        Vector<SchemaChange> argChanges = this.findInArgs(oldField.arguments(), newField.arguments(), (Function2 & Serializable & scala.Serializable)(x$70, x$71) -> SchemaComparator$.$anonfun$findInFields$3(newType, newField, x$70, BoxesRunTime.unboxToBoolean((Object)x$71)), (Function1 & Serializable & scala.Serializable)x$72 -> new SchemaChange.ObjectTypeArgumentRemoved(oldType, oldField, (Argument<?>)x$72), (Function3 & Serializable & scala.Serializable)(x$73, x$74, x$75) -> new SchemaChange.ObjectTypeArgumentDescriptionChanged(newType, newField, (Argument<?>)x$73, (Option<String>)x$74, (Option<String>)x$75), (Function3 & Serializable & scala.Serializable)(x$76, x$77, x$78) -> new SchemaChange.ObjectTypeArgumentDefaultChanged(newType, newField, (Argument<?>)x$76, (Option<Value>)x$77, (Option<Value>)x$78), (Function4 & Serializable & scala.Serializable)(x$79, x$80, x$81, x$82) -> SchemaComparator$.$anonfun$findInFields$7(newType, newField, x$79, BoxesRunTime.unboxToBoolean((Object)x$80), x$81, x$82), (Function2 & Serializable & scala.Serializable)(x$83, x$84) -> new SchemaChange.FieldArgumentAstDirectiveAdded(newType, newField, (Argument<?>)x$83, (sangria.ast.Directive)x$84), (Function2 & Serializable & scala.Serializable)(x$85, x$86) -> new SchemaChange.FieldArgumentAstDirectiveRemoved(newType, newField, (Argument<?>)x$85, (sangria.ast.Directive)x$86));
        return (Vector)((Vector)typeChanges.$plus$plus(argChanges, Vector$.MODULE$.canBuildFrom())).$plus$plus(directiveChanges, Vector$.MODULE$.canBuildFrom());
    }

    private Vector<SchemaChange> findInArgs(List<Argument<?>> oldArgs, List<Argument<?>> newArgs, Function2<Argument<?>, Object, SchemaChange> added, Function1<Argument<?>, SchemaChange> removed, Function3<Argument<?>, Option<String>, Option<String>, SchemaChange> description, Function3<Argument<?>, Option<Value>, Option<Value>, SchemaChange> function3, Function4<Argument<?>, Object, InputType<?>, InputType<?>, SchemaChange> typeChange, Function2<Argument<?>, sangria.ast.Directive, SchemaChange> dirAdded, Function2<Argument<?>, sangria.ast.Directive, SchemaChange> dirRemoved) {
        Set oldA = ((TraversableOnce)oldArgs.map((Function1 & Serializable & scala.Serializable)x$87 -> x$87.name(), List$.MODULE$.canBuildFrom())).toSet();
        Set newA = ((TraversableOnce)newArgs.map((Function1 & Serializable & scala.Serializable)x$88 -> x$88.name(), List$.MODULE$.canBuildFrom())).toSet();
        Vector remove = (Vector)oldA.diff((GenSet)newA).toVector().map((Function1 & Serializable & scala.Serializable)name -> (SchemaChange)removed.apply(oldArgs.find((Function1 & Serializable & scala.Serializable)x$89 -> BoxesRunTime.boxToBoolean((boolean)SchemaComparator$.$anonfun$findInArgs$4(name, x$89))).get()), Vector$.MODULE$.canBuildFrom());
        Vector add = (Vector)newA.diff((GenSet)oldA).toVector().map((Function1 & Serializable & scala.Serializable)name -> {
            Argument arg;
            return (SchemaChange)added.apply((Object)arg, (Object)BoxesRunTime.boxToBoolean((!MODULE$.isOptional(arg = (Argument)newArgs.find((Function1 & Serializable & scala.Serializable)x$90 -> BoxesRunTime.boxToBoolean((boolean)SchemaComparator$.$anonfun$findInArgs$6(name, x$90))).get()) ? 1 : 0) != 0));
        }, Vector$.MODULE$.canBuildFrom());
        Set changed = (Set)((TraversableLike)oldA.intersect((GenSet)newA)).flatMap((Function1 & Serializable & scala.Serializable)name -> {
            Argument oldArg = (Argument)oldArgs.find((Function1 & Serializable & scala.Serializable)x$91 -> BoxesRunTime.boxToBoolean((boolean)SchemaComparator$.$anonfun$findInArgs$8(name, x$91))).get();
            Argument newArg = (Argument)newArgs.find((Function1 & Serializable & scala.Serializable)x$92 -> BoxesRunTime.boxToBoolean((boolean)SchemaComparator$.$anonfun$findInArgs$9(name, x$92))).get();
            return (Vector)MODULE$.findDescriptionChanged(oldArg, newArg, (Function2<Option<String>, Option<String>, SchemaChange>)(Function2 & Serializable & scala.Serializable)(x$93, x$94) -> (SchemaChange)description.apply((Object)newArg, x$93, x$94)).$plus$plus(MODULE$.findInArg(oldArg, newArg, (Function2<Option<Value>, Option<Value>, SchemaChange>)(Function2 & Serializable & scala.Serializable)(x$95, x$96) -> (SchemaChange)function3.apply((Object)newArg, x$95, x$96), (Function3 & Serializable & scala.Serializable)(x$97, x$98, x$99) -> SchemaComparator$.$anonfun$findInArgs$12(typeChange, newArg, BoxesRunTime.unboxToBoolean((Object)x$97), x$98, x$99), (Function1<sangria.ast.Directive, SchemaChange>)(Function1 & Serializable & scala.Serializable)x$100 -> (SchemaChange)dirAdded.apply((Object)newArg, x$100), (Function1<sangria.ast.Directive, SchemaChange>)(Function1 & Serializable & scala.Serializable)x$101 -> (SchemaChange)dirRemoved.apply((Object)newArg, x$101)), Vector$.MODULE$.canBuildFrom());
        }, Set$.MODULE$.canBuildFrom());
        return (Vector)((Vector)remove.$plus$plus((GenTraversableOnce)add, Vector$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)changed, Vector$.MODULE$.canBuildFrom());
    }

    private Vector<SchemaChange> findInAstDirs(Vector<sangria.ast.Directive> oldDirectives, Vector<sangria.ast.Directive> newDirectives, Function1<sangria.ast.Directive, SchemaChange> added, Function1<sangria.ast.Directive, SchemaChange> removed) {
        Set oldD = ((TraversableOnce)oldDirectives.map((Function1 & Serializable & scala.Serializable)x$102 -> AstNode$.MODULE$.withoutAstLocations(x$102, AstNode$.MODULE$.withoutAstLocations$default$2()), Vector$.MODULE$.canBuildFrom())).toSet();
        Set newD = ((TraversableOnce)newDirectives.map((Function1 & Serializable & scala.Serializable)x$103 -> AstNode$.MODULE$.withoutAstLocations(x$103, AstNode$.MODULE$.withoutAstLocations$default$2()), Vector$.MODULE$.canBuildFrom())).toSet();
        Vector remove = (Vector)oldD.diff((GenSet)newD).toVector().map(removed, Vector$.MODULE$.canBuildFrom());
        Vector add = (Vector)newD.diff((GenSet)oldD).toVector().map(added, Vector$.MODULE$.canBuildFrom());
        return (Vector)remove.$plus$plus((GenTraversableOnce)add, Vector$.MODULE$.canBuildFrom());
    }

    private Vector<SchemaChange> findInArg(Argument<?> oldArg, Argument<?> newArg, Function2<Option<Value>, Option<Value>, SchemaChange> function2, Function3<Object, InputType<?>, InputType<?>, SchemaChange> typeChange, Function1<sangria.ast.Directive, SchemaChange> dirAdded, Function1<sangria.ast.Directive, SchemaChange> dirRemoved) {
        Vector vector;
        Option oldDefault = oldArg.defaultValue().flatMap((Function1 & Serializable & scala.Serializable)dv -> DefaultValueRenderer$.MODULE$.renderInputValue((Tuple2<?, ToInput<?, ?>>)dv, oldArg.argumentType(), MODULE$.coercionHelper()).map((Function1 & Serializable & scala.Serializable)v -> AstNode$.MODULE$.withoutAstLocations(v, AstNode$.MODULE$.withoutAstLocations$default$2())));
        Option newDefault = newArg.defaultValue().flatMap((Function1 & Serializable & scala.Serializable)dv -> DefaultValueRenderer$.MODULE$.renderInputValue((Tuple2<?, ToInput<?, ?>>)dv, newArg.argumentType(), MODULE$.coercionHelper()).map((Function1 & Serializable & scala.Serializable)v -> AstNode$.MODULE$.withoutAstLocations(v, AstNode$.MODULE$.withoutAstLocations$default$2())));
        Option option = oldDefault;
        Option option2 = newDefault;
        Vector withDefault = (option == null ? option2 != null : !option.equals(option2)) ? (Vector)package$.MODULE$.Vector().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SchemaChange[]{(SchemaChange)function2.apply((Object)oldDefault, (Object)newDefault)})) : package$.MODULE$.Vector().empty();
        String oldArgType = SchemaRenderer$.MODULE$.renderTypeName(oldArg.argumentType(), SchemaRenderer$.MODULE$.renderTypeName$default$2());
        String newArgType = SchemaRenderer$.MODULE$.renderTypeName(newArg.argumentType(), SchemaRenderer$.MODULE$.renderTypeName$default$2());
        String string = oldArgType;
        String string2 = newArgType;
        if (string == null ? string2 != null : !string.equals(string2)) {
            String string3 = SchemaRenderer$.MODULE$.renderTypeName(this.nonContainer(newArg), SchemaRenderer$.MODULE$.renderTypeName$default$2());
            String string4 = oldArgType;
            vector = (Vector)withDefault.$colon$plus(typeChange.apply((Object)BoxesRunTime.boxToBoolean(((string3 == null ? string4 != null : !string3.equals(string4)) ? 1 : 0) != 0), oldArg.argumentType(), newArg.argumentType()), Vector$.MODULE$.canBuildFrom());
        } else {
            vector = withDefault;
        }
        Vector withType = vector;
        Vector<SchemaChange> directiveChanges = this.findInAstDirs(oldArg.astDirectives(), newArg.astDirectives(), dirAdded, dirRemoved);
        return (Vector)withType.$plus$plus(directiveChanges, Vector$.MODULE$.canBuildFrom());
    }

    private Vector<SchemaChange> findInInputFields(InputObjectType<?> oldType, InputObjectType<?> newType, InputField<?> oldField, InputField<?> newField) {
        Vector vector;
        Option oldDefault = oldField.defaultValue().flatMap((Function1 & Serializable & scala.Serializable)dv -> DefaultValueRenderer$.MODULE$.renderInputValue((Tuple2<?, ToInput<?, ?>>)dv, oldField.fieldType(), MODULE$.coercionHelper()).map((Function1 & Serializable & scala.Serializable)v -> AstNode$.MODULE$.withoutAstLocations(v, AstNode$.MODULE$.withoutAstLocations$default$2())));
        Option newDefault = newField.defaultValue().flatMap((Function1 & Serializable & scala.Serializable)dv -> DefaultValueRenderer$.MODULE$.renderInputValue((Tuple2<?, ToInput<?, ?>>)dv, newField.fieldType(), MODULE$.coercionHelper()).map((Function1 & Serializable & scala.Serializable)v -> AstNode$.MODULE$.withoutAstLocations(v, AstNode$.MODULE$.withoutAstLocations$default$2())));
        Option option = oldDefault;
        Option option2 = newDefault;
        Vector withDefault = (option == null ? option2 != null : !option.equals(option2)) ? (Vector)package$.MODULE$.Vector().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SchemaChange.InputFieldDefaultChanged[]{new SchemaChange.InputFieldDefaultChanged(newType, newField, (Option<Value>)oldDefault, (Option<Value>)newDefault)})) : package$.MODULE$.Vector().empty();
        String oldFieldType = SchemaRenderer$.MODULE$.renderTypeName(oldField.fieldType(), SchemaRenderer$.MODULE$.renderTypeName$default$2());
        String newFieldType = SchemaRenderer$.MODULE$.renderTypeName(newField.fieldType(), SchemaRenderer$.MODULE$.renderTypeName$default$2());
        String string = oldFieldType;
        String string2 = newFieldType;
        if (string == null ? string2 != null : !string.equals(string2)) {
            String string3 = SchemaRenderer$.MODULE$.renderTypeName(this.nonContainer(newField), SchemaRenderer$.MODULE$.renderTypeName$default$2());
            String string4 = oldFieldType;
            vector = (Vector)withDefault.$colon$plus((Object)new SchemaChange.InputFieldTypeChanged(newType, newField, string3 == null ? string4 != null : !string3.equals(string4), oldField.fieldType(), newField.fieldType()), Vector$.MODULE$.canBuildFrom());
        } else {
            vector = withDefault;
        }
        Vector withType = vector;
        Vector<SchemaChange> directiveChanges = this.findInAstDirs(oldField.astDirectives(), newField.astDirectives(), (Function1<sangria.ast.Directive, SchemaChange>)(Function1 & Serializable & scala.Serializable)x$104 -> new SchemaChange.InputFieldAstDirectiveAdded(newType, newField, (sangria.ast.Directive)x$104), (Function1<sangria.ast.Directive, SchemaChange>)(Function1 & Serializable & scala.Serializable)x$105 -> new SchemaChange.InputFieldAstDirectiveRemoved(newType, newField, (sangria.ast.Directive)x$105));
        return (Vector)withType.$plus$plus(directiveChanges, Vector$.MODULE$.canBuildFrom());
    }

    private boolean isOptional(InputField<?> field) {
        InputType<?> inputType = field.fieldType();
        boolean bl = inputType instanceof OptionInputType;
        return bl;
    }

    private boolean isOptional(Argument<?> argument) {
        InputType<?> inputType = argument.argumentType();
        boolean bl = inputType instanceof OptionInputType;
        return bl;
    }

    private InputType<Object> nonContainer(InputField<?> field) {
        InputType<Object> inputType;
        InputType<Object> inputType2 = field.fieldType();
        if (inputType2 instanceof OptionInputType) {
            OptionInputType optionInputType = (OptionInputType)inputType2;
            InputType ofType = optionInputType.ofType();
            inputType = ofType;
        } else {
            inputType = inputType2;
        }
        return inputType;
    }

    private OutputType<Object> nonContainer(Field<?, ?> field) {
        OutputType<Object> outputType;
        OutputType<Object> outputType2 = field.fieldType();
        if (outputType2 instanceof OptionType) {
            OptionType optionType = (OptionType)outputType2;
            OutputType ofType = optionType.ofType();
            outputType = ofType;
        } else {
            outputType = outputType2;
        }
        return outputType;
    }

    private InputType<Object> nonContainer(Argument<?> argument) {
        InputType<Object> inputType;
        InputType<Object> inputType2 = argument.argumentType();
        if (inputType2 instanceof OptionInputType) {
            OptionInputType optionInputType = (OptionInputType)inputType2;
            InputType ofType = optionInputType.ofType();
            inputType = ofType;
        } else {
            inputType = inputType2;
        }
        return inputType;
    }

    private Vector<SchemaChange> findDescriptionChanged(HasDescription o, HasDescription n, Function2<Option<String>, Option<String>, SchemaChange> fn) {
        Option<String> option = o.description();
        Option<String> option2 = n.description();
        return (option == null ? option2 != null : !option.equals(option2)) ? (Vector)package$.MODULE$.Vector().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SchemaChange[]{(SchemaChange)fn.apply(o.description(), n.description())})) : package$.MODULE$.Vector().empty();
    }

    private Vector<SchemaChange> findDeprecationChanged(HasDeprecation o, HasDeprecation n, Function2<Option<String>, Option<String>, SchemaChange> fn) {
        Option<String> option = o.deprecationReason();
        Option<String> option2 = n.deprecationReason();
        return (option == null ? option2 != null : !option.equals(option2)) ? (Vector)package$.MODULE$.Vector().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SchemaChange[]{(SchemaChange)fn.apply(o.deprecationReason(), n.deprecationReason())})) : package$.MODULE$.Vector().empty();
    }

    private ValueCoercionHelper<Object> coercionHelper() {
        return this.coercionHelper;
    }

    public static final /* synthetic */ SchemaChange.DirectiveArgumentAdded $anonfun$findInDirective$1(Directive newDir$2, Argument x$5, boolean x$6) {
        return new SchemaChange.DirectiveArgumentAdded(newDir$2, x$5, x$6);
    }

    public static final /* synthetic */ SchemaChange.DirectiveArgumentTypeChanged $anonfun$findInDirective$5(Directive newDir$2, Argument x$14, boolean x$15, InputType x$16, InputType x$17) {
        return new SchemaChange.DirectiveArgumentTypeChanged(newDir$2, x$14, x$15, x$16, x$17);
    }

    public static final /* synthetic */ SchemaChange.TypeDescriptionChanged $anonfun$findChangesInTypes$1(Type newType$1, Option x$28, Option x$29) {
        return new SchemaChange.TypeDescriptionChanged(newType$1, (Option<String>)x$28, (Option<String>)x$29);
    }

    public static final /* synthetic */ boolean $anonfun$findInUnionTypes$4(String name$1, ObjectType x$32) {
        String string = x$32.name();
        String string2 = name$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$findInUnionTypes$6(String name$2, ObjectType x$33) {
        String string = x$33.name();
        String string2 = name$2;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$findInObjectTypeInterfaces$4(String name$3, InterfaceType x$60) {
        String string = x$60.name();
        String string2 = name$3;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$findInObjectTypeInterfaces$6(String name$4, InterfaceType x$61) {
        String string = x$61.name();
        String string2 = name$4;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ SchemaChange.ObjectTypeArgumentAdded $anonfun$findInFields$3(ObjectLikeType newType$10, Field newField$3, Argument x$70, boolean x$71) {
        return new SchemaChange.ObjectTypeArgumentAdded(newType$10, newField$3, x$70, x$71);
    }

    public static final /* synthetic */ SchemaChange.ObjectTypeArgumentTypeChanged $anonfun$findInFields$7(ObjectLikeType newType$10, Field newField$3, Argument x$79, boolean x$80, InputType x$81, InputType x$82) {
        return new SchemaChange.ObjectTypeArgumentTypeChanged(newType$10, newField$3, x$79, x$80, x$81, x$82);
    }

    public static final /* synthetic */ boolean $anonfun$findInArgs$4(String name$5, Argument x$89) {
        String string = x$89.name();
        String string2 = name$5;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$findInArgs$6(String name$6, Argument x$90) {
        String string = x$90.name();
        String string2 = name$6;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$findInArgs$8(String name$7, Argument x$91) {
        String string = x$91.name();
        String string2 = name$7;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$findInArgs$9(String name$7, Argument x$92) {
        String string = x$92.name();
        String string2 = name$7;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ SchemaChange $anonfun$findInArgs$12(Function4 typeChange$1, Argument newArg$1, boolean x$97, InputType x$98, InputType x$99) {
        return (SchemaChange)typeChange$1.apply((Object)newArg$1, (Object)BoxesRunTime.boxToBoolean((boolean)x$97), (Object)x$98, (Object)x$99);
    }

    private SchemaComparator$() {
        MODULE$ = this;
        this.coercionHelper = new ValueCoercionHelper(ValueCoercionHelper$.MODULE$.$lessinit$greater$default$1(), ValueCoercionHelper$.MODULE$.$lessinit$greater$default$2(), ValueCoercionHelper$.MODULE$.$lessinit$greater$default$3());
    }
}

