/*
 * Decompiled with CFR 0.152.
 */
package sangria.schema;

import sangria.ast.AstLocation;
import sangria.parser.SourceMapper;
import sangria.schema.Argument;
import sangria.schema.Directive;
import sangria.schema.EnumType;
import sangria.schema.EnumValue;
import sangria.schema.Field;
import sangria.schema.HasAstInfo;
import sangria.schema.InputField;
import sangria.schema.InputObjectType;
import sangria.schema.InterfaceType;
import sangria.schema.Named;
import sangria.schema.Named$;
import sangria.schema.ObjectLikeType;
import sangria.schema.ObjectType;
import sangria.schema.ScalarType;
import sangria.schema.Schema;
import sangria.schema.SchemaElementValidator;
import sangria.schema.Type;
import sangria.schema.UnionType;
import sangria.validation.InvalidDirectiveArgumentNameViolation;
import sangria.validation.InvalidDirectiveNameViolation;
import sangria.validation.InvalidEnumValueNameViolation;
import sangria.validation.InvalidFieldArgumentNameViolation;
import sangria.validation.InvalidFieldNameViolation;
import sangria.validation.InvalidInputFieldNameViolation;
import sangria.validation.InvalidTypeNameViolation;
import sangria.validation.Violation;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Vector;
import scala.package$;

public final class ValidNamesValidator$
implements SchemaElementValidator {
    public static ValidNamesValidator$ MODULE$;
    private final String explanation;

    static {
        new ValidNamesValidator$();
    }

    @Override
    public Option<SourceMapper> sourceMapper(Schema<?, ?> schema) {
        return SchemaElementValidator.sourceMapper$(this, schema);
    }

    @Override
    public List<AstLocation> location(HasAstInfo elem) {
        return SchemaElementValidator.location$(this, elem);
    }

    private String explanation() {
        return this.explanation;
    }

    public Vector<InvalidTypeNameViolation> validateUnionType(Schema<?, ?> schema, UnionType<?> tpe) {
        return this.validateType(schema, tpe, "Union");
    }

    public Vector<InvalidTypeNameViolation> validateEnumType(Schema<?, ?> schema, EnumType<?> tpe) {
        return this.validateType(schema, tpe, "Enum");
    }

    public Vector<InvalidTypeNameViolation> validateInputObjectType(Schema<?, ?> schema, InputObjectType<?> tpe) {
        return this.validateType(schema, tpe, "Input");
    }

    public Vector<InvalidTypeNameViolation> validateObjectType(Schema<?, ?> schema, ObjectType<?, ?> tpe) {
        return this.validateType(schema, tpe, "Object");
    }

    public Vector<InvalidTypeNameViolation> validateInterfaceType(Schema<?, ?> schema, InterfaceType<?, ?> tpe) {
        return this.validateType(schema, tpe, "Interface");
    }

    public Vector<InvalidTypeNameViolation> validateScalarType(Schema<?, ?> schema, ScalarType<?> tpe) {
        return this.validateType(schema, tpe, "Scalar");
    }

    public Vector<InvalidTypeNameViolation> validateType(Schema<?, ?> schema, Type tpe, String kind) {
        return !Named$.MODULE$.isValidName(((Named)((Object)tpe)).name()) ? (Vector)package$.MODULE$.Vector().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new InvalidTypeNameViolation[]{new InvalidTypeNameViolation(kind, ((Named)((Object)tpe)).name(), this.explanation(), this.sourceMapper(schema), this.location((HasAstInfo)((Object)tpe)))})) : package$.MODULE$.Vector().empty();
    }

    @Override
    public Vector<Violation> validateEnumValue(Schema<?, ?> schema, EnumType<?> tpe, EnumValue<?> value) {
        return !Named$.MODULE$.isValidName(value.name()) ? (Vector)package$.MODULE$.Vector().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new InvalidEnumValueNameViolation[]{new InvalidEnumValueNameViolation(tpe.name(), value.name(), this.explanation(), this.sourceMapper(schema), this.location(value))})) : package$.MODULE$.Vector().empty();
    }

    @Override
    public Vector<Violation> validateField(Schema<?, ?> schema, ObjectLikeType<?, ?> tpe, Field<?, ?> field) {
        return !Named$.MODULE$.isValidName(field.name()) ? (Vector)package$.MODULE$.Vector().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new InvalidFieldNameViolation[]{new InvalidFieldNameViolation(tpe.name(), field.name(), this.explanation(), this.sourceMapper(schema), this.location(field))})) : package$.MODULE$.Vector().empty();
    }

    @Override
    public Vector<Violation> validateFieldArgument(Schema<?, ?> schema, ObjectLikeType<?, ?> tpe, Field<?, ?> field, Argument<?> argument) {
        return !Named$.MODULE$.isValidName(argument.name()) ? (Vector)package$.MODULE$.Vector().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new InvalidFieldArgumentNameViolation[]{new InvalidFieldArgumentNameViolation(tpe.name(), field.name(), argument.name(), this.explanation(), this.sourceMapper(schema), this.location(argument))})) : package$.MODULE$.Vector().empty();
    }

    @Override
    public Vector<Violation> validateInputField(Schema<?, ?> schema, InputObjectType<?> tpe, InputField<?> field) {
        return !Named$.MODULE$.isValidName(field.name()) ? (Vector)package$.MODULE$.Vector().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new InvalidInputFieldNameViolation[]{new InvalidInputFieldNameViolation(tpe.name(), field.name(), this.explanation(), this.sourceMapper(schema), this.location(field))})) : package$.MODULE$.Vector().empty();
    }

    @Override
    public Vector<Violation> validateDirective(Schema<?, ?> schema, Directive tpe) {
        return !Named$.MODULE$.isValidName(tpe.name()) ? (Vector)package$.MODULE$.Vector().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new InvalidDirectiveNameViolation[]{new InvalidDirectiveNameViolation(tpe.name(), this.explanation(), (Option<SourceMapper>)None$.MODULE$, (List<AstLocation>)Nil$.MODULE$)})) : package$.MODULE$.Vector().empty();
    }

    @Override
    public Vector<Violation> validateDirectiveArgument(Schema<?, ?> schema, Directive tpe, Argument<?> argument) {
        return !Named$.MODULE$.isValidName(argument.name()) ? (Vector)package$.MODULE$.Vector().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new InvalidDirectiveArgumentNameViolation[]{new InvalidDirectiveArgumentNameViolation(tpe.name(), argument.name(), this.explanation(), this.sourceMapper(schema), this.location(argument))})) : package$.MODULE$.Vector().empty();
    }

    private ValidNamesValidator$() {
        MODULE$ = this;
        SchemaElementValidator.$init$(this);
        this.explanation = new StringBuilder(45).append("Valid names must satisfy following regex: /").append(Named$.MODULE$.NameRegexp()).append("/.").toString();
    }
}

