/*
 * Decompiled with CFR 0.152.
 */
package org.savara.activity.notifier.jms;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.naming.InitialContext;
import org.savara.activity.ActivityNotifier;
import org.savara.activity.model.Activity;
import org.savara.activity.util.ActivityModelUtil;
import org.savara.common.config.Configuration;

public class JMSActivityNotifier
implements ActivityNotifier {
    public static final String JMS_DESTINATION = "savara.activity.notifier.jms.destination";
    public static final String JMS_CONNECTION_FACTORY = "savara.activity.notifier.jms.connection.factory";
    private static Logger logger = Logger.getLogger(JMSActivityNotifier.class.getName());
    private String m_jndiInitialContextFactory = null;
    private String m_jndiProviderURL = null;
    private String m_jndiFactoryURLPackages = null;
    private String m_jmsConnectionFactory = null;
    private String m_jmsDestination = null;
    private Connection m_connection = null;
    private Session m_session = null;
    private MessageProducer m_producer = null;

    public void setConfiguration(Configuration config) {
        logger.info("Initializing SAVARA JMS Activity Notifier");
        if (this.m_jndiInitialContextFactory == null) {
            this.m_jndiInitialContextFactory = config.getProperty("java.naming.factory.initial");
        }
        if (this.m_jndiProviderURL == null) {
            this.m_jndiProviderURL = config.getProperty("java.naming.provider.url");
        }
        if (this.m_jndiFactoryURLPackages == null) {
            this.m_jndiFactoryURLPackages = config.getProperty("java.naming.factory.url.pkgs");
        }
        if (this.m_jmsConnectionFactory == null) {
            this.m_jmsConnectionFactory = config.getProperty(JMS_CONNECTION_FACTORY);
        }
        if (this.m_jmsDestination == null) {
            this.m_jmsDestination = config.getProperty(JMS_DESTINATION);
        }
        InitialContext ctx = null;
        try {
            if (this.m_jndiInitialContextFactory != null) {
                Properties jndiProps = new Properties();
                jndiProps.setProperty("java.naming.factory.initial", this.m_jndiInitialContextFactory);
                jndiProps.setProperty("java.naming.provider.url", this.m_jndiProviderURL);
                if (this.m_jndiFactoryURLPackages != null) {
                    jndiProps.setProperty("java.naming.factory.url.pkgs", this.m_jndiFactoryURLPackages);
                }
                ctx = new InitialContext(jndiProps);
            } else {
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("Creating default initial context");
                }
                ctx = new InitialContext();
            }
        }
        catch (Exception e) {
            logger.severe("Failed to create JNDI initial context: " + e);
        }
        if (ctx != null) {
            try {
                ConnectionFactory factory = (ConnectionFactory)ctx.lookup(this.m_jmsConnectionFactory);
                this.m_connection = factory.createConnection();
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("Connection: " + this.m_connection);
                }
                Destination dest = (Destination)ctx.lookup(this.m_jmsDestination);
                this.m_session = this.m_connection.createSession(false, 1);
                this.m_producer = this.m_session.createProducer(dest);
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine(Thread.currentThread() + ": Created JMS Activity Notifier connection");
                }
            }
            catch (Exception e) {
                logger.severe("Failed to create JMS connection: " + e);
            }
        }
    }

    public void setJNDIInitialContextFactory(String factory) {
        this.m_jndiInitialContextFactory = factory;
    }

    public void setJNDIProviderURL(String url) {
        this.m_jndiProviderURL = url;
    }

    public void setJNDIFactoryURLPackages(String pkgs) {
        this.m_jndiFactoryURLPackages = pkgs;
    }

    public void setJMSConnectionFactory(String cf) {
        this.m_jmsConnectionFactory = cf;
    }

    public void setJMSDestination(String dest) {
        this.m_jmsDestination = dest;
    }

    public void publish(Activity activity) {
        if (this.m_producer != null) {
            try {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                ActivityModelUtil.serialize((Activity)activity, (OutputStream)os);
                String act = new String(os.toByteArray());
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine(act);
                }
                TextMessage tm = this.m_session.createTextMessage(act);
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest(Thread.currentThread() + ": Sending JMS ServiceTracker record=" + tm);
                }
                this.m_producer.send((Message)tm);
            }
            catch (Exception e) {
                logger.severe("Failed to publish message: " + e);
            }
        } else {
            logger.warning("Could not publish message: " + activity);
        }
    }

    public void close() {
        try {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(Thread.currentThread() + ": Closing JMS Activity Notifier connection");
            }
            if (this.m_session != null) {
                this.m_session.close();
                this.m_session = null;
            }
            if (this.m_connection != null) {
                this.m_connection.close();
                this.m_connection = null;
            }
        }
        catch (Exception e) {
            logger.severe("Failed to close JMS connection: " + e);
        }
    }
}

