/*
 * Decompiled with CFR 0.152.
 */
package org.savara.activity;

import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.savara.activity.ActivityAnalyser;
import org.savara.activity.ActivityFilter;
import org.savara.activity.ActivityNotifier;
import org.savara.activity.ActivityProcessor;
import org.savara.activity.ActivityStore;
import org.savara.activity.ActivityValidator;
import org.savara.activity.model.Activity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultActivityProcessor
implements ActivityProcessor {
    private List<ActivityAnalyser> m_analysers = new Vector<ActivityAnalyser>();
    private List<ActivityFilter> m_filters = new Vector<ActivityFilter>();
    private List<ActivityValidator> m_validators = new Vector<ActivityValidator>();
    private List<ActivityStore> m_stores = new Vector<ActivityStore>();
    private List<ActivityNotifier> m_notifiers = new Vector<ActivityNotifier>();

    protected List<ActivityAnalyser> getAnalysers() {
        return this.m_analysers;
    }

    protected List<ActivityFilter> getFilters() {
        return this.m_filters;
    }

    protected List<ActivityValidator> getValidators() {
        return this.m_validators;
    }

    protected List<ActivityStore> getStores() {
        return this.m_stores;
    }

    protected List<ActivityNotifier> getNotifiers() {
        return this.m_notifiers;
    }

    @Override
    public void addActivityAnalyser(ActivityAnalyser analyser) {
        this.m_analysers.add(analyser);
    }

    @Override
    public void removeActivityAnalyser(ActivityAnalyser analyser) {
        this.m_analysers.remove(analyser);
    }

    @Override
    public void addActivityFilter(ActivityFilter filter) {
        this.m_filters.add(filter);
    }

    @Override
    public void removeActivityFilter(ActivityFilter filter) {
        this.m_filters.remove(filter);
    }

    @Override
    public void addActivityValidator(ActivityValidator validator) {
        this.m_validators.add(validator);
    }

    @Override
    public void removeActivityValidator(ActivityValidator validator) {
        this.m_validators.remove(validator);
    }

    @Override
    public void addActivityNotifier(ActivityNotifier notifier) {
        this.m_notifiers.add(notifier);
    }

    @Override
    public void removeActivityNotifier(ActivityNotifier notifier) {
        this.m_notifiers.remove(notifier);
    }

    @Override
    public void addActivityStore(ActivityStore store) {
        this.m_stores.add(store);
    }

    @Override
    public void removeActivityStore(ActivityStore store) {
        this.m_stores.remove(store);
    }

    @Override
    public void process(Activity activity) {
        ActivityFilter af;
        for (ActivityAnalyser aa : this.getAnalysers()) {
            aa.analyse(activity);
        }
        boolean process = this.getFilters().size() == 0;
        Iterator<Object> i$ = this.getFilters().iterator();
        while (i$.hasNext() && !(process = (af = i$.next()).isRelevant(activity))) {
        }
        if (process) {
            for (ActivityValidator av : this.getValidators()) {
                av.validate(activity);
            }
            for (ActivityStore as : this.getStores()) {
                as.store(activity);
            }
            for (ActivityNotifier an : this.getNotifiers()) {
                an.publish(activity);
            }
        }
    }
}

