/*
 * Decompiled with CFR 0.152.
 */
package org.savara.activity.osgi;

import java.util.Dictionary;
import java.util.Properties;
import java.util.logging.Logger;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.savara.activity.ActivityAnalyser;
import org.savara.activity.ActivityProcessor;
import org.savara.activity.ActivityProcessorFactory;
import org.savara.activity.ActivityValidator;

public class Activator
implements BundleActivator {
    private static BundleContext context;
    private ServiceTracker m_activityAnalyserTracker = null;
    private ServiceTracker m_activityValidatorTracker = null;
    private static final Logger _log;

    static BundleContext getContext() {
        return context;
    }

    public void start(BundleContext bundleContext) throws Exception {
        context = bundleContext;
        Properties props = new Properties();
        final ActivityProcessor avm = ActivityProcessorFactory.getActivityProcessor();
        context.registerService(ActivityProcessor.class.getName(), (Object)avm, (Dictionary)props);
        _log.fine("Registered Activity Validation Manager");
        this.m_activityValidatorTracker = new ServiceTracker(context, ActivityValidator.class.getName(), null){

            public Object addingService(ServiceReference ref) {
                Object ret = super.addingService(ref);
                _log.fine("Activity validator has been added: " + ret);
                avm.addActivityValidator((ActivityValidator)ret);
                return ret;
            }
        };
        this.m_activityValidatorTracker.open();
        this.m_activityAnalyserTracker = new ServiceTracker(context, ActivityAnalyser.class.getName(), null){

            public Object addingService(ServiceReference ref) {
                Object ret = super.addingService(ref);
                _log.fine("Activity analyser has been added: " + ret);
                avm.addActivityAnalyser((ActivityAnalyser)ret);
                return ret;
            }
        };
        this.m_activityAnalyserTracker.open();
    }

    public void stop(BundleContext bundleContext) throws Exception {
        context = null;
    }

    static {
        _log = Logger.getLogger(Activator.class.getName());
    }
}

