/*
 * Decompiled with CFR 0.152.
 */
package org.savara.bpel.parser.rules;

import java.util.List;
import org.savara.bpel.model.TReceive;
import org.savara.bpel.model.TVariable;
import org.savara.bpel.parser.rules.ConversionContext;
import org.savara.bpel.parser.rules.ProtocolParserRule;
import org.savara.bpel.util.BPELInteractionUtil;
import org.savara.bpel.util.PartnerLinkUtil;
import org.savara.bpel.util.TypeReferenceUtil;
import org.scribble.common.logging.Journal;
import org.scribble.protocol.model.Activity;
import org.scribble.protocol.model.Interaction;
import org.scribble.protocol.model.MessageSignature;
import org.scribble.protocol.model.Role;
import org.scribble.protocol.model.TypeReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReceiveParserRule
implements ProtocolParserRule {
    @Override
    public boolean isSupported(Object component) {
        return component instanceof TReceive;
    }

    @Override
    public void convert(ConversionContext context, Object component, List<Activity> activities, Journal journal) {
        TReceive elem = (TReceive)component;
        Interaction interaction = new Interaction();
        TVariable var = context.getVariable(elem.getVariable());
        String xmlType = BPELInteractionUtil.getXMLType(context.getProcess(), var.getMessageType(), context.getProtocolContext().getResourceLocator());
        TypeReference tref = TypeReferenceUtil.createTypeReference(xmlType, context);
        MessageSignature ms = new MessageSignature();
        ms.setOperation(elem.getOperation());
        ms.getTypeReferences().add(tref);
        String fromRole = PartnerLinkUtil.getServerPartnerRole(elem.getPartnerLink());
        if (fromRole != null && fromRole.equals(context.getRole())) {
            fromRole = PartnerLinkUtil.getClientPartnerRole(elem.getPartnerLink());
        }
        if (fromRole != null) {
            interaction.setFromRole(new Role(fromRole));
        }
        interaction.setMessageSignature(ms);
        activities.add((Activity)interaction);
    }
}

