/*
 * Decompiled with CFR 0.152.
 */
package org.savara.bpel.parser.rules;

import java.util.List;
import org.savara.bpel.model.TActivity;
import org.savara.bpel.model.TElseif;
import org.savara.bpel.model.TIf;
import org.savara.bpel.parser.rules.ParserContext;
import org.savara.bpel.parser.rules.ProtocolParserRule;
import org.savara.bpel.util.ActivityUtil;
import org.savara.common.logging.FeedbackHandler;
import org.scribble.protocol.model.Activity;
import org.scribble.protocol.model.Choice;
import org.scribble.protocol.model.Interaction;
import org.scribble.protocol.model.ModelObject;
import org.scribble.protocol.model.Role;
import org.scribble.protocol.model.When;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IfParserRule
implements ProtocolParserRule {
    @Override
    public boolean isSupported(Object component) {
        return component instanceof TIf;
    }

    @Override
    public void parse(ParserContext context, Object component, List<Activity> activities, FeedbackHandler handler) {
        TIf bpelElem = (TIf)component;
        Choice elem = new Choice();
        When cb = new When();
        TActivity act = ActivityUtil.getActivity(bpelElem);
        if (act != null) {
            context.parse(act, cb.getBlock().getContents(), handler);
            if (cb.getBlock().getContents().size() > 0 && cb.getBlock().getContents().get(0) instanceof Interaction) {
                Interaction interaction = (Interaction)cb.getBlock().getContents().get(0);
                cb.getBlock().getContents().remove(0);
                cb.derivedFrom((ModelObject)interaction);
                cb.setMessageSignature(interaction.getMessageSignature());
                elem.setFromRole(interaction.getFromRole());
                if (interaction.getToRoles().size() > 0) {
                    elem.setToRole((Role)interaction.getToRoles().get(0));
                }
            } else {
                handler.error("Main block of if does not contain an initial interaction", null);
            }
        }
        elem.getWhens().add(cb);
        for (int i = 0; i < bpelElem.getElseif().size(); ++i) {
            TElseif elseIfElem = bpelElem.getElseif().get(i);
            cb = new When();
            context.parse(elseIfElem, cb.getBlock().getContents(), handler);
            this.setupWhenMs(elem, cb, handler);
            elem.getWhens().add(cb);
        }
        if (bpelElem.getElse() != null) {
            cb = new When();
            context.parse(bpelElem.getElse(), cb.getBlock().getContents(), handler);
            this.setupWhenMs(elem, cb, handler);
            elem.getWhens().add(cb);
        }
        activities.add((Activity)elem);
    }

    protected void setupWhenMs(Choice elem, When cb, FeedbackHandler handler) {
        if (cb.getBlock().getContents().size() > 0 && cb.getBlock().getContents().get(0) instanceof Interaction) {
            Interaction interaction = (Interaction)cb.getBlock().getContents().get(0);
            cb.getBlock().getContents().remove(0);
            cb.derivedFrom((ModelObject)interaction);
            cb.setMessageSignature(interaction.getMessageSignature());
            if (elem.getFromRole() != null) {
                if (interaction.getFromRole() != null) {
                    if (!elem.getFromRole().equals((Object)interaction.getFromRole())) {
                        handler.error("ElseIf path has interaction with incompatible 'from' role", null);
                    }
                } else {
                    handler.error("ElseIf path does not contain a required 'from' role", null);
                }
            }
            elem.setFromRole(interaction.getFromRole());
            if (elem.getToRole() != null) {
                if (interaction.getToRoles().size() > 0) {
                    if (!elem.getToRole().equals(interaction.getToRoles().get(0))) {
                        handler.error("ElseIf path has interaction with incompatible 'to' role", null);
                    }
                } else {
                    handler.error("ElseIf path does not contain a required 'to' role", null);
                }
            }
        } else {
            handler.error("Main block of if does not contain an initial interaction", null);
        }
    }
}

