/*
 * Decompiled with CFR 0.152.
 */
package org.savara.bpel.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.wsdl.Definition;
import javax.wsdl.Message;
import javax.wsdl.Part;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.namespace.QName;
import org.savara.bpel.model.ObjectFactory;
import org.savara.bpel.model.TActivity;
import org.savara.bpel.model.TExtensibleElements;
import org.savara.bpel.model.TImport;
import org.savara.bpel.model.TInvoke;
import org.savara.bpel.model.TProcess;
import org.savara.bpel.model.TScope;
import org.savara.bpel.model.TSequence;
import org.savara.common.resources.ResourceLocator;
import org.savara.common.util.XMLUtils;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class BPELInteractionUtil {
    private static Logger logger = Logger.getLogger(BPELInteractionUtil.class.getName());

    public static TInvoke getInvoke(TActivity act) {
        TInvoke ret = null;
        if (act instanceof TInvoke) {
            ret = (TInvoke)act;
        } else if (act instanceof TSequence && ((TSequence)act).getActivity().size() > 0 && ((TSequence)act).getActivity().get(0) instanceof TInvoke) {
            ret = (TInvoke)((TSequence)act).getActivity().get(0);
        }
        return ret;
    }

    public static int countInvokes(TExtensibleElements scope) {
        Element elem = null;
        try {
            elem = BPELInteractionUtil.convertScopeToDOM(scope);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        int ret = 0;
        if (elem != null) {
            ret = BPELInteractionUtil.countInvokes(elem);
        }
        return ret;
    }

    public static int countInvokes(Element elem) {
        int ret = 0;
        if (elem.getLocalName().equals("invoke")) {
            ret = 1;
        } else {
            NodeList nl = elem.getChildNodes();
            for (int i = 0; i < nl.getLength(); ++i) {
                if (!(nl.item(i) instanceof Element)) continue;
                ret += BPELInteractionUtil.countInvokes((Element)nl.item(i));
            }
        }
        return ret;
    }

    protected static Element convertScopeToDOM(TExtensibleElements desc) throws IOException {
        Element ret = null;
        try {
            ObjectFactory factory = new ObjectFactory();
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{desc.getClass()});
            Marshaller marshaller = context.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            if (desc instanceof TProcess) {
                marshaller.marshal(factory.createProcess((TProcess)desc), (OutputStream)baos);
            } else if (desc instanceof TScope) {
                marshaller.marshal(factory.createScope((TScope)desc), (OutputStream)baos);
            }
            baos.close();
            ret = (Element)XMLUtils.getNode((String)baos.toString());
        }
        catch (Exception e) {
            throw new IOException("Failed to serialize scope", e);
        }
        return ret;
    }

    public static String getXMLType(TProcess process, QName wsdlMessageType, ResourceLocator locator) {
        String ret = null;
        String namespace = wsdlMessageType.getNamespaceURI();
        for (TImport imp : process.getImport()) {
            if (imp.getNamespace() == null || !imp.getNamespace().equals(namespace) || imp.getLocation() == null || !imp.getLocation().endsWith(".wsdl")) continue;
            try {
                URI uri = locator.getResourceURI(imp.getLocation());
                if (uri == null || (ret = BPELInteractionUtil.getXMLType(wsdlMessageType, uri)) == null) continue;
                break;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    public static String getXMLType(QName wsdlMessageType, URI uri) {
        String ret = null;
        try {
            Message mesg;
            WSDLReader reader = WSDLFactory.newInstance().newWSDLReader();
            Definition defn = reader.readWSDL(uri.toString());
            if (defn != null && (mesg = defn.getMessage(wsdlMessageType)) != null && mesg.getParts().size() == 1) {
                Part part = (Part)mesg.getParts().values().iterator().next();
                if (part.getElementName() != null) {
                    ret = part.getElementName().toString();
                } else if (part.getTypeName() != null) {
                    ret = part.getTypeName().toString();
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to read WSDL", e);
        }
        return ret;
    }
}

