/*
 * Decompiled with CFR 0.152.
 */
package org.savara.bpel.model.change;

import java.util.Iterator;
import java.util.List;
import org.savara.bpel.model.TImport;
import org.savara.bpel.model.TProcess;
import org.savara.bpel.model.TSequence;
import org.savara.bpel.model.change.AbstractBPELModelChangeRule;
import org.savara.bpel.util.ImportUtil;
import org.savara.contract.model.Contract;
import org.savara.contract.model.Interface;
import org.savara.protocol.model.change.ModelChangeContext;
import org.savara.protocol.model.change.ModelChangeUtils;
import org.scribble.protocol.model.ModelObject;
import org.scribble.protocol.model.Protocol;
import org.scribble.protocol.model.ProtocolModel;
import org.scribble.protocol.model.Role;

public class ProtocolModelChangeRule
extends AbstractBPELModelChangeRule {
    public boolean isInsertSupported(ModelChangeContext context, ProtocolModel model, ModelObject mobj, ModelObject ref) {
        boolean ret = false;
        if (mobj instanceof Protocol && this.isBPELModel(model)) {
            ret = true;
        }
        return ret;
    }

    public boolean insert(ModelChangeContext context, ProtocolModel model, ModelObject mobj, ModelObject ref) {
        TProcess bpelModel = this.getBPELModel(model);
        Protocol conv = (Protocol)mobj;
        String roleNamespace = null;
        TSequence seq = new TSequence();
        if (conv.getParent() instanceof ProtocolModel) {
            bpelModel.setName(conv.getName() + "_" + conv.getLocatedRole().getName());
            Contract contract = ModelChangeUtils.getContract((ModelChangeContext)context, (Role)conv.getLocatedRole());
            if (contract != null) {
                roleNamespace = contract.getNamespace();
                bpelModel.setTargetNamespace(contract.getNamespace());
            }
            this.addImport(context, bpelModel, conv, conv.getLocatedRole());
            List roles = conv.getRoles();
            for (Role r : roles) {
                this.addImport(context, bpelModel, conv, r);
            }
            TImport imp = new TImport();
            imp.setLocation(bpelModel.getName() + "Artifacts.wsdl");
            imp.setNamespace(roleNamespace);
            imp.setImportType("http://schemas.xmlsoap.org/wsdl/");
            bpelModel.getImport().add(imp);
            bpelModel.setSequence(seq);
            List acts = conv.getBlock().getContents();
            Object parent = context.getParent();
            context.setParent((Object)seq);
            for (int i = 0; i < acts.size(); ++i) {
                context.insert(model, (ModelObject)acts.get(i), null);
            }
            context.setParent(parent);
            return true;
        }
        return false;
    }

    protected void addImport(ModelChangeContext context, TProcess bpelModel, Protocol conv, Role role) {
        Contract contract = ModelChangeUtils.getContract((ModelChangeContext)context, (Role)role);
        if (contract != null) {
            boolean gen = false;
            Iterator iter = contract.getInterfaces().iterator();
            while (!gen && iter.hasNext()) {
                Interface intf = (Interface)iter.next();
                if (intf.getMessageExchangePatterns().size() <= 0) continue;
                gen = true;
            }
            if (gen) {
                String fileName = ImportUtil.getWSDLFileName(role, conv.getName(), "");
                TImport imp = new TImport();
                imp.setLocation(fileName);
                imp.setNamespace(contract.getNamespace());
                imp.setImportType("http://schemas.xmlsoap.org/wsdl/");
                bpelModel.getImport().add(imp);
            }
        }
    }
}

