/*
 * Decompiled with CFR 0.152.
 */
package org.savara.bpel.parser.rules;

import java.util.List;
import org.savara.bpel.model.TActivity;
import org.savara.bpel.model.TOnMessage;
import org.savara.bpel.model.TPick;
import org.savara.bpel.model.TVariable;
import org.savara.bpel.parser.rules.ParserContext;
import org.savara.bpel.parser.rules.ProtocolParserRule;
import org.savara.bpel.util.ActivityUtil;
import org.savara.bpel.util.BPELInteractionUtil;
import org.savara.bpel.util.PartnerLinkUtil;
import org.savara.bpel.util.TypeReferenceUtil;
import org.savara.common.logging.FeedbackHandler;
import org.scribble.protocol.model.Activity;
import org.scribble.protocol.model.Block;
import org.scribble.protocol.model.Choice;
import org.scribble.protocol.model.Interaction;
import org.scribble.protocol.model.MessageSignature;
import org.scribble.protocol.model.Role;
import org.scribble.protocol.model.TypeReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PickParserRule
implements ProtocolParserRule {
    @Override
    public boolean isSupported(Object component) {
        return component instanceof TPick;
    }

    @Override
    public void parse(ParserContext context, Object component, List<Activity> activities, FeedbackHandler handler) {
        TPick pick = (TPick)component;
        Choice elem = new Choice();
        Role fromRole = null;
        for (int i = 0; i < pick.getOnMessage().size(); ++i) {
            TOnMessage onMessageElem = pick.getOnMessage().get(i);
            Block cb = new Block();
            context.parse(onMessageElem, cb.getContents(), handler);
            String fromRoleName = PartnerLinkUtil.getServerPartnerRole(onMessageElem.getPartnerLink());
            if (i == 0) {
                if (fromRoleName != null) {
                    fromRole = new Role(fromRoleName);
                }
            } else if (fromRoleName != null && fromRole != null && !fromRoleName.equals(fromRole.getName())) {
                handler.error("Pick path has different from roles", null);
            }
            elem.setRole(fromRole);
            TVariable var = context.getVariable(onMessageElem.getVariable());
            String xmlType = BPELInteractionUtil.getXMLType(context.getProcess(), var.getMessageType(), context.getResourceLocator());
            TypeReference tref = TypeReferenceUtil.createTypeReference(xmlType, context);
            MessageSignature ms = new MessageSignature();
            ms.setOperation(onMessageElem.getOperation());
            ms.getTypeReferences().add(tref);
            Interaction interaction = new Interaction();
            interaction.setMessageSignature(ms);
            if (fromRole != null) {
                interaction.setFromRole(new Role(fromRole));
            }
            cb.add((Activity)interaction);
            TActivity act = ActivityUtil.getActivity(onMessageElem);
            if (act != null) {
                context.parse(act, cb.getContents(), handler);
            }
            elem.getPaths().add(cb);
        }
        activities.add((Activity)elem);
    }
}

