/*
 * Decompiled with CFR 0.152.
 */
package org.savara.bpmn2.generation.process;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.savara.bpmn2.internal.generation.process.BPMN2GenerationException;
import org.savara.bpmn2.internal.generation.process.BPMN2ModelFactory;
import org.savara.bpmn2.internal.generation.process.BPMN2NotationFactory;
import org.savara.bpmn2.internal.generation.process.components.BPMNActivity;
import org.savara.bpmn2.internal.generation.process.components.BPMNDiagram;
import org.savara.bpmn2.internal.generation.process.components.BPMNPool;
import org.savara.bpmn2.internal.generation.process.components.ChoiceActivity;
import org.savara.bpmn2.internal.generation.process.components.DoActivity;
import org.savara.bpmn2.internal.generation.process.components.DoBlockActivity;
import org.savara.bpmn2.internal.generation.process.components.ParallelActivity;
import org.savara.bpmn2.internal.generation.process.components.ReceiveActivity;
import org.savara.bpmn2.internal.generation.process.components.RepeatActivity;
import org.savara.bpmn2.internal.generation.process.components.RunActivity;
import org.savara.bpmn2.internal.generation.process.components.SendActivity;
import org.savara.bpmn2.internal.generation.process.components.SequenceActivity;
import org.savara.bpmn2.model.TDefinitions;
import org.savara.common.logging.FeedbackHandler;
import org.savara.common.model.generator.ModelGenerator;
import org.savara.common.resources.ResourceLocator;
import org.scribble.protocol.model.Activity;
import org.scribble.protocol.model.Block;
import org.scribble.protocol.model.Choice;
import org.scribble.protocol.model.DefaultVisitor;
import org.scribble.protocol.model.Do;
import org.scribble.protocol.model.Interaction;
import org.scribble.protocol.model.Interrupt;
import org.scribble.protocol.model.Parallel;
import org.scribble.protocol.model.Protocol;
import org.scribble.protocol.model.ProtocolModel;
import org.scribble.protocol.model.Repeat;
import org.scribble.protocol.model.Run;
import org.scribble.protocol.model.Visitor;

public class ProtocolToBPMN2ProcessModelGenerator
implements ModelGenerator {
    private boolean m_consecutiveIds = false;
    private static final Logger logger = Logger.getLogger(ProtocolToBPMN2ProcessModelGenerator.class.getName());

    public void setUseConsecutiveIds(boolean b) {
        this.m_consecutiveIds = b;
    }

    public boolean isSupported(Object source, String targetType) {
        return source instanceof ProtocolModel && ((ProtocolModel)source).isLocated() && (targetType.equals("bpmn2") || targetType.equals("bpmn"));
    }

    public Object generate(Object source, FeedbackHandler handler, ResourceLocator locator) {
        TDefinitions ret = null;
        if (source instanceof ProtocolModel) {
            ProtocolModel pm = (ProtocolModel)source;
            TDefinitions defns = new TDefinitions();
            BPMN2ModelFactory model = new BPMN2ModelFactory(defns);
            BPMN2NotationFactory notation = new BPMN2NotationFactory(model);
            model.setUseConsecutiveIds(this.m_consecutiveIds);
            notation.setUseConsecutiveIds(this.m_consecutiveIds);
            BPMN2ModelVisitor visitor = new BPMN2ModelVisitor(pm.getProtocol().getName(), model, notation);
            this.generateProcess(pm, visitor, handler, locator);
            visitor.completeModels();
            ret = defns;
        }
        return ret;
    }

    protected void generateProcess(ProtocolModel local, BPMN2ModelVisitor visitor, FeedbackHandler handler, ResourceLocator locator) {
        local.visit((Visitor)visitor);
    }

    public class BPMN2ModelVisitor
    extends DefaultVisitor {
        private BPMN2ModelFactory m_modelFactory = null;
        private BPMN2NotationFactory m_notationFactory = null;
        private String m_choreoName = null;
        private List<BPMNActivity> m_bpmnActivityStack = new ArrayList<BPMNActivity>();
        private Map<String, BPMNDiagram> m_activityModels = new HashMap<String, BPMNDiagram>();

        public BPMN2ModelVisitor(String choreoName, BPMN2ModelFactory model, BPMN2NotationFactory notation) {
            this.m_choreoName = choreoName;
            this.m_modelFactory = model;
            this.m_notationFactory = notation;
        }

        public boolean start(Protocol elem) {
            try {
                BPMNDiagram diagram = this.getBPMNModel(elem);
                BPMNPool pool = diagram.createPool(this.getPoolName(elem));
                this.pushBPMNActivity(pool);
            }
            catch (Exception e) {
                logger.severe("Failed to get state machine for behavior '" + elem + "': " + e);
            }
            return true;
        }

        protected String getPoolName(Protocol elem) {
            if (elem.getParent() instanceof ProtocolModel) {
                return elem.getRole().getName();
            }
            return elem.getName() + "_" + elem.getRole().getName();
        }

        public void end(Protocol elem) {
            BPMNActivity umls = this.getBPMNActivity();
            if (umls != null) {
                umls.childrenComplete();
            }
            this.popBPMNActivity();
        }

        public boolean start(Choice elem) {
            try {
                this.pushBPMNActivity(new ChoiceActivity(elem, this.getBPMNActivity(), this.m_modelFactory, this.m_notationFactory));
            }
            catch (Exception e) {
                logger.severe("Failed to create choice state: " + e);
            }
            return true;
        }

        public void end(Choice elem) {
            this.popBPMNActivity();
        }

        public boolean start(Parallel elem) {
            try {
                this.pushBPMNActivity(new ParallelActivity(elem, this.getBPMNActivity(), this.m_modelFactory, this.m_notationFactory));
            }
            catch (Exception e) {
                logger.severe("Failed to create parallel state: " + e);
            }
            return true;
        }

        public void end(Parallel elem) {
            this.popBPMNActivity();
        }

        public void accept(Run elem) {
            RunActivity state = null;
            BPMNActivity umls = this.getBPMNActivity();
            if (umls != null) {
                state = new RunActivity((Activity)elem, umls, this.m_modelFactory, this.m_notationFactory);
            }
        }

        public boolean start(Do elem) {
            DoActivity state = null;
            BPMNActivity umls = this.getBPMNActivity();
            if (umls != null) {
                state = new DoActivity((Activity)elem, umls, this.m_modelFactory, this.m_notationFactory);
                this.pushBPMNActivity(state);
                DoBlockActivity inline = new DoBlockActivity(state, this.m_modelFactory, this.m_notationFactory);
                this.pushBPMNActivity(inline);
            }
            return true;
        }

        public void end(Do elem) {
            if (this.getBPMNActivity() instanceof DoBlockActivity) {
                this.popBPMNActivity();
            }
            this.popBPMNActivity();
        }

        public boolean start(Interrupt elem) {
            if (this.getBPMNActivity() instanceof DoBlockActivity) {
                this.popBPMNActivity();
            }
            return true;
        }

        public void end(Interrupt elem) {
        }

        public void accept(Interaction elem) {
            if (elem.getFromRole() == null || elem.getFromRole().equals((Object)elem.enclosingProtocol().getRole())) {
                BPMNActivity umls = this.getBPMNActivity();
                if (umls != null) {
                    SendActivity sa = new SendActivity(elem, umls, this.m_modelFactory, this.m_notationFactory);
                    BPMNDiagram amodel = umls.getBPMNDiagram();
                    amodel.registerSendActivity(elem, sa);
                }
            } else {
                BPMNActivity umls = this.getBPMNActivity();
                if (umls != null) {
                    ReceiveActivity sa = new ReceiveActivity(elem, umls, this.m_modelFactory, this.m_notationFactory);
                    BPMNDiagram amodel = umls.getBPMNDiagram();
                    amodel.registerReceiveActivity(elem, sa);
                }
            }
        }

        public boolean start(Block elem) {
            try {
                this.pushBPMNActivity(new SequenceActivity(this.getBPMNActivity(), this.m_modelFactory, this.m_notationFactory));
            }
            catch (Exception e) {
                logger.severe("Failed to create sequence state: " + e);
            }
            return true;
        }

        public void end(Block elem) {
            this.popBPMNActivity();
        }

        public boolean start(Repeat elem) {
            try {
                this.pushBPMNActivity(new RepeatActivity(elem, this.getBPMNActivity(), this.m_modelFactory, this.m_notationFactory));
                this.pushBPMNActivity(new SequenceActivity(this.getBPMNActivity(), this.m_modelFactory, this.m_notationFactory));
            }
            catch (Exception e) {
                logger.severe("Failed to create while Activity: " + e);
            }
            return true;
        }

        public void end(Repeat elem) {
            this.popBPMNActivity();
            this.popBPMNActivity();
        }

        protected BPMNDiagram getBPMNModel(Protocol elem) throws BPMN2GenerationException {
            Protocol main = elem.getTopLevelProtocol();
            String name = main.getName();
            BPMNDiagram ret = this.m_activityModels.get(name);
            if (ret == null) {
                ret = new BPMNDiagram(this.m_choreoName, name, null, this.m_modelFactory, this.m_notationFactory);
                this.m_activityModels.put(name, ret);
            }
            return ret;
        }

        protected void pushBPMNActivity(BPMNActivity act) {
            this.m_bpmnActivityStack.add(0, act);
        }

        protected BPMNActivity getBPMNActivity() {
            BPMNActivity ret = null;
            if (this.m_bpmnActivityStack.size() > 0) {
                ret = this.m_bpmnActivityStack.get(0);
            }
            return ret;
        }

        protected void popBPMNActivity() {
            BPMNActivity umls = this.getBPMNActivity();
            if (umls != null) {
                umls.childrenComplete();
            }
            if (this.m_bpmnActivityStack.size() > 0) {
                this.m_bpmnActivityStack.remove(0);
            }
        }

        public void completeModels() {
            for (BPMNDiagram amodel : this.m_activityModels.values()) {
                amodel.completeModel();
            }
        }
    }
}

