/*
 * Decompiled with CFR 0.152.
 */
package org.savara.bpmn2.internal.generation.process.components;

import org.savara.bpmn2.internal.generation.process.BPMN2GenerationException;
import org.savara.bpmn2.internal.generation.process.BPMN2ModelFactory;
import org.savara.bpmn2.internal.generation.process.BPMN2NotationFactory;
import org.savara.bpmn2.internal.generation.process.components.AbstractBPMNActivity;
import org.savara.bpmn2.internal.generation.process.components.BPMNActivity;
import org.savara.bpmn2.internal.generation.process.components.JunctionActivity;
import org.scribble.protocol.model.Parallel;

public class ParallelActivity
extends AbstractBPMNActivity {
    private boolean m_completed = false;
    private BPMNActivity m_forkState = null;
    private BPMNActivity m_joinState = null;

    public ParallelActivity(Parallel parallel, BPMNActivity parent, BPMN2ModelFactory model, BPMN2NotationFactory notation) throws BPMN2GenerationException {
        super(parent, model, notation);
        this.initialize(parallel);
    }

    protected void initialize(Parallel elem) throws BPMN2GenerationException {
        Object parallelState = this.getModelFactory().createANDGateway(this.getContainer());
        this.m_forkState = new JunctionActivity(parallelState, this, this.getModelFactory(), this.getNotationFactory());
        Object joinState = this.getModelFactory().createANDGateway(this.getContainer());
        this.m_joinState = new JunctionActivity(joinState, this, this.getModelFactory(), this.getNotationFactory());
    }

    public void childrenComplete() {
        if (!this.m_completed) {
            int width = this.m_forkState.getWidth() + this.m_joinState.getWidth() + 100;
            int height = 0;
            if (this.getChildStates().remove(this.m_joinState)) {
                this.getChildStates().add(this.m_joinState);
            }
            int maxwidth = 0;
            for (int i = 1; i < this.getChildStates().size() - 1; ++i) {
                BPMNActivity umls = (BPMNActivity)this.getChildStates().get(i);
                height += umls.getHeight() + 40;
                if (umls.getWidth() > maxwidth) {
                    maxwidth = umls.getWidth();
                }
                umls.transitionFrom(this.m_forkState, null);
                Object endNode = umls.getEndNode();
                this.m_joinState.transitionFrom(umls, null);
            }
            width += maxwidth;
            if (height >= 50) {
                height -= 50;
            }
            if (height < this.m_forkState.getHeight()) {
                height = this.m_forkState.getHeight();
            }
            if (height < this.m_joinState.getHeight()) {
                height = this.m_joinState.getHeight();
            }
            this.setWidth(width);
            this.setHeight(height);
            this.adjustWidth(width);
            this.m_completed = true;
        }
    }

    public Object getStartNode() {
        return this.m_forkState.getStartNode();
    }

    public Object getEndNode() {
        return this.m_joinState.getEndNode();
    }

    public BPMNActivity getStartState() {
        return this.m_forkState;
    }

    public BPMNActivity getEndState() {
        return this.m_joinState;
    }

    public void adjustWidth(int width) {
        int extrawidth = this.m_forkState.getWidth() + this.m_joinState.getWidth() + 100;
        this.setWidth(width);
        for (int i = 1; i < this.getChildStates().size() - 1; ++i) {
            BPMNActivity umls = (BPMNActivity)this.getChildStates().get(i);
            umls.adjustWidth(width - extrawidth);
        }
    }

    public void calculatePosition(int x, int y) {
        int cury = y;
        int midx = x + this.getWidth() / 2;
        int midy = y + this.getHeight() / 2;
        this.setX(x);
        this.setY(y);
        for (int i = 1; i < this.getChildStates().size() - 1; ++i) {
            BPMNActivity act = (BPMNActivity)this.getChildStates().get(i);
            act.calculatePosition(midx - act.getWidth() / 2, cury);
            cury += act.getHeight() + 40;
        }
        this.m_forkState.calculatePosition(x, midy - this.m_forkState.getHeight() / 2);
        this.m_joinState.calculatePosition(x + this.getWidth() - this.m_joinState.getWidth(), midy - this.m_joinState.getHeight() / 2);
    }

    public void draw(Object parent) {
        BPMNActivity act;
        int i;
        for (i = 0; i < this.getChildStates().size(); ++i) {
            act = (BPMNActivity)this.getChildStates().get(i);
            act.draw(parent);
        }
        for (i = 1; i < this.getChildStates().size(); ++i) {
            act = (BPMNActivity)this.getChildStates().get(i);
            if (act == this.m_joinState) continue;
            this.getStartState().transitionTo(act, null, parent);
            act.getEndState().transitionTo(this.m_joinState, null, parent);
        }
    }
}

