/*
 * Decompiled with CFR 0.152.
 */
package org.savara.bpmn2.internal.generation.process.components;

import org.savara.bpmn2.internal.generation.process.BPMN2ModelFactory;
import org.savara.bpmn2.internal.generation.process.BPMN2NotationFactory;
import org.savara.bpmn2.internal.generation.process.components.AbstractBPMNActivity;
import org.savara.bpmn2.internal.generation.process.components.BPMNActivity;

public class SequenceActivity
extends AbstractBPMNActivity {
    private boolean m_completed = false;

    public SequenceActivity(BPMNActivity parent, BPMN2ModelFactory model, BPMN2NotationFactory notation) {
        super(parent, model, notation);
    }

    public void childrenComplete() {
        if (!this.m_completed) {
            this.transitionSequentialNodes();
            this.m_completed = true;
        }
    }

    public void calculatePosition(int x, int y) {
        int curx = x;
        int midy = y + this.getHeight() / 2;
        this.setX(x);
        this.setY(y);
        for (int i = 0; i < this.getChildStates().size(); ++i) {
            BPMNActivity act = (BPMNActivity)this.getChildStates().get(i);
            act.calculatePosition(curx, midy - act.getHeight() / 2);
            curx += act.getWidth() + 50;
        }
    }

    public Object getStartNode() {
        Object ret = null;
        if (this.getChildStates().size() > 0) {
            BPMNActivity state = (BPMNActivity)this.getChildStates().get(0);
            ret = state.getStartNode();
        }
        return ret;
    }

    public Object getEndNode() {
        Object ret = null;
        int len = 0;
        len = this.getChildStates().size();
        if (len > 0) {
            BPMNActivity state = (BPMNActivity)this.getChildStates().get(len - 1);
            ret = state.getEndNode();
        }
        return ret;
    }

    public BPMNActivity getStartState() {
        BPMNActivity ret = null;
        if (this.getChildStates().size() > 0) {
            BPMNActivity state;
            ret = state = (BPMNActivity)this.getChildStates().get(0);
        }
        return ret;
    }

    public BPMNActivity getEndState() {
        BPMNActivity ret = null;
        int len = 0;
        len = this.getChildStates().size();
        if (len > 0) {
            BPMNActivity state = (BPMNActivity)this.getChildStates().get(len - 1);
            ret = state.getEndState();
        }
        return ret;
    }

    public void adjustWidth(int width) {
        float percentChange = (float)width / (float)this.getWidth();
        for (int i = 0; i < this.getChildStates().size(); ++i) {
            BPMNActivity act = (BPMNActivity)this.getChildStates().get(i);
            int cur = act.getWidth();
            int newWidth = (int)((float)cur * percentChange);
            act.adjustWidth(newWidth);
            int change = act.getWidth() - cur;
            this.setWidth(this.getWidth() + change);
        }
    }

    public void draw(Object parent) {
        for (int i = 0; i < this.getChildStates().size(); ++i) {
            BPMNActivity act = (BPMNActivity)this.getChildStates().get(i);
            act.draw(parent);
            if (i <= 0) continue;
            BPMNActivity prev = (BPMNActivity)this.getChildStates().get(i - 1);
            prev.transitionTo(act, null, parent);
        }
    }
}

