/*
 * Decompiled with CFR 0.152.
 */
package org.savara.bpmn2.parser;

import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;
import javax.xml.bind.JAXBElement;
import org.savara.bpmn2.model.TChoreography;
import org.savara.bpmn2.model.TDefinitions;
import org.savara.bpmn2.model.TImport;
import org.savara.bpmn2.model.TItemDefinition;
import org.savara.bpmn2.model.TRootElement;
import org.savara.bpmn2.parser.BPMN2ParserUtil;
import org.savara.bpmn2.parser.rules.DefaultBPMN2ParserContext;
import org.savara.bpmn2.parser.rules.Scope;
import org.savara.bpmn2.util.BPMN2ModelUtil;
import org.savara.common.logging.FeedbackHandler;
import org.savara.protocol.util.FeedbackHandlerProxy;
import org.scribble.common.logging.Journal;
import org.scribble.common.resource.Content;
import org.scribble.protocol.ProtocolContext;
import org.scribble.protocol.model.DataType;
import org.scribble.protocol.model.ProtocolModel;
import org.scribble.protocol.model.TypeImport;
import org.scribble.protocol.model.TypeImportList;
import org.scribble.protocol.parser.AnnotationProcessor;
import org.scribble.protocol.parser.ProtocolParser;

public class BPMN2ProtocolParser
implements ProtocolParser {
    private static final String BPMN_FILE_EXTENSION = "bpmn";
    private static Logger logger = Logger.getLogger(BPMN2ProtocolParser.class.getName());

    public boolean isSupported(Content content) {
        return content.hasExtension(BPMN_FILE_EXTENSION);
    }

    public ProtocolModel parse(ProtocolContext context, Content content, Journal journal) throws IOException {
        ProtocolModel ret = null;
        InputStream is = content.getInputStream();
        TDefinitions defns = BPMN2ModelUtil.deserialize(is);
        is.close();
        Scope scope = BPMN2ParserUtil.createScope(defns);
        DefaultBPMN2ParserContext parserContext = new DefaultBPMN2ParserContext((FeedbackHandler)new FeedbackHandlerProxy(journal), scope);
        for (JAXBElement<? extends TRootElement> elem : defns.getRootElement()) {
            if (elem.getDeclaredType() != TChoreography.class) continue;
            TChoreography choreo = (TChoreography)elem.getValue();
            ProtocolModel pm = new ProtocolModel();
            this.initialize(pm, defns);
            ret = pm;
            break;
        }
        return ret;
    }

    public void setAnnotationProcessor(AnnotationProcessor ap) {
    }

    protected void initialize(ProtocolModel pm, TDefinitions defns) {
        for (JAXBElement<? extends TRootElement> elem : defns.getRootElement()) {
            if (elem.getDeclaredType() != TItemDefinition.class) continue;
            TItemDefinition itemdefn = (TItemDefinition)elem.getValue();
            TypeImport ti = new TypeImport();
            ti.setName(itemdefn.getStructureRef().getLocalPart());
            DataType dt = new DataType();
            dt.setDetails(itemdefn.getStructureRef().toString());
            ti.setDataType(dt);
            TypeImportList tilist = new TypeImportList();
            tilist.setFormat("xsd");
            String location = null;
            for (TImport imp : defns.getImport()) {
                if (!imp.getNamespace().equals(itemdefn.getStructureRef().getNamespaceURI())) continue;
                if (imp.getLocation() == null) break;
                location = imp.getLocation();
                break;
            }
            if (location != null) {
                tilist.setLocation(location);
            }
            tilist.getTypeImports().add(ti);
            pm.getImports().add(tilist);
        }
    }
}

