/*
 * Decompiled with CFR 0.152.
 */
package org.savara.bpmn2.internal.generation.process.components;

import java.util.List;
import org.savara.bpmn2.internal.generation.process.BPMN2ModelFactory;
import org.savara.bpmn2.internal.generation.process.BPMN2NotationFactory;
import org.savara.bpmn2.internal.generation.process.components.AbstractBPMNActivity;
import org.savara.bpmn2.internal.generation.process.components.BPMNActivity;
import org.savara.bpmn2.internal.generation.process.components.JunctionActivity;
import org.savara.bpmn2.model.TSubProcess;

public abstract class InlineActivity
extends AbstractBPMNActivity {
    private boolean m_completed = false;
    private BPMNActivity m_finalState = null;
    private TSubProcess m_subProcess = null;

    public InlineActivity(BPMNActivity parent, BPMN2ModelFactory model, BPMN2NotationFactory notation) {
        super(parent, model, notation);
        this.initialize(parent);
    }

    protected void initialize(BPMNActivity parent) {
        this.m_subProcess = (TSubProcess)this.getModelFactory().createSubProcess(parent.getContainer());
        new JunctionActivity(this.getModelFactory().createInitialNode(this.getContainer()), this, this.getModelFactory(), this.getNotationFactory());
        this.m_finalState = new JunctionActivity(this.getModelFactory().createFinalNode(this.getContainer()), this, this.getModelFactory(), this.getNotationFactory());
    }

    public TSubProcess getSubProcess() {
        return this.m_subProcess;
    }

    public void childrenComplete() {
        if (!this.m_completed) {
            if (this.getChildStates().remove(this.m_finalState)) {
                this.getChildStates().add(this.m_finalState);
            }
            this.transitionSequentialNodes();
            this.setHeight(this.getHeight() + 80);
            this.setWidth(this.getWidth() + 100);
            this.m_completed = true;
        }
    }

    public void calculatePosition(int x, int y) {
        int curx = x + 50;
        int midy = this.getHeight() / 2;
        this.setX(x);
        this.setY(y);
        for (int i = 0; i < this.getChildStates().size(); ++i) {
            BPMNActivity act = (BPMNActivity)this.getChildStates().get(i);
            act.calculatePosition(curx, y + (midy - act.getHeight() / 2));
            curx += act.getWidth() + 50;
        }
    }

    public void draw(Object parent) {
        this.getNotationFactory().createTask(this.getModelFactory(), this.m_subProcess, parent, this.getX(), this.getY(), this.getWidth(), this.getHeight());
        for (int i = 0; i < this.getChildStates().size(); ++i) {
            BPMNActivity act = (BPMNActivity)this.getChildStates().get(i);
            act.draw(parent);
            if (i <= 0) continue;
            BPMNActivity prev = (BPMNActivity)this.getChildStates().get(i - 1);
            prev.transitionTo(act, null, parent);
        }
    }

    public void breakLinks() {
        Object node = this.getStartNode();
        List<Object> list = this.getModelFactory().getInboundControlLinks(node);
        for (int i = list.size() - 1; i >= 0; --i) {
            Object edge = list.get(i);
            this.tidyUpEdge(edge);
        }
    }

    protected void tidyUpEdge(Object edge) {
        Object sourceNode = this.getModelFactory().getSource(edge);
        this.getModelFactory().delete(edge);
        if (this.getModelFactory().getInboundControlLinks(sourceNode).size() <= 1 && this.getModelFactory().getOutboundControlLinks(sourceNode).size() == 0 && (this.getModelFactory().isDecision(sourceNode) || this.getModelFactory().isJoin(sourceNode))) {
            if (this.getModelFactory().getInboundControlLinks(sourceNode).size() == 1) {
                Object actedge = this.getModelFactory().getInboundControlLinks(sourceNode).get(0);
                this.tidyUpEdge(actedge);
            }
            this.getModelFactory().delete(sourceNode);
        }
    }

    public Object getContainer() {
        return this.m_subProcess;
    }

    public Object getStartNode() {
        return this.m_subProcess;
    }

    public Object getEndNode() {
        return this.m_subProcess;
    }

    public BPMNActivity getStartState() {
        return this;
    }

    public BPMNActivity getEndState() {
        return this;
    }
}

