/*
 * Decompiled with CFR 0.152.
 */
package org.savara.bpmn2.internal.parser.choreo.rules;

import java.util.Iterator;
import java.util.List;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.logging.Logger;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.savara.bpmn2.internal.parser.choreo.rules.BPMN2ParserContext;
import org.savara.bpmn2.internal.parser.choreo.rules.BPMN2ParserRule;
import org.savara.bpmn2.internal.parser.choreo.rules.ParserRuleFactory;
import org.savara.bpmn2.model.TChoreography;
import org.savara.bpmn2.model.TChoreographyTask;
import org.savara.bpmn2.model.TExclusiveGateway;
import org.savara.bpmn2.model.TFlowElement;
import org.savara.bpmn2.model.TFlowNode;
import org.savara.bpmn2.model.TInterface;
import org.savara.bpmn2.model.TParticipant;
import org.savara.bpmn2.model.TSequenceFlow;
import org.savara.bpmn2.model.TStartEvent;
import org.savara.common.logging.MessageFormatter;
import org.savara.common.model.annotation.Annotation;
import org.savara.protocol.model.Fork;
import org.savara.protocol.model.Join;
import org.savara.protocol.model.util.ChoiceUtil;
import org.scribble.protocol.model.Activity;
import org.scribble.protocol.model.Block;
import org.scribble.protocol.model.Choice;
import org.scribble.protocol.model.CustomActivity;
import org.scribble.protocol.model.Introduces;
import org.scribble.protocol.model.ModelObject;
import org.scribble.protocol.model.Parallel;
import org.scribble.protocol.model.Protocol;
import org.scribble.protocol.model.Role;
import org.scribble.protocol.util.ActivityUtil;
import org.scribble.protocol.util.RoleUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TChoreographyParserRule
implements BPMN2ParserRule {
    private static final String PARTICIPANT_NAMESPACE_PREFIX = "pns";
    private static Logger LOG = Logger.getLogger(TChoreographyParserRule.class.getName());

    @Override
    public boolean isSupported(Object elem) {
        return elem.getClass() == TChoreography.class;
    }

    @Override
    public void parse(BPMN2ParserContext context, Object elem, Block container) {
        TChoreography choreo = (TChoreography)elem;
        TStartEvent startEvent = null;
        for (JAXBElement<? extends TFlowElement> jaxb : choreo.getFlowElement()) {
            if (((TFlowElement)jaxb.getValue()).getClass() != TStartEvent.class) continue;
            if (startEvent != null) {
                context.getFeedbackHandler().error(MessageFormatter.format((ResourceBundle)PropertyResourceBundle.getBundle("org.savara.bpmn2.Messages"), (String)"SAVARA-BPMN2-00001", (Object[])new Object[0]), null);
                continue;
            }
            startEvent = (TStartEvent)jaxb.getValue();
        }
        if (startEvent == null) {
            context.getFeedbackHandler().error(MessageFormatter.format((ResourceBundle)PropertyResourceBundle.getBundle("org.savara.bpmn2.Messages"), (String)"SAVARA-BPMN2-00002", (Object[])new Object[0]), null);
        } else {
            this.processNode(context, startEvent, container);
            this.cleanUpJoins(context);
            this.localiseIntroductions(context, container);
            this.defineNamespaces(context, container);
        }
    }

    protected void localiseIntroductions(BPMN2ParserContext context, Block container) {
        for (Introduces rl : context.getScope().getIntroduces().values()) {
            for (int i = rl.getIntroducedRoles().size() - 1; i >= 0; --i) {
                Role r = (Role)rl.getIntroducedRoles().get(i);
                Block b = RoleUtil.getEnclosingBlock((Protocol)container.getEnclosingProtocol(), (Role)r, (boolean)false);
                if (b == null || b == container.getEnclosingProtocol().getBlock()) continue;
                Introduces innerrl = null;
                if (b.size() > 0 && b.get(0) instanceof Introduces) {
                    innerrl = (Introduces)b.get(0);
                } else {
                    innerrl = new Introduces();
                    innerrl.setIntroducer(rl.getIntroducer());
                    b.getContents().add(0, innerrl);
                }
                rl.getIntroducedRoles().remove(r);
                innerrl.getIntroducedRoles().add(r);
            }
            if (rl.getIntroducedRoles().size() <= 0) continue;
            container.getEnclosingProtocol().getBlock().getContents().add(0, rl);
        }
    }

    protected void cleanUpJoins(BPMN2ParserContext context) {
        Block parParent;
        Iterator<Block> joinBlocks = context.getScope().getJoinBlocks().values().iterator();
        while (joinBlocks.hasNext()) {
            Block joinBlock = joinBlocks.next();
            if (!(joinBlock.getParent() instanceof Parallel) || ((Parallel)joinBlock.getParent()).getPaths().size() != 2 || joinBlock.getContents().size() != 2 || !(joinBlock.getContents().get(0) instanceof Join) || !(joinBlock.getContents().get(1) instanceof Fork)) continue;
            Join join = (Join)joinBlock.getContents().get(0);
            Fork fork = (Fork)joinBlock.getContents().get(1);
            if ((join.getRoles().size() != 0 || fork.getRoles().size() != 0) && !join.getRoles().containsAll(fork.getRoles())) continue;
            Parallel par = (Parallel)joinBlock.getParent();
            Block parParent2 = (Block)par.getParent();
            int parIndex = parParent2.indexOf((Activity)par);
            par.getPaths().remove(joinBlock);
            parParent2.remove((Activity)par);
            parParent2.getContents().addAll(parIndex, ((Block)par.getPaths().get(0)).getContents());
            context.getScope().getParallelReviewList().remove(par);
            Join otherJoin = context.getScope().getJoin(fork.getLabel());
            if (otherJoin != null) {
                otherJoin.getLabels().remove(fork.getLabel());
                otherJoin.getLabels().addAll(join.getLabels());
            }
            joinBlocks.remove();
        }
        for (Block joinBlock : context.getScope().getJoinBlocks().values()) {
            if (!(joinBlock.getParent() instanceof Parallel) || ((Parallel)joinBlock.getParent()).getPaths().size() != 2 || joinBlock.getContents().size() != 1 || !(joinBlock.getContents().get(0) instanceof Join)) continue;
            Parallel par = (Parallel)joinBlock.getParent();
            parParent = (Block)par.getParent();
            int parIndex = parParent.indexOf((Activity)par);
            par.getPaths().remove(joinBlock);
            parParent.remove((Activity)par);
            parParent.getContents().addAll(parIndex, ((Block)par.getPaths().get(0)).getContents());
            context.getScope().getParallelReviewList().remove(par);
            Join join = (Join)joinBlock.getContents().get(0);
            for (String label : join.getLabels()) {
                Fork sync = context.getScope().getFork(label);
                ((Block)sync.getParent()).remove((Activity)sync);
            }
        }
        for (Parallel par : context.getScope().getParallelReviewList()) {
            if (par.getPaths().size() >= 2) continue;
            parParent = (Block)par.getParent();
            int parIndex = parParent.indexOf((Activity)par);
            if (par.getPaths().size() == 1) {
                parParent.getContents().addAll(parIndex, ((Block)par.getPaths().get(0)).getContents());
            }
            parParent.remove((Activity)par);
        }
    }

    protected void processNode(BPMN2ParserContext context, TFlowNode elem, Block container) {
        BPMN2ParserRule rule;
        if (elem.getIncoming().size() > 1) {
            Block b = context.getScope().getJoinBlocks().get(elem);
            if (b == null) {
                container = this.createJoin(context, elem, container);
            } else {
                ModelObject parent;
                for (parent = container.getParent(); parent != null && parent != b && !(parent instanceof Protocol); parent = parent.getParent()) {
                }
                if (parent != b) {
                    Vector<Block> list = new Vector<Block>();
                    list.add(container);
                    list.add(b);
                    Block common = ActivityUtil.getEnclosingBlock(list);
                    if (common != null) {
                        if (!this.isInScopeOfSingleParallel(common, list)) {
                            for (parent = common.getParent(); parent != null && !(parent instanceof Parallel) && !(parent instanceof Protocol); parent = parent.getParent()) {
                            }
                            if (parent instanceof Parallel) {
                                Parallel oldParallel = (Parallel)b.getParent();
                                oldParallel.getPaths().remove(b);
                                ((Parallel)parent).getPaths().add(b);
                                if (oldParallel.getPaths().size() == 0) {
                                    ((Block)oldParallel.getParent()).remove((Activity)oldParallel);
                                } else if (oldParallel.getPaths().size() == 1) {
                                    int pos = ((Block)oldParallel.getParent()).indexOf((Activity)oldParallel);
                                    if (pos == -1) {
                                        LOG.severe("Could not find position of parallel");
                                    } else {
                                        ((Block)oldParallel.getParent()).getContents().addAll(pos, ((Block)oldParallel.getPaths().get(0)).getContents());
                                    }
                                    ((Block)oldParallel.getParent()).remove((Activity)oldParallel);
                                    context.getScope().getParallelReviewList().remove(oldParallel);
                                }
                            } else {
                                LOG.severe("Unable to find a containing parallel construct");
                            }
                        }
                    } else {
                        LOG.severe("Failed to find common block");
                    }
                }
                return;
            }
        }
        if ((rule = ParserRuleFactory.getParserRule(elem)) != null) {
            rule.parse(context, elem, container);
        }
        if (elem.getOutgoing().size() == 1) {
            Object target;
            TSequenceFlow seq = (TSequenceFlow)context.getScope().getBPMN2Element(elem.getOutgoing().get(0).getLocalPart());
            if (seq != null && (target = seq.getTargetRef()) instanceof TFlowNode) {
                if (((TFlowNode)target).getIncoming().size() > 1) {
                    Fork sync = new Fork();
                    sync.setLabel(this.getJoinName(elem.getOutgoing().get(0).getLocalPart()));
                    this.getRoles(context, (TFlowNode)target, (CustomActivity)sync);
                    container.add((Activity)sync);
                    context.getScope().registerFork(sync);
                }
                this.processNode(context, (TFlowNode)target, container);
            }
        } else if (elem.getOutgoing().size() > 1) {
            if (elem instanceof TExclusiveGateway) {
                Parallel parallel = new Parallel();
                container.add((Activity)parallel);
                context.getScope().getParallelReviewList().add(parallel);
                Block mainBlock = new Block();
                parallel.getPaths().add(mainBlock);
                Choice choice = new Choice();
                mainBlock.add((Activity)choice);
                for (QName seqFlowQName : elem.getOutgoing()) {
                    TSequenceFlow seq = (TSequenceFlow)context.getScope().getBPMN2Element(seqFlowQName.getLocalPart());
                    Block b = new Block();
                    choice.getPaths().add(b);
                    if (!(seq.getTargetRef() instanceof TFlowNode)) continue;
                    if (((TFlowNode)seq.getTargetRef()).getIncoming().size() > 1) {
                        Fork sync = new Fork();
                        sync.setLabel(this.getJoinName(seqFlowQName.getLocalPart()));
                        this.getRoles(context, (TFlowNode)seq.getTargetRef(), (CustomActivity)sync);
                        b.add((Activity)sync);
                        context.getScope().registerFork(sync);
                    }
                    this.processNode(context, (TFlowNode)seq.getTargetRef(), b);
                }
                Role role = ChoiceUtil.getDecisionMaker((Choice)choice);
                if (role != null) {
                    choice.setRole(new Role(role));
                }
            } else {
                Parallel parallel = new Parallel();
                container.add((Activity)parallel);
                for (QName seqFlowQName : elem.getOutgoing()) {
                    TSequenceFlow seq = (TSequenceFlow)context.getScope().getBPMN2Element(seqFlowQName.getLocalPart());
                    Block b = new Block();
                    parallel.getPaths().add(b);
                    if (!(seq.getTargetRef() instanceof TFlowNode)) continue;
                    if (((TFlowNode)seq.getTargetRef()).getIncoming().size() > 1) {
                        Fork sync = new Fork();
                        sync.setLabel(this.getJoinName(seqFlowQName.getLocalPart()));
                        this.getRoles(context, (TFlowNode)seq.getTargetRef(), (CustomActivity)sync);
                        b.add((Activity)sync);
                        context.getScope().registerFork(sync);
                    }
                    this.processNode(context, (TFlowNode)seq.getTargetRef(), b);
                }
            }
        }
    }

    protected void defineNamespaces(BPMN2ParserContext context, Block container) {
        Protocol protocol = container.getEnclosingProtocol();
        String tns = context.getScope().getDefinitions().getTargetNamespace();
        if (protocol != null && tns != null && tns.trim().length() > 0) {
            int count = 1;
            for (Role role : protocol.getRoles()) {
                String namespace = tns + "/" + role.getName();
                String name = role.getName();
                QName intf = this.getInterfaceName(context, role);
                if (intf != null) {
                    namespace = intf.getNamespaceURI();
                    name = intf.getLocalPart();
                }
                String prefix = PARTICIPANT_NAMESPACE_PREFIX + count++;
                Annotation pann = new Annotation("Interface");
                pann.getProperties().put("namespace", namespace);
                pann.getProperties().put("name", name);
                pann.getProperties().put("role", role.getName());
                protocol.getAnnotations().add(pann);
                pann = new Annotation("Type");
                pann.getProperties().put("prefix", prefix);
                pann.getProperties().put("namespace", namespace);
                protocol.getAnnotations().add(pann);
            }
        }
    }

    protected QName getInterfaceName(BPMN2ParserContext context, Role role) {
        QName ret = null;
        for (TParticipant part : context.getScope().getChoreography().getParticipant()) {
            if (!part.getName().equals(role.getName())) continue;
            if (part.getInterfaceRef().size() <= 0) break;
            QName intfQName = part.getInterfaceRef().get(0);
            Object intf = context.getScope().getBPMN2Element(intfQName.getLocalPart());
            if (!(intf instanceof TInterface)) break;
            ret = ((TInterface)intf).getImplementationRef();
            break;
        }
        return ret;
    }

    protected void getRoles(BPMN2ParserContext context, TFlowNode node, CustomActivity activity) {
        block5: {
            block4: {
                if (!(node instanceof TChoreographyTask)) break block4;
                TChoreographyTask task = (TChoreographyTask)node;
                for (QName qname : task.getParticipantRef()) {
                    TParticipant p = (TParticipant)context.getScope().getBPMN2Element(qname.getLocalPart());
                    if (p != null) {
                        Role r = new Role(p.getName());
                        if (activity.getRoles().contains(r)) continue;
                        activity.getRoles().add(r);
                        continue;
                    }
                    LOG.severe("Could not find participant for id '" + qname.getLocalPart() + "'");
                }
                break block5;
            }
            if (node.getOutgoing().size() <= 0) break block5;
            for (QName qname : node.getOutgoing()) {
                TSequenceFlow seqFlow = (TSequenceFlow)context.getScope().getBPMN2Element(qname.getLocalPart());
                TFlowNode otherNode = (TFlowNode)seqFlow.getTargetRef();
                if (otherNode != null) {
                    this.getRoles(context, otherNode, activity);
                    continue;
                }
                LOG.severe("Unable to find node for '" + qname.getLocalPart() + "'");
            }
        }
    }

    protected boolean isInScopeOfSingleParallel(Block common, List<Block> list) {
        boolean inscope = false;
        for (Activity act : common.getContents()) {
            if (!(act instanceof Parallel)) continue;
            Vector<Block> blks = new Vector<Block>(list);
            for (Block path : ((Parallel)act).getPaths()) {
                for (int i = blks.size() - 1; i >= 0; --i) {
                    Block blk = (Block)blks.get(i);
                    Vector<Block> sublist = new Vector<Block>();
                    sublist.add(blk);
                    sublist.add(path);
                    Block enclosing = ActivityUtil.getEnclosingBlock(sublist);
                    if (enclosing != path) continue;
                    blks.remove(blk);
                }
            }
            if (blks.size() != 0) continue;
            inscope = true;
            break;
        }
        return inscope;
    }

    protected Block createJoin(BPMN2ParserContext context, TFlowNode elem, Block container) {
        ModelObject parent;
        Join join = new Join();
        for (QName qname : elem.getIncoming()) {
            join.getLabels().add(this.getJoinName(qname.getLocalPart()));
            context.getScope().registerJoin(join);
        }
        this.getRoles(context, elem, (CustomActivity)join);
        join.setXOR(elem instanceof TExclusiveGateway);
        for (parent = container.getParent(); parent != null && !(parent instanceof Parallel) && !(parent instanceof Protocol); parent = parent.getParent()) {
        }
        container = new Block();
        if (parent instanceof Parallel) {
            ((Parallel)parent).getPaths().add(container);
        } else if (parent instanceof Protocol) {
            LOG.severe("No enclosing parallel construct in protocol");
        } else {
            LOG.severe("No enclosing parallel construct");
        }
        container.add((Activity)join);
        context.getScope().getJoinBlocks().put(elem, container);
        return container;
    }

    protected String getJoinName(String label) {
        String ret = label;
        if (ret != null && ret.startsWith("SequenceFlow_")) {
            ret = ret.replaceAll("SequenceFlow_", "L");
        }
        return ret;
    }
}

