/*
 * Decompiled with CFR 0.152.
 */
package org.savara.bpmn2.internal.parser.choreo.rules;

import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.savara.bpmn2.internal.parser.choreo.rules.BPMN2ParserContext;
import org.savara.bpmn2.internal.parser.choreo.rules.BPMN2ParserRule;
import org.savara.bpmn2.model.TChoreographyTask;
import org.savara.bpmn2.model.TError;
import org.savara.bpmn2.model.TInterface;
import org.savara.bpmn2.model.TMessage;
import org.savara.bpmn2.model.TMessageFlow;
import org.savara.bpmn2.model.TOperation;
import org.savara.bpmn2.model.TParticipant;
import org.savara.common.model.annotation.Annotation;
import org.scribble.protocol.model.Activity;
import org.scribble.protocol.model.Block;
import org.scribble.protocol.model.Interaction;
import org.scribble.protocol.model.Introduces;
import org.scribble.protocol.model.MessageSignature;
import org.scribble.protocol.model.ParameterDefinition;
import org.scribble.protocol.model.Role;
import org.scribble.protocol.model.TypeReference;

public class TChoreographyTaskParserRule
implements BPMN2ParserRule {
    public boolean isSupported(Object elem) {
        return elem.getClass() == TChoreographyTask.class;
    }

    public void parse(BPMN2ParserContext context, Object elem, Block container) {
        TChoreographyTask task = (TChoreographyTask)elem;
        for (QName mflowQName : task.getMessageFlowRef()) {
            TMessageFlow mflow = (TMessageFlow)context.getScope().getBPMN2Element(mflowQName.getLocalPart());
            this.parseMessageFlow(context, mflow, container);
        }
    }

    protected void parseMessageFlow(BPMN2ParserContext context, TMessageFlow mflow, Block container) {
        TParticipant source = (TParticipant)context.getScope().getBPMN2Element(mflow.getSourceRef().getLocalPart());
        TParticipant target = (TParticipant)context.getScope().getBPMN2Element(mflow.getTargetRef().getLocalPart());
        Interaction interaction = new Interaction();
        Role initiatingRole = context.getScope().getRole(source.getName());
        if (initiatingRole == null) {
            initiatingRole = new Role(source.getName());
            context.getScope().registerRole(initiatingRole);
            ParameterDefinition pd = new ParameterDefinition();
            pd.setName(source.getName());
            container.getEnclosingProtocol().getParameterDefinitions().add(pd);
        }
        interaction.setFromRole(new Role(initiatingRole));
        Role otherRole = context.getScope().getRole(target.getName());
        if (otherRole == null) {
            otherRole = new Role(target.getName());
            context.getScope().registerRole(otherRole);
            Introduces intros = context.getScope().getIntroduces().get(initiatingRole);
            if (intros == null) {
                intros = new Introduces();
                intros.setIntroducer(initiatingRole);
                context.getScope().getIntroduces().put(initiatingRole, intros);
            }
            intros.getIntroducedRoles().add(otherRole);
        }
        interaction.getToRoles().add(new Role(otherRole));
        if (mflow.getMessageRef() != null) {
            TMessage mesg = (TMessage)context.getScope().getBPMN2Element(mflow.getMessageRef().getLocalPart());
            MessageSignature msig = new MessageSignature();
            TypeReference tref = new TypeReference(mesg.getName());
            msig.getTypeReferences().add(tref);
            interaction.setMessageSignature(msig);
        }
        this.checkForCorrelation(context, interaction, source, target, mflow);
        container.add((Activity)interaction);
    }

    protected void checkForCorrelation(BPMN2ParserContext context, Interaction interaction, TParticipant source, TParticipant target, TMessageFlow mflow) {
        Annotation annotation = null;
        for (QName qname : target.getInterfaceRef()) {
            TInterface intf = (TInterface)context.getScope().getBPMN2Element(qname.getLocalPart());
            if (intf == null) continue;
            for (TOperation op : intf.getOperation()) {
                if (op.getInMessageRef() == null || !op.getInMessageRef().equals(mflow.getMessageRef())) continue;
                annotation = new Annotation("Correlation");
                annotation.getProperties().put("request", op.getName());
                interaction.getMessageSignature().setOperation(op.getName());
                break;
            }
            if (annotation == null) continue;
            break;
        }
        if (annotation == null) {
            TError err = null;
            TMessage mesg = (TMessage)context.getScope().getBPMN2Element(mflow.getMessageRef().getLocalPart());
            if (mesg != null) {
                for (JAXBElement jAXBElement : context.getScope().getDefinitions().getRootElement()) {
                    TError te;
                    if (!(jAXBElement.getValue() instanceof TError) || !(te = (TError)jAXBElement.getValue()).getStructureRef().equals(mesg.getItemRef())) continue;
                    err = te;
                    break;
                }
            }
            for (QName qName : source.getInterfaceRef()) {
                TInterface intf = (TInterface)context.getScope().getBPMN2Element(qName.getLocalPart());
                if (intf != null) {
                    for (TOperation op : intf.getOperation()) {
                        if (op.getOutMessageRef() != null && op.getOutMessageRef().equals(mflow.getMessageRef())) {
                            annotation = new Annotation("Correlation");
                            annotation.getProperties().put("replyTo", op.getName());
                            interaction.getMessageSignature().setOperation(op.getName());
                            break;
                        }
                        if (err == null || !op.getErrorRef().contains(new QName(context.getScope().getDefinitions().getTargetNamespace(), err.getId()))) continue;
                        annotation = new Annotation("Correlation");
                        annotation.getProperties().put("replyTo", op.getName());
                        Annotation intfann = new Annotation("Fault");
                        intfann.getProperties().put("name", err.getErrorCode());
                        interaction.getAnnotations().add(intfann);
                        interaction.getMessageSignature().setOperation(op.getName());
                        break;
                    }
                }
                if (annotation == null) continue;
                break;
            }
        }
        if (annotation != null) {
            interaction.getAnnotations().add(annotation);
        }
    }
}

