/*
 * Decompiled with CFR 0.152.
 */
package org.savara.bpmn2.generation.process;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.savara.bpmn2.internal.generation.BPMN2GenerationException;
import org.savara.bpmn2.internal.generation.BPMN2ModelFactory;
import org.savara.bpmn2.internal.generation.BPMN2NotationFactory;
import org.savara.bpmn2.internal.generation.components.BPMNActivity;
import org.savara.bpmn2.internal.generation.components.BPMNDiagram;
import org.savara.bpmn2.internal.generation.components.BPMNPool;
import org.savara.bpmn2.internal.generation.components.BoundaryEvent;
import org.savara.bpmn2.internal.generation.components.ChoiceActivity;
import org.savara.bpmn2.internal.generation.components.DoActivity;
import org.savara.bpmn2.internal.generation.components.DoBlockActivity;
import org.savara.bpmn2.internal.generation.components.ForkActivity;
import org.savara.bpmn2.internal.generation.components.JoinActivity;
import org.savara.bpmn2.internal.generation.components.ParallelActivity;
import org.savara.bpmn2.internal.generation.components.ReceiveActivity;
import org.savara.bpmn2.internal.generation.components.RepeatActivity;
import org.savara.bpmn2.internal.generation.components.RunActivity;
import org.savara.bpmn2.internal.generation.components.SendActivity;
import org.savara.bpmn2.internal.generation.components.SequenceActivity;
import org.savara.bpmn2.internal.generation.components.ServiceInvocationActivity;
import org.savara.bpmn2.model.ObjectFactory;
import org.savara.bpmn2.model.TBaseElement;
import org.savara.bpmn2.model.TBoundaryEvent;
import org.savara.bpmn2.model.TDefinitions;
import org.savara.bpmn2.model.TError;
import org.savara.bpmn2.model.TErrorEventDefinition;
import org.savara.bpmn2.model.TImport;
import org.savara.bpmn2.model.TInterface;
import org.savara.bpmn2.model.TItemDefinition;
import org.savara.bpmn2.model.TMessage;
import org.savara.bpmn2.model.TOperation;
import org.savara.bpmn2.model.TReceiveTask;
import org.savara.bpmn2.model.TRootElement;
import org.savara.bpmn2.model.TSendTask;
import org.savara.bpmn2.model.TServiceTask;
import org.savara.common.logging.FeedbackHandler;
import org.savara.common.model.annotation.Annotation;
import org.savara.common.model.annotation.AnnotationDefinitions;
import org.savara.common.model.generator.ModelGenerator;
import org.savara.common.resources.ResourceLocator;
import org.savara.protocol.model.Fork;
import org.savara.protocol.model.Join;
import org.savara.protocol.model.util.InteractionUtil;
import org.scribble.protocol.model.Activity;
import org.scribble.protocol.model.Block;
import org.scribble.protocol.model.Choice;
import org.scribble.protocol.model.CustomActivity;
import org.scribble.protocol.model.DefaultVisitor;
import org.scribble.protocol.model.Do;
import org.scribble.protocol.model.ImportList;
import org.scribble.protocol.model.Interaction;
import org.scribble.protocol.model.Interrupt;
import org.scribble.protocol.model.Parallel;
import org.scribble.protocol.model.Protocol;
import org.scribble.protocol.model.ProtocolModel;
import org.scribble.protocol.model.Repeat;
import org.scribble.protocol.model.Role;
import org.scribble.protocol.model.Run;
import org.scribble.protocol.model.TypeImport;
import org.scribble.protocol.model.TypeImportList;
import org.scribble.protocol.model.TypeReference;
import org.scribble.protocol.model.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProtocolToBPMN2ProcessModelGenerator
implements ModelGenerator {
    private static final String BPMN_FILE_EXTENSION = ".bpmn";
    private boolean _consecutiveIds = false;
    private boolean _messageBasedInvocation = false;
    private ObjectFactory _objectFactory = new ObjectFactory();
    private static final Logger logger = Logger.getLogger(ProtocolToBPMN2ProcessModelGenerator.class.getName());

    public void setUseConsecutiveIds(boolean b) {
        this._consecutiveIds = b;
    }

    public void setMessageBasedInvocation(boolean b) {
        this._messageBasedInvocation = b;
    }

    public boolean getMessageBasedInvocation() {
        return this._messageBasedInvocation;
    }

    public boolean isSupported(Object source, String targetType) {
        return source instanceof ProtocolModel && ((ProtocolModel)source).isLocated() && (targetType.equals("bpmn2") || targetType.equals("bpmn"));
    }

    public Map<String, Object> generate(Object source, FeedbackHandler handler, ResourceLocator locator) {
        HashMap<String, TDefinitions> ret = null;
        if (source instanceof ProtocolModel) {
            ProtocolModel pm = (ProtocolModel)source;
            TDefinitions defns = new TDefinitions();
            this.initNamespace(defns, pm);
            this.initImports(defns, pm);
            this.initMessages(defns, pm);
            BPMN2ModelFactory model = new BPMN2ModelFactory(defns);
            BPMN2NotationFactory notation = new BPMN2NotationFactory(model);
            model.setUseConsecutiveIds(this._consecutiveIds);
            notation.setUseConsecutiveIds(this._consecutiveIds);
            BPMN2ModelVisitor visitor = new BPMN2ModelVisitor(pm.getProtocol().getName(), model, notation);
            this.generateProcess(pm, visitor, handler, locator);
            visitor.completeModels();
            ret = new HashMap<String, TDefinitions>();
            ret.put(pm.getProtocol().getName() + "_" + pm.getProtocol().getLocatedRole().getName() + BPMN_FILE_EXTENSION, defns);
        }
        return ret;
    }

    protected void initNamespace(TDefinitions defns, ProtocolModel pm) {
        String role = pm.getProtocol().getLocatedRole().getName();
        Annotation ann = AnnotationDefinitions.getAnnotationWithProperty((List)pm.getProtocol().getAnnotations(), (String)"Interface", (String)"role", (Object)role);
        if (ann != null) {
            defns.setTargetNamespace((String)ann.getProperties().get("namespace"));
        }
    }

    protected void initImports(TDefinitions defns, ProtocolModel pm) {
        List anns = AnnotationDefinitions.getAnnotations((List)pm.getProtocol().getAnnotations(), (String)"Type");
        for (Annotation ann : anns) {
            TImport imp = new TImport();
            imp.setImportType("http://www.w3.org/2001/XMLSchema");
            imp.setLocation((String)ann.getProperties().get("location"));
            imp.setNamespace((String)ann.getProperties().get("namespace"));
            defns.getImport().add(imp);
        }
    }

    protected void initMessages(TDefinitions defns, ProtocolModel pm) {
        for (ImportList il : pm.getImports()) {
            if (!(il instanceof TypeImportList)) continue;
            TypeImportList til = (TypeImportList)il;
            for (TypeImport ti : til.getTypeImports()) {
                TItemDefinition itemDef = new TItemDefinition();
                itemDef.setId("ITEM" + ti.getName());
                itemDef.setStructureRef(QName.valueOf(ti.getDataType().getDetails()));
                defns.getRootElement().add(this._objectFactory.createItemDefinition(itemDef));
                TMessage mesg = new TMessage();
                mesg.setId("ID" + ti.getName());
                mesg.setName(ti.getName());
                mesg.setItemRef(new QName(defns.getTargetNamespace(), itemDef.getId()));
                defns.getRootElement().add(this._objectFactory.createMessage(mesg));
            }
        }
    }

    protected TInterface getInterface(TDefinitions defns, Role role) {
        TInterface ret = null;
        String intfName = role.getName();
        for (JAXBElement<? extends TRootElement> rootElem : defns.getRootElement()) {
            if (!(rootElem.getValue() instanceof TInterface) || !((TInterface)rootElem.getValue()).getName().equals(intfName)) continue;
            ret = (TInterface)rootElem.getValue();
            break;
        }
        if (ret == null) {
            ret = new TInterface();
            ret.setId(intfName + "Interface");
            ret.setName(intfName);
            defns.getRootElement().add(this._objectFactory.createInterface(ret));
        }
        return ret;
    }

    protected void generateProcess(ProtocolModel local, BPMN2ModelVisitor visitor, FeedbackHandler handler, ResourceLocator locator) {
        local.visit((Visitor)visitor);
    }

    public class BPMN2ModelVisitor
    extends DefaultVisitor {
        private BPMN2ModelFactory m_modelFactory = null;
        private BPMN2NotationFactory m_notationFactory = null;
        private String m_choreoName = null;
        private List<BPMNActivity> m_bpmnActivityStack = new ArrayList<BPMNActivity>();
        private Map<String, BPMNDiagram> m_activityModels = new HashMap<String, BPMNDiagram>();

        public BPMN2ModelVisitor(String choreoName, BPMN2ModelFactory model, BPMN2NotationFactory notation) {
            this.m_choreoName = choreoName;
            this.m_modelFactory = model;
            this.m_notationFactory = notation;
        }

        public boolean start(Protocol elem) {
            try {
                BPMNDiagram diagram = this.getBPMNModel(elem);
                BPMNPool pool = diagram.createPool(this.getPoolName(elem));
                this.pushBPMNActivity(pool);
            }
            catch (Exception e) {
                logger.severe("Failed to get state machine for behavior '" + elem + "': " + e);
            }
            return true;
        }

        protected String getPoolName(Protocol elem) {
            if (elem.getParent() instanceof ProtocolModel) {
                return elem.getLocatedRole().getName();
            }
            return elem.getName() + "_" + elem.getLocatedRole().getName();
        }

        public void end(Protocol elem) {
            BPMNActivity umls = this.getBPMNActivity();
            if (umls != null) {
                umls.childrenComplete();
            }
            this.popBPMNActivity();
        }

        public boolean start(Choice elem) {
            if (!(this.getBPMNActivity() instanceof ServiceInvocationActivity)) {
                try {
                    this.pushBPMNActivity(new ChoiceActivity(elem, this.getBPMNActivity(), this.m_modelFactory, this.m_notationFactory));
                }
                catch (Exception e) {
                    logger.severe("Failed to create choice state: " + e);
                }
            }
            return true;
        }

        public void end(Choice elem) {
            this.popBPMNActivity();
        }

        public boolean start(Parallel elem) {
            try {
                this.pushBPMNActivity(new ParallelActivity(elem, this.getBPMNActivity(), this.m_modelFactory, this.m_notationFactory));
            }
            catch (Exception e) {
                logger.severe("Failed to create parallel state: " + e);
            }
            return true;
        }

        public void end(Parallel elem) {
            this.popBPMNActivity();
        }

        public void accept(Run elem) {
            BPMNActivity umls = this.getBPMNActivity();
            if (umls != null) {
                new RunActivity((Activity)elem, umls, this.m_modelFactory, this.m_notationFactory);
            }
        }

        public boolean start(Do elem) {
            DoActivity state = null;
            BPMNActivity umls = this.getBPMNActivity();
            if (umls != null) {
                state = new DoActivity((Activity)elem, umls, this.m_modelFactory, this.m_notationFactory);
                this.pushBPMNActivity(state);
                DoBlockActivity inline = new DoBlockActivity(state, this.m_modelFactory, this.m_notationFactory);
                this.pushBPMNActivity(inline);
            }
            return true;
        }

        public void end(Do elem) {
            if (this.getBPMNActivity() instanceof DoBlockActivity) {
                this.popBPMNActivity();
            }
            this.popBPMNActivity();
        }

        public boolean start(Interrupt elem) {
            if (this.getBPMNActivity() instanceof DoBlockActivity) {
                this.popBPMNActivity();
            }
            return true;
        }

        public void end(Interrupt elem) {
        }

        public void accept(Interaction elem) {
            if (InteractionUtil.isSend((Interaction)elem)) {
                if (ProtocolToBPMN2ProcessModelGenerator.this.getMessageBasedInvocation() || !InteractionUtil.isRequest((Interaction)elem)) {
                    BPMNActivity umls = this.getBPMNActivity();
                    if (umls != null) {
                        SendActivity sa = new SendActivity(elem, umls, this.m_modelFactory, this.m_notationFactory);
                        BPMNDiagram amodel = umls.getBPMNDiagram();
                        amodel.registerSendActivity(elem, sa);
                        TSendTask task = sa.getSendTask();
                        if (task != null) {
                            task.setMessageRef(this.getMessageReference(elem));
                            task.setOperationRef(this.getOperationReference(elem, task.getMessageRef()));
                        }
                    }
                } else {
                    BPMNActivity umls = this.getBPMNActivity();
                    if (umls != null) {
                        try {
                            ServiceInvocationActivity sa = new ServiceInvocationActivity(elem, umls, this.m_modelFactory, this.m_notationFactory);
                            BPMNDiagram amodel = umls.getBPMNDiagram();
                            amodel.registerSendActivity(elem, sa);
                            TServiceTask task = sa.getServiceTask();
                            if (task != null) {
                                task.setOperationRef(this.getOperationReference(elem, this.getMessageReference(elem)));
                            }
                            this.pushBPMNActivity(sa);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            } else {
                ServiceInvocationActivity act = this.getServiceInvocationActivity();
                if (InteractionUtil.isRequest((Interaction)elem) || ProtocolToBPMN2ProcessModelGenerator.this.getMessageBasedInvocation() || act == null) {
                    BPMNActivity umls = this.getBPMNActivity();
                    if (umls != null) {
                        ReceiveActivity sa = new ReceiveActivity(elem, umls, this.m_modelFactory, this.m_notationFactory);
                        BPMNDiagram amodel = umls.getBPMNDiagram();
                        amodel.registerReceiveActivity(elem, sa);
                        TReceiveTask task = sa.getReceiveTask();
                        if (task != null) {
                            task.setMessageRef(this.getMessageReference(elem));
                            task.setOperationRef(this.getOperationReference(elem, task.getMessageRef()));
                        }
                    }
                } else if (InteractionUtil.isFaultResponse((Interaction)elem)) {
                    BPMNActivity umls = this.getBPMNActivity();
                    TBoundaryEvent event = (TBoundaryEvent)this.m_modelFactory.createBoundaryEvent(umls.getContainer());
                    TErrorEventDefinition eed = new TErrorEventDefinition();
                    eed.setId(this.m_modelFactory.createId());
                    eed.setErrorRef(this.getErrorReference(elem));
                    this.getOperationReference(elem, eed.getErrorRef());
                    event.getEventDefinition().add(ProtocolToBPMN2ProcessModelGenerator.this._objectFactory.createErrorEventDefinition(eed));
                    event.setAttachedToRef(new QName(this.m_modelFactory.getDefinitions().getTargetNamespace(), act.getServiceTask().getId()));
                    BoundaryEvent be = new BoundaryEvent(event, act.getStartState(), this.m_modelFactory, this.m_notationFactory);
                    act.register(umls, be);
                } else {
                    this.getOperationReference(elem, this.getMessageReference(elem));
                }
            }
        }

        protected ServiceInvocationActivity getServiceInvocationActivity() {
            ServiceInvocationActivity ret = null;
            if (this.m_bpmnActivityStack.size() > 0) {
                BPMNActivity ba = this.m_bpmnActivityStack.get(0);
                if (ba instanceof ServiceInvocationActivity) {
                    ret = (ServiceInvocationActivity)ba;
                } else if (ba instanceof SequenceActivity && this.m_bpmnActivityStack.size() > 1 && this.m_bpmnActivityStack.get(1) instanceof ServiceInvocationActivity) {
                    ret = (ServiceInvocationActivity)this.m_bpmnActivityStack.get(1);
                }
            }
            return ret;
        }

        public boolean start(Block elem) {
            try {
                this.pushBPMNActivity(new SequenceActivity(this.getBPMNActivity(), this.m_modelFactory, this.m_notationFactory));
            }
            catch (Exception e) {
                logger.severe("Failed to create sequence state: " + e);
            }
            return true;
        }

        public void end(Block elem) {
            this.popBPMNActivity();
        }

        public boolean start(Repeat elem) {
            try {
                this.pushBPMNActivity(new RepeatActivity(elem, this.getBPMNActivity(), this.m_modelFactory, this.m_notationFactory));
                this.pushBPMNActivity(new SequenceActivity(this.getBPMNActivity(), this.m_modelFactory, this.m_notationFactory));
            }
            catch (Exception e) {
                logger.severe("Failed to create while Activity: " + e);
            }
            return true;
        }

        public void end(Repeat elem) {
            this.popBPMNActivity();
            this.popBPMNActivity();
        }

        public void accept(CustomActivity act) {
            BPMNActivity umls;
            if (act instanceof Fork) {
                BPMNActivity umls2 = this.getBPMNActivity();
                if (umls2 != null) {
                    new ForkActivity((Fork)act, umls2, this.m_modelFactory, this.m_notationFactory);
                }
            } else if (act instanceof Join && (umls = this.getBPMNActivity()) != null) {
                new JoinActivity((Join)act, umls, this.m_modelFactory, this.m_notationFactory);
            }
        }

        protected BPMNDiagram getBPMNModel(Protocol elem) throws BPMN2GenerationException {
            Protocol main = elem.getTopLevelProtocol();
            String name = main.getName();
            BPMNDiagram ret = this.m_activityModels.get(name);
            if (ret == null) {
                ret = new BPMNDiagram(this.m_choreoName, name, null, this.m_modelFactory, this.m_notationFactory);
                this.m_activityModels.put(name, ret);
            }
            return ret;
        }

        protected void pushBPMNActivity(BPMNActivity act) {
            this.m_bpmnActivityStack.add(0, act);
        }

        protected BPMNActivity getBPMNActivity() {
            BPMNActivity ret = null;
            if (this.m_bpmnActivityStack.size() > 0) {
                ret = this.m_bpmnActivityStack.get(0);
            }
            return ret;
        }

        protected void popBPMNActivity() {
            BPMNActivity umls = null;
            do {
                if ((umls = this.getBPMNActivity()) != null) {
                    umls.childrenComplete();
                }
                if (this.m_bpmnActivityStack.size() <= 0) continue;
                this.m_bpmnActivityStack.remove(0);
            } while (umls instanceof ServiceInvocationActivity);
        }

        public void completeModels() {
            for (BPMNDiagram amodel : this.m_activityModels.values()) {
                amodel.completeModel();
            }
        }

        protected QName getMessageReference(Interaction interaction) {
            QName ret = null;
            if (interaction.getMessageSignature() == null || interaction.getMessageSignature().getTypeReferences().size() == 0) {
                return null;
            }
            for (JAXBElement<? extends TRootElement> rootElem : this.m_modelFactory.getDefinitions().getRootElement()) {
                TMessage mesg;
                if (!(rootElem.getValue() instanceof TMessage) || !(mesg = (TMessage)rootElem.getValue()).getName().equals(((TypeReference)interaction.getMessageSignature().getTypeReferences().get(0)).getName())) continue;
                ret = new QName(this.m_modelFactory.getDefinitions().getTargetNamespace(), mesg.getId());
                if (!InteractionUtil.isFaultResponse((Interaction)interaction)) break;
                String faultName = InteractionUtil.getFaultName((Interaction)interaction);
                boolean found = false;
                for (JAXBElement<? extends TRootElement> subRootElem : this.m_modelFactory.getDefinitions().getRootElement()) {
                    if (!(subRootElem.getValue() instanceof TError) || !((TError)subRootElem.getValue()).getStructureRef().equals(mesg.getItemRef()) || !((TError)subRootElem.getValue()).getName().equals(faultName)) continue;
                    found = true;
                }
                if (found) break;
                TError error = new TError();
                error.setId("ERR" + faultName);
                error.setName(faultName);
                error.setErrorCode(faultName);
                error.setStructureRef(mesg.getItemRef());
                this.m_modelFactory.getDefinitions().getRootElement().add(ProtocolToBPMN2ProcessModelGenerator.this._objectFactory.createError(error));
                break;
            }
            return ret;
        }

        protected QName getErrorReference(Interaction interaction) {
            QName ret = null;
            if (interaction.getMessageSignature() == null || interaction.getMessageSignature().getTypeReferences().size() == 0) {
                return null;
            }
            if (!InteractionUtil.isFaultResponse((Interaction)interaction)) {
                return null;
            }
            for (JAXBElement<? extends TRootElement> rootElem : this.m_modelFactory.getDefinitions().getRootElement()) {
                TMessage mesg;
                if (!(rootElem.getValue() instanceof TMessage) || !(mesg = (TMessage)rootElem.getValue()).getName().equals(((TypeReference)interaction.getMessageSignature().getTypeReferences().get(0)).getName())) continue;
                String faultName = InteractionUtil.getFaultName((Interaction)interaction);
                TError error = null;
                for (JAXBElement<? extends TRootElement> subRootElem : this.m_modelFactory.getDefinitions().getRootElement()) {
                    if (!(subRootElem.getValue() instanceof TError) || !((TError)subRootElem.getValue()).getStructureRef().equals(mesg.getItemRef()) || !((TError)subRootElem.getValue()).getName().equals(faultName)) continue;
                    error = (TError)subRootElem.getValue();
                    break;
                }
                if (error == null) {
                    error = new TError();
                    error.setId("ERR" + faultName);
                    error.setName(faultName);
                    error.setErrorCode(faultName);
                    error.setStructureRef(mesg.getItemRef());
                    this.m_modelFactory.getDefinitions().getRootElement().add(ProtocolToBPMN2ProcessModelGenerator.this._objectFactory.createError(error));
                }
                ret = new QName(this.m_modelFactory.getDefinitions().getTargetNamespace(), error.getId());
                break;
            }
            return ret;
        }

        protected QName getOperationReference(Interaction interaction, QName messageOrErrorRef) {
            QName ret = null;
            if (interaction.getMessageSignature().getOperation() == null) {
                return null;
            }
            Role serverRole = null;
            if (InteractionUtil.isRequest((Interaction)interaction)) {
                if (interaction.getToRoles().size() > 0) {
                    serverRole = (Role)interaction.getToRoles().get(0);
                }
                if (serverRole == null) {
                    serverRole = interaction.getEnclosingProtocol().getLocatedRole();
                }
            } else {
                serverRole = interaction.getFromRole();
                if (serverRole == null) {
                    serverRole = interaction.getEnclosingProtocol().getLocatedRole();
                }
            }
            if (serverRole == null) {
                return null;
            }
            TInterface intf = ProtocolToBPMN2ProcessModelGenerator.this.getInterface(this.m_modelFactory.getDefinitions(), serverRole);
            if (intf == null) {
                return null;
            }
            TOperation op = null;
            String opName = InteractionUtil.getOperationName((Interaction)interaction);
            for (TOperation curop : intf.getOperation()) {
                if (!curop.getName().equals(opName)) continue;
                op = curop;
                break;
            }
            if (op == null) {
                op = new TOperation();
                op.setName(opName);
                op.setId("OP_" + serverRole.getName() + "_" + op.getName());
                intf.getOperation().add(op);
            }
            ret = new QName(this.m_modelFactory.getDefinitions().getTargetNamespace(), op.getId());
            if (InteractionUtil.isRequest((Interaction)interaction)) {
                if (op.getInMessageRef() == null) {
                    op.setInMessageRef(messageOrErrorRef);
                } else if (!op.getInMessageRef().equals(messageOrErrorRef)) {
                    // empty if block
                }
            } else if (InteractionUtil.isFaultResponse((Interaction)interaction)) {
                String faultName = InteractionUtil.getFaultName((Interaction)interaction);
                TBaseElement error = null;
                for (JAXBElement<? extends TRootElement> rootElem : this.m_modelFactory.getDefinitions().getRootElement()) {
                    TError cur;
                    if (!(rootElem.getValue() instanceof TError) || !(cur = (TError)rootElem.getValue()).getErrorCode().equals(faultName)) continue;
                    error = cur;
                    break;
                }
                if (error != null) {
                    QName qname = new QName(this.m_modelFactory.getDefinitions().getTargetNamespace(), error.getId());
                    if (!op.getErrorRef().contains(qname)) {
                        op.getErrorRef().add(qname);
                    }
                }
            } else if (op.getOutMessageRef() == null) {
                op.setOutMessageRef(messageOrErrorRef);
            } else if (!op.getOutMessageRef().equals(messageOrErrorRef)) {
                // empty if block
            }
            return ret;
        }
    }
}

