/*
 * Decompiled with CFR 0.152.
 */
package org.savara.bpmn2.internal.generation;

import java.util.UUID;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.savara.bpmn2.internal.generation.BPMN2ModelFactory;
import org.savara.bpmn2.model.BPMNDiagram;
import org.savara.bpmn2.model.BPMNEdge;
import org.savara.bpmn2.model.BPMNPlane;
import org.savara.bpmn2.model.BPMNShape;
import org.savara.bpmn2.model.Bounds;
import org.savara.bpmn2.model.DiagramElement;
import org.savara.bpmn2.model.ObjectFactory;
import org.savara.bpmn2.model.ParticipantBandKind;
import org.savara.bpmn2.model.Point;
import org.savara.bpmn2.model.Shape;
import org.savara.bpmn2.model.TBaseElement;
import org.savara.bpmn2.model.TChoreographyTask;
import org.savara.bpmn2.model.TGateway;
import org.savara.bpmn2.model.TParticipant;
import org.savara.bpmn2.model.TProcess;
import org.savara.bpmn2.model.TSequenceFlow;

public class BPMN2NotationFactory {
    private static final int BAND_HEIGHT = 15;
    private BPMN2ModelFactory m_modelFactory = null;
    private BPMNPlane m_plane = null;
    private ObjectFactory m_factory = new ObjectFactory();
    private boolean m_consecutiveIds = false;
    private int m_id = 1;

    public BPMN2NotationFactory(BPMN2ModelFactory modelFactory) {
        this.m_modelFactory = modelFactory;
    }

    public void setUseConsecutiveIds(boolean b) {
        this.m_consecutiveIds = b;
    }

    protected String createId() {
        if (this.m_consecutiveIds) {
            return "NID" + this.m_id++;
        }
        return UUID.randomUUID().toString();
    }

    public Object createDiagram(BPMN2ModelFactory factory, Object diagramModel, int x, int y, int width, int height) {
        BPMNDiagram ret = new BPMNDiagram();
        ret.setId(this.createId());
        this.m_modelFactory.getDefinitions().getBPMNDiagram().add(ret);
        this.m_plane = new BPMNPlane();
        ret.setBPMNPlane(this.m_plane);
        ret.setBPMNPlane(this.m_plane);
        return this.m_plane;
    }

    public Object createPool(BPMN2ModelFactory factory, Object poolModel, Object diagramNotation, int x, int y, int width, int height) {
        BPMNShape shape = new BPMNShape();
        shape.setId(this.createId());
        if (poolModel instanceof TProcess) {
            TProcess base = (TProcess)poolModel;
            TBaseElement participant = null;
            for (TParticipant p : this.m_modelFactory.getCollaboration().getParticipant()) {
                if (!p.getName().equals(base.getName())) continue;
                participant = p;
                break;
            }
            if (participant != null) {
                shape.setBpmnElement(new QName(this.m_modelFactory.getDefinitions().getTargetNamespace(), participant.getId()));
            }
        }
        Bounds b = new Bounds();
        b.setX(x);
        b.setY(y);
        b.setWidth(width);
        b.setHeight(height);
        shape.setBounds(b);
        if (diagramNotation instanceof BPMNPlane) {
            BPMNPlane plane = (BPMNPlane)diagramNotation;
            plane.getDiagramElement().add(this.m_factory.createBPMNShape(shape));
        }
        return shape;
    }

    public Object createTask(BPMN2ModelFactory factory, Object taskModel, Object parentNotation, int x, int y, int width, int height) {
        BPMNShape shape = new BPMNShape();
        shape.setId(this.createId());
        if (taskModel instanceof TBaseElement) {
            TBaseElement base = (TBaseElement)taskModel;
            shape.setBpmnElement(new QName(this.m_modelFactory.getDefinitions().getTargetNamespace(), base.getId()));
        }
        Bounds b = new Bounds();
        b.setX(x);
        b.setY(y);
        b.setWidth(width);
        b.setHeight(height);
        shape.setBounds(b);
        if (parentNotation instanceof BPMNPlane) {
            BPMNPlane plane = (BPMNPlane)parentNotation;
            plane.getDiagramElement().add(this.m_factory.createBPMNShape(shape));
        }
        return shape;
    }

    public Object createChoreographyTask(BPMN2ModelFactory factory, Object taskModel, Object parentNotation, int x, int y, int width, int height) {
        TChoreographyTask ct = (TChoreographyTask)taskModel;
        QName otherParticipantRef = null;
        for (QName qname : ct.getParticipantRef()) {
            if (qname.equals(ct.getInitiatingParticipantRef())) continue;
            otherParticipantRef = qname;
            break;
        }
        BPMNShape shape = new BPMNShape();
        shape.setId(this.createId());
        BPMNShape initParticipant = new BPMNShape();
        initParticipant.setChoreographyActivityShape(new QName(this.m_modelFactory.getDefinitions().getTargetNamespace(), shape.getId()));
        initParticipant.setParticipantBandKind(ParticipantBandKind.TOP_INITIATING);
        initParticipant.setBpmnElement(ct.getInitiatingParticipantRef());
        initParticipant.setIsMessageVisible(true);
        BPMNShape targetParticipant = new BPMNShape();
        targetParticipant.setChoreographyActivityShape(new QName(this.m_modelFactory.getDefinitions().getTargetNamespace(), shape.getId()));
        targetParticipant.setParticipantBandKind(ParticipantBandKind.BOTTOM_NON_INITIATING);
        targetParticipant.setBpmnElement(otherParticipantRef);
        if (taskModel instanceof TBaseElement) {
            TBaseElement base = (TBaseElement)taskModel;
            shape.setBpmnElement(new QName(this.m_modelFactory.getDefinitions().getTargetNamespace(), base.getId()));
        }
        Bounds b = new Bounds();
        b.setX(x);
        b.setY(y);
        b.setWidth(width);
        b.setHeight(height);
        shape.setBounds(b);
        b = new Bounds();
        b.setX(x);
        b.setY(y);
        b.setWidth(width);
        b.setHeight(15.0);
        initParticipant.setBounds(b);
        b = new Bounds();
        b.setX(x);
        b.setY(y + height - 15);
        b.setWidth(width);
        b.setHeight(15.0);
        targetParticipant.setBounds(b);
        if (parentNotation instanceof BPMNPlane) {
            BPMNPlane plane = (BPMNPlane)parentNotation;
            plane.getDiagramElement().add(this.m_factory.createBPMNShape(shape));
            plane.getDiagramElement().add(this.m_factory.createBPMNShape(initParticipant));
            plane.getDiagramElement().add(this.m_factory.createBPMNShape(targetParticipant));
        }
        return shape;
    }

    public Object createEvent(BPMN2ModelFactory factory, Object eventModel, Object parentNotation, int x, int y, int width, int height) {
        BPMNShape shape = new BPMNShape();
        shape.setId(this.createId());
        if (eventModel instanceof TBaseElement) {
            TBaseElement base = (TBaseElement)eventModel;
            shape.setBpmnElement(new QName(this.m_modelFactory.getDefinitions().getTargetNamespace(), base.getId()));
        }
        Bounds b = new Bounds();
        b.setX(x);
        b.setY(y);
        b.setWidth(width);
        b.setHeight(height);
        shape.setBounds(b);
        if (parentNotation instanceof BPMNPlane) {
            BPMNPlane plane = (BPMNPlane)parentNotation;
            plane.getDiagramElement().add(this.m_factory.createBPMNShape(shape));
        }
        return shape;
    }

    public Object createJunction(BPMN2ModelFactory factory, Object junctionModel, Object parentNotation, int x, int y, int width, int height) {
        BPMNShape shape = new BPMNShape();
        shape.setId(this.createId());
        if (junctionModel instanceof TBaseElement) {
            TBaseElement base = (TBaseElement)junctionModel;
            shape.setBpmnElement(new QName(this.m_modelFactory.getDefinitions().getTargetNamespace(), base.getId()));
        }
        Bounds b = new Bounds();
        b.setX(x);
        b.setY(y);
        b.setWidth(width);
        b.setHeight(height);
        shape.setBounds(b);
        if (parentNotation instanceof BPMNPlane) {
            BPMNPlane plane = (BPMNPlane)parentNotation;
            plane.getDiagramElement().add(this.m_factory.createBPMNShape(shape));
        }
        return shape;
    }

    public Object createSequenceLink(BPMN2ModelFactory factory, Object linkModel, Object diagramNotation) {
        BPMNEdge edge = new BPMNEdge();
        edge.setId(this.createId());
        DiagramElement source = null;
        DiagramElement target = null;
        int extrax = 0;
        if (linkModel instanceof TSequenceFlow) {
            TSequenceFlow seqflow = (TSequenceFlow)linkModel;
            edge.setBpmnElement(new QName(this.m_modelFactory.getDefinitions().getTargetNamespace(), seqflow.getId()));
            if (diagramNotation instanceof BPMNPlane && seqflow.getSourceRef() instanceof TBaseElement && seqflow.getTargetRef() instanceof TBaseElement) {
                BPMNPlane plane = (BPMNPlane)diagramNotation;
                for (JAXBElement<? extends DiagramElement> jbde : plane.getDiagramElement()) {
                    DiagramElement de = (DiagramElement)jbde.getValue();
                    if (!(de instanceof BPMNShape) || ((BPMNShape)de).getBpmnElement() == null) continue;
                    if (((BPMNShape)de).getBpmnElement().getLocalPart().equals(((TBaseElement)seqflow.getSourceRef()).getId())) {
                        source = (BPMNShape)de;
                        continue;
                    }
                    if (!((BPMNShape)de).getBpmnElement().getLocalPart().equals(((TBaseElement)seqflow.getTargetRef()).getId())) continue;
                    target = (BPMNShape)de;
                }
            }
            if (seqflow.getSourceRef() instanceof TGateway) {
                extrax = 20;
            }
        }
        if (diagramNotation instanceof BPMNPlane && source != null && target != null) {
            BPMNPlane plane = (BPMNPlane)diagramNotation;
            edge.setSourceElement(new QName(this.m_modelFactory.getDefinitions().getTargetNamespace(), source.getId()));
            edge.setTargetElement(new QName(this.m_modelFactory.getDefinitions().getTargetNamespace(), target.getId()));
            Point sourcep = new Point();
            sourcep.setX(((Shape)source).getBounds().getX() + ((Shape)source).getBounds().getWidth() + (double)extrax);
            sourcep.setY(((Shape)source).getBounds().getY() + ((Shape)source).getBounds().getHeight() / 2.0);
            edge.getWaypoint().add(sourcep);
            Point targetp = new Point();
            targetp.setX(((Shape)target).getBounds().getX());
            targetp.setY(((Shape)target).getBounds().getY() + ((Shape)target).getBounds().getHeight() / 2.0);
            edge.getWaypoint().add(targetp);
            plane.getDiagramElement().add(this.m_factory.createBPMNEdge(edge));
        }
        return edge;
    }

    public Object createMessageLink(BPMN2ModelFactory factory, Object linkModel, Object diagramNotation) {
        BPMNEdge edge = new BPMNEdge();
        edge.setId(this.createId());
        return edge;
    }
}

