/*
 * Decompiled with CFR 0.152.
 */
package org.savara.bpmn2.internal.generation.components;

import org.savara.bpmn2.internal.generation.BPMN2ModelFactory;
import org.savara.bpmn2.internal.generation.BPMN2NotationFactory;
import org.savara.bpmn2.internal.generation.components.AbstractBPMNActivity;
import org.savara.bpmn2.internal.generation.components.BPMNActivity;
import org.savara.bpmn2.internal.generation.components.JunctionActivity;

public class BPMNPool
extends AbstractBPMNActivity {
    private boolean m_completed = false;
    private Object m_pool = null;
    private BPMNActivity m_initialState = null;
    private BPMNActivity m_finalState = null;

    public BPMNPool(Object diagram, String name, BPMNActivity parent, BPMN2ModelFactory model, BPMN2NotationFactory notation) {
        super(parent, model, notation);
        this.initialize(diagram, name);
    }

    public void initialize(Object diagram, String name) {
        this.m_pool = this.getModelFactory().createPool(diagram, name);
        this.m_initialState = new JunctionActivity(this.getModelFactory().createInitialNode(this.getContainer()), this, this.getModelFactory(), this.getNotationFactory());
        this.m_finalState = new JunctionActivity(this.getModelFactory().createFinalNode(this.getContainer()), this, this.getModelFactory(), this.getNotationFactory());
    }

    public Object getContainer() {
        return this.m_pool;
    }

    public Object getStartNode() {
        return this.m_initialState.getStartNode();
    }

    public Object getEndNode() {
        return this.m_finalState.getEndNode();
    }

    public BPMNActivity getStartState() {
        return this.m_initialState;
    }

    public BPMNActivity getEndState() {
        return this.m_finalState;
    }

    public void childrenComplete() {
        if (!this.m_completed) {
            if (this.getChildStates().remove(this.m_finalState)) {
                this.getChildStates().add(this.m_finalState);
            }
            this.transitionSequentialNodes();
            this.setHeight(this.getHeight() + 80);
            this.setWidth(this.getWidth() + 100);
            this.m_completed = true;
        }
    }

    public void calculatePosition(int x, int y) {
        int curx = 50;
        int midy = this.getHeight() / 2;
        this.setX(x);
        this.setY(y);
        for (int i = 0; i < this.getChildStates().size(); ++i) {
            BPMNActivity act = this.getChildStates().get(i);
            act.calculatePosition(curx, y + (midy - act.getHeight() / 2));
            curx += act.getWidth() + 50;
        }
    }

    public void draw(Object parent) {
        this.getNotationFactory().createPool(this.getModelFactory(), this.m_pool, parent, this.getX(), this.getY(), this.getWidth(), this.getHeight());
        for (int i = 0; i < this.getChildStates().size(); ++i) {
            BPMNActivity act = this.getChildStates().get(i);
            act.draw(parent);
            if (i <= 0) continue;
            BPMNActivity prev = this.getChildStates().get(i - 1);
            prev.transitionTo(act, null, parent);
        }
    }
}

