/*
 * Decompiled with CFR 0.152.
 */
package org.savara.bpmn2.internal.parser.choreo;

import java.util.List;
import javax.xml.bind.JAXBElement;
import org.savara.bpmn2.internal.parser.choreo.rules.Scope;
import org.savara.bpmn2.model.TChoreography;
import org.savara.bpmn2.model.TDefinitions;
import org.savara.bpmn2.model.TFlowElement;
import org.savara.bpmn2.model.TInterface;
import org.savara.bpmn2.model.TMessage;
import org.savara.bpmn2.model.TMessageFlow;
import org.savara.bpmn2.model.TParticipant;
import org.savara.bpmn2.model.TRootElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BPMN2ChoreographyParserUtil {
    public static Scope createScope(TDefinitions defns) {
        return new Scope(defns);
    }

    public static void initializeScope(Scope scope, TDefinitions defns) {
        for (JAXBElement<? extends TRootElement> elem : defns.getRootElement()) {
            if (elem.getDeclaredType() == TMessage.class) {
                TMessage mesg = (TMessage)elem.getValue();
                scope.registerBPMN2Element(mesg.getId(), mesg);
                continue;
            }
            if (elem.getDeclaredType() != TInterface.class) continue;
            TInterface intf = (TInterface)elem.getValue();
            scope.registerBPMN2Element(intf.getId(), intf);
        }
    }

    public static void initializeScope(Scope scope, TChoreography choreo) {
        scope.setChoreography(choreo);
        BPMN2ChoreographyParserUtil.initializeParticipants(scope, choreo.getParticipant());
        BPMN2ChoreographyParserUtil.initializeFlowElements(scope, choreo.getFlowElement());
        BPMN2ChoreographyParserUtil.initializeMessageFlows(scope, choreo.getMessageFlow());
    }

    private static void initializeParticipants(Scope scope, List<TParticipant> participants) {
        for (TParticipant p : participants) {
            scope.registerBPMN2Element(p.getId(), p);
        }
    }

    private static void initializeMessageFlows(Scope scope, List<TMessageFlow> mflows) {
        for (TMessageFlow mflow : mflows) {
            scope.registerBPMN2Element(mflow.getId(), mflow);
        }
    }

    private static void initializeFlowElements(Scope scope, List<JAXBElement<? extends TFlowElement>> flowElements) {
        for (JAXBElement<? extends TFlowElement> jaxb : flowElements) {
            TFlowElement fe = (TFlowElement)jaxb.getValue();
            scope.registerBPMN2Element(fe.getId(), fe);
        }
    }
}

